<?php
/**
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2016 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class OWLBlogPostModuleFrontController extends ModuleFrontController
{
	private $blog_post;
	private $OWLLink;
	private $owlTag;
	protected $imageType;
	public function __construct()
	{
		parent::__construct();

		$this->context = Context::getContext();
	}
	public function init()
	{
		$this->imageType = 'jpg';
		parent::init();
		$this->context->smarty->assign($this->getMetaTags($this->context->language->id, $this->context->shop->id));
	}
	public function initContent()
	{
		$this->OWLLink = new OWLLink();
		$this->owlTag = new OWLTag();
		$this->id_owl_blog_post = Tools::getValue('id_owl_blog_post');
		$options_str = Configuration::get('OWL_BLOG_CONFIG');
		$options_arr = Tools::jsonDecode($options_str, 1);
		$this->optionsArr = $options_arr;
		parent::initContent();
		$this->_display();
		$this->setTemplate('post.tpl');
	}
	public function _display()
	{
		$id_lang = $this->context->language->id;
		$id_shop = $this->context->shop->id;
		/*get content detail post*/
		$image_size = 'large';
		$post = $this->getPostById($image_size, $this->id_owl_blog_post, $id_lang, $id_shop);
		$this->context->smarty->assign('OWLLink', $this->OWLLink); 
		$this->context->smarty->assign('capchatpath', __PS_BASE_URI__.'modules/owlblog/');
		$link_main = $this->optionsArr['OWL_MAIN_BLOG_URL'];
		
		if ($post != null)
		{
			/*breadcurm*/
			$breadcrumb = array();
			$breadcrumb['links'] = array();
			$node_home = array();
			$node_home['title'] = $this->module->l('Home');
			$node_home['url'] = $this->context->link->getPageLink('index');
			$breadcrumb['links'][] = $node_home;
			$node_blog = array();
			$node_blog['title'] = $this->module->l('Blog');
			$node_blog['url'] = $this->context->link->getModuleLink('owlblog', 'categoryPost');
			$breadcrumb['links'][] = $node_blog;
			
			$id_category = Tools::getValue('category_parent');
			$cat = new OWLCategory($id_category);
			$cat_parent = $cat->getParentsCategories($cat->id_owl_blog_category, $id_lang, $id_shop);
			$breadcrumb = $this->OWLLink->getPath($breadcrumb, $cat_parent);
			
			$node_cat = array();
			$node_cat['title'] = $cat->name[$id_lang];
			$node_cat['url'] = $this->OWLLink->getCategoryPostLink($cat->id_owl_blog_category, $cat->link_rewrite[$id_lang]);
			$breadcrumb['links'][] = $node_cat;
			
			$node_end = array();
			$node_end['title'] = $post['name'];
			$node_end['url'] = '#';
			$breadcrumb['links'][] = $node_end;
			
			$breadcrumb['count'] = count($breadcrumb['links']);	
			
			$this->context->smarty->assign('breadcrumb', $breadcrumb);
			$this->context->smarty->assign('post', $post);
			
			/*tag*/
			
			$tags = $this->owlTag->getTagsForTag($this->id_owl_blog_post);
			$this->context->smarty->assign('owltags', $tags);
			
			/*related post*/
			$id_related_posts = explode('-', $post['id_related_posts']);
			$related_posts = array();
			$image_size_related_post = 'small';
			foreach ($id_related_posts as $k => $id)
			{
				if ($id !== end($id_related_posts) && $k < 5)
				{
					$item = $this->getPostById($image_size_related_post, $id, $id_lang, $id_shop);
					$related_posts[$k] = $item;
				}
			}
			$this->context->smarty->assign('related_posts', $related_posts);
			/*comment*/
			$url_rewrite = Configuration::get('PS_REWRITING_SETTINGS');
			$this->context->smarty->assign('url_rewrite', $url_rewrite);
		
			$this->context->smarty->assign('id_shop', $id_shop);
			$postObj = new OWLPost($this->id_owl_blog_post, $id_lang, $id_shop);
			$nb = 5;
			if (Tools::issubmit('viewall'))
			{
				$viewall = true;
				$this->context->smarty->assign('viewall', $viewall);
			}
			else
				$viewall = false;
			$temps = $postObj->getCommentForPost($id_lang, $id_shop, $nb, $viewall);
			$comments = array();
			foreach ($temps as $comment)
			{
				$comment['date_add'] = $postObj->formatDateAdd($comment['date_add']);
				$comments[] = $comment;
			}
			$count_comment = $postObj->getCountComment($id_lang, $id_shop);
			$this->context->smarty->assign('count_comment_total', $count_comment);
			$this->context->smarty->assign('count_comment_show', $nb);
			$this->context->smarty->assign('comments', $comments);
			$category_allow_comment = Db::getInstance()->getValue('
			SELECT allow_comment
			FROM '._DB_PREFIX_.'owl_blog_category
			WHERE id_owl_blog_category='.$post['id_owl_blog_category'].'
			');
			$post_allow_comment = $post['allow_comment'];
			if ($category_allow_comment && $post_allow_comment && $this->allowComment($id_shop)) 
			{
				$using_captcha = $this->optionsArr['OWL_DISPLAY_CAPTCHA'];
				$validate_comment = $this->optionsArr['OWL_COMMENTS_VALIDATE'];
				$this->context->smarty->assign('using_captcha', $using_captcha);
				$this->context->smarty->assign('validate_comment', $validate_comment);
				$this->context->smarty->assign('display_form_comment', 1);
				/* msg error comment */
				if (Tools::getValue('submitcomment') == 'true')
				{
					$error = $this->ProcessSubmit();
					if (is_array($error))
						$this->context->smarty->assign('error', $error);
					else
						Tools::redirect($this->OWLLink->getLinkPostDetail($post['id_owl_blog_post'], $post['link_rewrite'], $post['id_owl_blog_category']).($url_rewrite == 1 ? '?' : '&').'sb');
				}
				if (Tools::issubmit('sb'))
					$this->context->smarty->assign('success', true);
			}
			else
				$this->context->smarty->assign('display_form_comment', 0);
		}
		else 
			$this->context->smarty->assign('errorposts', 1);
	}
	public function ProcessSubmit()
	{
		if (Tools::getValue('submitcomment') == 'true')
		{
			$comment = new OWLComment(Tools::getValue('id_owl_blog_comment'));
			$comment->copyFromPost();
			$using_captcha = $this->optionsArr['OWL_DISPLAY_CAPTCHA'];
			$errors = $comment->validateController($using_captcha);
			if (count($errors) <= 0)
			{
				Tools::getValue('id_owl_blog_comment') ? $comment->update() : $comment->add();
				return true;
			}
			else
				return $errors;
		}
	}
	public function getPostById($image_size, $id_owl_blog_post = null, $id_lang = null, $id_shop = null)
	{	
		$sql = 'SELECT b.*,a.* FROM '._DB_PREFIX_.'owl_blog_post a
				LEFT JOIN '._DB_PREFIX_.'owl_blog_post_lang b
				ON (a.id_owl_blog_post= b.id_owl_blog_post AND b.id_shop = '.$id_shop.')
				LEFT JOIN '._DB_PREFIX_.'owl_blog_post_shop c
				ON (a.id_owl_blog_post= c.id_owl_blog_post)
				WHERE (c.active=1) AND b.id_lang = '.$id_lang.' AND c.id_shop = '.$id_shop.' AND a.id_owl_blog_post = '.$id_owl_blog_post.'';
		$row = Db::getInstance()->getRow($sql);
		if ($row)
		{
			$row['date_add'] = OWLPost::formatDateAdd($row['date_add']);
			$author = new Employee($row['author']);
			$row['author'] = $author->firstname.' '.$author->lastname;
			$blogCategory = new OWLCategory($row['id_owl_blog_category'], $id_lang, $id_shop);
			$row['category'] = $blogCategory;
			if ($image_size != 'none')
			{
				$save_path = _PS_MODULE_DIR_.'owlblog/views/img/media/posts/src/'.$id_owl_blog_post;
				$url_path = __PS_BASE_URI__.'modules/owlblog/views/img/media/posts/cache/'.$id_owl_blog_post.'_'.$id_shop;
				if (file_exists($save_path.'.jpg'))
					$row['image'] = $url_path.'_'.$image_size.'.'.$this->imageType;
				else
					$row['image'] = __PS_BASE_URI__.'modules/owlblog/views/img/media/posts/cache/no_image'.'_'.$image_size.'.'.$this->imageType;
			}
			return $row;
		}
		return false;
	}
	public function allowComment($id_shop = null)	
	{
		$allowComment = $this->optionsArr['OWL_ALLOW_COMMENTS_BY_GUESTS'];
		if (!$allowComment && !$this->context->customer->id)
			return false;
		return true;
	}
	public function getBlogPostMetas($id_owl_blog_post, $id_lang = null, $id_shop = null)
	{
		$sql = 'SELECT `name`, `meta_title`, `meta_description`, `meta_keywords`
				FROM `'._DB_PREFIX_.'owl_blog_post` p
				LEFT JOIN `'._DB_PREFIX_.'owl_blog_post_lang` pl ON (p.`id_owl_blog_post` = pl.`id_owl_blog_post` AND pl.id_shop = '.$id_shop.')
				LEFT JOIN `'._DB_PREFIX_.'owl_blog_post_shop` ps ON (p.`id_owl_blog_post` = ps.`id_owl_blog_post`)
				WHERE pl.id_lang = '.$id_lang.' AND ps.id_shop = '.$id_shop.'
					AND pl.id_owl_blog_post = '.$id_owl_blog_post.'
					AND ps.active = 1';
		if ($row = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($sql))
		{
			if (empty($row['meta_description']))
				$row['meta_description'] = strip_tags($row['name']);
			if (!empty($row['meta_title']))
				$row['meta_title'] = $row['meta_title'].' - '.Configuration::get('PS_SHOP_NAME');
			else
				$row['meta_title'] = $row['name'].' - '.Configuration::get('PS_SHOP_NAME');
			return $row;
		}
	}
	public function getMetaTags($id_lang, $id_shop)
	{
		if ($id_owl_blog_post = Tools::getValue('id_owl_blog_post'))
			return $this->getBlogPostMetas($id_owl_blog_post, $id_lang, $id_shop);
	}
}