<?php
/**
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2016 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

include_once(dirname(__FILE__).'/../../classes/OWLPost.php');
require_once (dirname(__FILE__).'/../../url/OWLLink.php');	
include_once(dirname(__FILE__).'/../../classes/OWLTag.php');
class OwlBlogTagModuleFrontController extends ModuleFrontController
{
	protected $id_owl_blog_tag;
	protected $OWLLink;
	private $imageType;
	public function init()
	{
		$this->imageType = 'jpg';
		parent::init();
	}
	public function initContent()
	{
		parent::initContent();
		$this->id_owl_blog_tag = Tools::getValue('id_owl_blog_tag');
		$this->OWLLink = new OWLLink();
		$id_shop = Context::getContext()->shop->id;
		$options_str = Configuration::get('OWL_BLOG_CONFIG', null, null, $id_shop);
		$options_arr = Tools::jsonDecode($options_str, 1);
		$this->optionsArr = $options_arr;
		$this->_display();
		$this->setTemplate('tag.tpl');
	}
	public function _display()
	{
		$id_shop = Context::getContext()->shop->id;
		$id_lang = Context::getContext()->language->id;	
		/*get config*/
		$this->context->smarty->assign('owl_posts_per_page', $this->optionsArr['OWL_POSTS_PER_PAGE']);
		/*get blog_tag*/
		$owl_blog_tag = new OWLTag($this->id_owl_blog_tag);
		$this->context->smarty->assign('meta_title', $owl_blog_tag->name.'_'.Configuration::get('PS_SHOP_NAME'));
		$this->context->smarty->assign('owl_blog_tag', $owl_blog_tag);
		
		//breadcrumb
		$breadcrumb = array();
		$breadcrumb['links'] = array();
		$node_home = array();
		$node_home['title'] = $this->module->l('Home');
		$node_home['url'] = $this->context->link->getPageLink('index');
		$breadcrumb['links'][] = $node_home;
		$node_blog = array();
		$node_blog['title'] = $this->module->l('Blog');
		$node_blog['url'] = $this->context->link->getModuleLink('owlblog', 'categoryPost');
		$breadcrumb['links'][] = $node_blog;
		
		$node_end = array();
		$node_end['title'] = $owl_blog_tag->name;
		$node_end['url'] = '#';
		$breadcrumb['links'][] = $node_end;
		$breadcrumb['count'] = 3;
		
		$this->context->smarty->assign('breadcrumb', $breadcrumb);
		/*get post list*/
		$page = Tools::getValue('p');
		if ($page == null)
			$page = 0;
		$owl_post_list = $this->getPostes($page, $id_lang, $id_shop);
		if ($owl_post_list != null)
		{
			$this->context->smarty->assign('owl_postes_empty', 0);
			$this->context->smarty->assign('owl_post_list', $owl_post_list);
		}
		else
			$this->context->smarty->assign('owl_postes_empty', 1);
		/*sort post*/
		$this->context->smarty->assign('pl_orderby', (Tools::getValue('orderby') ? Tools::getValue('orderby') : 'post_date_create'));
		$this->context->smarty->assign('pl_orderway', (Tools::getValue('orderway') ? Tools::getValue('orderway') : 'DESC'));
		$sql = 'SELECT a.*, b.* FROM '._DB_PREFIX_.'owl_blog_post a
				LEFT JOIN '._DB_PREFIX_.'owl_blog_post_lang b
				ON (a.id_owl_blog_post= b.id_owl_blog_post AND b.id_shop = '.$id_shop.')
				LEFT JOIN '._DB_PREFIX_.'owl_blog_post_shop c
				ON (a.id_owl_blog_post= c.id_owl_blog_post)
				LEFt JOIN '._DB_PREFIX_.'owl_blog_post_tag pt ON (pt.id_owl_blog_post = a.id_owl_blog_post)
				WHERE a.active = 1 AND b.id_lang = '.$id_lang.' AND c.id_shop = '.$id_shop.' AND pt.id_owl_blog_tag = '.$this->id_owl_blog_tag.'';
		$count = count(Db::getInstance()->ExecuteS($sql));
		$this->_pagination($count, $id_shop);
		/* load javascript, css */
		$this->context->smarty->assign('_MODULE_DIR_', _MODULE_DIR_);
		/* -load javascript, css */
		$this->context->smarty->assign('OWLLink', $this->OWLLink);
		$this->context->smarty->assign('count', $count);
		$url_rewrite = Configuration::get('PS_REWRITING_SETTINGS');
		$this->context->smarty->assign('url_rewrite', $url_rewrite);
	}
	public function getPostes($page = 0, $id_lang = null, $id_shop = null)
	{
		$leng = (Tools::getValue('n') ? Tools::getValue('n') : $this->optionsArr['OWL_POSTS_PER_PAGE']);
		$start = $leng * ($page == 0 ? 0 : $page - 1);
		$end = $leng;
		$orderby = (Tools::getValue('orderby') ? Tools::getValue('orderby') : 'date_add');
		$orderway = (Tools::getValue('orderway') ? Tools::getValue('orderway') : 'DESC');
		$sql = 'SELECT a.*, b.* FROM '._DB_PREFIX_.'owl_blog_post a
				LEFT JOIN '._DB_PREFIX_.'owl_blog_post_lang b
				ON (a.id_owl_blog_post= b.id_owl_blog_post AND b.id_shop = '.$id_shop.')
				LEFT JOIN '._DB_PREFIX_.'owl_blog_post_shop c
				ON (a.id_owl_blog_post= c.id_owl_blog_post)
				LEFt JOIN '._DB_PREFIX_.'owl_blog_post_tag pt ON (pt.id_owl_blog_post = a.id_owl_blog_post)
				WHERE a.active = 1 AND b.id_lang = '.$id_lang.' AND c.id_shop = '.$id_shop.' AND pt.id_owl_blog_tag = '.$this->id_owl_blog_tag.'
				ORDER BY '.($orderby == 'date_add' ? 'a.' : 'b.').$orderby.' '.$orderway.'
				LIMIT '.$start.','.$end.'
				';
		$posts = Db::getInstance()->ExecuteS($sql);
		$posts_new = array();
		foreach ($posts as $post)
		{
			$postObj = new OWLPost($post['id_owl_blog_post']);
			$post['date_add_no_format'] = $post['date_add'];
			$post['date_add'] = $postObj->formatDateAdd($post['date_add']);
			$author = new Employee($post['author']);
			$post['author'] = $author->firstname.' '.$author->lastname;
			$post['count_comment'] = $postObj->getCountComment($id_lang, $id_shop);
			$post['link'] = $this->OWLLink->getLinkPostDetail($post['id_owl_blog_post'], $post['link_rewrite'], $post['id_owl_blog_category']);
			$imep = 'medium';
			if ($imep != 'none')
			{
				$save_path = _PS_MODULE_DIR_.'owlblog/views/img/media/posts/src/'.$post['id_owl_blog_post'];
				$url_path = __PS_BASE_URI__.'modules/owlblog/views/img/media/posts/cache/'.$post['id_owl_blog_post'];
				if (file_exists($save_path.'.'.$this->imageType))
					$post['image'] = $url_path.'_'.$id_shop.'_'.$imep.'.'.$this->imageType;
				else
					$post['image'] = __PS_BASE_URI__.'modules/owlblog/views/img/media/posts/cache/no_image'.'_'.$imep.'.'.$this->imageType;
			}
			$posts_new[] = $post;
		}
		return $posts_new;
	}
	public function _pagination($nbProducts = 10, $id_shop = null)
	{
		if (!self::$initialized)
			$this->init();
		elseif (!$this->context)
			$this->context = Context::getContext();
		$nArray = (int)$this->optionsArr['OWL_POSTS_PER_PAGE'] != 10 ? array((int)$this->optionsArr['OWL_POSTS_PER_PAGE'], 10, 20, 50) : array(10, 20, 50);
		// Clean duplicate values
		$nArray = array_unique($nArray);
		asort($nArray);
		$this->n = abs((int)(Tools::getValue('n', ((isset($this->context->cookie->nb_item_per_page) && $this->context->cookie->nb_item_per_page >= 10) ? $this->context->cookie->nb_item_per_page : (int)$this->optionsArr['OWL_POSTS_PER_PAGE']))));
		$this->p = abs((int)Tools::getValue('p', 1));
		if (!is_numeric(Tools::getValue('p', 1)) || Tools::getValue('p', 1) < 0)
			Tools::redirect(self::$this->context->link->getPaginationLink(false, false, $this->n, false, 1, false));
		$current_url = tools::htmlentitiesUTF8($_SERVER['REQUEST_URI']);
		//delete parameter page
		$current_url = preg_replace('/(\?)?(&amp;)?p=\d+/', '$1', $current_url);
		$range = 2; /* how many pages around page selected */
		if ($this->p < 0)
			$this->p = 0;
		if (isset($this->context->cookie->nb_item_per_page) && $this->n != $this->context->cookie->nb_item_per_page && in_array($this->n, $nArray))
			$this->context->cookie->nb_item_per_page = $this->n;
		$pages_nb = ceil($nbProducts / (int)$this->n);
		if ($this->p > $pages_nb && $nbProducts <> 0)
			Tools::redirect(self::$this->context->link->getPaginationLink(false, false, $this->n, false, $pages_nb, false));
		$start = (int)($this->p - $range);
		if ($start < 1)
			$start = 1;
		$stop = (int)($this->p + $range);
		if ($stop > $pages_nb)
			$stop = (int)$pages_nb;
		$this->context->smarty->assign('nb_products', $nbProducts);
		$pagination_infos = array(
			'products_per_page' => (int)Configuration::get('PS_PRODUCTS_PER_PAGE', null, null, $id_shop),
			'pages_nb' => $pages_nb,
			'p' => $this->p,
			'n' => $this->n,
			'nArray' => $nArray,
			'range' => $range,
			'start' => $start,
			'stop' => $stop,
			'current_url' => $current_url
		);
		$this->context->smarty->assign($pagination_infos);
	}
}