<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class OwlCountdown extends Module
{
	public function __construct()
	{
		$this->name = 'owlcountdown';
		$this->tab = 'front_office_features';
		$this->version = '1.1.0';
		$this->author = 'owltheme';
		$this->need_instance = 0;
		$this->bootstrap = true;
		parent::__construct();
		$this->displayName = $this->l('OWL Count down');
		$this->description = $this->l('Show a block display count down time');
		$this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
	}
	public function install()
	{
		if (!parent::install() || !$this->registerHook('header') || !$this->registerHook('displayCountDownProduct') || !$this->registerHook('displayCountDownProductDetial'))
				return false;
		return true;
	}
	public function uninstall()
	{
		if (!parent::uninstall() || !Configuration::deleteByName('owlcountdown'))
				return false;
		return true;
	}
	public function hookDisplayCountDownProductDetial($params)
	{
		$check_time = null;
		$product = $params['product'];
		if (isset($product->specificPrice))
		{
			$product_specific_price = $product->specificPrice;
			$this->smarty->assign('time_to', $product_specific_price['to']);
			$this->smarty->assign('time_from', $product_specific_price['from']);
			$this->smarty->assign('id_product', $product->id);
			$this->smarty->assign('prev_id', 'prod_id');
			return $this->display(__FILE__, 'owlcountdown.tpl');
		}
		else
			return false;
	}
	public function hookDisplayCountDownProduct($params)
	{
		$check_time = null;
		if (isset($params['product']['specific_prices']))
		{
			$product_specific_price = $params['product']['specific_prices'];
			$this->smarty->assign('time_to', $product_specific_price['to']);
			$this->smarty->assign('time_from', $product_specific_price['from']);
			$id_product = $params['product']['id_product'];
			$this->smarty->assign('check_time', $check_time);
			$this->smarty->assign('id_product', $id_product);
			$this->smarty->assign('prev_id', $params['prev_id']);
			return $this->display(__FILE__, 'owlcountdown.tpl');
		}
		else
			return false;
	}
	public function hookHeader()
	{
		$this->context->controller->addCss($this->_path.'views/css/owlcountdown.css');
		$this->context->controller->addJs($this->_path.'views/js/owlcountdown.js');
	}
}