<?php
/**
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2016 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

include_once(dirname(__FILE__).'/classes/CustomHtmlClass.php');
include_once(dirname(__FILE__).'/sql/SampleDataCustomHtml.php');
class OwlCustomhtml extends Module
{
	protected $error = false;
	private $_html;
	private $myHook = array('displayNav','displayTop','displayTopColumn','displayHookSpecial','displayBanner','displayLeftColumn','displayRightColumn','displayFooter','displayHome', 'displayTopHome', 'displayBottomHome', 'displayBottomFooter', 'displayCopyRight', 'displayTopFooter', 'displayProductPage', 'displayHomeLeft');
	public function __construct()
	{
		$this->name = 'owlcustomhtml';
		$this->tab = 'front_office_features';
		$this->version = '1.0.0';
		$this->author = 'owltheme';
		$this->bootstrap = true;
		parent::__construct();
		$this->displayName = $this->l('OWL Static Block');
		$this->description = $this->l('Adds Html blocks to hook');
		$this->confirmUninstall = $this->l('Are you sure that you want to delete your HTML blocks?');
	}
	
	public function install()
	{	
		if (parent::install() == false || !$this->registerHook('header') || !$this->registerHook('actionShopDataDuplication') || !$this->registerHook('actionObjectLanguageAddAfter'))
			return false;
		foreach ($this->myHook as $hook)
			if (!$this->registerHook($hook))
				return false;
		include(dirname(__FILE__).'/sql/install.php');
		$sample_data = new SampleDataCustomHtml();
		$sample_data->initData();
		return true;
	}
	public function uninstall()
	{
		include(dirname(__FILE__).'/sql/uninstall.php');
		foreach ($this->myHook as $hook)
			$this->clearCacheBlock($hook);
		if (parent::uninstall() == false)
			return false;
		return true;
	}
	public function getContent()
	{
		if (Tools::isSubmit('changeStatus') || Tools::isSubmit('delete_cat_block'))
		{
			$this->_postProcess();
			$this->_html .= $this->renderList();
		}
		elseif (Tools::isSubmit('addblock') || Tools::isSubmit('id_owlcustomhtml') || Tools::isSubmit('saveBlock'))
		{
			$this->_postProcess();
			$this->renderAddForm();
		}
		else
		{
			$this->_postProcess();
			$this->_html .= $this->renderList();
		}
		return $this->_html;
	}
	private function _postProcess()
	{
		$errors = array();
		if (Tools::isSubmit('saveBlock'))
		{
			$block = new CustomHtmlClass(Tools::getValue('id_owlcustomhtml'));
			$block->copyFromPost();
			$errors = $block->validateController();		
			if (count($errors))
				$this->_html .= $this->displayError(implode('. ', $errors));
			else
			{
				Tools::getValue('id_owlcustomhtml') ? $block->update() : $block->add();
				$this->clearCacheBlock(Tools::getValue('hook'));
				Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&saveBlockConfirmation');
			}
		}
		elseif (Tools::isSubmit('changeStatus') && Tools::getValue('id_owlcustomhtml'))
		{
			$block = new CustomHtmlClass(Tools::getValue('id_owlcustomhtml'));
			if ($block->active == 0)
				$block->active = 1;
			else
				$block->active = 0;
			$res = $block->update();
			$this->clearCacheBlock(Tools::getValue('hook'));
			$this->html .= ($res ? $this->displayConfirmation($this->l('Configuration updated')) : $this->displayError($this->l('The configuration could not be updated.')));
			Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'));
		}
		elseif (Tools::isSubmit('delete_id_block'))
		{
			$block = new CustomHtmlClass(Tools::getValue('delete_id_block'));
			$block->delete();
			$this->clearCacheBlock(Tools::getValue('hook'));
			Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&deleteBlockConfirmation');
		}
		elseif (Tools::isSubmit('saveBlockConfirmation'))
			$this->_html = $this->displayConfirmation($this->l('Static block has been saved successfully'));
		elseif (Tools::isSubmit('deleteBlockConfirmation'))
			$this->_html = $this->displayConfirmation($this->l('Static block deleted successfully'));
	}
	private function clearCacheBlock($hook)
	{
		$this->_clearCache('owlcustomhtml_'.Tools::strtolower($this->getHookName($hook)).'.tpl');
	}
	private function getHookName($id_hook, $name = false)
	{
		if (!$result = Db::getInstance()->getRow('
		SELECT `name`,`title`
		FROM `'._DB_PREFIX_.'hook` 
		WHERE `id_hook` = '.(int)($id_hook)))
			return false;
		return $result['name'];
	}
	private function getBlocks()
	{
		$this->context = Context::getContext();
		$id_lang = $this->context->language->id;
		$id_shop = $this->context->shop->id;
		if (!$result = Db::getInstance()->ExecuteS(
			'SELECT b.id_owlcustomhtml, b.hook, bs.active, bl.`title`, bl.`content` 
			FROM `'._DB_PREFIX_.'owlcustomhtml` b 
			LEFT JOIN `'._DB_PREFIX_.'owlcustomhtml_shop` bs ON (b.`id_owlcustomhtml` = bs.`id_owlcustomhtml` )
			LEFT JOIN `'._DB_PREFIX_.'owlcustomhtml_lang` bl ON (b.`id_owlcustomhtml` = bl.`id_owlcustomhtml`'.( $id_shop ? 'AND bl.`id_shop` = '.$id_shop : ' ' ).') 
			WHERE bl.id_lang = '.(int)$id_lang.
			( $id_shop ? ' AND bs.`id_shop` = '.$id_shop : ' ' )))
			return false;
		return $result;
	}
	
	public function getHookTitle($id_hook, $name = false)
	{
		if (!$result = Db::getInstance()->getRow('
			SELECT `name`,`title`
			FROM `'._DB_PREFIX_.'hook` 
			WHERE `id_hook` = '.(int)($id_hook)))
			return false;
		return (($result['title'] != '' && $name) ? $result['title'] : $result['name']);
	}
	public function renderList()
	{
		$blocks = array();
		if ($this->getBlocks() && count($this->getBlocks()) > 0)
		{
			$blocks = $this->getBlocks();
			foreach ($blocks as $key => $block)
				$blocks[$key]['status'] = $this->displayStatus($block['id_owlcustomhtml'], $block['active']);
		}
		$this->context->smarty->assign(
			array(
				'link' => $this->context->link,
				'blocks' => $blocks
			)
		);
		return $this->display(__FILE__, 'views/templates/admin/list.tpl');
	}
	public function getHookList()
	{
		$hooks = array();
		
		foreach ($this->myHook as $key => $hook)
		{
			$hooks[$key]['key'] = $hook;
			$hooks[$key]['name'] = $hook;
		}
		return $hooks;
	}
	public function renderAddForm()
	{
		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
		$hooks = $this->getHookList();
		$this->fields_form[0]['form'] = array(
					'tinymce' => true,
					'legend' => array(
					'title' => $this->l('Block item'),
			),
			'input' => array(
				array(
					'type' => 'text',
					'label' => $this->l('Title'),
					'lang' => true,
					'name' => 'title',
					'cols' => 40,
					'rows' => 10
					
				),
				array(
					'type' => 'select',
					'label' => $this->l('Hook'),
					'name' => 'hook',
					'options' => array(
						'query' => $hooks, 
						'id' => 'key',
						'name' => 'name'
					)
					
				),
				array(
					'type' => 'textarea',
					'label' => $this->l('HTML'),
					'name' => 'content',
					'lang' => true,
					'autoload_rte' => true,
					'cols' => 40,
					'rows' => 10
				),
				array(
						'type' => 'switch',
						'label' => $this->l('Displayed'),
						'name' => 'active',
						'values' => array(
									array(
										'id' => 'active_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'active_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
						),
				)
			),
			'submit' => array(
				'title' => $this->l('Save'),
			)
		);
		
		$helper = new HelperForm();
		$helper->module = $this;
		$helper->name_controller = 'owlcustomhtml';
		$helper->identifier = $this->identifier;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->show_cancel_button = true;
		$helper->back_url = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules');
		foreach (Language::getLanguages(false) as $lang)
			$helper->languages[] = array(
				'id_lang' => $lang['id_lang'],
				'iso_code' => $lang['iso_code'],
				'name' => $lang['name'],
				'is_default' => ($default_lang == $lang['id_lang'] ? 1 : 0)
			);

		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name;
		$helper->default_form_language = $default_lang;
		$helper->allow_employee_form_lang = $default_lang;
		$helper->toolbar_scroll = true;
		$helper->title = $this->displayName;
		$helper->submit_action = 'saveBlock';
		$helper->toolbar_btn = array(
			'save' =>
			array(
				'desc' => $this->l('Save'),
				'href' => $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&save'.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
			),
			'back' =>
			array(
				'href' => $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
				'desc' => $this->l('Back to list')
			)
		);
		
		$id_owlcustomhtml = Tools::getValue('id_owlcustomhtml');
		if (Tools::isSubmit('id_owlcustomhtml') && $id_owlcustomhtml)
		{
			$block = new CustomHtmlClass((int)$id_owlcustomhtml);
			$this->fields_form[0]['form']['input'][] = array('type' => 'hidden', 'name' => 'id_owlcustomhtml');
			$helper->fields_value['id_owlcustomhtml'] = (int)Tools::getValue('id_owlcustomhtml', $block->id_owlcustomhtml);
			$helper->fields_value['active'] = Tools::getValue('active', $block->active);
			$helper->fields_value['hook'] = Tools::getValue('hook', $block->hook);
		}
		else
		{
			$block = new CustomHtmlClass();
			$helper->fields_value['active'] = Tools::getValue('active', 1);
			$helper->fields_value['hook'] = Tools::getValue('hook', 9);
		}
		foreach (Language::getLanguages(false) as $lang)
		{
			$helper->fields_value['title'][(int)$lang['id_lang']] = Tools::getValue('title_'.(int)$lang['id_lang'], $block->title[(int)$lang['id_lang']]);
			$helper->fields_value['content'][(int)$lang['id_lang']] = Tools::getValue('content_'.(int)$lang['id_lang'], $block->content[(int)$lang['id_lang']]);
		}
		
		$this->_html .= $helper->generateForm($this->fields_form);
	}
	public function displayStatus($id, $active)
	{
		$status_arr = array();
		if ($active == 0)
		{
			$status_arr['title'] = $this->l('Disabled');
			$status_arr['icon'] = 'icon-remove';
			$status_arr['class'] = 'btn-danger';
		}
		else
		{
			$status_arr['title'] = $this->l('Enabled');
			$status_arr['icon'] = 'icon-check';
			$status_arr['class'] = 'btn-success';
		}
		$status_arr['s_href'] = AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&changeStatus&id_owlcustomhtml='.$id;
		return $status_arr;
	}
	
	private function getBlockFromHook($hook_name)
	{
		$block_list = array();
		$this->context = Context::getContext();
		$id_shop = $this->context->shop->id;
		
		$results = Db::getInstance()->ExecuteS('SELECT b.`id_owlcustomhtml` FROM `'._DB_PREFIX_.'owlcustomhtml` b
		LEFT JOIN `'._DB_PREFIX_.'owlcustomhtml_shop` bs ON (b.id_owlcustomhtml = bs.id_owlcustomhtml)
		WHERE bs.active = 1 AND (bs.id_shop = '.(int)$id_shop.') AND b.`hook` = "'.$hook_name.'"');
		foreach ($results as $row)
		{
			$temp = new CustomHtmlClass($row['id_owlcustomhtml']);
			$block_list[] = $temp;
		}	

		return $block_list;
	}
	public function hookDisplayNav()
	{
		if (!$this->isCached('owlcustomhtml_displaynav.tpl', $this->getCacheId('owlcustomhtml_displaynav')))
		{
			$block_list = $this->getBlockFromHook('displayNav');
			
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_displaynav.tpl', $this->getCacheId('owlcustomhtml_displaynav'));
	}
	public function hookDisplayTop()
	{
		if (!$this->isCached('owlcustomhtml_top.tpl', $this->getCacheId('owlcustomhtml_top')))
		{
			$block_list = $this->getBlockFromHook('displayTop');
			
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_top.tpl', $this->getCacheId('owlcustomhtml_top'));
	}
	public function hookdisplayHookSpecial()
	{
		if (!$this->isCached('owlcustomhtml_hookspecial.tpl', $this->getCacheId('owlcustomhtml_hookspecial')))
		{
			$block_list = $this->getBlockFromHook('displayHookSpecial');
			
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_hookspecial.tpl', $this->getCacheId('owlcustomhtml_hookspecial'));
	}
	public function hookDisplayTopColumn()
	{
		if (!$this->isCached('owlcustomhtml_topcolumn.tpl', $this->getCacheId('owlcustomhtml_topcolumn')))
		{
			$block_list = $this->getBlockFromHook('displayTopColumn');
			
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_topcolumn.tpl', $this->getCacheId('owlcustomhtml_topcolumn'));
	}
	
	public function hookDisplayLeftColumn()
	{
		if (!$this->isCached('owlcustomhtml_leftcolumn.tpl', $this->getCacheId('owlcustomhtml_leftcolumn')))
		{
			$block_list = $this->getBlockFromHook('displayLeftColumn');
			
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_leftcolumn.tpl', $this->getCacheId('owlcustomhtml_leftcolumn'));
	}
	
	public function hookDisplayRightColumn()
	{
		if (!$this->isCached('owlcustomhtml_rightcolumn.tpl', $this->getCacheId('owlcustomhtml_rightcolumn')))
		{
			$block_list = $this->getBlockFromHook('displayRightColumn');
			
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_rightcolumn.tpl', $this->getCacheId('owlcustomhtml_rightcolumn'));
	}
	
	public function hookDisplayFooter()
	{
		if (!$this->isCached('owlcustomhtml_footer.tpl', $this->getCacheId('owlcustomhtml_footer')))
		{
			$block_list = $this->getBlockFromHook('displayFooter');
			
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_footer.tpl', $this->getCacheId('owlcustomhtml_footer'));
	}
	
	public function hookDisplayHome()
	{
		if (!$this->isCached('owlcustomhtml_home.tpl', $this->getCacheId('owlcustomhtml_home')))
		{
			$block_list = $this->getBlockFromHook('displayHome');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_home.tpl', $this->getCacheId('owlcustomhtml_home'));
	}
	public function hookDisplayTopHome()
	{
		if (!$this->isCached('owlcustomhtml_displaytophome.tpl', $this->getCacheId('owlcustomhtml_displaytophome')))
		{
			$block_list = $this->getBlockFromHook('displayTopHome');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_displaytophome.tpl', $this->getCacheId('owlcustomhtml_displaytophome'));
	}
	public function hookDisplayBottomHome()
	{
		if (!$this->isCached('owlcustomhtml_displaybottomhome.tpl', $this->getCacheId('owlcustomhtml_displaybottomhome')))
		{
			$block_list = $this->getBlockFromHook('displayBottomHome');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_displaybottomhome.tpl', $this->getCacheId('owlcustomhtml_displaybottomhome'));
	}
	public function hookDisplayBottomFooter()
	{
		if (!$this->isCached('owlcustomhtml_displaybottomfooter.tpl', $this->getCacheId('owlcustomhtml_displaybottomfooter')))
		{
			$block_list = $this->getBlockFromHook('displayBottomFooter');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_displaybottomfooter.tpl', $this->getCacheId('owlcustomhtml_displaybottomfooter'));
	}
	public function hookDisplayTopFooter()
	{
		if (!$this->isCached('owlcustomhtml_displaytopfooter.tpl', $this->getCacheId('owlcustomhtml_displaytopfooter')))
		{
			$block_list = $this->getBlockFromHook('displayTopFooter');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_displaytopfooter.tpl', $this->getCacheId('owlcustomhtml_displaytopfooter'));
	}
	
	public function hookDisplayCopyRight()
	{
		if (!$this->isCached('owlcustomhtml_displaycopyright.tpl', $this->getCacheId('owlcustomhtml_displaycopyright')))
		{
			$block_list = $this->getBlockFromHook('displayCopyRight');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_displaycopyright.tpl', $this->getCacheId('owlcustomhtml_displaycopyright'));
	}
	public function hookDisplayProductPage()
	{
		if (!$this->isCached('owlcustomhtml_displayproductpage.tpl', $this->getCacheId('owlcustomhtml_displayproductpage')))
		{
			$block_list = $this->getBlockFromHook('displayProductPage');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_displayproductpage.tpl', $this->getCacheId('owlcustomhtml_displayproductpage'));
	}
	public function hookDisplayHomeLeft()
	{
		if (!$this->isCached('owlcustomhtml_displayhomeleft.tpl', $this->getCacheId('owlcustomhtml_displayhomeleft')))
		{
			$block_list = $this->getBlockFromHook('displayHomeLeft');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		}
		return $this->display(__FILE__, 'owlcustomhtml_displayhomeleft.tpl', $this->getCacheId('owlcustomhtml_displayhomeleft'));
	}
	
	public function hookHeader($params)
	{
		$this->context->controller->addCSS($this->_path.'views/css/owlcustomhtml.css');
	}
	public function hookActionShopDataDuplication($params)
	{
		Db::getInstance()->execute('
		INSERT IGNORE INTO '._DB_PREFIX_.'owlcustomhtml_shop (id_owlcustomhtml, id_shop, active)
		SELECT id_owlcustomhtml, '.(int)$params['new_id_shop'].', active
		FROM '._DB_PREFIX_.'owlcustomhtml_shop
		WHERE id_shop = '.(int)$params['old_id_shop']);
		
		Db::getInstance()->execute('
		INSERT IGNORE INTO '._DB_PREFIX_.'owlcustomhtml_lang (id_owlcustomhtml, id_lang, id_shop, title, content)
		SELECT id_owlcustomhtml, id_lang, '.(int)$params['new_id_shop'].', title, content
		FROM '._DB_PREFIX_.'owlcustomhtml_lang
		WHERE id_shop = '.(int)$params['old_id_shop']);
	}
	public function hookActionObjectLanguageAddAfter($params)
	{
		Db::getInstance()->execute('
		INSERT IGNORE INTO '._DB_PREFIX_.'owlcustomhtml_lang (id_owlcustomhtml, id_lang, id_shop, title, content)
		SELECT id_owlcustomhtml, '.(int)$params['object']->id.', id_shop, title, content
		FROM '._DB_PREFIX_.'owlcustomhtml_lang
		WHERE id_lang = '.(int)Configuration::get('PS_LANG_DEFAULT'));	
	}
}
?>