<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

class OwlMobileMenu extends Module
{
	private $temp_url = '{owlmobilemenu_url}';
	private $html;
	private $settings_default;
	private $config;
	protected $user_groups;
	public function __construct()
	{
		$this->name = 'owlmobilemenu';
		$this->tab = 'front_office_features';
		$this->version = '1.0.0';
		$this->author = 'owltheme';
		$this->bootstrap = true;
		parent::__construct();
		$this->displayName = $this->l('OWL Mobile Menu');
		$this->description = $this->l('Show Mobile Menu');
	}
	public function install()
	{
		if (!parent::install() || !$this->registerHook('displayMobileMenu') || !$this->registerHook('displayTop'))
			return false;
		return true;
	}
	
	public function hookdisplayHeader()
	{
		$this->context->controller->addCSS(($this->_path).'views/css/owlmobilemenu.css');
		$this->context->controller->addJS(($this->_path).'views/js/owlmobilemenu.js');
	}
	
	public function getRespCategories($id_category = 2, $id_lang = false)
	{
		$id_lang = $id_lang ? (int)$id_lang : (int)Context::getContext()->language->id;
		$categories = Category::getNestedCategories($id_category, $id_lang, false, $this->user_groups);
		$menu = $this->generateCategoriesMenu($categories);
		return $menu;
	}
	
	public function generateCategoriesMenu($categories, $is_children = 0)
	{
		$nodes = [];
		foreach ($categories as $key => $category)
		{
			$node = $this->makeNode([]);
			if ($category['level_depth'] > 1)
			{
				$cat = new Category($category['id_category']);
				$link = $cat->getLink();
			}
			else
				$link = $this->context->link->getPageLink('index');
			$node['id'] = $category['id_category'];
			$node['url'] = $link;
			$node['type'] = 'category';
			$node['page_identifier'] = 'category-'.$category['id_category'];
			if ((bool)$category['active'] === false)
				continue;
		
			if (isset($this->context->smarty->tpl_vars['page_name']))
			{
				$page_name = $this->context->smarty->tpl_vars['page_name']->value;
				$current = $page_name == 'category' && (int)Tools::getValue('id_category') == (int)$category['id_category'];
				$node['current'] = $current;
			}
			
			$node['label']   = $category['name'];
			$node['image_urls']  = [];

			if (isset($category['children']) && !empty($category['children']))
			{
				$node['children'] = $this->generateCategoriesMenu($category['children'], 1);
				$files = scandir(_PS_CAT_IMG_DIR_);
				if (count(preg_grep('/^'.$category['id_category'].'-([0-9])?_thumb.jpg/i', $files)) > 0)
				{
					foreach ($files as $file)
					{
						if (preg_match('/^'.$category['id_category'].'-([0-9])?_thumb.jpg/i', $file) === 1)
						{
							$image_url = $this->context->link->getMediaLink(_THEME_CAT_DIR_.$file);
							$node['image_urls'][] = $image_url;
						}
					}
				}
			}
			$nodes[] = $node;
		}
		return $nodes;
	}
	
	protected function makeNode(array $fields)
	{
		$defaults = [
			'type' => '',
			'label' => '',
			'url' => '',
			'children' => [],
			'open_in_new_window' => false,
			'image_urls' => [],
			'page_identifier' => null,
			'id' => 2
		];
		return array_merge($defaults, $fields);
	}
	
	public function hookdisplayMobileMenu()
	{
		$id_lang = (int)$this->context->language->id;
		$id_shop = (int)Context::getContext()->shop->id;
		$id = 2;
		$category = new Category($id, $id_lang, $id_shop);
		$mobile_menu = $this->getRespCategories($id, $id_lang);
		$this->context->smarty->assign(
			array('mobile_menu' => $mobile_menu)
		);
		
		return $this->display(__FILE__, 'owlmobilemenu.tpl');
	}
	public function hookDisplayTop()
	{
		/*return $this->display(__FILE__, 'owlmobilemenu_icon.tpl');*/
	}
}