{**
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2016 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{$id_lang = Context::getContext()->language->id}
{foreach from = $product_groups item = product_group name = product_group}
	<div class="{$product_group.class|escape:'html':'UTF-8'} product_list">
		<div class="block-home-title">
			<div class="owl-out-title">
				<h3>{l s='Deals of the days' mod='owlproductfilter'}</h3>
			</div>
		</div>
	<div class="out-prod-filter">
			<div class="prod-filter-inner clearfix">
				{if isset($product_group.product_list) && count($product_group.product_list) > 0}
					{foreach from=$product_group.product_list item=product name=product_list}
						{if isset($product.id_product)}
						<div class="item product-box ajax_block_product">
							<div class="product-container">
							<div class="row">
								<div class="prod-filter-left col-md-5">
									<div class="product-container-img">
										<a class="product_img_link" href="{$product.link|escape:'html':'UTF-8'}">
											<img src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'medium_default')|escape:'html':'UTF-8'}" alt="{$product.legend|escape:html:'UTF-8'}" />
										</a>
										<div class="owl-label">
										{if isset($product.new) && $product.new == 1}
											<a class="new-box" href="{$product.link|escape:'html':'UTF-8'}">
												<span class="new-label">{l s='New' mod='owlproductfilter'}</span>
											</a>
										{/if}
										
										</div>
										{hook h='displayCountDownProduct' product=$product prev_id = 'prod_home_special'}
									</div>
								</div>
								<div class="prod-filter-right col-md-7">
									<div class="offer_area clearfix">
										<h2>{l s='Product of the Day with' mod='owlproductfilter'} <span class="discount-percent">45%</span> {l s='OFF' mod='owlproductfilter'}</h2>
										<p class="t2">{l s='Hurry on! Its a limited time proposition. Next day another template will be discounted.' mod='owlproductfilter'}</p>
									</div>
									<h5 class="product-name">
										<a href="{$product.link|escape:'html':'UTF-8'}" title="{$product.name|escape:html:'UTF-8'}">{$product.name|truncate:20:''|escape:'html':'UTF-8'}</a>
									</h5>
									{hook h='displayProductListReviews' product=$product}
									<div class="attribute-color clearfix">
										{hook h='displayProductAttributes' product=$product}
									</div>
									{if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
									<div class="content_price clearfix">
										{if isset($product.show_price) && $product.show_price && !isset($restricted_country_mode)}
											{if isset($product.specific_prices) && $product.specific_prices && isset($product.specific_prices.reduction) && $product.specific_prices.reduction > 0}
												<div class="price-item">
													<label>Your Price</label>
													<span class="price product-price special-price">
														{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}
													</span>
												</div>
												{hook h="displayProductPriceBlock" product=$product type="old_price"}
												<div class="price-item">
													<label>Old Price</label>
													<span class="old-price product-price">
														{displayWtPrice p=$product.price_without_reduction}
													</span>
													{hook h="displayProductPriceBlock" id_product=$product.id_product type="old_price"}
												</div>
											{else}
												<span class="price product-price">
												{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}
												</span>
											{/if}
											{hook h="displayProductPriceBlock" product=$product type="price"}
											
											{if isset($product.specific_prices) && $product.specific_prices && isset($product.specific_prices.reduction) && $product.specific_prices.reduction > 0}
											<div class="price-item">
												<label>Your Save</label>
												{if $product.specific_prices.reduction_type == 'percentage'}
													<span>-{$product.specific_prices.reduction|escape:'html':'UTF-8' * 100}%</span>
												{else}
													<span class="sale-label">{l s='Sale' mod='owlproductfilter'}</span>
												{/if}	
											</div>
											{/if}
											{hook h="displayProductPriceBlock" product=$product type="unit_price"}
										{/if}
									</div>
									{/if}
									
									<div class="out-button">
										<div class="functional-buttons">
											{if ($product.id_product_attribute == 0 || (isset($add_prod_display) && ($add_prod_display == 1))) && $product.available_for_order && !isset($restricted_country_mode) && $product.customizable != 2 && !$PS_CATALOG_MODE}
												{if (!isset($product.customization_required) || !$product.customization_required) && ($product.allow_oosp || $product.quantity > 0)}
													{capture}add=1&amp;id_product={$product.id_product|intval}{if isset($static_token)}&amp;token={$static_token|escape:'html':'UTF-8'}{/if}{/capture}
													<a class="button ajax_add_to_cart_button btn btn-default" href="{$link->getPageLink('cart', true, NULL, $smarty.capture.default, false)|escape:'html':'UTF-8'}" rel="nofollow" data-id-product="{$product.id_product|intval}" data-minimal_quantity="{if isset($product.product_attribute_minimal_quantity) && $product.product_attribute_minimal_quantity > 1}{$product.product_attribute_minimal_quantity|intval}{else}{$product.minimal_quantity|intval}{/if}">
													    <i class="icon-basket"></i>
														<span>{l s='Add to cart' mod='owlproductfilter'}</span>
													</a>
												{else}
													<span class="button ajax_add_to_cart_button btn btn-default disabled">
														<span>{l s='Out of stock' mod='owlproductfilter'}</span>
													</span>
												{/if}
											{/if}
										</div>
										{if isset($quick_view) && $quick_view}
											<a class="quick-view" href="{$product.link|escape:'html':'UTF-8'}" data-toggle="tooltip" title="{l s='Quick view' mod='owlproductfilter'}">
												<span>{l s='Quick view' mod='owlproductfilter'}</span>
											</a>
										{/if}
									</div>
								</div>
							</div>
							</div>
						</div>
						{/if}
					{/foreach}
				
				{else}
					<div class="item product-box ajax_block_product">
						<p class="alert alert-warning">{l s='No product at this time' mod='owlproductfilter'}</p>
					</div>	
				{/if}
			</div>
	  </div>
	</div>
{/foreach}