/**
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    Codespot SA <support@presthemes.com>
*  @copyright 2007-2016 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

function isMobileIpad() {
	if(navigator.userAgent.match(/Android/i) ||
		navigator.userAgent.match(/webOS/i) ||
		navigator.userAgent.match(/iPad/i) ||
		navigator.userAgent.match(/iPhone/i) ||
		navigator.userAgent.match(/iPod/i)
		){
			return true;
	}
	else return false;
}

function isMobile() {
	if(navigator.userAgent.match(/Android/i) ||
		navigator.userAgent.match(/webOS/i) ||
		navigator.userAgent.match(/iPhone/i) ||
		navigator.userAgent.match(/iPod/i)
		){
			return true;
	}
	else return false;
}

$(function(){
	$(window).on("load",function()
	{
		$(".menu-mobile-inner").mCustomScrollbar({
			theme:"minimal"
		});
	});
			
	var scrol_to_top = 1;
	if (typeof scrol_to_top !== "undefined" && scrol_to_top)
	{
		if($(this).scrollTop()==0)		
			$('#owl_scroll_top').addClass('disabled');
	
		$(window).scroll(function(){
			if($(this).scrollTop()!=0)
				$('#owl_scroll_top').removeClass('disabled');
			else
				$('#owl_scroll_top').addClass('disabled');
		});
		$('#owl_scroll_top').click(function(){
			$('body,html').animate({scrollTop:0},500);
		});
	}
});

$(document).ready(function()
{
	checkBrowser();
	searchdropDown();
    $('[data-toggle="tooltip"]').tooltip();
	
	$(document).on('click', '#switch_left_column .icon_wrap', function()
	{
		$('#left_column').addClass('open-left');
		$('body#category').addClass('no-scroll');		
		$("body#category").append('<div class="modal-backdrop fade in"></div>');
		$("#left_column.open-left").mCustomScrollbar({
			theme:"dark-2"
		});
	});
	
	$(document).on('click', '.left-icon-back .icon-back', function()
	{
		$('#left_column').removeClass('open-left');
		$('body#category').removeClass('no-scroll');
		$('.modal-backdrop').remove();
	});
	if(isMobile())
	{
		$('.product_tab_container').addClass('mobile');
		accordionProductTab();
	}
		

});

function searchdropDown()
{
	elementClick1 = '#search_block_top .search_hover';
	elementSlide1 = '#search_block_top .drop_search';
	activeClass1 = 'active';

	$(elementClick1).on('click', function(e){
		e.stopPropagation();
		var subUl = $(this).next(elementSlide1);
		if(subUl.is(':hidden'))
		{
			subUl.slideDown();
			$(this).addClass(activeClass1);
		}
		else
		{
			if($(window).width()>=768)
			{
				subUl.slideUp();
				$(this).removeClass(activeClass1);
			}
		}
		if($(window).width()>=768)
		{
			$(elementClick1).not(this).next(elementSlide1).slideUp();
			$(elementClick1).not(this).removeClass(activeClass1);
		}
		e.preventDefault();
	});
	$(elementSlide1).on('click', function(e){
		e.stopPropagation();
	});
	$(document).on('click', function(e){
		if($(window).width()>=768)
		{
			e.stopPropagation();
			var elementHide1 = $(elementClick1).next(elementSlide1);
			$(elementHide1).slideUp();
			$(elementClick1).removeClass('active');
		}
	});
	$(window).resize(function(){
		if($(window).width()<768)
			$('#search_block_top .drop_search').show();
		else
			$('#search_block_top .drop_search').hide();
	});	
}
function checkBrowser()
{
	var isOpera = !!window.opera || navigator.userAgent.indexOf(' OPR/') >= 0;
	var isFirefox = typeof InstallTrigger !== 'undefined';
	var isSafari = Object.prototype.toString.call(window.HTMLElement).indexOf('Constructor') > 0;
	var isChrome = !!window.chrome && !isOpera;
	var isIE = false || !!document.documentMode;
	
	if(isChrome || isSafari)
	{
		$('.bn-top-home ul li:first-child').css('margin-bottom','1px');
	}
	else
		return false;
}

function accordionProductTab()
{
	$('.product_tab_container h2.title_block').on('click', function(e){
		$(this).toggleClass('active').next('.toggle-footer').stop().slideToggle('medium');
		e.preventDefault();
	})
	$('.product_tab_container').addClass('accordion').find('.toggle-footer').slideUp('fast');
}