{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2016 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{if count($categoryProducts) > 0 && $categoryProducts !== false}
<section class="page-product-box blockproductscategory">
	
	    <div class="block-home-title">
			          <div class="owl-out-title">
					  <h3 class="productscategory_h3 page-product-heading">
						{if $categoryProducts|@count == 1}
							{l s='product in the same category' mod='productscategory'}
						{else}
							{l s='products in the same category' mod='productscategory'}
						{/if}
					</h3>
					  </div>
		 </div>
	<div id="productscategory_list" class="products_block clearfix">
		<ul id="bxslider1" class="bxslider clearfix">
		{foreach from=$categoryProducts item='categoryProduct' name=categoryProduct}
			<li class="product-box item">
				<div class="product-container">
				<div class="product-container-img">
					<a class="product_img_link" href="{$link->getProductLink($categoryProduct.id_product, $categoryProduct.link_rewrite, $categoryProduct.category, $categoryProduct.ean13)}" class="lnk_img product-image" title="{$categoryProduct.name|htmlspecialchars}">
					<img src="{$link->getImageLink($categoryProduct.link_rewrite, $categoryProduct.id_image, 'home_default')|escape:'html':'UTF-8'}" alt="{$categoryProduct.name|htmlspecialchars}" /></a>
					<div class="owl-label">
					{if isset($categoryProduct.specific_prices) && $categoryProduct.specific_prices && isset($categoryProduct.specific_prices.reduction) && $categoryProduct.specific_prices.reduction > 0}
					  <a class="sale-box" href="{$categoryProduct.link|escape:'html':'UTF-8'}">
						{if $categoryProduct.specific_prices.reduction_type == 'percentage'}
							<span class="price-percent-reduction">-{$categoryProduct.specific_prices.reduction|escape:'html':'UTF-8' * 100}%</span>
						{else}
							<a class="sale-box" href="{$categoryProduct.link|escape:'html':'UTF-8'}">
							<span class="sale-label">{l s='Sale' mod='wtproductfilter'}</span>
							</a>
						{/if}	
						</a>
					{/if}
					</div>
					<div class="prod-hover">
					
						<div class="functional-buttons clearfix">
							{if !$PS_CATALOG_MODE && ($categoryProduct.allow_oosp || $categoryProduct.quantity > 0)}
								<div class="no-print">
									<a class="exclusive button ajax_add_to_cart_button" href="{$link->getPageLink('cart', true, NULL, 'qty=1&amp;id_product={$categoryProduct.id_product|intval}&amp;token={$static_token}&amp;add')|escape:'html':'UTF-8'}" data-id-product="{$categoryProduct.id_product|intval}" title="{l s='Add to cart' mod='productscategory'}">
										<span>{l s='Add to cart' mod='productscategory'}</span>
									</a>
								</div>
							{/if}
						</div>
					</div>
				</div>
				<h5 itemprop="name" class="product-name">
					<a href="{$link->getProductLink($categoryProduct.id_product, $categoryProduct.link_rewrite, $categoryProduct.category, $categoryProduct.ean13)|escape:'html':'UTF-8'}" title="{$categoryProduct.name|htmlspecialchars}">{$categoryProduct.name|truncate:30:'...'|escape:'html':'UTF-8'}</a>
				</h5>
				{if $ProdDisplayPrice && $categoryProduct.show_price == 1 && !isset($restricted_country_mode) && !$PS_CATALOG_MODE}
					<div class="content_price">
					{if isset($categoryProduct.specific_prices) && $categoryProduct.specific_prices
					&& ($categoryProduct.displayed_price|number_format:2 !== $categoryProduct.price_without_reduction|number_format:2)}

						<span class="price special-price">{convertPrice price=$categoryProduct.displayed_price}</span>
						<span class="old-price">{displayWtPrice p=$categoryProduct.price_without_reduction}</span>

					{else}
						<span class="price">{convertPrice price=$categoryProduct.displayed_price}</span>
					{/if}
					</div>
				{else}
				<br />
				{/if}
				</div>
			</li>
		{/foreach}
		</ul>
	</div>
</section>
{/if}
