<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

class Tmcategoryslider extends Module
{
    protected $html = '';
    protected $spacer_size = '5';
    protected $_postErrors  = array();

    public function __construct()
    {
        $this->name = 'tmcategoryslider';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'TemplateMela';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('TM - Category Product Slider');
        $this->description = $this->l('Adds a block with sub category.');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall this module?');

        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        $arrayDefault = array('3','4','5','6');
        Configuration::updateValue("TM_CATE_LIST", serialize($arrayDefault)); // Empty array that contains ID categories
		Configuration::updateValue("TM_CATE_SLIDER", 1);
		Configuration::updateValue("TM_CATE_NBR", 5);
	
        include(dirname(__FILE__).'/sql/install.php');

        return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('displayHome');
    }

    public function uninstall()
    {
        Configuration::deleteByName('TM_CATE_LIST');
		Configuration::deleteByName('TM_CATE_SLIDER');
		Configuration::deleteByName('TM_CATE_NBR');

        include(dirname(__FILE__).'/sql/uninstall.php');

        return parent::uninstall();
    }

    public function getContent()
    {
        $output = '';
		
        if (((bool)Tools::isSubmit('submitTmcategoryslider')) == true) {
            $ids = Tools::getValue('TM_CATE_LIST');
			$nbr = (int)Tools::getValue('TM_CATE_NBR');
            if (empty($ids) || !is_array($ids)) {
                $ids = array(1);
            } else if (!$nbr || $nbr <= 0 || !Validate::isInt($nbr)) {
				$errors[] = $this->l('An invalid number of products has been specified.');
			}
			
			if (isset($errors) && count($errors))
                $output = $this->displayError(implode('<br />', $errors));
            else
            {
				Configuration::updateValue('TM_CATE_SLIDER', (int)(Tools::getValue('TM_CATE_SLIDER')));
                Configuration::updateValue('TM_CATE_NBR', (int)($nbr));
	            Configuration::updateValue('TM_CATE_LIST', serialize($ids));
				$output .= $this->displayConfirmation($this->l('Your settings have been updated.'));
			}
        }

        if (((bool)Tools::isSubmit('submitCategoryImage')) == true) {
            $category_id = Tools::getValue('category_id');
            $id_lang = (int) Context::getContext()->language->id;
            $id_lang = $id_lang ? (int)$id_lang : (int)Context::getContext()->language->id;
            $id_shop = (int) Context::getContext()->shop->id;
            $category = new Category((int)$category_id, (int)$id_lang, (int)$id_shop);
            $name_cate = $category->name;
            if($_FILES['imagethumb']['tmp_name']!='') {
                $upload_path = _PS_MODULE_DIR_.$this->name.'/views/img/';
                $filename = $category_id.'-'.Tools::stripslashes($this->name).'.jpg';
                if(move_uploaded_file($_FILES['imagethumb']['tmp_name'],$upload_path .$filename)) {
                    $cate_exit = $this->getimage($category_id, $id_shop);
                    if($cate_exit ==null) {
                        $this->addcategoryicon($category_id,$name_cate,$filename,$id_shop);
                        $output .= $this->displayConfirmation($this->l('Add Image Successfully'));
                    } else {
                        $this->updatecategoryicon($category_id,$name_cate,$filename);
                        $output .= $this->displayConfirmation($this->l('Updated Successfully'));
                    }
                }
            }
        }

        if (Tools::isSubmit('deletetmcategoryslider') && Tools::getValue('id_category')) {
            $category_id = Tools::getValue('id_category');
            $id_lang = (int) Context::getContext()->language->id;
            $id_lang = $id_lang ? (int)$id_lang : (int)Context::getContext()->language->id;
            $id_shop = (int) Context::getContext()->shop->id;
            $category = new Category((int)$category_id, (int)$id_lang, (int)$id_shop);
            $name_cate = $category->name;
            $upload_path = _PS_MODULE_DIR_.$this->name.'/views/img/';
            $filename = $category_id.'-'.Tools::stripslashes($this->name).'.jpg';
            $cate_exit = $this->getimage($category_id, $id_shop);
            if($cate_exit == null) {
                $output .= $this->displayConfirmation($this->l('No Image Found'));
            } else {
                $this->deleteCategoryId(Tools::getValue('id_category'));
                unlink ($upload_path.$filename);
                $output .= $this->displayConfirmation($this->l('Deleted Successfully'));
            }
        }

        $this->context->smarty->assign('module_dir', $this->_path);

        return $output.$this->renderForm().$this->imageForm().$this->renderList();
    }

    protected function renderForm()
    {
        $values = $this->getConfigFormValues(); // Get values form database
        $var = $values['TM_CATE_LIST'];
        if (!is_array($var)) {
            $var = array(1);
        }

        $fields_form = array(
            'form' => array(
                'legend' => array(
                'title' => $this->l('Category List'),
                'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'categories',
                        'label' => $this->l('Show Link/Label Category:'),
                        'name' => 'TM_CATE_LIST',
                        'class' => 'fixed-width-xs',
                        'desc' => $this->l('Set the categories to be showed.'),
                        'tree'  => array(
                            'id'                  => 'categories-tree',
                            'selected_categories' => $var,
                            'disabled_categories' => null,
                            'use_search'          => true,
                            'use_checkbox'        => true,
                        ),
                    ),
					array(
                        'type' => 'switch',
                        'label' => $this->l('Display Products as Slider'),
                        'name' => 'TM_CATE_SLIDER',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
					array(
                        'col' => 3,
                        'type' => 'text',
                        'name' => 'TM_CATE_NBR',
                        'label' => $this->l('Products to Display'),
                    )
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                    'name' => 'submitTmcategoryslider',
                ),
            ),
        );

        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitTmcategoryslider';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($fields_form));
    }

    protected function getConfigFormValues()
    {
        $result =  array(
            'TM_CATE_LIST' =>  Tools::getValue('TM_CATE_LIST', Configuration::get('TM_CATE_LIST')),
			'TM_CATE_SLIDER' =>  Tools::getValue('TM_CATE_SLIDER', Configuration::get('TM_CATE_SLIDER')),
			'TM_CATE_NBR' =>  Tools::getValue('TM_CATE_NBR', Configuration::get('TM_CATE_NBR')),
            'category_id' => Tools::getValue('category_id', Configuration::get('category_id')),
        );

        if(!is_array($result['TM_CATE_LIST']) && !empty($result['TM_CATE_LIST'])) {
            $result['TM_CATE_LIST'] = unserialize($result['TM_CATE_LIST']);
        }

        return $result;
    }

    protected function imageForm()
    {
        $id_lang = (int)Context::getContext()->language->id;
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Upload Image For Categories'),
                    'icon' => 'icon-upload',
                ),
                'input' => array(
                    array(
                        'type' => 'file',
                        'label' => $this->l('Upload Category Image:'),
                        'name' => 'imagethumb',
                        'id' => 'imagethumb',
                    ),
                    array(
                        'type' => 'category_list',
                        'label' => 'Select Category:',
                        'name' => 'category_id',
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                    'name' => 'submitCategoryImage',
                ),
            ),
        );

        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitCategoryImage';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
            'options_image' => $this->getCategoryOptions(1, (int)$id_lang, (int)Shop::getContextShopID()),
        );
        $helper->override_folder = '/';

        return $helper->generateForm(array($fields_form));
    }

    protected function renderList()
    {
        $fields_list = array(
            'id_tmcategoryslider' => array(
                'title' => $this->l(' ID'),
                'type' => 'text',
            ),
            'id_shop' => array(
                'title' => $this->l('ID shop'),
                'type' => 'text',
            ),
            'image' => array(
                'title' => $this->l('Icon Category '),
                'type' => 'text',
            ),
            'id_category' => array(
                'title' => $this->l('ID Category'),
                'type' => 'text',
            ),
            'name_category' => array(
                'title' => $this->l('Name Category'),
                'type' => 'text',
            ),
        );

        $helper = new HelperList();
        $helper->shopLinkType = '';
        $helper->simple_header = true;
        $helper->identifier = 'id_category';
        $helper->actions = array('delete');
        $helper->show_toolbar = false;

        $helper->title = $this->l('Category Image List');
        $helper->table = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $links = $this->getcategoryicon();
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        if (is_array($links) && count($links))
            return $helper->generateList($links, $fields_list);
        else
            return false;
    }

    protected function getCategoryOptions($id_category = 1, $id_lang = false, $id_shop = false, $space = true)
    {
        $id_lang = $id_lang ? (int)$id_lang : (int)Context::getContext()->language->id;
        $category = new Category((int)$id_category, (int)$id_lang, (int)$id_shop);

        if (is_null($category->id))
        {
            return;
        }
        if ($space)
        {
            $children = Category::getChildren((int)$id_category, (int)$id_lang, true, (int)$id_shop);
            $spacer = str_repeat('&nbsp;', $this->spacer_size * (int)$category->level_depth);
        }
        $shop = (object)Shop::getShop((int)$category->getShopID());
        $this->html .= '<option value="'.(int)$category->id.'">'.(isset($spacer) ? $spacer : '').$category->name.'('.$shop->name.')</option>';

        if (isset($children) && count($children))
        {
            foreach ($children as $child) {
                $this->getCategoryOptions((int)$child['id_category'], (int)$id_lang, (int)$child['id_shop']);
            }
            return $this->html;
        }
    }
	
    public  function addcategoryicon($category_id,$name_cate,$filename,$id_shop)
    {
        $result = Db::getInstance()->execute('INSERT  INTO `'._DB_PREFIX_.'tmcategoryslider`(`id_category`,`name_category`,`image`,`id_shop`) VALUES ('.(int)$category_id.', \''.pSQL($name_cate).'\', \''.pSQL($filename).'\','.(int)$id_shop.')');
        return $result;
    }

    public function updatecategoryicon($category_id,$name_cate,$filename)
    {
        $result = Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.'tmcategoryslider` SET `name_category` = \''.pSQL($name_cate).'\',`image` =\''.pSQL($filename).'\' WHERE `id_category` = '.(int)$category_id);
        return $result;
    }

    public static function deleteCategoryId($category_id)
    {
        $sql = 'DELETE FROM `'._DB_PREFIX_.'tmcategoryslider` WHERE `id_category` = '.(int)$category_id;
        Db::getInstance()->execute($sql);
    }
    
    public function getimage($category_id,$id_shop)
    {
        $sql = 'SELECT id_tmcategoryslider ,image,id_category,name_category FROM '._DB_PREFIX_.'tmcategoryslider WHERE id_category = '.(int)$category_id.' and id_shop ='.(int)$id_shop.'' ;
        return Db::getInstance()->executeS($sql);
    }

    public function getcategoryicon()
    {
        $sql = 'SELECT id_tmcategoryslider ,image,id_category,name_category, id_shop FROM '._DB_PREFIX_.'tmcategoryslider';
        return Db::getInstance()->executeS($sql);
    }

    public function hookHeader($params)
    {
        $this->context->controller->addCSS($this->_path.'/views/css/tmcategoryslider.css');
    }

    public function hookDisplayHome($params)
    {
        $id_lang = (int)Context::getContext()->language->id;
        $id_shop = (int)Context::getContext()->shop->id;
        $config_values = $this->getConfigFormValues();        
        $arrayCategory = array();
        $categoryimg = '';
		$nb = Configuration::get('TM_CATE_NBR');
        foreach ($config_values['TM_CATE_LIST'] as $id){
            if($id == 1) { continue; }
		    $category = new Category((int)$id, $id_lang, $id_shop);			
            $child_cate = Category::getChildren((int)$id, $id_lang);			
            $categoryids = $this->getimage($id, $id_shop);
			$categoryProducts = $category->getProducts($this->context->language->id, 0, ($nb ? $nb : 8));			
			//$childcategoryProducts =  $child_cate->getProducts($this->context->language->id, 0, ($nb ? $nb : 8));
           
		    foreach ($categoryids as $categoryid) {
                $categoryimg = $categoryid;
            }
            $html = '';
			if($categoryProducts) {
				$arrayCategory[] = array('id' => $id, 'html'=>$html, 'name'=> $category->name, 'category'=> $category, 'description'=> $category->description, 'child_cate'=>$child_cate,'cate_id' =>$categoryimg, 'product' => $categoryProducts );
			}
			
       }
        $this->smarty->assign(array(
            'tmcategoryinfos' => $arrayCategory,
			'homeSize' => Image::getSize(ImageType::getFormatedName('home')),
			'slider' => (int)Configuration::get('TM_CATE_SLIDER'),
		));
        return $this->display(__FILE__, 'tmcategoryslider.tpl');
   }   
}
