{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2016 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<div id="tmmanufacturerblock" class="block products_block clearfix">
	<h2 class="homepage-heading">{l s='Manufacturer' mod='tmmanufacturerblock'}</h2>

	{if isset($tmmanufacturer) && $tmmanufacturer}
		<!-- Custom start -->
		{assign var='sliderFor' value=5} <!-- Define Number of product for SLIDER -->
		{assign var='productCount' value=count($tmmanufacturer)}
	
		{if $productCount >= $sliderFor}
			<div class="customNavigation">
				<a class="btn prev tmmanufacture_prev"></a>
				<a class="btn next tmmanufacture_next"></a>
			</div>
		{/if}		
		<!-- Custom End -->

		<div class="block_content row">
			<ul id="manufacturer-carousel" class="tm-carousel owl-carousel product_list">
				{foreach from=$tmmanufacturer item=manufacturer name=manufacturerList}
					<li class="item">
						<div class="manufacturer_image">
							<a href="{$link->getmanufacturerLink($manufacturer.id_manufacturer, $manufacturer.link_rewrite)}">
								<img src="{$img_manu_dir}{$manufacturer.id_manufacturer}.jpg" alt="{$manufacturer.name|escape:'html':'UTF-8'}" title="{$manufacturer.name|escape:'html':'UTF-8'}" />
							</a>
						</div>
						{if $tmmanufacturername}
							<div class="manufacturer_name">	
								<h5 itemprop="name">
									<a class="manufacturer-name" href="{$link->getmanufacturerLink($manufacturer.id_manufacturer, $manufacturer.link_rewrite)}" itemprop="url">
										{$manufacturer.name|escape:'html':'UTF-8'}
									</a>
								</h5>
							</div>
						{/if}
					</li>
				{/foreach}
			</ul>
        	
		</div>
	{else}
		<div class="alert alert-info">{l s='There are no manufacturers.' mod='tmmanufacturerblock'}</div>
	{/if}
</div>
</div>