<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

class Tmproductstab extends Module
{
    protected $config_form = false;

    public function __construct()
    {
        $this->name = 'tmproductstab';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'TemplateMela';
        $this->need_instance = 0;

        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('TM - Products Tab');
        $this->description = $this->l('Displays Products tab as Grid or Slider');

        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        $success = (parent::install()
            && $this->registerHook('header')
            && $this->registerHook('addproduct')
            && $this->registerHook('updateproduct')
            && $this->registerHook('deleteproduct')
            && $this->registerHook('categoryUpdate')
            && $this->registerHook('actionOrderStatusPostUpdate')
            && $this->registerHook('displayHome')
            && Configuration::updateValue('TMPRODUCTSTAB_SLIDER', 1)
            && Configuration::updateValue('TMPRODUCTSTAB_NEW', 1)
            && Configuration::updateValue('TMPRODUCTSTAB_FEATURED', 1)
            && Configuration::updateValue('TMPRODUCTSTAB_BEST', 1)
            && Configuration::updateValue('TMPRODUCTSTAB_SPECIAL', 0)
            && Configuration::updateValue('TMPRODUCTSTAB_NBR', 10)
            && ProductSale::fillProductSales()
        );

        $this->_clearCache('*');

        return $success;
    }

    public function uninstall()
    {
        Configuration::deleteByName('TMPRODUCTSTAB_SLIDER');
        Configuration::deleteByName('TMPRODUCTSTAB_NEW');
        Configuration::deleteByName('TMPRODUCTSTAB_FEATURED');
        Configuration::deleteByName('TMPRODUCTSTAB_BEST');
        Configuration::deleteByName('TMPRODUCTSTAB_SPECIAL');
        Configuration::deleteByName('TMPRODUCTSTAB_NBR');

        $this->_clearCache('*');
        return parent::uninstall();
    }

    public function getContent()
    {
        $output = '';
        $errors = array();
        if (((bool)Tools::isSubmit('submitTmproductstabModule')) == true)
        {
            $nbr = (int)Tools::getValue('TMPRODUCTSTAB_NBR');

            if (!$nbr || $nbr <= 0 || !Validate::isInt($nbr))
            {
                $errors[] = $this->l('An invalid number of products has been specified.');
            }

            if (isset($errors) && count($errors))
                $output = $this->displayError(implode('<br />', $errors));
            else
            {
                Configuration::updateValue('TMPRODUCTSTAB_SLIDER', (int)(Tools::getValue('TMPRODUCTSTAB_SLIDER')));
                Configuration::updateValue('TMPRODUCTSTAB_NEW', (int)(Tools::getValue('TMPRODUCTSTAB_NEW')));
                Configuration::updateValue('TMPRODUCTSTAB_FEATURED', (int)(Tools::getValue('TMPRODUCTSTAB_FEATURED')));
                Configuration::updateValue('TMPRODUCTSTAB_BEST', (int)(Tools::getValue('TMPRODUCTSTAB_BEST')));
                Configuration::updateValue('TMPRODUCTSTAB_SPECIAL', (int)(Tools::getValue('TMPRODUCTSTAB_SPECIAL')));
                Configuration::updateValue('TMPRODUCTSTAB_NBR', (int)($nbr));
                $this->_clearCache('*');
                $output = $this->displayConfirmation($this->l('Your settings have been updated.'));
            }
        }

        return $output.$this->renderForm();
    }

    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitTmproductstabModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }

    protected function getConfigForm()
    {
        return array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Settings'),
                    'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Display Products as Slider'),
                        'name' => 'TMPRODUCTSTAB_SLIDER',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Show New Products'),
                        'name' => 'TMPRODUCTSTAB_NEW',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Show Featured Products'),
                        'name' => 'TMPRODUCTSTAB_FEATURED',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Show Best Seller Products'),
                        'name' => 'TMPRODUCTSTAB_BEST',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Show Special Products'),
                        'name' => 'TMPRODUCTSTAB_SPECIAL',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'name' => 'TMPRODUCTSTAB_NBR',
                        'label' => $this->l('Products to Display'),
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            )
        );
    }

    protected function getConfigFormValues()
    {
        return array(
            'TMPRODUCTSTAB_SLIDER' => Tools::getValue('TMPRODUCTSTAB_SLIDER', Configuration::get('TMPRODUCTSTAB_SLIDER')),
            'TMPRODUCTSTAB_NEW' => Tools::getValue('TMPRODUCTSTAB_NEW', Configuration::get('TMPRODUCTSTAB_NEW')),
            'TMPRODUCTSTAB_FEATURED' => Tools::getValue('TMPRODUCTSTAB_FEATURED', Configuration::get('TMPRODUCTSTAB_FEATURED')),
            'TMPRODUCTSTAB_BEST' => Tools::getValue('TMPRODUCTSTAB_BEST', Configuration::get('TMPRODUCTSTAB_BEST')),
            'TMPRODUCTSTAB_SPECIAL' => Tools::getValue('TMPRODUCTSTAB_SPECIAL', Configuration::get('TMPRODUCTSTAB_SPECIAL')),
            'TMPRODUCTSTAB_NBR' => Tools::getValue('TMPRODUCTSTAB_NBR', Configuration::get('TMPRODUCTSTAB_NBR')),
        );
    }

    public function hookHeader()
    {
        $this->context->controller->addCSS($this->_path.'/views/css/tmproductstab.css');
    }

    public function hookDisplayHome()
    {
        if (!$this->isCached('tmproductstab.tpl', $this->getCacheId()))
        {
            $nb = Configuration::get('TMPRODUCTSTAB_NBR');
            $newProducts = Product::getNewProducts((int) $this->context->language->id, 0, ($nb ? $nb : 8));
            $specialProducts = Product::getPricesDrop((int) $this->context->language->id, 0, ($nb ? $nb : 8));
            $bestSeller = ProductSale::getBestSalesLight((int) $this->context->language->id, 0, ($nb ? $nb : 8));
            $category = new Category(Context::getContext()->shop->getCategory(), (int)Context::getContext()->language->id); 
            $featureProduct = $category->getProducts((int)Context::getContext()->language->id, 0, ($nb ? $nb : 8), 'position');

            if(!$newProducts) $newProducts = null;
            if(!$bestSeller) $bestSeller = null;
            if(!$specialProducts) $specialProducts = null;
            
            $tmproducttab = array();
            if(Configuration::get('TMPRODUCTSTAB_FEATURED')) {
                $tmproducttab[] = array('id' => 'feature_product', 'name' => $this->l('Featured'), 'productInfo' => $featureProduct);
            }
            if(Configuration::get('TMPRODUCTSTAB_NEW')) {
                $tmproducttab[] = array('id' => 'new_product', 'name' => $this->l('Latest'), 'productInfo' => $newProducts);
            }
            if(Configuration::get('TMPRODUCTSTAB_SPECIAL')) {
                $tmproducttab[] = array('id' => 'special_product', 'name' => $this->l('Specials'), 'productInfo' => $specialProducts);
            }
            if(Configuration::get('TMPRODUCTSTAB_BEST')) {
                $tmproducttab[] = array('id' => 'bestseller_product', 'name' => $this->l('Best seller'), 'productInfo' => $bestSeller);
            }
            


            $this->smarty->assign(array(
                'homeSize' => Image::getSize(ImageType::getFormatedName('home')),
                'no_prod' => (int)Configuration::get('TMPRODUCTSTAB_NBR'),
                'slider' => (int)Configuration::get('TMPRODUCTSTAB_SLIDER'),
            ));
            $this->context->smarty->assign('tmproducttab', $tmproducttab);
        }

        return $this->display(__FILE__, 'tmproductstab.tpl', $this->getCacheId());
    }

    public function hookDisplayTopColumn()
    {
        if (!isset($this->context->controller->php_self) || $this->context->controller->php_self != 'index')
            return;

        return $this->hookDisplayHome();
    }

    public function hookAddProduct($params)
    {
        $this->_clearCache('*');
    }

    public function hookUpdateProduct($params)
    {
        $this->_clearCache('*');
    }

    public function hookDeleteProduct($params)
    {
        $this->_clearCache('*');
    }

    public function hookCategoryUpdate($params)
    {
        $this->_clearCache('*');
    }

    public function hookActionOrderStatusPostUpdate($params)
    {
        $this->_clearCache('*');
    }

    public function _clearCache($template, $cache_id = NULL, $compile_id = NULL)
    {
        parent::_clearCache('tmproductstab.tpl');
    }
}
