{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2016 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<!-- Breadcrumb -->
<div class="breadcrumbdiv">
	{if isset($smarty.capture.path)}{assign var='path' value=$smarty.capture.path}{/if}
	<div class="breadcrumb container clearfix">
		<!-- Page Name with Breadcrumb --> 
		{if $page_name =='product'}
			<h1 class="breadcrumb-product">{$product->name|escape:'html':'UTF-8'}</h1>
		{/if}
		{if $page_name =='module-smartblog-category'}
			{if $title_category eq ''}
				<h1 class="breadcrumb-allblogcategory">{$path}</h1>
			{else}
				<h1 class="breadcrumb-blogcategory">{$title_category|escape:'html':'UTF-8'}</h1>
			{/if}
		{/if}
		{if $page_name =='module-smartblog-details'}
			<h1 class="breadcrumb-blogpage">{$meta_title|escape:'html':'UTF-8'}</h1>
		{/if}
		{if $page_name =='pagenotfound'}
			<h1 class="breadcrumb-pagonotfound">{$meta_title|escape:'html':'UTF-8'}</h1>
		{/if}
		{if $page_name =='category'}
			<h1 class="breadcrumb-category">{$category->name|escape:'html':'UTF-8'}</h1>
		{/if}

		{if $page_name !='category' && $page_name !='product' && $page_name !='module-smartblog-category' && $page_name !='module-smartblog-details' && $page_name !='pagenotfound'}
			<div class="breadcrumb-page">{$path}</div>
		{/if}
		<!--End Page Name with Breadcrumb --> 

		<div class="breadcrumbs">
			<a class="home" href="{if isset($force_ssl) && $force_ssl}{$base_dir_ssl}{else}{$base_dir}{/if}" title="{l s='Return to Home'}"><i class="icon-home"></i></a>
			{if isset($path) AND $path}
				<span class="navigation-pipe"{if isset($category) && isset($category->id_category) && $category->id_category == (int)Configuration::get('PS_ROOT_CATEGORY')} style="display:none;"{/if}>{$navigationPipe|escape:'html':'UTF-8'}</span>
				{if $path|strpos:'span' !== false}
					<span class="navigation_page">{$path|@replace:'<a ': '<span itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a itemprop="url" '|@replace:'data-gg="">': '><span itemprop="title">'|@replace:'</a>': '</span></a></span>'}</span>
				{else}
					{$path}
				{/if}
			{/if}
		</div>
		{if isset($smarty.get.search_query) && isset($smarty.get.results) && $smarty.get.results > 1 && isset($smarty.server.HTTP_REFERER)}
			<div class="breadcrumbs search">
				{capture}{if isset($smarty.get.HTTP_REFERER) && $smarty.get.HTTP_REFERER}{$smarty.get.HTTP_REFERER}{elseif isset($smarty.server.HTTP_REFERER) && $smarty.server.HTTP_REFERER}{$smarty.server.HTTP_REFERER}{/if}{/capture}
				<a href="{$smarty.capture.default|escape:'html':'UTF-8'|secureReferrer|regex_replace:'/[\?|&]content_only=1/':''}" name="back">
					<i class="icon-chevron-left left"></i> {l s='Back to Search results for "%s" (%d other results)' sprintf=[$smarty.get.search_query,$smarty.get.results]}
				</a>
			</div>
		{/if}
	</div>
</div>
<!-- /Breadcrumb -->