{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2016 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{if isset($orderProducts) && count($orderProducts)}
	<section id="crossselling" class="page-product-box">
		<h3 class="productscategory_h2 page-product-heading">
			{if $page_name == 'product'}
				{l s='Customers who bought this product also bought:' mod='crossselling'}
			{else}
				{l s='We recommend' mod='crossselling'}
			{/if}
		</h3>
		<div class="block products_block crossselling-block clearfix">
			<!-- Megnor start -->
			{assign var='sliderFor' value=5} <!-- Define Number of product for SLIDER -->
			{assign var='productCount' value=count($orderProducts)}
			{if $productCount >= $sliderFor}
			<div class="customNavigation">
				<a class="btn prev crossselling_prev"></a>
				<a class="btn next crossselling_next"></a>
			</div>
			{/if}
			<!-- Megnor End -->
			<div class="block_content">
				 <ul id="{if $productCount >= $sliderFor}crossselling-carousel{else}crossselling-grid{/if}" class="{if $productCount >= $sliderFor}tm-carousel product_list{else}product_list grid{/if} clearfix">
					{foreach from=$orderProducts item='orderProduct' name=orderProduct}
						<li class="{if $productCount >= $sliderFor}item{else} ajax_block_product col-xs-12 col-sm-4 col-md-3 {/if}">
							<div class="product-container" itemtype="http://schema.org/Product" itemscope="">
								<div class="left-block">
									<div class="product-image-container">
										<a class="product-image product_image" href="{$orderProduct.link|escape:'html':'UTF-8'}" title="{$orderProduct.name|escape:'html':'UTF-8'}" itemprop="url">
											<img class="replace-2x img-responsive" src="{$orderProduct.image}" alt="{$orderProduct.name|escape:'html':'UTF-8'}" title="{$orderProduct.name|escape:'html':'UTF-8'}" itemprop="image" />
											{hook h="displayTmHoverImage" link_rewrite=$orderProduct.link_rewrite id_product=$orderProduct.id_product}
										</a>
										
										{if isset($orderProduct.new) && $orderProduct.new == 1}
											<a class="new-box" href="{$orderProduct.link|escape:'html':'UTF-8'}">
												<span class="new-label">{l s='New'}</span>
											</a>
										{/if}
										{if isset($orderProduct.on_sale) && $orderProduct.on_sale && isset($orderProduct.show_price) && $orderProduct.show_price && !$PS_CATALOG_MODE}
											<a class="sale-box" href="{$orderProduct.link|escape:'html':'UTF-8'}">
												<span class="sale-label">{l s='Sale!'}</span>
											</a>
										{/if}
									</div>
								</div>
								<div class="right-block">	
								{capture name='displayProductListReviews'}{hook h='displayProductListReviews' product=$orderProduct}{/capture}
									{if $smarty.capture.displayProductListReviews}
										<div class="hook-reviews">
										{hook h='displayProductListReviews' product=$orderProduct}
										</div>
									{/if}		
									<h5 itemprop="name">
										<a class="product-name" href="{$orderProduct.link|escape:'html':'UTF-8'}" title="{$orderProduct.name|escape:'html':'UTF-8'}" itemprop="url" >
											{$orderProduct.name|truncate:45:'...'|escape:'html':'UTF-8'}
										</a>
									</h5>
									
									{if $crossDisplayPrice && $orderProduct.show_price == 1 && !isset($restricted_country_mode) && !$PS_CATALOG_MODE}
										<div class="content_price">
											{hook h="displayProductPriceBlock" product=$orderProduct type='before_price'}
											<span class="price product-price">
												{convertPrice price=$orderProduct.displayed_price}
											</span>
											{if isset($orderProduct.specific_prices) && $orderProduct.specific_prices}
												{if $orderProduct.specific_prices.reduction && $orderProduct.specific_prices.reduction_type == 'percentage'}
													<span class="price-percent-reduction">-{$orderProduct.specific_prices.reduction * 100}%</span>
												{/if}
												<span class="old-price product-price">
													{displayWtPrice p=$orderProduct.price_without_reduction}
												</span>
											{/if}
										</div>
									{/if}
									<div class="button-container">
										{if !$PS_CATALOG_MODE && ($orderProduct.allow_oosp || $orderProduct.quantity > 0)}
											{capture}add=1&amp; id_product={$orderProduct.id_product|intval}{if isset($orderProduct.id_product_attribute) && $orderProduct.id_product_attribute}&amp;ipa={$orderProduct.id_product_attribute|intval}{/if}{if isset($static_token)}&amp;token={$static_token}{/if}{/capture}
											<a class="button ajax_add_to_cart_button btn btn-default" href="{$link->getPageLink('cart', true, NULL, $smarty.capture.default, false)|escape:'html':'UTF-8'}" rel="nofollow" title="{l s='Add to cart' mod='crossselling'}" data-id-product="{$orderProduct.id_product|intval}">
												<span>{l s='Add to cart'}</span>
											</a>
										{else}
											<span class="button ajax_add_to_cart_button btn btn-default disabled">
												<span>{l s='Add to cart'}</span>
											</span>
										{/if}
										{hook h='displayProductListFunctionalButtons' product=$orderProduct}
										{if isset($comparator_max_item) && $comparator_max_item}
											<div class="compare">
												<a class="add_to_compare" href="{$orderProduct.link|escape:'html':'UTF-8'}" data-id-product="{$orderProduct.id_product}">{l s='Add to Compare'}</a>
											</div>
										{/if}
										{if isset($quick_view) && $quick_view}
										<a class="quick-view" href="{$orderProduct.link|escape:'html':'UTF-8'}" rel="{$orderProduct.link|escape:'html':'UTF-8'}">
											<span>{l s='Quick view'}</span>
										</a>
										{/if}
									</div>
									<div class="functional-buttons clearfix">
										
									</div>
								</div>
							</div>
						</li>
					{/foreach}
				</ul>
			</div>
        </div>
	</section>
{/if}