{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2016 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{if count($categoryProducts) > 0 && $categoryProducts !== false}
<section class="page-product-box blockproductscategory">
	<h3 class="productscategory_h3 page-product-heading">
		{if $categoryProducts|@count == 1}
			{l s='Releated Products' sprintf=[$categoryProducts|@count] mod='productscategory'}
		{else}
			{l s='Releated Products' sprintf=[$categoryProducts|@count] mod='productscategory'}
		{/if}
	</h3>
	<div class="block products_block productscategory-block clearfix">
		<!-- Megnor start -->
			{assign var='sliderFor' value=5} <!-- Define Number of product for SLIDER -->
			{assign var='productCount' value=count($categoryProducts)}
			{if $productCount >= $sliderFor}
			<div class="customNavigation">
				<a class="btn prev  productcategory_prev"></a>
				<a class="btn next productcategory_next"></a>
			</div>
			{/if}
		<!-- Megnor End -->	  

		<div class="block_content">
			<ul id="{if $productCount >= $sliderFor}productscategory-carousel{else}productscategory-grid{/if}" class="{if $productCount >= $sliderFor}tm-carousel product_list{else}product_list grid{/if} clearfix">
				{foreach from=$categoryProducts item='categoryProduct' name=categoryProduct}
					<li class="{if $productCount >= $sliderFor}item{else} ajax_block_product col-xs-12 col-sm-4 col-md-3 {/if}">
						<div class="product-container" itemtype="http://schema.org/Product" itemscope="">
							<div class="product-box-inner">	
								<div class="left-block">
									<div class="product-image-container">
										<a class="product-image product_image" href="{$link->getProductLink($categoryProduct.id_product, $categoryProduct.link_rewrite, $categoryProduct.category, $categoryProduct.ean13)}" title="{$categoryProduct.name|escape:'html':'UTF-8'}" itemprop="url">
											<img class="replace-2x img-responsive" src="{$link->getImageLink($categoryProduct.link_rewrite, $categoryProduct.id_image, 'home_default')|escape:'html':'UTF-8'}" alt="{$categoryProduct.name|escape:'html':'UTF-8'}" title="{$categoryProduct.name|escape:'html':'UTF-8'}"itemprop="image" />
											{hook h="displayTmHoverImage" link_rewrite=$categoryProduct.link_rewrite id_product=$categoryProduct.id_product}
										</a>
										
										{if isset($categoryProduct.new) && $categoryProduct.new == 1}
											<a class="new-box" href="{$categoryProduct.link|escape:'html':'UTF-8'}">
												<span class="new-label">{l s='New'}</span>
											</a>
										{/if}
										{if isset($categoryProduct.on_sale) && $categoryProduct.on_sale && isset($categoryProduct.show_price) && $categoryProduct.show_price && !$PS_CATALOG_MODE}
											<a class="sale-box" href="{$categoryProduct.link|escape:'html':'UTF-8'}">
												<span class="sale-label">{l s='Sale!'}</span>
											</a>
										{/if}
									</div>
								</div>
								<div class="right-block">	
								{capture name='displayProductListReviews'}{hook h='displayProductListReviews' product=$categoryProduct}{/capture}
									{if $smarty.capture.displayProductListReviews}
										<div class="hook-reviews">
										{hook h='displayProductListReviews' product=$categoryProduct}
										</div>
									{/if}		
									<h5 itemprop="name">
										<a class="product-name" href="{$link->getProductLink($categoryProduct.id_product, $categoryProduct.link_rewrite, $categoryProduct.category, $categoryProduct.ean13)|escape:'html':'UTF-8'}" title="{$categoryProduct.name|escape:'html':'UTF-8'}" itemprop="url" >
											{$categoryProduct.name|truncate:45:'...'|escape:'html':'UTF-8'}
										</a>
									</h5>
									
									{if $ProdDisplayPrice && $categoryProduct.show_price == 1 && !isset($restricted_country_mode) && !$PS_CATALOG_MODE}
										<div class="content_price">
											{hook h="displayProductPriceBlock" product=$categoryProduct type='before_price'}
											<span class="price product-price">
												{convertPrice price=$categoryProduct.displayed_price}
											</span>
											{if isset($categoryProduct.specific_prices) && $categoryProduct.specific_prices && ($categoryProduct.displayed_price|number_format:2 !== $categoryProduct.price_without_reduction|number_format:2)}
												{if $categoryProduct.specific_prices.reduction && $categoryProduct.specific_prices.reduction_type == 'percentage'}
													<span class="price-percent-reduction">-{$categoryProduct.specific_prices.reduction * 100}%</span>
												{/if}
												<span class="old-price product-price">
													{displayWtPrice p=$categoryProduct.price_without_reduction}
												</span>
											{/if}
										</div>
									{/if}
									<div class="button-container">
										{if ($categoryProduct.id_product_attribute == 0 || (isset($add_prod_display) && ($add_prod_display == 1))) && $categoryProduct.available_for_order && !isset($restricted_country_mode) && $categoryProduct.customizable != 2 && !$PS_CATALOG_MODE}
											{if (!isset($categoryProduct.customization_required) || !$categoryProduct.customization_required) && ($categoryProduct.allow_oosp || $categoryProduct.quantity > 0)}
												{capture}add=1&amp;id_product={$categoryProduct.id_product|intval}{if isset($categoryProduct.id_product_attribute) && $categoryProduct.id_product_attribute}&amp;ipa={$categoryProduct.id_product_attribute|intval}{/if}{if isset($static_token)}&amp;token={$static_token}{/if}{/capture}
												<a class="button ajax_add_to_cart_button btn btn-default" href="{$link->getPageLink('cart', true, NULL, $smarty.capture.default, false)|escape:'html':'UTF-8'}" rel="nofollow" title="{l s='Add to cart'}" data-id-product-attribute="{$categoryProduct.id_product_attribute|intval}" data-id-product="{$categoryProduct.id_product|intval}" data-minimal_quantity="{if isset($categoryProduct.product_attribute_minimal_quantity) && $categoryProduct.product_attribute_minimal_quantity >= 1}{$categoryProduct.product_attribute_minimal_quantity|intval}{else}{$categoryProduct.minimal_quantity|intval}{/if}">
													<span>{l s='Add to cart'}</span>
												</a>
											{else}
												<span class="button ajax_add_to_cart_button btn btn-default disabled">
													<span>{l s='Add to cart'}</span>
												</span>
											{/if}
										{/if}
										{hook h='displayProductListFunctionalButtons' product=$categoryProduct}
										{if isset($comparator_max_item) && $comparator_max_item}
											<div class="compare">
												<a class="add_to_compare" href="{$categoryProduct.link|escape:'html':'UTF-8'}" data-id-product="{$categoryProduct.id_product}">{l s='Add to Compare'}</a>
											</div>
										{/if}
										{if isset($quick_view) && $quick_view}
										<a class="quick-view" href="{$categoryProduct.link|escape:'html':'UTF-8'}" rel="{$categoryProduct.link|escape:'html':'UTF-8'}">
											<span>{l s='Quick view'}</span>
										</a>
										{/if}
									</div>
									<div class="functional-buttons clearfix">
										
									</div>
								</div>
							</div>
						</div>
					</li>
				{/foreach}
			</ul>
		</div>
	</div>
</section>
<!--end Accessories -->
{/if}