<?php
/* ########################################################################### */
/*                                                                             */
/*                      Copyright 2014     Miloslav Kubín                      */
/*                        http://presta-modul.shopmk.cz                        */
/*                                                                             */
/*             Please do not change this text, remove the link,                */
/*          or remove all or any part of the creator copyright notice          */
/*                                                                             */
/*    Please also note that although you are allowed to make modifications     */
/*     for your own personal use, you may not distribute the original or       */
/*                 the modified code without permission.                       */
/*                                                                             */
/*                    SELLING AND REDISTRIBUTION IS FORBIDDEN!                 */
/*             Download is allowed only from presta-modul.shopmk.cz            */
/*                                                                             */
/*       This software is provided as is, without warranty of any kind.        */
/*           The author shall not be liable for damages of any kind.           */
/*               Use of this software indicates that you agree.                */
/*                                                                             */
/*                                    ***                                      */
/*                                                                             */
/*              Prosím, neměňte tento text, nemazejte odkazy,                  */
/*      neodstraňujte části a nebo celé oznámení těchto autorských práv        */
/*                                                                             */
/*     Prosím vezměte také na vědomí, že i když máte možnost provádět změny    */
/*        pro vlastní osobní potřebu,nesmíte distribuovat původní nebo         */
/*                        upravený kód bez povolení.                           */
/*                                                                             */
/*                   PRODEJ A DISTRIBUCE JE ZAKÁZÁNA!                          */
/*          Download je povolen pouze z presta-modul.shopmk.cz                 */
/*                                                                             */
/*   Tento software je poskytován tak, jak je, bez záruky jakéhokoli druhu.    */
/*          Autor nenese odpovědnost za škody jakéhokoliv druhu.               */
/*                  Používáním tohoto softwaru znamená,                        */
/*           že souhlasíte s výše uvedenými autorskými právy .                 */
/*                                                                             */
/* ########################################################################### */
//use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

if (!defined('_PS_VERSION_'))
	exit;

define('GFIX', 'GP_');

include_once(dirname(__FILE__).'/mainTools.php');
include_once(dirname(__FILE__).'/new_api/callback.php');
include_once(dirname(__FILE__).'/new_api/gopay_restapi.php');

include_once(dirname(__FILE__).'/classes/GoPayBills.php');
include_once(dirname(__FILE__).'/classes/GoPayOrders.php');
include_once(dirname(__FILE__).'/classes/GoPayRefund.php');
include_once(dirname(__FILE__).'/classes/GoPayRecurrent.php');
include_once(dirname(__FILE__).'/classes/GoPayRefundProducts.php');

class Add_gopay_new extends PaymentModule
{
	const _ZAKLADNI_DPH = 21;

	const INSTALL_SQL_FILE = 'db_install.sql';
	const UPDATE_SQL_FILE = 'db_update.sql';
	const UNINSTALL_SQL_FILE = 'db_uninstall.sql';

	public $functions;
	public $need_override;

	private static $hooks = array(
		'home',
		'header',
		'payment',
		'adminOrder',
		'leftColumn',
		'rihgtColumn',
		'paymentReturn',
		'paymentOptions',	/* ver >= 1.7 */
		'displayPaymentEU',
		'displayPDFInvoice',
		'displayOverrideTemplate',
		'actionAdminControllerSetMedia',
		'actionGetExtraMailTemplateVars'
	);

	public static $settings = array(
		'settings' => 'Add_gopay_newMainSetting',
		'paymentButtons' => 'Add_gopay_newPaymentButtons',
		'surcharges' => 'Add_gopay_newSurcharges',
		'EETsettings' => 'Add_gopay_newEETsettings',
		'register' => 'Add_gopay_newRegister',
	);

	public static $basePayments = array(
		'PAYMENT_CARD' => 'Platební karty',
		'BANK_ACCOUNT' => 'Bankovní převody',
		'ACCOUNT' => 'Platbu vyberu na platební bráně'
	);

	public static $gopayDefaultLang = 'CS';
	public static $gopayDefaultCurrency = 'CZK';
	public static $gopayLanguages = array('CS', 'EN', 'SK', 'DE', 'RU', 'PL', 'HU', 'FR', 'RO');
	public static $gopayCurrencies = array('CZK', 'EUR', 'PLN', 'HUF', 'GBP', 'USD', 'RON', 'HRK', 'BGN');

	public function __construct()
	{
		$this->name = 'add_gopay_new';
		$this->tab = 'payments_gateways';
		$this->author = 'Miloslav Kubín';
		$this->author_uri = 'http://presta-modul.shopmk.cz';
		$this->authormail = 'presstashop@gmail.com';
		$this->__path = _PS_MODULE_DIR_.$this->name;
		if (version_compare(_PS_VERSION_, '1.7', '>=') === true)
		{
			$this->version = '17.90220';
			$this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
		} else
		{
			$this->version = '16.90220';
			$this->ps_versions_compliancy = array('min' => '1.5', 'max' => '1.6.99');
		}

		$this->need_instance = 1;
		$this->is_eu_compatible = 1;
		$this->bootstrap = true;
		$this->currencies = true;
		$this->currencies_mode = 'checkbox';

		parent::__construct();

		if (version_compare(_PS_VERSION_, '1.7', '>=') === true)
			$this->displayName = $this->l('New GoPay (1.7)');
		else
			$this->displayName = $this->l('New GoPay (1.5, 1.6)');

		$this->description = $this->l('Payment gateway GoPay - New inline payment gateway now!').'<br><span style="color:green">'
							.$this->l('Interface payment gateway uses to communicate REST API').'</span>';

		if (!count(Currency::checkPaymentCurrencies($this->id)))
			$this->warning = $this->l('No currency has been set for this module.');

		$this->confirmUninstall = $this->l('Do you want to uninstall this module ?');

		if (!$error = $this->checkFunctions())
		{
			include_once(dirname(__FILE__).'/functions.php');
			$object = 'Add_gopay_newRegisterFunctions';
			if(!is_object($object))
				$this->functions = new $object($this);
		}
		else
		{
			$this->description .= $error;
			$this->checkFunctions = false;
		}

		if(Module::isInstalled($this->name))
		{
			if(Tools::getValue('configure') == $this->name || Tools::getValue('module_name') == $this->name)
			{
				$this->token = Tools::getAdminTokenLite('AdminModules');
				include_once(dirname(__FILE__).'/classes/paymentButtons.php');
				include_once(dirname(__FILE__).'/classes/surcharges.php');
				include_once(dirname(__FILE__).'/classes/EETsettings.php');
				include_once(dirname(__FILE__).'/classes/mainsetting.php');
				include_once(dirname(__FILE__).'/classes/register.php');

				foreach(self::$settings as $name => $class)
					if(!is_object($class))
						self::$settings[$name] = new $class($this);

				if (!$this->isPatched("classes/Mail.php", "/GoPay##Mail/")
					|| !$this->isPatched("classes/Mail.php", "/actionGetExtraMailTemplateVars/")
				) {
					$this->need_override .= '<br><span style="color: red">'.$this->l('Incomplete installation, overrides are not correct, please reinstall module!').'</span>';
				}
			}

			$this->translations();

			$this->extra_mail_vars = array(
				'{repeat_payment_url}' => '',
				'{recurrence_period}' => '',
				'{recurrence_date_to}' => ''
			);

			if (Tools::getValue('configure') == $this->name)
				$this->hookActionAdminControllerSetMedia();
		}

		if(Configuration::get('PS_DISABLE_OVERRIDES'))
		{
			$this->need_override .= '<br><span style="color: red">'.$this->l('You are prohibited overrides, the module will not correct work!').' &nbsp; &nbsp; <a href="'.$this->context->link->getAdminLink('AdminPerformance').'">'.$this->l('Enable it').'</a></span>';
		}

		$this->description .= $this->need_override;

		if (version_compare(_PS_VERSION_, '1.6.0.11', '<') === true)
		{
			Configuration::updateValue('PS_OS_OUTOFSTOCK_PAID', Configuration::get('PS_OS_OUTOFSTOCK'));
			Configuration::updateValue('PS_OS_OUTOFSTOCK_UNPAID', Configuration::get('PS_OS_OUTOFSTOCK'));
		}

		$this->tabTitle = array(
			'en' => 'Gopay - Payment Listing', 
			'cs' => 'Gopay - Výpis plateb', 
			'sk' => 'GoPay - Výpis platieb', 
		);

		if (Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('select max(LENGTH(`name`)) from `'._DB_PREFIX_.'configuration`') < 32)
			Db::getInstance(_PS_USE_SQL_SLAVE_)->execute('ALTER TABLE `'._DB_PREFIX_.'configuration` CHANGE `name` `name` VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL');
	}

	public function install()
	{
		if ($this->isPatched("classes/Mail.php", "/function Send/")
		) {
			$data = file_get_contents(_PS_OVERRIDE_DIR_.'/classes/Mail.php');
			$data = str_replace("function Send","function Send_GoPay_override", $data);
			file_put_contents(_PS_OVERRIDE_DIR_.'/classes/Mail.php', $data);
		}

		$find = "'size' => 32";
		$replace = "'size' => 254";
		$path = dirname(__FILE__)."/../../classes/Configuration.php";
		$content = file_get_contents($path);
		$content_chunks = explode($find, $content);
		if(count($content_chunks) == 2){
			$content = implode($replace, $content_chunks);
			file_put_contents($path, $content);
			Db::getInstance()->execute('ALTER TABLE `'._DB_PREFIX_.'configuration` CHANGE `name` `name` VARCHAR(254) NOT NULL');
		}

		if (!Add_gopay_newTools::executeFileQueries(dirname(__FILE__).'/sql/'.self::INSTALL_SQL_FILE)
			|| !Add_gopay_newTools::executeFileQueries(dirname(__FILE__).'/sql/'.self::UPDATE_SQL_FILE, true)
			|| !parent::install()
			|| !Add_gopay_newTools::installModuleTab($this, 'GopayAccount', $this->tabTitle, 'AdminParentCustomer', true)
			|| !Add_gopay_newTools::registerHooks($this, self::$hooks)
			|| !Add_gopay_newTools::createOrderStatuses($this)
			|| !Add_gopay_newTools::copyMails($this)
			|| !Add_gopay_newTools::createCMS($this->name)
		)
			return false;

		return true;
	}
	
	public function uninstall()
	{
		if ((boolean)Configuration::get(GFIX.'_FORCE_UNINSTALL')
				&& (!Add_gopay_newTools::executeFileQueries(dirname(__FILE__).'/sql/'.self::UNINSTALL_SQL_FILE)
					|| !Add_gopay_newTools::deleteStatuses()
					|| !Add_gopay_newTools::deleteMails()
					|| !Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'configuration` WHERE `name` LIKE \''.GFIX.'%\''))
			|| !Add_gopay_newTools::uninstallModuleTab('GopayAccount')
			|| !Add_gopay_newTools::uninstallSettings(self::$settings)
			|| !Configuration::deleteByName(GFIX.'_REGISTER')
			|| !Add_gopay_newTools::deleteCMS()
			|| !parent::uninstall()
		)
			return false;

		if ($this->isPatched("classes/Mail.php", "/function Send_GoPay_override/")
		) {
			$data = file_get_contents(_PS_OVERRIDE_DIR_.'/classes/Mail.php');
			$data = str_replace("function Send_GoPay_override","function Send", $data);
			file_put_contents(_PS_OVERRIDE_DIR_.'/classes/Mail.php', $data);
		}

		return true;
	}

	private function isPatched($filename, $pattern)
	{
		$file   = _PS_OVERRIDE_DIR_.$filename;
		$result = false;
		if (file_exists($file))
		{
			$file_content = file_get_contents($file);
			$result = preg_match($pattern, $file_content) > 0;
		}

		return $result;
	}

	public function checkFunctions()
	{
		$functions = array('base64_decode', 'str_rot13', 'gzuncompress', 'gzinflate', 'curl_exec');
		$errors = '';

		foreach ($functions as $f)
		{
			if (!$this->suhosin_function_exists($f))
				$errors .= '<br><span style="color: red">'.$this->l('PHP function is disabled! Enable it in your hosting: ').'<b>'.$f.'</b></span>';
		}

		return $errors;
	}

	public function suhosin_function_exists($func)
	{
		if (extension_loaded('suhosin'))
		{
			$suhosin = @ini_get("suhosin.executor.func.blacklist");
			$suhosin_eval = @ini_get("suhosin.executor.eval.blacklist");
			if (empty($suhosin) == false)
			{
				$suhosin = explode(',', $suhosin);
				$suhosin = array_map('trim', $suhosin);
				$suhosin = array_map('strtolower', $suhosin);
				return (function_exists($func) == true && array_search($func, $suhosin) === false);
			}
			elseif (empty($suhosin_eval) == false)
			{
				
				$suhosin_eval = explode(',', $suhosin_eval);
				$suhosin_eval = array_map('trim', $suhosin_eval);
				$suhosin_eval = array_map('strtolower', $suhosin_eval);
				return (function_exists($func) == true && array_search($func, $suhosin_eval) === false);
			}
		}

		return function_exists($func);
	}

	/* ------------------------------------------------------------- */
	/*  HOOKS
	/* ------------------------------------------------------------- */
	public function hookActionAdminControllerSetMedia()
	{
		if (Tools::getValue('configure') == $this->name
		   || (Tools::isSubmit('vieworder') && Tools::getValue('controller') == 'AdminOrders'))
		{
			$this->context->controller->addJquery();
			$this->context->controller->addjqueryPlugin('idTabs');
			$this->context->controller->addCSS($this->_path.'views/css/'.$this->name.'_admin.css');
			$this->context->controller->addJS($this->_path.'views/js/'.$this->name.'_admin.js');
		}

		if (version_compare(_PS_VERSION_, '1.6', '<') === true && Tools::getValue('configure') == $this->name)
			$this->context->controller->addCSS($this->_path.'views/css/admin-theme.css');
	}

	public function hookHeader()
	{

		if (Tools::getValue('id_module') == $this->id
			|| in_array(Tools::getValue('controller'), array('order', 'orderopc', 'order-opc', 'history', 'orderdetail'))
			|| (Tools::getValue('fc') == 'module' && Tools::getValue('module') == $this->name)
		)
		{
			$this->context->controller->addjqueryPlugin('fancybox');
			if (version_compare(_PS_VERSION_, '1.7', '<') === true)
			{
				$this->context->controller->addJS($this->_path.'/views/js/'.$this->name.'.js');
				$this->context->controller->addCSS($this->_path.'/views/css/'.$this->name.'.css');
			} else
			{
				$this->context->controller->registerStylesheet('modules-'.$this->name, 'modules/'.$this->name.'/views/css/'.$this->name.'.css', array('media' => 'all', 'priority' => 150));
				$this->context->controller->registerJavascript('modules-'.$this->name, 'modules/'.$this->name.'/views/js/'.$this->name.'.js', array('position' => 'bottom', 'priority' => 150));
			}

			$this->_prepVariables();

			return $this->display(__FILE__, '/views/templates//front/header_infos.tpl');
		}
	}

	public function hookLeftColumn($params)
	{
		if (Configuration::get(GFIX.'_HOOK') == 'left')
			return $this->functions->displayPaymentLogo();

		return false;
	}

	public function hookRightColumn($params)
	{
		if (Configuration::get(GFIX.'_HOOK') == 'right')
			return $this->functions->displayPaymentLogo();

		return false;
	}

	public function hookFooter($params)
	{
		if (Configuration::get(GFIX.'_HOOK') == 'footer')
			return $this->functions->displayPaymentLogo();

		return false;
	}

	public function hookDisplayPDFInvoice($params)
	{
		if (isset($params['object']->id_order) && Configuration::get(GFIX.'_BILL_PDF') && $bill = New_GoPay_Bills::getBill($params['object']->id_order))
		{
			$detail = New_Gopay_RestAPI::getBillDetail($bill[0]['id_session']);
			if (isset($detail->errors))
				return;

			$date = new DateTime($detail[0]->dat_trzby);

			$tab = '
<table width="100%">
	<tr><td colspan="2"> </td></tr>
	<tr>
		<td width="50%" style="font-size:7pt !important;"><b>'.$this->l('fik:').'</b> '.$detail[0]->fik.'</td>
		<td width="50%" style="font-size:7pt !important;"><b>'.$this->l('bkp:').'</b> '.$detail[0]->bkp.'</td>
	</tr>
	<tr>
		<td style="font-size:7pt !important;">
			<b>'.$this->l('Date and time of receipt revenue:').'</b> '.$date->format('Y-m-d H:i:s').'
		</td>
		<td style="font-size:7pt !important;">
			<b>'.$this->l('Workshop:').'</b> '.$detail[0]->id_provoz.'
			<b>'.$this->l('Cash desk:').'</b> '.$detail[0]->id_pokl.'
		</td>
	</tr>
	<tr><td colspan="2" style="font-size:8pt !important;">'.Configuration::get(GFIX.'_EET_MSG').'</td></tr>
</table>';
			return $tab;
		}
	}

	public function hookActionGetExtraMailTemplateVars($params)
	{
		if (!isset($params['template_vars']['{id_order}']))
			return;

		$id_order = $params['template_vars']['{id_order}'];

		$params['extra_template_vars']['{repeat_payment_url}'] = Context::getContext()->link->getModuleLink($this->name, 'repeatPayment', array('paymentChannel' => 'ACCOUNT', 'orderId' => $id_order, 'repeatInMail' => 1), true);

		if ($recurrence = New_GoPay_Recurrent::getReccurencePeriod($id_order))
		{
			if (!$params['extra_template_vars']['{recurrence_period}'])
				$params['extra_template_vars']['{recurrence_period}'] = $this->mailRepeated_1.$recurrence[0]['recurrence_period'].' '.$recurrence[0]['recurrence_cycle'];
			if (!$params['extra_template_vars']['{recurrence_date_to}'])
				$params['extra_template_vars']['{recurrence_date_to}'] = $this->mailRepeated_2.$recurrence[0]['recurrence_date_to'];
		}

		return $params;
	}

	public function hookPaymentOptions($params)
	{
		if (!$this->active
			|| !$this->checkCurrency($params['cart'])
			|| !$this->isAllowedCarrier($this->getCarrierId($params))
		)
			return;

		return $this->functions->hookPaymentOptions($params);
	}

	public function hookPayment($params)
	{
		if (!$this->active
			|| !$this->checkCurrency($params['cart'])
			|| !$this->isAllowedCarrier($this->getCarrierId($params))
		)
			return;

		return $this->functions->hookPayment($params);
	}

	public function hookDisplayPaymentEU($params)
	{
		if (!$this->active
			|| !$this->checkCurrency($params['cart'])
			|| !$this->isAllowedCarrier($this->getCarrierId($params))
		)
			return array();

		return $this->functions->hookDisplayPaymentEU($params);
	}

	public function hookDisplayOverrideTemplate($params)
	{
		if (version_compare(_PS_VERSION_, '1.7', '>=') === true)
		{
			if (!isset($params['template_file']))
				return false;

			$tpl = $this->name.'/views/templates/front/'.$params['template_file'].'.tpl';
		} else
		{
			if (!isset($params['controller']->php_self))
				return false;

			$tpl = $this->name.'/views/templates/front/'.$params['controller']->php_self.'.tpl';
		}

		if (Tools::file_exists_cache(_PS_THEME_DIR_.'modules/'.$tpl))
			return _PS_THEME_DIR_.'modules/'.$tpl;
		elseif (Tools::file_exists_cache(_PS_MODULE_DIR_.$tpl))
			return _PS_MODULE_DIR_.$tpl;
 
		return false;
	}

	public function hookPaymentReturn($params)
	{
		if (!$this->active) {
			return;
		}

		$Callback	 = new Callback_new();
		if (version_compare(_PS_VERSION_, '1.7', '>=') === true)
			$order	 = $params['order'];
		else
			$order	 = $params['objOrder'];

		$cart		 = new Cart($order->id_cart);
		$currency	 = new Currency($order->id_currency);
		$state		 = $order->getCurrentState();

		$_PAYMENTS	 = $this->getTestPayments($cart);
		if (Configuration::get(GFIX.'_GATEWAY_MODE'))
			if (Configuration::get(GFIX.'_BUTTONS_MODE') == 1)
				$_PAYMENTS	 = $this->getShortenedPayments($cart);
			else
				$_PAYMENTS	 = $this->getPaymentInstruments($cart);

		$this->smarty->assign(array(
				'status'		 => 'ok',
				'shop_name'		 => $this->context->shop->name,
				'temlate_folder' => _PS_MODULE_DIR_.$this->name.'/views/templates',
				'paymentStatus'	 => $Callback->updateForCallback(Tools::getValue('id'), Tools::getValue('id_order')),
				'typeG'			 => 'repeatPayment',
				'_PAYMENTS'		 => $_PAYMENTS,
				'_REPEAT'		 => 1,
				'order'			 => $order
		));

		if (isset($order->reference) && !empty($order->reference))
			$this->smarty->assign('reference', $order->reference);

		return $this->_warnings().$this->display(__FILE__, 'payment_return.tpl');
	}

	public function hookAdminOrder($params)
	{
		$_html = '';
		$paymentErrors = '';
		$order = new Order($params['id_order']);
		$token = Tools::getAdminTokenLite('AdminOrders');
		$order_payment = New_Gopay_Order::getOrderById($order->id);

		if (Tools::isSubmit('submitGoPayRefund'))
		{
			if (Tools::getValue('refund_type') == 1)
			{
				if ($this->_doRefund($order, 1))
					Tools::redirectAdmin('index.php?controller=AdminOrders&id_order='.$order->id.'&vieworder&conf=4&token='.$token);
				else
					$this->context->controller->errors[] = $this->l('Entered amount is greater than the carrying value of the order');
			}
			elseif(Tools::getValue('refund_type') == 2)
			{
				$products = Tools::getValue('sel_products');
				$shipping = Tools::getValue('sel_shipping');
				$quantity = Tools::getValue('sel_quantity');
				$pricing = Tools::getValue('sel_price');
				$discount = Tools::getValue('sel_discounts');

				if ($this->_doRefund($order, 2, $products, $quantity, $pricing, $shipping, $discount))
					Tools::redirectAdmin('index.php?controller=AdminOrders&id_order='.$order->id.'&vieworder&conf=4&token='.$token);
				else
					$this->context->controller->errors[] = $this->l('Entered amount is greater than the carrying value of the order');
			}
		}
		elseif (Tools::isSubmit('submitCancelPreauthorized'))
		{
			$create_payment = New_Gopay_RestAPI::cancelPreauthorizedPayment($order_payment['id_session']);
			if (empty($create_payment->errors))
			{
				$order_payment = new New_Gopay_Order((int)$order->id);
				$order_payment->id_session = $create_payment->id;
				$order_payment->currency = $order->id_currency;
				$order_payment->total_paid = (float)$order->total_paid;
				$order_payment->update_date = pSQL(date('Y-m-d H:i:s'));
				$order_payment->payment_status = New_GoPay_Helper::REFUNDED;
				$order_payment->update();

				$history = new OrderHistory();
				$history->id_order = $order->id;
				if ($order->current_state != _PAYMENT_REFUND_)
				{
					$history->changeIdOrderState(_PAYMENT_REFUND_, $order, true);
					$history->addWithemail();
				}

				Tools::redirectAdmin('index.php?controller=AdminOrders&id_order='.$order->id.'&vieworder&conf=4&token='.$token);
			} else
				$paymentErrors = $create_payment->errors;
		}
		elseif (Tools::isSubmit('submitCapturePreauthorized'))
		{
			$create_payment = New_Gopay_RestAPI::capturePreauthorizedPayment($order_payment['id_session']);
			if (empty($create_payment->errors))
			{
				$order_payment = new New_Gopay_Order((int)$order->id);
				$order_payment->id_session = $create_payment->id;
				$order_payment->currency = $order->id_currency;
				$order_payment->total_paid = (float)$order->total_paid;
				$order_payment->update_date = pSQL(date('Y-m-d H:i:s'));
				$order_payment->payment_status = New_GoPay_Helper::PAID;
				$order_payment->update();

				$history = new OrderHistory();
				$history->id_order = $order->id;
				if ($order->current_state != _PS_OS_PAYMENT_)
				{
					$history->changeIdOrderState(_PS_OS_PAYMENT_, $order, true);
					$history->addWithemail();
				}

				Tools::redirectAdmin('index.php?controller=AdminOrders&id_order='.$order->id.'&vieworder&conf=4&token='.$token);
			} else
				$paymentErrors = $create_payment->errors;
		}

		$admin_templates = array();

		if ($this->_needPaymentButton($order))
			$admin_templates[] = 'payment_link';

		if ($this->_needValidation($order))
			$admin_templates[] = 'validation';

		if ($this->_needRefund($order))
		{
			$admin_templates[] = 'refund';
		}

		if ($bill = New_GoPay_Bills::getBill((int)$order->id))
		{
			$admin_templates[] = 'bill';
			$this->context->smarty->assign(
				array(
					'bill'	 => $bill
				)
			);
		}

		if (count($admin_templates) > 0)
		{
			$currency = new Currency($order->id_currency);
			$carrier = new Carrier($order->id_carrier);
			$refund_amount = New_GoPay_Refund::getTotalAmountRefundByIdOrder($order->id);
			$products = $order->getProducts();
			$refunded_products = New_GoPay_Refund_Products::getListRefundProducts($order->id);
			$refunded_shipping = false;

			foreach ($products as $key=>&$product)
			{
				foreach ($refunded_products as $refund)
				{
					if ($product['id_order_detail'] == $refund['id_order_detail'])
					{
						if ($product['product_quantity'] > $refund['quantity'])
						{
							$product['product_quantity'] = $product['product_quantity'] - $refund['quantity'];
						}
						else
							unset($products[$key]);
					}

					if ($refund['refund_shipping'])
						$refunded_shipping = true;
				}
			}

			$partialy_refund = false;
			if (New_GoPay_Refund::getStatus($order->id) != New_GoPay_Helper::REFUNDED
			   && $refund_amount > 0
			   && $refund_amount < $order->total_paid)
				$partialy_refund = true;

			if (version_compare(_PS_VERSION_, '1.5', '>='))
				$order_state = $order->current_state;
			else
				$order_state = OrderHistory::getLastOrderState($order->id);

			$this->context->smarty->assign(
				array(
					'authorization'	 => (int)Configuration::get(GFIX.'_PREAUTHORIZED'),
					'base_url'		 => _PS_BASE_URL_.__PS_BASE_URI__,
					'MODULE_NAME'	 => $this->name,
					'order_state'	 => $order_state,
					'order'			 => $order,
					'carrier'		 => $carrier,
					'currency'		 => $currency,
					'paymentErrors'	 => $paymentErrors,
					'paymentLink'	 => $this->context->link->getModuleLink($this->name, 'repeatPayment', array('paymentChannel'=>'ACCOUNT', 'orderId'=>$order->id), true),
					'refund_amount'	 => $order->total_paid - $refund_amount,
					'partialy_refund' => $partialy_refund,
					'refunded_shipping'	 => $refunded_shipping,
					'discounts'		 => $order->getCartRules(),
					'products'		 => $products,
					'discounts'		 => $order->getCartRules(),
					'list_refunds'	 => New_GoPay_Refund::getListRefund($order->id),
					'ps_version'	 => _PS_VERSION_
				)
			);

			foreach ($admin_templates as $admin_template)
			{
				$_html .= $this->display(__FILE__, '/views/templates/admin/admin_order/'.$admin_template.'.tpl');
			}
		}

		return $_html;
	}

	/* ------------------------------------------------------------- */
	/*  PRIVATE FUNCTIONS
	/* ------------------------------------------------------------- */
	private function _warnings()
	{
		if (!Configuration::get(GFIX.'_GATEWAY_MODE'))
			return $this->displayError($this->l('Payment gateway is running in test mode , orders will not actually been paid.'));

		return ;
	}

	private function _needValidation(Order $order)
	{
		$row = New_Gopay_Order::getOrderById((int)$order->id);

		return $row && $row['preauthorized'] && $row['payment_status'] == New_GoPay_Helper::AUTHORIZED;
	}

	private function _needPaymentButton(Order $order)
	{
		$row = New_Gopay_Order::getOrderById((int)$order->id);

		return $row && !$order->hasBeenPaid();
	}

	private function _needRefund(Order $order)
	{
		$row = New_Gopay_Order::getOrderById((int)$order->id);

		return $row && Configuration::get(GFIX.'_REFUND') && $order->hasBeenPaid();
	}

	private function _doRefund(Order $order, $type, $products = false, $quantity = false, $pricing = false, $shipping = false, $discount = false)
	{
		$order_payment = New_Gopay_Order::getOrderById((int)$order->id);

		if (!$order_payment
			|| !in_array($order_payment['payment_status'], array(New_GoPay_Helper::PARTIALLY_REFUNDED, New_GoPay_Helper::PAID))
		)
			return false;

		$id = $order_payment['id_session'];
		$currency = new Currency((int)$order->id_currency);

		$orderState = _PAYMENT_REFUND_;
		$complete = New_GoPay_Helper::REFUNDED;
		if (!$is_complete)
		{
			$orderState = _PAYMENT_PARTIALLY_REFUNDED_;
			$complete = New_GoPay_Helper::PARTIALLY_REFUNDED;
		}

		$total_paid = Tools::ps_round((float)$order->total_paid, 2);
		$create_refund = New_Gopay_RestAPI::refundPayment($id, $order, $total_paid, $type, $products, $quantity, $pricing, $shipping, $discount);
		$refund = new New_GoPay_Refund();
		$refund->id_order = (int)$order->id;
		$refund->refund_amount = (float)$create_refund['data']['amount']/100;

		$message = $this->l('Refund operation result:').'<br>';

		if (!empty($create_refund['status']->errors))
		{
			foreach ($create_refund['status']->errors as $error)
			{
				$error_code = isset($error->error_code) ? $error->error_code : '';
				$error_name = isset($error->error_name) ? $error->error_name : '';
				$error_message = isset($error->message) ? $error->message : '';
				$error_description = isset($error->description) ? $error->description : '';
			}
			$refund->result = $this->l('Error').': '.($error_name ? $error_name : $error_code);

			$refund->save();
			$message .= $this->l('Transaction error!').'<br>
						Error_code: '.$error_code.'<br>
						Error_name: '.$error_name.'<br>
						Message: '.$error_message.'<br>
						Description: '.$error_description.'<br>
			';
		} else
		{
			$payment_status = New_Gopay_RestAPI::checkPaymentStatus($id);
			$refund->result = $create_refund['status']->result;

			$message .= 'AMOUNT: '.$refund->refund_amount.'<br>
					AUTHORIZATIONID: '.$order_payment['id_session'].'<br>
					CURRENCYCODE: '.$currency->iso_code.'<br>
					COMPLETETYPE: '.$refund->result.'<br>
			';

			if ($refund->save())
			{
				$order_status = new New_Gopay_Order($order->id);
				$order_status->payment_status = $payment_status->state;
				$order_status->update();

				foreach ($products as $id_order_detail)
				{
					$refunded = new New_GoPay_Refund_Products();
					$refunded->id_order = $order->id;
					$refunded->id_order_detail = $id_order_detail;
					$refunded->quantity = $quantity[$id_order_detail];
					$refunded->save();
				}

				if ($shipping)
				{
					$refunded = new New_GoPay_Refund_Products();
					$refunded->id_order = $order->id;
					$refunded->refund_shipping = 1;
					$refunded->save();
				}
			}
		}

		return $this->_addNewPrivateMessage((int)$order->id, $message);

	}

	private function generateForm($payment_type)
	{
		$context = Context::getContext();
		$module_dir = _PS_MODULE_DIR_.$this->name.'/views/templates';

		$code = $payment_type['code'];
		if (isset($payment_type['swift']) && $payment_type['swift'])
			$code = $payment_type['swift'];

		if (file_exists($module_dir.'/front/payment_infos/'.$code.'_infos.tpl'))
			$tpl_enable = $context->smarty->createTemplate($module_dir.'/front/payment_infos/'.$code.'_infos.tpl');
		else
			$tpl_enable = $context->smarty->createTemplate($module_dir.'/front/payment_infos.tpl');

		$tpl_enable->assign(array(
			'_CUSTOM_NAMES'	 => Configuration::get(GFIX.'_CUSTOM_NAMES'),
			'PRICE_VIEW'	 => Configuration::get(GFIX.'_PRICE_VIEW'),
			'payment_type'	 => $payment_type
		));

		return $tpl_enable->fetch();
	}

	/* ------------------------------------------------------------- */
	/*  PUBLIC FUNCTIONS
	/* ------------------------------------------------------------- */

	public function _prepVariables()
	{
		$SKIP_STEP = 0;
		if (version_compare(_PS_VERSION_, '1.7', '>=') === true
		   || Configuration::get(GFIX.'_SKIP_STEP')
		)
			$SKIP_STEP = 1;

		return $this->context->smarty->assign(array(
				'_ADD_GOPAY'				 => $this,
				'ADD_GOPAY_STATUS'			 => _PAYMENT_NEW_,
				'ADD_GOPAY_STATUS_CHOSEN'	 => _PAYMENT_CHOSEN_,
				'ADD_GOPAY_STATUS_TIMEOUT'	 => _PAYMENT_TIMEOUT_,
				'ADD_GOPAY_STATUS_CANCELED'	 => _PAYMENT_CANCELED_,
				'_PS_OS_ERROR_'				 => _PS_OS_ERROR_,
				'RECURRENT'					 => new New_GoPay_Recurrent(),
				'SKIP_STEP'					 => $SKIP_STEP,
				'GATEWAY_MODE'				 => (int)Configuration::get(GFIX.'_GATEWAY_MODE'),
				'INLINE_MODE'				 => (int)Configuration::get(GFIX.'_INLINE_MODE'),
				'ORDER_MODE'				 => (int)Configuration::get(GFIX.'_ORDER_MODE'),
				'PAYMENT_MODE'				 => (int)Configuration::get(GFIX.'_PAYMENT_MODE'),
				'BUTTONS_MODE'				 => (int)Configuration::get(GFIX.'_BUTTONS_MODE'),
				'_PREAUTHORIZED'			 => (int)Configuration::get(GFIX.'_PREAUTHORIZED'),
				'_RECURRENT'				 => (int)Configuration::get(GFIX.'_RECURRENT'),
				'_GP_DEF_LANG'				 => strtolower(self::$gopayDefaultLang),
				'_HIDE_GROUP_ACCOUNT'		 => Configuration::get(GFIX.'_HIDE_GROUP_ACCOUNT')
		));
	}

	public static function getOrderByReference($reference)
	{
		$sql = 'SELECT `id_order`
				FROM `'._DB_PREFIX_.'orders`
				WHERE `reference` = \''.$reference.'\'
					'.Shop::addSqlRestriction();
		$result = Db::getInstance()->getRow($sql);

		return isset($result['id_order']) ? $result['id_order'] : false;
	}

	public function getPaymentOption($payment_type)
	{
		if (version_compare(_PS_VERSION_, '1.7', '<') === true)
			return;

		$paymentOption = new PaymentOption();
		$paymentOption->setCallToActionText(Configuration::get(GFIX.'_DISPLAY_NAMES') ? $payment_type['title'] : '')
						->setAction($this->context->link->getModuleLink($this->name, 'validation', array(), true))
						->setModuleName($this->name)
						->setAdditionalInformation($this->generateForm($payment_type))
						->setLogo(Configuration::get(GFIX.'_DISPLAY_IMAGES') ? $payment_type['logo'] : '')
						->setInputs(array(
							'paymentChannel' => array(
								'name' => 'paymentChannel',
								'type' => 'hidden',
								'value' => $payment_type['code'],
							),
							'paymentSwift' => array(
								'name' => 'paymentSwift',
								'type' => 'hidden',
								'value' => isset($payment_type['swift']) ? $payment_type['swift'] : '',
							),
							'inline_mode' => array(
								'name' => 'inline_mode',
								'type' => 'hidden',
								'value' => (int)Configuration::get(GFIX.'_INLINE_MODE'),
							),
							'confirm_gopay' => array(
								'name' => 'confirm_gopay',
								'type' => 'hidden',
								'value' => 1,
							)
						));

		return $paymentOption;
	}

	public function getEmbeddedPaymentOption($params)
	{
		if (version_compare(_PS_VERSION_, '1.7', '<') === true)
			return;

		$paymentOption = new PaymentOption();
		$paymentOption->setCallToActionText($this->l('Fast Payment - Payment gateway GoPay'))
						->setModuleName($this->name)
						->setForm($this->displayFormPS7($params));

		return $paymentOption;
    }

	public function getImage($key, $default = false)
	{
		if (!Configuration::get(GFIX.'_DISPLAY_IMAGES') && version_compare(_PS_VERSION_, '1.7', '<') === true)
			return;

		$_PAYMENT_IMAGE = $default;
		if (Configuration::get(GFIX.'_CUSTOM_IMAGES'))
			$_PAYMENT_IMAGE = __PS_BASE_URI__.'modules/'.$this->name.'/views/images/payments/'.$key.'.gif';

		return $_PAYMENT_IMAGE;
	}

	public function getTestPayments(Cart $cart)
	{
		$payment_options = array();
		$currency = new Currency($cart->id_currency);
		foreach (self::$basePayments as $key => $name)
		{
			if ((Configuration::get(GFIX.'_RECURRENT') ? $key == 'PAYMENT_CARD' : true)
				&& (Configuration::get(GFIX.'_PREAUTHORIZED') ? $key == 'PAYMENT_CARD' : true)
				&& (Configuration::get(GFIX.'_ORDER_MODE') ? $key == 'PAYMENT_CARD' : true)
				&& !Configuration::get(GFIX.'_HIDE_GROUP_'.$key.'_'.$currency->iso_code)
			)
			{
				$_PAYMENT_DESC_ = '';
				$_PAYMENT_TITLE = $name;
				if (Configuration::get(GFIX.'_CUSTOM_NAMES'))
				{
					$_PAYMENT_DESC_ = Configuration::get(GFIX.'_GROUP_DESC_'.$key.'_'.$cart->id_lang);
					if ($_TITLE = Configuration::get(GFIX.'_GROUP_NAME_'.$key.'_'.$cart->id_lang))
						$_PAYMENT_TITLE = $_TITLE;
				}

				$payment_options[] = 
							array(
								'code'	 => $key,
								'title'	 => Configuration::get(GFIX.'_DISPLAY_NAMES') ? $_PAYMENT_TITLE : '',
								'desc'	 => '<b style="color:red">'.$this->l('Test payment, money not send').'</b><br />'.(Configuration::get(GFIX.'_DISPLAY_NAMES') ? $_PAYMENT_DESC_ : ''),
								'price'	 => self::getCost($cart, $key),
								'logo'	 => $this->getImage($key)
				);
			}
		}

		return $payment_options;
	}

	public function getShortenedPayments(Cart $cart)
	{
		$payment_options = array();
		$currency = new Currency($cart->id_currency);
		foreach (self::$basePayments as $key => $name)
		{
			if ((Configuration::get(GFIX.'_RECURRENT') ? $key == 'PAYMENT_CARD' : true)
				&& (Configuration::get(GFIX.'_PREAUTHORIZED') ? $key == 'PAYMENT_CARD' : true)
				&& (Configuration::get(GFIX.'_ORDER_MODE') ? $key == 'PAYMENT_CARD' : true)
				&& !Configuration::get(GFIX.'_HIDE_GROUP_'.$key.'_'.$currency->iso_code)
			)
			{
				$_PAYMENT_DESC_ = '';
				$_PAYMENT_TITLE = $name;
				if (Configuration::get(GFIX.'_CUSTOM_NAMES'))
				{
					$_PAYMENT_DESC_ = Configuration::get(GFIX.'_GROUP_DESC_'.$key.'_'.$cart->id_lang);
					if ($_TITLE = Configuration::get(GFIX.'_GROUP_NAME_'.$key.'_'.$cart->id_lang))
						$_PAYMENT_TITLE = $_TITLE;
				}

				$payment_options[] = 
							array(
								'code'	 => $key,
								'title'	 => Configuration::get(GFIX.'_DISPLAY_NAMES') ? $_PAYMENT_TITLE : '',
								'desc'	 => Configuration::get(GFIX.'_DISPLAY_NAMES') ? $_PAYMENT_DESC_ : '',
								'price'	 => $this->getCost($cart, $key),
								'logo'	 => $this->getImage($key)
				);
			}
		}

		return $payment_options;
	}

	public function getPaymentInstruments(Cart $cart)
	{
		$currency = new Currency($cart->id_currency);
		$PAYMENTS = New_Gopay_RestAPI::enabledPaymentInstruments($currency->iso_code);
		$gopayDefaultLang = strtolower(self::$gopayDefaultLang);

		foreach ($PAYMENTS->enabledPaymentInstruments as $delete=>&$payment)
		{
			$payment->desc = '';
			$payment->active = false;
			$key = $payment->paymentInstrument;
			if ((Configuration::get(GFIX.'_RECURRENT') ? $key == 'PAYMENT_CARD' : true)
				&& (Configuration::get(GFIX.'_PREAUTHORIZED') ? $key == 'PAYMENT_CARD' : true)
				&& (Configuration::get(GFIX.'_ORDER_MODE') ? $key == 'PAYMENT_CARD' : true)
			)
			{
				if (Configuration::get(GFIX.'_DISPLAY_NAMES'))
				{
					if (Configuration::get(GFIX.'_CUSTOM_NAMES'))
					{
						$payment->label->{$gopayDefaultLang} = Configuration::get(GFIX.'_PAYMENT_NAME_'.$key.'_'.$cart->id_lang);
						$payment->desc = Configuration::get(GFIX.'_PAYMENT_DESC_'.$key.'_'.$cart->id_lang);
					}
				} else
					$payment->label->{$gopayDefaultLang} = '';

				$payment->image->normal = $this->getImage($key, $payment->image->normal);
				$payment->price = self::getCost($cart, $key);
				$payment->active = Configuration::get(GFIX.'_HIDE_PAYMENT_'.$key.'_'.$currency->iso_code) ? false : true;

				if ($payment->enabledSwifts)
				{
					foreach ($payment->enabledSwifts as $delete=>&$swift)
					{
						$swift->desc = '';
						$key2 = $swift->swift;
						if (Configuration::get(GFIX.'_DISPLAY_NAMES'))
						{
							if (Configuration::get(GFIX.'_CUSTOM_NAMES'))
							{
								$swift->label->{$gopayDefaultLang} = Configuration::get(GFIX.'_PAYMENT_NAME_'.$key2.'_'.$cart->id_lang);
								$swift->desc = Configuration::get(GFIX.'_PAYMENT_DESC_'.$key2.'_'.$cart->id_lang);
							}
						} else
							$swift->label->{$gopayDefaultLang} = '';

						$swift->price = self::getCost($cart, $key2);
						$swift->image->normal = $this->getImage($key2, $swift->image->normal);
						$swift->active = Configuration::get(GFIX.'_HIDE_PAYMENT_'.$key2.'_'.$currency->iso_code) ? false : true;
						$swift->paymentInstrument = $key;	// pro PS 1.7 convertSTD($params)
					}
				}
			}
		}

		return $PAYMENTS;
	}

	public function getPaymentDetails(Cart $cart, $selectedPayment)
	{
		$currency = new Currency($cart->id_currency);
		$PAYMENTS = New_Gopay_RestAPI::enabledPaymentInstruments($currency->iso_code);
		$gopayDefaultLang = strtolower(self::$gopayDefaultLang);
		foreach ($PAYMENTS->enabledPaymentInstruments as $payment)
		{
			if ($payment->enabledSwifts)
				foreach ($payment->enabledSwifts as $swift)
				{
					$swift->desc = '';
					$key2 = $swift->swift;
					if (Configuration::get(GFIX.'_CUSTOM_NAMES'))
					{
						$swift->label->{$gopayDefaultLang} = Configuration::get(GFIX.'_PAYMENT_NAME_'.$key2.'_'.$cart->id_lang);
						$swift->desc = Configuration::get(GFIX.'_PAYMENT_DESC_'.$key2.'_'.$cart->id_lang);
					}
					if ($key2 == $selectedPayment)
						return array(
							'code'	 => $key2,
							'title'	 => $swift->label->{$gopayDefaultLang},
							'desc'	 => $swift->desc,
							'price_wt' => self::getCost($cart, $key2, true),
							'price'	 => self::getCost($cart, $key2),
							'logo'	 => $this->getImage($key2, $swift->image->normal)
						);
				}

			$payment->desc = '';
			$key = $payment->paymentInstrument;
			if (Configuration::get(GFIX.'_CUSTOM_NAMES'))
			{
				$payment->label->{$gopayDefaultLang} = Configuration::get(GFIX.'_PAYMENT_NAME_'.$key.'_'.$cart->id_lang);
				$payment->desc = Configuration::get(GFIX.'_PAYMENT_DESC_'.$key.'_'.$cart->id_lang);
			}
			if ($key == $selectedPayment)
				return array(
					'code'	 => $key,
					'title'	 => $payment->label->{$gopayDefaultLang},
					'desc'	 => $payment->desc,
					'price_wt' => self::getCost($cart, $key, true),
					'price'	 => self::getCost($cart, $key),
					'logo'	 => $this->getImage($key, $payment->image->normal)
				);
		}

		return false;
	}

	public function displayForm($params, $templateName)
	{
		$this->_prepVariables();
		$this->context->smarty->assign($params);

		return $this->_warnings().$this->display(__FILE__, '/views/templates/hook/'.$templateName.'.tpl');
	}

	protected function displayFormPS7($params)
	{
		$this->context->smarty->assign(array(
			'typeG'		 => 'validation',
			'_PAYMENTS'	 => $this->getPaymentInstruments($params['cart'])
		));

		return $this->context->smarty->fetch('module:add_gopay_new/views/templates/hook/windowed.tpl');
    }

	public function _addNewPrivateMessage($id_order, $message)
	{
		if (!(bool)$id_order)
			return false;

		$new_message = new Message();
		$message = strip_tags($message, '<br>');

		if (!Validate::isCleanHtml($message))
			$message = $this->l('Payment message is not valid, please check your module.');

		$new_message->message = $message;
		$new_message->id_order = (int)$id_order;
		$new_message->id_employee = 1;
		$new_message->private = 1;

		return $new_message->add();
	}

	protected function isAllowedCarrier($id_carrier)
	{
		$allowed_carriers = unserialize(Configuration::get(GFIX.'_ALLOWED_CARRIERS'));
		// no restriction if  allowed_carriers is empty
		if (!is_array($allowed_carriers) || !count($allowed_carriers))
			return true;
	  
		if (in_array($id_carrier, $allowed_carriers))
			return true;
	  
		return false;
	}

	protected function getCarrierId($params)
	{
		if ((int)$params['cart']->id_carrier)
			$carrier = new Carrier((int)$params['cart']->id_carrier);

		$option = $this->context->cart->getDeliveryOption(null, false); 
		if (is_array($option))
		{
			$vals = array_values($option);
			if (isset($vals[0]))
				$carrier = new Carrier((int)$vals[0]);
		}

		if (Validate::isLoadedObject($carrier))
			return $carrier->id_reference;
	}

	public function checkCurrency($cart)
	{
		$currency_order = new Currency($cart->id_currency);
		$currencies_module = $this->getCurrency($cart->id_currency);

		if (is_array($currencies_module))
			foreach ($currencies_module as $currency_module)
				if ($currency_order->id == $currency_module['id_currency'])
					return true;

		return false;
	}

	public static function getCost(Cart $cart, $payment_code = null, $withTax = true)
	{
		$orderTotal = $cart->getOrderTotal(true, Cart::BOTH);
		$carrier = new Carrier($cart->id_carrier);
		$currency = new Currency($cart->id_currency);
		$carrier_tax_rate = $carrier->getTaxesRate(new Address((int)$cart->{Configuration::get('PS_TAX_ADDRESS_TYPE')}));

		if (!Configuration::get(GFIX.'_PRICE_DIFFERENT'))
			$payment_code = '';

		if(Configuration::get(GFIX.'_FEE_TYPE_'.$payment_code))
		{
			$percent = Configuration::get(GFIX.'_FEE_VALUE_'.$payment_code)/100;
			$fee = $orderTotal * $percent;
   		}  else
			$fee = Tools::convertPrice(Configuration::get(GFIX.'_FEE_VALUE_'.$payment_code), $currency);

		if ($withTax)
		{
   			$fee = $fee*(1+($carrier_tax_rate/100));
		}

		if (Configuration::get(GFIX.'_PRICE_VIEW') && $fee > 0)
		{
   			return Tools::displayPrice($fee, $currency->id);
		} else
   			return false;
	}

	public function _displayPeriodes($period_type, $period_name)
	{
		$this->DAYS = 31;
		$this->WEEKS = 53;
		$this->MONTHS = 12;

		$this->context->smarty->assign(array(
			'RECURRENCE_PERIOD'		 => Configuration::get(GFIX.'_RECURRENCE_PERIOD'),
			'recurrent_periodes'	 => $this->{$period_type},
			'period_name'			 => $period_name,
		));

		return $this->display(__FILE__, '/views/templates/back/recurrence_period.tpl');
	}

	public function getAPIErrors($id, $log = array())
	{
		$logs = '<ol style="padding:20px;">';
		foreach ($log->errors as $error)
		{
			if (isset($error->scope))
				$logs .= '<li><b>'.$this->l('Error scope: ').'</b> '.$error->scope.'</li>';
			if (isset($error->field))
				$logs .= '<li><b>'.$this->l('Error field: ').'</b> '.$error->field.'</li>';
			if (isset($error->error_code))
				$logs .= '<li><b>'.$this->l('Error code: ').'</b> '.$error->error_code.'</li>';
			if (isset($error->error_name))
				$logs .= '<li><b>'.$this->l('Error name: ').'</b> '.$error->error_name.'</li>';
			if (isset($error->message))
				$logs .= '<li><b>'.$this->l('Error message: ').'</b> '.$error->message.'</li>';
			if (isset($error->description))
				$logs .= '<li><b>'.$this->l('Error description: ').'</b> '.$error->description.'</li><br>';
			if (isset($error->inputs))
				$logs .= '<li><b>'.$this->l('Error inputs: ').'</b> <pre>'.var_export($error->inputs, true).'</pre></li><br>';
		}
		$logs .= '</ol>';

		$orders = $this->l('Your order ID is :').' <b>'.$id.'</b>';

		if (Configuration::get(GFIX.'_ERRORS_REPORT'))
		{
			$id_lang = (int)$this->context->language->id;
			$iso_lang = Language::getIsoById($id_lang);

			if (!is_dir(dirname(__FILE__).'/mails/'.Tools::strtolower($iso_lang)))
				$id_lang = Language::getIdByIso('en');

			Mail::Send(
						$id_lang,
						'gopay_error_reporting',
						Mail::l('Error reporting from your GoPay module',
						(int)$this->context->language->id),
						array('{logs}' => $logs,
						'{orders}' => $orders),
						Configuration::get('PS_SHOP_EMAIL'),
						null, null, null, null, null,
						_PS_MODULE_DIR_.$this->name.'/mails/'
			);
		}

		return array('orders' => $orders, 'logs' => $logs);
	}

	/* ------------------------------------------------------------- */
	/*  DISPLAY CONTENT
	/* ------------------------------------------------------------- */
	public function getContent()
	{
		$_postProces = $this->functions->_postProces();

		if (Tools::getValue('error'))
			$_postProces .= $this->displayError(Tools::getValue('error'));

		if ($this->need_override)
			$_postProces .= $this->displayError($this->need_override);

		$show_shop = true;
		$shop_context = Shop::getContext();

		if (Shop::isFeatureActive() && $shop_context == Shop::CONTEXT_ALL)
			$show_shop = false;
		elseif (Shop::isFeatureActive() && $shop_context == Shop::CONTEXT_GROUP)
			$show_shop = false;

		if (!$show_shop)
			$_postProces .= $this->adminDisplayWarning($this->l('You must select a store for which you want to set parameters.'));

		$this->context->smarty->assign(array(
			'displayName'		 => $this->displayName,
			'module_name'		 => $this->name,
			'version'			 => $this->version,
			'temlate_folder'	 => _PS_MODULE_DIR_.$this->name.'/views/templates/',
			'settings'			 => self::$settings,
			'idTab'				 => Tools::getValue('idTab'),
			'SHOW_SHOP'			 => $show_shop,
			'registerFunctions'	 => $this->functions,
			'REGISTER'			 => $this->functions->isRegistered()
		));

		return $_postProces.$this->display(__FILE__, '/views/templates/back/admin_main.tpl');
	}

	/* ------------------------------------------------------------- */
	/*  GET TRANSLATIONS
	/* ------------------------------------------------------------- */
	private function translations()
	{
		$this->PAID_MESSAGE = $this->l('The payment was successful. Thank you for using our services.');
		$this->CANCELED_MESSAGE = $this->l('Payment was canceled. Repeat the payment again, please.');
		$this->AUTHORIZED_MESSAGE = $this->l('The payment was authorized, pending completion. About payment, we will we will immediately notify via email with confirmation of payment.');
		$this->REFUNDED_MESSAGE = $this->l('The payment was refunded.');
		$this->PAYMENT_METHOD_CHOSEN_ONLINE_MESSAGE = sprintf($this->l('Payment has not been made. About payment, we will immediately notify via email with confirmation of payment. If you do not receive the next working day email confirmation of payment, please contact support:  %s'), Configuration::get('PS_SHOP_EMAIL'));
		$this->PAYMENT_METHOD_CHOSEN_OFFLINE_MESSAGE = $this->l('Payment has not been made. The payment gateway GoPay you received and payment information to your email you were sent information to make the payment. About payment, we will we will immediately notify via email with confirmation of payment.');
		$this->PAYMENT_METHOD_CHOSEN_MESSAGE = $this->l('Payment has not been made. About payment, we will immediately notify via email with confirmation of payment.');
		$this->FAILED_MESSAGE = sprintf($this->l('During the payment was an error. Contact support by email:  %s'), Configuration::get('PS_SHOP_EMAIL'));
		$this->TIMEOUTED_MESSAGE = $this->l('Payment error - an expired payment.');
		$this->CREATED_MESSAGE = $this->l('You have been redirected to a payment gateway, but on your part not to complete the payment.');
		$this->faultyPaymentIdentity = $this->l('Unable to verify the identity of the payment. Contact e-shop.');
		$this->orderNotExist = $this->l('No existing order that has a number:');
		$this->paymentCreationFailed = $this->l('Failed to create a payment GoPay. Check the configuration of the payment module GoPay.');
		$this->paymentNotVerified = $this->l('Payment has not been verified.');
		$this->notCorrectOrderPayment = $this->l('Payment can be made paymentSessionId disagree with order number.');
		$this->undefinedOrderFaultyState = $this->l('Order was not found or is in the wrong state.');
		$this->alreadyClosed = $this->l('The order has been closed. Select the product again.');
		$this->OrderPaymentClosed = $this->l('The order is either paid or closed. Create a new order.');
		$this->created = $this->l('You have been redirected to a payment gateway, but on your part not to complete the payment.');
		$this->configurationFailed = $this->l('Is not set parameters, check the settings in the administration module.');
		$this->emailIncorrect = $this->l('Incorrect format of your email:');
		$this->errorSaveOrder = $this->l('Failed to saving data order on database');
		$this->errorUpdateOrder = $this->l('Failed to update data order on database');
		$this->mailRepeated_1 = $this->l('Repeated payment will take place in regular cycles: ');
		$this->mailRepeated_2 = $this->l('The last payment is made: ');
		$this->payAgain = $this->l('Again pay with Gopay');
		$this->payGopay = $this->l('Pay with Gopay');
		$this->notOrderId = $this->l('Order ID not exist');
		$this->notAllowedCurrency = $this->l('Currency not allowed:');
	}

	public function validateOrder($id_cart, $id_order_state, $amount_paid, $payment_method = 'Unknown',
		$message = null, $extra_vars = array(), $currency_special = null, $dont_touch_amount = false,
		$secure_key = false, Shop $shop = null)
	{
		if (!Configuration::get(GFIX.'_PRICE_VIEW'))
		{
			parent::validateOrder($id_cart, $id_order_state, $amount_paid, $payment_method, $message, $extra_vars, $currency_special, $dont_touch_amount, $secure_key, $shop);

			return $this->repairOrder($this->currentOrder);
		}

		if (version_compare(_PS_VERSION_, '1.5', '>=') === true && version_compare(_PS_VERSION_, '1.5.5', '<') === true)
			include_once(dirname(__FILE__).'/validateOrder/1.5.php');

		if (version_compare(_PS_VERSION_, '1.5.5', '>=') === true && version_compare(_PS_VERSION_, '1.6', '<') === true)
			include_once(dirname(__FILE__).'/validateOrder/1.5.5.php');

		if (version_compare(_PS_VERSION_, '1.6', '>=') === true && version_compare(_PS_VERSION_, '1.6.0.8', '<') === true)
			include_once(dirname(__FILE__).'/validateOrder/1.6.php');

		if (version_compare(_PS_VERSION_, '1.6.0.8', '>=') === true && version_compare(_PS_VERSION_, '1.6.1', '<') === true)
			include_once(dirname(__FILE__).'/validateOrder/1.6.0.8.php');

		if (version_compare(_PS_VERSION_, '1.6.1', '>=') === true && version_compare(_PS_VERSION_, '1.7', '<') === true)
			include_once(dirname(__FILE__).'/validateOrder/1.6.1.php');

		if (version_compare(_PS_VERSION_, '1.7', '>=') === true)
			include_once(dirname(__FILE__).'/validateOrder/1.7.php');
		
		$override = new Add_gopay_newOverride();
		$override->validateOrder($id_cart, $id_order_state, $amount_paid, $payment_method, $message, $extra_vars, $currency_special, $dont_touch_amount, $secure_key, $shop);
		$this->currentOrder = (int)$override->currentOrder;

		return $this->repairOrder($this->currentOrder);
	}

	private function repairOrder()
	{
		// oprava špatně uložených hodnot ve starších verzích PS */
		$order = new Order($this->currentOrder);
		$currency = new Currency($order->id_currency);
		$order->total_paid_tax_excl = (float)Tools::ps_round($order->total_paid_tax_excl, (int)$currency->decimals * _PS_PRICE_DISPLAY_PRECISION_);
		$order->total_paid_tax_incl = (float)Tools::ps_round($order->total_paid_tax_incl, (int)$currency->decimals * _PS_PRICE_DISPLAY_PRECISION_);
		$order->total_paid = $order->total_paid_tax_incl;

		return $order->save();
	}
}
