<?php
/* ########################################################################### */
/*                                                                             */
/*                      Copyright 2014     Miloslav Kubín                      */
/*                        http://presta-modul.shopmk.cz                        */
/*                                                                             */
/*             Please do not change this text, remove the link,                */
/*          or remove all or any part of the creator copyright notice          */
/*                                                                             */
/*    Please also note that although you are allowed to make modifications     */
/*     for your own personal use, you may not distribute the original or       */
/*                 the modified code without permission.                       */
/*                                                                             */
/*                    SELLING AND REDISTRIBUTION IS FORBIDDEN!                 */
/*             Download is allowed only from presta-modul.shopmk.cz            */
/*                                                                             */
/*       This software is provided as is, without warranty of any kind.        */
/*           The author shall not be liable for damages of any kind.           */
/*               Use of this software indicates that you agree.                */
/*                                                                             */
/*                                    ***                                      */
/*                                                                             */
/*              Prosím, neměňte tento text, nemazejte odkazy,                  */
/*      neodstraňujte části a nebo celé oznámení těchto autorských práv        */
/*                                                                             */
/*     Prosím vezměte také na vědomí, že i když máte možnost provádět změny    */
/*        pro vlastní osobní potřebu,nesmíte distribuovat původní nebo         */
/*                        upravený kód bez povolení.                           */
/*                                                                             */
/*                   PRODEJ A DISTRIBUCE JE ZAKÁZÁNA!                          */
/*          Download je povolen pouze z presta-modul.shopmk.cz                 */
/*                                                                             */
/*   Tento software je poskytován tak, jak je, bez záruky jakéhokoli druhu.    */
/*          Autor nenese odpovědnost za škody jakéhokoliv druhu.               */
/*                  Používáním tohoto softwaru znamená,                        */
/*           že souhlasíte s výše uvedenými autorskými právy .                 */
/*                                                                             */
/* ########################################################################### */

include_once('../../config/config.inc.php');
include_once('../../init.php');
include_once('add_gopay_new.php');
$gopay = new Add_gopay_new();

if (Tools::isSubmit('submit_cancel_recurrent'))
{
	$id_recurrent = New_GoPay_Recurrent::getIdGopayRecurrentByIdSession(Tools::getValue('id_session'));
	$recurrent = new New_GoPay_Recurrent($id_recurrent);

	if (!Validate::isLoadedObject($recurrent))
		die(Tools::jsonEncode(array(
			'errors' => 1,
			'message' => $gopay->l('Order not exist on session: ').Tools::getValue('id_session')
		)));

	if (New_GoPay_Recurrent::getReccurenceEnded($recurrent->id_session))
		die(Tools::jsonEncode(array('errors' => 0)));

	$void_recurrence = New_Gopay_RestAPI::voidRecurrencePayment($recurrent->id_session);
	if (!empty($void_recurrence->errors))
	{
		foreach ($void_recurrence->errors as $error)
			if ($error->message != 'api.PAYMENT_RECURRENCE_STOPPED')
				die(Tools::jsonEncode(array(
					'errors' => 1,
					'message' => $error->message
				)));
	}
		

	$recurrent_end = new New_GoPay_Recurrent();
	$recurrent_end->id_order = $recurrent->id_order;
	$recurrent_end->id_session = $recurrent->id_session;
	$recurrent_end->id_parent_session = $recurrent->id_parent_session;
	$recurrent_end->recurrence_cycle = $recurrent->recurrence_cycle;
	$recurrent_end->recurrence_period = $recurrent->recurrence_period;
	$recurrent_end->recurrence_date_to = $recurrent->recurrence_date_to;
	$recurrent_end->recurrence_state = 'END_RECURRENT';
	if (!$recurrent_end->add())
		$array = array(
				'errors' => 1,
				'message' => $gopay->l('Error save data on database')
		);
	else
		$array = array(
			'errors' => 0
		);

	die(Tools::jsonEncode($array));
}
elseif (Tools::isSubmit('submit_upload_logo'))
{
	if ($_FILES["file"]["name"])
	{
		$koncovky = array('gif');
		$extension = strtolower(pathinfo($_FILES["file"]["name"], PATHINFO_EXTENSION));
		if (in_array($extension, $koncovky))
		{
			if (is_uploaded_file($_FILES["file"]["tmp_name"]))
			{
				if (!move_uploaded_file($_FILES["file"]["tmp_name"], dirname(__FILE__).'/views/images/payments/'.Tools::getValue('ID').'.gif'))
					die(Tools::jsonEncode(array('errors' => 1,
								'message' => $gopay->l('There was an error uploading the file, check permissions to access the folder /modules/add_gopay_new!'))));
			} else
				die(Tools::jsonEncode(array('errors' => 1,
							'message' => $gopay->l('Error: Not uploaded file: ').$_FILES["file"]["tmp_name"])));
		} else
			die(Tools::jsonEncode(array('errors' => 1,
						'message' => $gopay->l('You can only upload images!  (*.gif)'))));
	} else
		die(Tools::jsonEncode(array('errors' => 1,
					'message' => $gopay->l('Not image for upload'))));

	die(Tools::jsonEncode(array('errors' => 0,
				'url' => _MODULE_DIR_.$gopay->name.'/views/images/payments/'.Tools::getValue('ID').'.gif')));
}
elseif (Tools::isSubmit('delete_logo'))
{
	$image = dirname(__FILE__).'/views/images/payments/'.Tools::getValue('ID').'.gif';
	if (file_exists($image))
		if (unlink($image))
			die(Tools::jsonEncode(array('errors' => 0)));
		else
			die(Tools::jsonEncode(array('errors' => 1,
						'message' => $gopay->l('Error deleting image ').$image)));
	else
		die(Tools::jsonEncode(array('errors' => 1,
					'message' => $gopay->l('Image not exist ').$image)));
}