<?php
include_once(dirname(__FILE__).'/moduleconfig.php');

class Add_gopay_newEETsettings extends Add_gopay_newModuleConfig
{
	public $_M;
	private $currentUrl;

	public function init()
	{
		$this->_M = $this->getModule();
		$this->currentUrl = AdminController::$currentIndex.'&configure='.$this->_M->name.'&token='.$this->_M->token.'&idTab=EETsettings';
	}

	public function install()
	{
		Configuration::updateValue(GFIX.'_DIC', '');
		Configuration::updateValue(GFIX.'_EET', 0);
		Configuration::updateValue(GFIX.'_BILL_PDF', 0);
		Configuration::updateValue(GFIX.'_EET_MSG', 'Tržba registrována v běžném režimu dle zákona č. 112/2016 Sb.');
		Configuration::updateValue(GFIX.'_VAT_OTHER', 0);

		return true;
	}

	public function uninstall()
	{
		if (Configuration::get(GFIX.'_FORCE_UNINSTALL'))
		{
		}

		Configuration::deleteByName(GFIX.'_DIC');
		Configuration::deleteByName(GFIX.'_EET');
		Configuration::deleteByName(GFIX.'_BILL_PDF');
		Configuration::deleteByName(GFIX.'_EET_MSG');
		Configuration::deleteByName(GFIX.'_VAT_OTHER');

		return true;
	}

	public function getTitle()
	{
		return $this->l('EET Settings', 'EETsettings');
	}

	public function postProces()
	{
		if ($error = $this->_validate())
			return $this->_M->displayError($error);

		if (Tools::isSubmit('submitEETSettings'))
		{
			Configuration::updateValue(GFIX.'_DIC', Tools::getValue('_DIC'));
			Configuration::updateValue(GFIX.'_EET', Tools::getValue('_EET'));
			Configuration::updateValue(GFIX.'_BILL_PDF', Tools::getValue('_BILL_PDF'));
			Configuration::updateValue(GFIX.'_EET_MSG', Tools::getValue('_EET_MSG'));
			Configuration::updateValue(GFIX.'_VAT_OTHER', Tools::getValue('_VAT_OTHER'));

			return Tools::redirectAdmin($this->currentUrl.'&conf=6');
		}
	}

	public function showForm()
	{
		return $this->renderForms($this->getForm(), $this->getConfig());
	}
	
	public function getForm()
	{
		$fields_form = array(
			$this->_M->name.'-EETsettings' => array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Advanced settings EET', 'EETsettings'),
						'icon' => 'icon-money'
					),
					'input' => array(
						array(
							'type' => 'text',
							'name' => '_DIC',
							'label' => $this->l('Shop vat number:', 'EETsettings'),
							'suffix' => '',
							'desc' => '',
							'class' => 'col-lg-2',
							'required' => false,
							'lang' => false,
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Enable EET - Advanced mode', 'EETsettings'),
							'name' => '_EET',
							'desc' => $this->l('Enable if you sell goods or services in more VAT rates while you are at the gate GoPay selected variant B', 'EETsettings'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'eet_on',
									'value' => 1,
									'label' => $this->l('Yes', 'EETsettings')
								),
								array(
									'id' => 'eet_off',
									'value' => 0,
									'label' => $this->l('No', 'EETsettings')
								)
							)
						),
						array(
						array(
							'type' => 'text',
							'name' => '_DIC',
							'label' => $this->l('Shop vat number:', 'EETsettings'),
							'suffix' => '',
							'desc' => '',
							'class' => 'col-lg-2',
							'required' => false,
							'lang' => false,
						),
							'type' => 'switch',
							'label' => $this->l('I pay VAT in another country', 'EETsettings'),
							'name' => '_VAT_OTHER',
							'desc' => $this->l('If you are VAT and do business in another country, where he also assess VAT, will be sent to the breakdown of the parameter base is not subject to VAT', 'EETsettings'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'eet_on',
									'value' => 1,
									'label' => $this->l('Yes', 'EETsettings')
								),
								array(
									'id' => 'eet_off',
									'value' => 0,
									'label' => $this->l('No', 'EETsettings')
								)
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Display bill information in invoice PDF', 'EETsettings'),
							'name' => '_BILL_PDF',
							'desc' => '',
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'eet_on',
									'value' => 1,
									'label' => $this->l('Yes', 'EETsettings')
								),
								array(
									'id' => 'eet_off',
									'value' => 0,
									'label' => $this->l('No', 'EETsettings')
								)
							)
						),
						array(
							'type' => 'text',
							'name' => '_EET_MSG',
							'label' => $this->l('EET message in invoice PDF:', 'EETsettings'),
							'suffix' => '',
							'desc' => '',
							'class' => 'col-lg-7',
							'required' => false,
							'lang' => false,
						),
						array(
							'type' => 'hidden',
							'name' => 'idTab'
						)
					),
					// Submit Button
					'submit' => array(
									'title' => $this->l('Save', 'EETsettings'),
									'name' => 'submitEETSettings',
									'icon' => 'process-icon-save'
					)
				)
			)
		);

		return $fields_form;
	}

	private function getConfig()									  
	{
		$fields['idTab'] = 'EETsettings';

		$fields['_DIC'] = Tools::getValue('_DIC', Configuration::get(GFIX.'_DIC'));
		$fields['_EET'] = Tools::getValue('_EET', Configuration::get(GFIX.'_EET'));
		$fields['_BILL_PDF'] = Tools::getValue('_BILL_PDF', Configuration::get(GFIX.'_BILL_PDF'));
		$fields['_EET_MSG'] = Tools::getValue('_EET_MSG', Configuration::get(GFIX.'_EET_MSG'));
		$fields['_VAT_OTHER'] = Tools::getValue('_VAT_OTHER', Configuration::get(GFIX.'_VAT_OTHER'));

		return $fields;
	}

	protected function _validate()
	{
		$condition = array();
		if (Tools::isSubmit('submitEETSettings'))
		{
		}

		if (count($condition) > 0)
			return implode('<br>', $condition);
	}
}
