<?php
if (!defined('_PS_VERSION_'))
	exit;

class New_Gopay_Order extends ObjectModel
{
	public $id_order;
	public $id_cart;
	public $id_session;
	public $currency;
	public $total_paid;
	public $recurrent;
	public $preauthorized;
	public $payment_date;
	public $update_date;
	public $payment_status;

	/**
	 * @see ObjectModel::$definition
	 */
	public static $definition = array(
				'table' => 'add_gopay_new_order',
				'primary' => 'id_order',
				'fields' => array(
            		'id_order'		 => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            		'id_cart'		 => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            		'id_session'	 => array('type' => self::TYPE_INT),
					'currency' 		 => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            		'total_paid'	 => array('type' => self::TYPE_FLOAT, 'validate' => 'isFloat'),
            		'recurrent'		 => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            		'preauthorized'	 => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
					'payment_date'	 => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            		'update_date'	 => array('type' => self::TYPE_DATE),
            		'payment_status' => array('type' => self::TYPE_STRING, 'validate' => 'isString')
					)
	);
 
	public function __construct($id = null) 
	{
		return parent::__construct($id);     
	}

	public static function getOrderById($id_order)
	{
		$query = new DbQuery();
		$query->select('a.*');
		$query->from(self::$definition['table'], 'a');
		$query->where('`id_order` = \''.(int)$id_order.'\'');

		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($query);
	}

	public static function getIdOrderByTransactionId($id_session)
	{
		$query = new DbQuery();
		$query->select('a.`id_order`');
		$query->from(self::$definition['table'], 'a');
		$query->where('`id_session` = \''.(int)$id_session.'\'');

		if ($result = Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($query))
			return (int)$result;

		return 0;
	}
}
