<?php
include_once(dirname(__FILE__).'/moduleconfig.php');

class Add_gopay_newMainSetting extends Add_gopay_newModuleConfig
{
	public $_M;
	private $id_lang;
	private $currentUrl;

	public function init()
	{
		$this->_M = $this->getModule();
		$this->currentUrl = AdminController::$currentIndex.'&configure='.$this->_M->name.'&token='.$this->_M->token.'&idTab=settings';
		$allowed_carriers = Configuration::get(GFIX.'_ALLOWED_CARRIERS');
		$this->allowed_carriers = $allowed_carriers ? unserialize($allowed_carriers) : '';
		$this->id_lang = Context::getContext()->language->id;
	}

	public function install()
	{
		Configuration::updateValue(GFIX.'_FORCE_UNINSTALL', 0);
		Configuration::updateValue(GFIX.'_GATEWAY_MODE', 0);

		Configuration::updateValue(GFIX.'_GO_ID', '');
		Configuration::updateValue(GFIX.'_CLIENT_ID', '');
		Configuration::updateValue(GFIX.'_CLIENT_SECRET', '');
		Configuration::updateValue(GFIX.'_GO_ID_TEST', '8286129500');
		Configuration::updateValue(GFIX.'_CLIENT_ID_TEST', '1235180089');
		Configuration::updateValue(GFIX.'_CLIENT_SECRET_TEST', 'dF8PRhaE');

		Configuration::updateValue(GFIX.'_ORDER_DESCRIPTION', '');
		Configuration::updateValue(GFIX.'_INLINE_MODE', 0);
		Configuration::updateValue(GFIX.'_ORDER_MODE', 0);
		Configuration::updateValue(GFIX.'_PREAUTHORIZED', 0);
		Configuration::updateValue(GFIX.'_RECURRENT', 0);
		Configuration::updateValue(GFIX.'_RECURRENCE_TYPE', 'periodic');
		Configuration::updateValue(GFIX.'_RECURRENCE_CYCLE', 'MONTH');
		Configuration::updateValue(GFIX.'_RECURRENCE_PERIOD', 1);
		Configuration::updateValue(GFIX.'_RECURRENCE_DATE_TO', 0);
		Configuration::updateValue(GFIX.'_REFUND', 0);
		Configuration::updateValue(GFIX.'_SKIP_STEP', 0);
		Configuration::updateValue(GFIX.'_HOOK', 'left');
		Configuration::updateValue(GFIX.'_ORDER_REFERENCE', 0);
		Configuration::updateValue(GFIX.'_ERRORS_REPORT', 1);
		Configuration::updateValue(GFIX.'_ALLOWED_CARRIERS', serialize(array()));

		return true;
	}

	public function uninstall()
	{
		if (Configuration::get(GFIX.'_FORCE_UNINSTALL'))
		{
		}

		Configuration::deleteByName(GFIX.'_FORCE_UNINSTALL');
		Configuration::deleteByName(GFIX.'_GATEWAY_MODE');
		Configuration::deleteByName(GFIX.'_GO_ID');
		Configuration::deleteByName(GFIX.'_CLIENT_ID');
		Configuration::deleteByName(GFIX.'_CLIENT_SECRET');
		Configuration::deleteByName(GFIX.'_GO_ID_TEST');
		Configuration::deleteByName(GFIX.'_CLIENT_ID_TEST');
		Configuration::deleteByName(GFIX.'_CLIENT_SECRET_TEST');
		Configuration::deleteByName(GFIX.'_INLINE_MODE');
		Configuration::deleteByName(GFIX.'_ORDER_MODE');
		Configuration::deleteByName(GFIX.'_PREAUTHORIZED');
		Configuration::deleteByName(GFIX.'_RECURRENT');
		Configuration::deleteByName(GFIX.'_RECURRENCE_TYPE');
		Configuration::deleteByName(GFIX.'_RECURRENCE_CYCLE');
		Configuration::deleteByName(GFIX.'_RECURRENCE_PERIOD');
		Configuration::deleteByName(GFIX.'_RECURRENCE_DATE_TO');
		Configuration::deleteByName(GFIX.'_REFUND');
		Configuration::deleteByName(GFIX.'_SKIP_STEP');
		Configuration::deleteByName(GFIX.'_HOOK');
		Configuration::deleteByName(GFIX.'_ORDER_REFERENCE');
		Configuration::deleteByName(GFIX.'_ERRORS_REPORT');
		Configuration::deleteByName(GFIX.'_ALLOWED_CARRIERS');

		$languages = Language::getLanguages(true);
		foreach ($languages as $language)
		{
			$lang = $language['id_lang'];
			Configuration::deleteByName(GFIX.'_ORDER_DESCRIPTION_'.$lang);
		}

		return true;
	}

	public function getTitle()
	{
		return $this->l('Basic Settings', 'mainsetting');
	}

	public function postProces()
	{
		if ($error = $this->_validate())
			return $this->_M->displayError($error);

		if (Tools::isSubmit('submitBasicSettings'))
		{
			Configuration::updateValue(GFIX.'_FORCE_UNINSTALL', Tools::getValue('_FORCE_UNINSTALL'));

			Configuration::updateValue(GFIX.'_GO_ID', Tools::getValue('_GO_ID'));
			Configuration::updateValue(GFIX.'_CLIENT_ID', Tools::getValue('_CLIENT_ID'));
			Configuration::updateValue(GFIX.'_CLIENT_SECRET', Tools::getValue('_CLIENT_SECRET'));
			Configuration::updateValue(GFIX.'_GO_ID_TEST', Tools::getValue('_GO_ID_TEST'));
			Configuration::updateValue(GFIX.'_CLIENT_ID_TEST', Tools::getValue('_CLIENT_ID_TEST'));
			Configuration::updateValue(GFIX.'_CLIENT_SECRET_TEST', Tools::getValue('_CLIENT_SECRET_TEST'));

			Configuration::updateValue(GFIX.'_ORDER_DESCRIPTION', Tools::getValue('_ORDER_DESCRIPTION'));
			Configuration::updateValue(GFIX.'_INLINE_MODE', Tools::getValue('_INLINE_MODE'));
			Configuration::updateValue(GFIX.'_ORDER_MODE', Tools::getValue('_ORDER_MODE'));
			Configuration::updateValue(GFIX.'_PREAUTHORIZED', Tools::getValue('_PREAUTHORIZED'));
			Configuration::updateValue(GFIX.'_RECURRENT', Tools::getValue('_RECURRENT'));
			Configuration::updateValue(GFIX.'_RECURRENCE_TYPE', Tools::getValue('_RECURRENCE_TYPE'));
			Configuration::updateValue(GFIX.'_RECURRENCE_CYCLE', Tools::getValue('_RECURRENCE_CYCLE'));
			Configuration::updateValue(GFIX.'_RECURRENCE_PERIOD', Tools::getValue('_RECURRENCE_PERIOD'));
			Configuration::updateValue(GFIX.'_RECURRENCE_DATE_TO', Tools::getValue('_RECURRENCE_DATE_TO'));
			Configuration::updateValue(GFIX.'_REFUND', Tools::getValue('_REFUND'));
			Configuration::updateValue(GFIX.'_SKIP_STEP', Tools::getValue('_SKIP_STEP'));
			Configuration::updateValue(GFIX.'_HOOK', Tools::getValue('_HOOK'));
			Configuration::updateValue(GFIX.'_ORDER_REFERENCE', Tools::getValue('_ORDER_REFERENCE'));
			Configuration::updateValue(GFIX.'_ERRORS_REPORT', Tools::getValue('_ERRORS_REPORT'));

			$languages = Language::getLanguages(false);
			foreach ($languages as $language)
			{
				$lang = $language['id_lang'];
				Configuration::updateValue(GFIX.'_ORDER_DESCRIPTION_'.$lang, Tools::getValue('_ORDER_DESCRIPTION_'.$lang));
			}

			foreach ($this->getStatuses() as $status)
				Configuration::updateValue(GFIX.$status['code'], Tools::getValue($status['code']));

			$ALLOWED_CARRIERS = Tools::getValue('_ALLOWED_CARRIERS');
			Configuration::updateValue(GFIX.'_ALLOWED_CARRIERS', $ALLOWED_CARRIERS ? serialize($ALLOWED_CARRIERS) : '');

			return Tools::redirectAdmin($this->currentUrl.'&conf=6');

		} elseif (Tools::isSubmit('test_configuration'))
		{
			$data = include_once(_PS_MODULE_DIR_.$this->_M->name.'/new_api/gopay_test.php');
			die(Tools::jsonEncode($data));

		} elseif (Tools::isSubmit('submitDeleteStatuses'))
		{
			$_DELETE_STATUSES = Tools::getValue('_DELETE_STATUSES');
			if (is_array($_DELETE_STATUSES) && count($_DELETE_STATUSES) > 0)
			{
				foreach ($_DELETE_STATUSES as $status)
				{
					$order_state = new OrderState((int)$status, $this->id_lang);

					if (!$order_state->delete())
					{
						return $this->_M->displayError($this->l('An error has occurred: Can\'t delete the current order\'s status.', 'mainsetting'));
					}
				}
				return Tools::redirectAdmin($this->currentUrl.'&conf=1');

			} else
				return $this->_M->displayError($this->l('An error has occurred: You have not selected any status.', 'mainsetting'));
		}
	}

	public function showForm()
	{
		return $this->renderForms($this->getForm(), $this->getConfig());
	}
	
	public function getForm()
	{
		$languages = Context::getContext()->language->getLanguages();
		$currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));

		$positions = array(
			array(
				'value' => '1',
				'name' => 'Left'
			),
			array(
				'value' => '2',
				'name' => 'Right'
			)
		);

		$_CARRIERS = Carrier::getCarriers($this->id_lang, true, false, false, null, Carrier::ALL_CARRIERS);

		foreach ($_CARRIERS as $key => $val)
		{
			$carriers[$key]['name'] = $val['name'];
			$carriers[$key]['id'] = 'ALLOWED_CARRIERS['.$val['id_reference'].']';
			$carriers[$key]['val'] = $val['id_reference'];
		}

		$_STATUSES = array();
		foreach (self::getOrderStates($this->id_lang) as $status)
		{
			$_STATUSES[] = array(
				"id" => $status['id_order_state'],
				'val' => $status['id_order_state'],
				"name" => $status['id_order_state'].' - '.$status['name']
			);
		}

		$recurrence_types = array(
			array(
				"id" => 'periodic',
				"name" => $this->l('Periodic recurring payment', 'mainsetting')
			),
			array(
				"id" => 'request',
				"name" => $this->l('Repeated payment on request', 'mainsetting')
			)
		);

		$recurrence_cycles = array(
			array(
				"id" => 'DAY',
				"name" => $this->l('Daily recurring', 'mainsetting')
			),
			array(
				"id" => 'WEEK',
				"name" => $this->l('Weekly recurring', 'mainsetting')
			),
			array(
				"id" => 'MONTH',
				"name" => $this->l('Monthly recurring', 'mainsetting')
			)
		);

		$_RECURRENCE_DATE_TO = array(
			array(
				"id" => '0',
				"name" => $this->l('Never (end of expiration CK)', 'mainsetting')
			),
			array(
				"id" => '3',
				"name" => '3 '.$this->l('cycles', 'mainsetting')
			),
			array(
				"id" => '6',
				"name" => '6 '.$this->l('cycles', 'mainsetting')
			),
			array(
				"id" => '9',
				"name" => '9 '.$this->l('cycles', 'mainsetting')
			),
			array(
				"id" => '18',
				"name" => '18 '.$this->l('cycles', 'mainsetting')
			),
			array(
				"id" => '24',
				"name" => '24 '.$this->l('cycles', 'mainsetting')
			),
			array(
				"id" => '30',
				"name" => '30 '.$this->l('cycles', 'mainsetting')
			),
			array(
				"id" => '36',
				"name" => '36 '.$this->l('cycles', 'mainsetting')
			),
			array(
				"id" => '42',
				"name" => '42 '.$this->l('cycles', 'mainsetting')
			),
			array(
				"id" => '48',
				"name" => '48 '.$this->l('cycles', 'mainsetting')
			)
		);

		$hooks = array(
			array(
				"id" => 'left',
				"name" => $this->l('Left column', 'mainsetting')
			),
			array(
				"id" => 'right',
				"name" => $this->l('Right column', 'mainsetting')
			),
			array(
				"id" => 'footer',
				"name" => $this->l('Footer', 'mainsetting')
			)
		);

		$fields_form = array(
			$this->_M->name.'-general' => array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Payment Gateway Mode', 'mainsetting'),
						'icon' => 'icon-cogs'
					),
					'input' => array(
						array(
							'type' => 'radio',
							'label' => $this->l('Payment Gateway Mode', 'mainsetting'),
							'desc' => $this->l('Payment Gateway URL is a type of communication with the payment system GoPay.', 'mainsetting'),
							'name' => '_GATEWAY_MODE',
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'mode_on',
									'value' => 1,
									'label' => $this->l('Full', 'mainsetting')
								),
								array(
									'id' => 'mode_off',
									'value' => 0,
									'label' => $this->l('Test', 'mainsetting')
								)
							)
						),
						array(
							'type' => 'text',
							'name' => '_GO_ID',
							'label' => $this->l('Target GoID:', 'mainsetting'),
							'suffix' => '',
							'desc' => $this->l('Target GoID identifier is e-shop (10-digit number), available at the time of integration GoPay.', 'mainsetting'),
							'class' => 'col-lg-2',
							'form_group_class' => 'full_mode '.(!Configuration::get(GFIX.'_GATEWAY_MODE') ? 'hide_mode' : '').'',
							'maxlength' => 10,
							'required' => true,
							'lang' => false,
						),
						array(
							'type' => 'text',
							'name' => '_CLIENT_ID',
							'label' => $this->l('Client ID:', 'mainsetting'),
							'suffix' => '',
							'desc' => $this->l('Client ID is a secret code (10-digit number) in the system GoPay that you get the time integration GoPay.', 'mainsetting'),
							'class' => 'col-lg-3',
							'form_group_class' => 'full_mode '.(!Configuration::get(GFIX.'_GATEWAY_MODE') ? 'hide_mode' : '').'',
							'maxlength' => 24,
							'required' => true,
							'lang' => false,
						),
						array(
							'type' => 'text',
							'name' => '_CLIENT_SECRET',
							'label' => $this->l('Client Secret:', 'mainsetting'),
							'suffix' => '',
							'desc' => $this->l('Client Secret is a secret code (8 characters) in the system GoPay that you get the time integration GoPay.', 'mainsetting'),
							'class' => 'col-lg-3',
							'form_group_class' => 'full_mode '.(!Configuration::get(GFIX.'_GATEWAY_MODE') ? 'hide_mode' : '').'',
							'maxlength' => 24,
							'required' => true,
							'lang' => false,
						),
						array(
							'type' => 'text',
							'name' => '_GO_ID_TEST',
							'label' => $this->l('Target GoID:', 'mainsetting'),
							'suffix' => '',
							'desc' => $this->l('Target GoID identifier is e-shop (10-digit number), available at the time of integration GoPay.', 'mainsetting'),
							'class' => 'col-lg-2',
							'form_group_class' => 'test_mode '.(Configuration::get(GFIX.'_GATEWAY_MODE') ? 'hide_mode' : '').'',
							'maxlength' => 10,
							'required' => true,
							'lang' => false,
						),
						array(
							'type' => 'text',
							'name' => '_CLIENT_ID_TEST',
							'label' => $this->l('Client ID:', 'mainsetting'),
							'suffix' => '',
							'desc' => $this->l('Client ID is a secret code (10-digit number) in the system GoPay that you get the time integration GoPay.', 'mainsetting'),
							'class' => 'col-lg-3',
							'form_group_class' => 'test_mode '.(Configuration::get(GFIX.'_GATEWAY_MODE') ? 'hide_mode' : '').'',
							'maxlength' => 24,
							'required' => true,
							'lang' => false,
						),
						array(
							'type' => 'text',
							'name' => '_CLIENT_SECRET_TEST',
							'label' => $this->l('Client Secret:', 'mainsetting'),
							'suffix' => '',
							'desc' => $this->l('Client Secret is a secret code (8 characters) in the system GoPay that you get the time integration GoPay.', 'mainsetting'),
							'class' => 'col-lg-3',
							'form_group_class' => 'test_mode '.(Configuration::get(GFIX.'_GATEWAY_MODE') ? 'hide_mode' : '').'',
							'maxlength' => 24,
							'required' => true,
							'lang' => false,
						),
						array(
							'type' => 'button',
							'name' => '',
							'desc' => '<input type="button"  id="test_config" value="'.$this->l('Test Configuration', 'mainsetting').'" class="btn btn-default button_main">',
							'class' => 'col-lg-3',
							'required' => false,
							'lang' => false,
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Inline payment gateway', 'mainsetting'),
							'name' => '_INLINE_MODE',
							'desc' => $this->l('Inline payment gateway - Fast payments without redirection.', 'mainsetting').' '.$this->l('This option is available only if you have on your site', 'mainsetting').' <a href="'.Context::getContext()->link->getAdminLink('AdminPreferences').'" target="new"> '.$this->l('deployed SSL', 'mainsetting').'</a>',
							'disabled' => Configuration::get('PS_SSL_ENABLED') ? false : true,
							'values' => array(
								array(
									'id' => 'inline_on',
									'value' => 1,
									'label' => $this->l('Yes', 'mainsetting')
								),
								array(
									'id' => 'inline_off',
									'value' => 0,
									'label' => $this->l('No', 'mainsetting')
								)
							)
						),
						/*array(
							'type' => 'switch',
							'label' => $this->l('Create order after payment', 'mainsetting'),
							'name' => '_ORDER_MODE',
							'desc' => $this->l('The order will be created only if the customer makes a payment to the gate GoPays.', 'mainsetting').
									'<br>'.$this->l('This is an unverified feature, use it at your own risk.', 'mainsetting'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'order_on',
									'value' => 1,
									'label' => $this->l('Yes', 'mainsetting')
								),
								array(
									'id' => 'order_off',
									'value' => 0,
									'label' => $this->l('No', 'mainsetting')
								)
							)
						),*/
						array(
							'type' => 'switch',
							'label' => $this->l('When you uninstall module to delete stored data', 'mainsetting'),
							'name' => '_FORCE_UNINSTALL',
							'desc' => $this->l('All settings will be deleted, order status, and database tables. You use only if necessary!', 'mainsetting'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'delete_on',
									'value' => 1,
									'label' => $this->l('Yes', 'mainsetting')
								),
								array(
									'id' => 'delete_off',
									'value' => 0,
									'label' => $this->l('No', 'mainsetting')
								)
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Skip step order confirmation', 'mainsetting'),
							'name' => '_SKIP_STEP',
							'desc' => $this->l('The order will be finalized after selecting payment methods without displaying the confirmation page.', 'mainsetting'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'skip_on',
									'value' => 1,
									'label' => $this->l('Yes', 'mainsetting')
								),
								array(
									'id' => 'skip_off',
									'value' => 0,
									'label' => $this->l('No', 'mainsetting')
								)
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Pair payments by order reference', 'mainsetting'),
							'name' => '_ORDER_REFERENCE',
							'desc' => $this->l('The Order reference will be used as a variable payment symbol.', 'mainsetting'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'reference_on',
									'value' => 1,
									'label' => $this->l('Yes', 'mainsetting')
								),
								array(
									'id' => 'reference_off',
									'value' => 0,
									'label' => $this->l('No', 'mainsetting')
								)
							)
						),
						array(
							'type' => 'select',
							'name' => '_HOOK',
							'label' => $this->l('Show payment logo in hook', 'mainsetting'),
							'desc' => '',
							'required' => false,
							'lang' => false,
							'options' => array(
								'query' => $hooks,
								'id' => 'id',
								'name' => 'name'
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Enable Errors Report', 'mainsetting'),
							'name' => '_ERRORS_REPORT',
							'desc' => $this->l('If an error occurs in communication with payment gateway will be sent an email to ', 'mainsetting').Configuration::get('PS_SHOP_EMAIL'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'report_on',
									'value' => 1,
									'label' => $this->l('Yes', 'mainsetting')
								),
								array(
									'id' => 'report_off',
									'value' => 0,
									'label' => $this->l('No', 'mainsetting')
								)
							)
						),
						array(
							'type' => 'hidden',
							'name' => 'idTab'
						)
					),
					// Submit Button
					'submit' => array(
									'title' => $this->l('Save', 'mainsetting'),
									'name' => 'submitBasicSettings',
									'icon' => 'process-icon-save'
					)
				)
			),
			$this->_M->name.'-general1' => array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Setting payment preference', 'mainsetting'),
						'icon' => 'icon-cogs'
					),
					'input' => array(
						array(
							'type' => 'html',
							'name' => '',
							'label' => ' ',
							'title' => '',
							'col' => 9,
							'html_content' => '
								<script type="text/javascript">
									var period_days = \''.$this->_displayPeriodes('DAYS', $this->l('days', 'mainsetting')).'\';
									var period_weeks = \''.$this->_displayPeriodes('WEEKS', $this->l('weeks', 'mainsetting')).'\';
									var period_months = \''.$this->_displayPeriodes('MONTHS', $this->l('months', 'mainsetting')).'\';
								</script>'
						),
						array(
							'type' => 'switch',
							'name' => '_REFUND',
							'label' => $this->l('Return money:', 'mainsetting'),
							'desc' => $this->l('Refund of the payment is a functionality which allows recovering funds for already made payment to the customer.', 'mainsetting'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'refund_on',
									'value' => 1,
									'label' => $this->l('Yes', 'mainsetting')
								),
								array(
									'id' => 'refund_off',
									'value' => 0,
									'label' => $this->l('No', 'mainsetting')
								)
							)
						),
						array(
							'type' => 'text',
							'name' => '_ORDER_DESCRIPTION',
							'label' => $this->l('Order description:', 'mainsetting'),
							'desc' => $this->l('Description or order acknowledgments, displays the customer in the payment window.', 'mainsetting'),
							'maxlength' => 256,
							'class' => 'col-lg-9',
							'lang' => true,
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Pre-authorized payments', 'mainsetting'),
							'name' => '_PREAUTHORIZED',
							'desc' => $this->l('Pre-authorization is a type of payment that provides blocking funds in the bank account of paying customer. At the moment of completion of payment on the payment gateway funds are not transferred to GoPay business account but is created blocking (pre-authorization) on the bank of paying customer. Blocking can be based on the trader instruction canceled or made a transaction as completed, ie. the transfer of blocked funds to GoPay business account. All operations with pre-authorized payments can be made for a period of 4 days from the establishment of payment. Payment methods supporting pre-authorize are payment cards only.', 'mainsetting'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'preauthorized_on',
									'value' => 1,
									'label' => $this->l('Yes', 'mainsetting')
								),
								array(
									'id' => 'preauthorized_off',
									'value' => 0,
									'label' => $this->l('No', 'mainsetting')
								)
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Recurrent payments', 'mainsetting'),
							'name' => '_RECURRENT',
							'desc' => $this->l('Recurring payment is a functionality that allows accept payment from customer on a regular basis. The customer is at the time of creating payment informed at the payment gateway of its parameters (amount, payment frequency, etc.). After the successful establishment of the initialization payment are payments made automatically with defined period or upon request. The customer is informed by e-mail about each completed payment. Merchant is informed through notification about the change in payment. Payment methods supporting recurring payment are payment cards.', 'mainsetting'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'recurrent_on',
									'value' => 1,
									'label' => $this->l('Yes', 'mainsetting')
								),
								array(
									'id' => 'recurrent_off',
									'value' => 0,
									'label' => $this->l('No', 'mainsetting')
								)
							)
						),
						array(
							'type' => 'select',
							'name' => '_RECURRENCE_TYPE',
							'label' => $this->l('Recurrence type:', 'mainsetting'),
							'desc' => $this->l('Time period of recurring.', 'mainsetting'),
							'required' => false,
							'lang' => false,
							'options' => array(
								'query' => $recurrence_types,
								'id' => 'id',
								'name' => 'name'
							)
						),
						array(
							'type' => 'select',
							'name' => '_RECURRENCE_CYCLE',
							'label' => $this->l('Recurrence cycle:', 'mainsetting'),
							'desc' => $this->l('Time period of recurring.', 'mainsetting'),
							'class' => 'display_inline',
							'required' => false,
							'lang' => false,
							'options' => array(
								'query' => $recurrence_cycles,
								'id' => 'id',
								'name' => 'name'
							)
						),
						array(
							'type' => 'select',
							'name' => '_RECURRENCE_DATE_TO',
							'label' => $this->l('Recurrence date To:', 'mainsetting'),
							'desc' => $this->l('End of recurrence.', 'mainsetting'),
							'required' => false,
							'lang' => false,
							'options' => array(
								'query' => $_RECURRENCE_DATE_TO,
								'id' => 'id',
								'name' => 'name'
							)
						),
						array(
							'type' => 'hidden',
							'name' => 'idTab'
						)
					),
					// Submit Button
					'submit' => array(
									'title' => $this->l('Save', 'mainsetting'),
									'name' => 'submitBasicSettings',
									'icon' => 'process-icon-save'
					)
				)
			),
			$this->_M->name.'-general2' => array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Statuses settings', 'mainsetting'),
						'icon' => 'icon-cogs'
					),
					'input' => $this->status_inputs(),
					// Submit Button
					'submit' => array(
									'title' => $this->l('Save', 'mainsetting'),
									'name' => 'submitBasicSettings',
									'icon' => 'process-icon-save'
					)
				)
			),
			$this->_M->name.'-general3' => array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Deleting Statuses', 'mainsetting'),
						'icon' => 'icon-cogs'
					),
					'input' => array(
						array(
							'type' => 'select',
							'multiple' => true,
							'label' => $this->l('Statuses', 'mainsetting'),
							'desc' => $this->l('Be very careful when deleting, if you delete status needed for proper function module, you will need to reinstall the module
', 'mainsetting'), 
							'name' => '_DELETE_STATUSES[]',
							'size' => 5,
							'options' => array(
									'query' => $_STATUSES,
									'id' => 'id',
									'name' => 'name'
							)
						),
						array(
							'type' => 'button',
							'name' => '',
							'desc' => '<button type="submit" name="submitDeleteStatuses" class="btn btn-default button_main" onclick="if (confirm(\''.$this->l('Delete stauses?', 'mainsetting').'\')){return true;}else{event.stopPropagation(); event.preventDefault();};">'.$this->l('Delete stauses', 'mainsetting').'</button>',
							'class' => 'col-lg-3',
							'required' => false,
							'lang' => false,
						)
					)
				)
			),
			$this->_M->name.'-general4' => array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Allowed carriers', 'mainsetting'),
						'icon' => 'icon-cogs'
					),
					'input' => array(
						array(
							'type'	=> 'checkbox',
							'label'   => $this->l('Carriers:', 'mainsetting'),
							'desc'	=> $this->l('Allowed carriers, leave empty for all.', 'mainsetting'),
							'name'	=> '',
							'values'  => array(
								'query' => $carriers,
								'id'	=> 'id',
								'name'  => 'name'
							)
						),
						array(
							'type' => 'hidden',
							'name' => 'idTab'
						)
					),
					// Submit Button
					'submit' => array(
									'title' => $this->l('Save', 'mainsetting'),
									'name' => 'submitBasicSettings',
									'icon' => 'process-icon-save'
					)
				)
			)
		);

		return $fields_form;
	}

	private function getStatuses()									  
	{
		return $statuses = array(
			array('code' => '_NEW', 'name' => 'GoPay - order created'),
			array('code' => '_CREATED', 'name' => 'GoPay - recurring payment created'),
			array('code' => '_TIMEOUTED', 'name' => 'GoPay - timeout'),
			array('code' => '_PAYMENT_METHOD_CHOSEN', 'name' => 'GoPay - payment chosen'),
			array('code' => '_CANCELED', 'name' => 'GoPay - canceled'),
			array('code' => '_AUTHORIZED', 'name' => 'GoPay - authorized'),
			array('code' => '_REFUNDED', 'name' => 'GoPay - refunded'),
			array('code' => '_PARTIALLY_REFUNDED', 'name' => 'GoPay - partially refunded')
		);
	}

	private function status_inputs()									  
	{
		foreach (OrderState::getOrderStates((int)$this->id_lang) as $status)
		{
			$_ORDER_STATUSES[] = array(
				"id" => $status['id_order_state'],
				'val' => $status['id_order_state'],
				"name" => $status['id_order_state'].' - '.$status['name']
			);
		}

		$inputs[] = array(
						'type' => 'hidden',
						'name' => 'idTab'
		);

		foreach ($this->getStatuses() as $status)
		{
			$inputs[] = array(
							'type' => 'select',
							'name' => $status['code'],
							'label' => $status['name'],
							'desc' => '',
							'required' => false,
							'lang' => false,
							'options' => array(
								'query' => $_ORDER_STATUSES,
								'id' => 'id',
								'name' => 'name'
							)
			);
		}

		return $inputs;
	}

	private function getConfig()									  
	{
		$fields = array();
		$fields['idTab'] = 'settings';

		$fields['_FORCE_UNINSTALL'] = Tools::getValue('_FORCE_UNINSTALL', Configuration::get(GFIX.'_FORCE_UNINSTALL'));

		$fields['_GATEWAY_MODE'] = Tools::getValue('_GATEWAY_MODE', Configuration::get(GFIX.'_GATEWAY_MODE'));
		$fields['_GO_ID'] = Tools::getValue('_GO_ID', Configuration::get(GFIX.'_GO_ID'));
		$fields['_GO_ID_TEST'] = Tools::getValue('_GO_ID_TEST', Configuration::get(GFIX.'_GO_ID_TEST'));
		$fields['_CLIENT_ID'] = Tools::getValue('_CLIENT_ID', Configuration::get(GFIX.'_CLIENT_ID'));
		$fields['_CLIENT_ID_TEST'] = Tools::getValue('_CLIENT_ID_TEST', Configuration::get(GFIX.'_CLIENT_ID_TEST'));
		$fields['_CLIENT_SECRET'] = Tools::getValue('_CLIENT_SECRET', Configuration::get(GFIX.'_CLIENT_SECRET'));
		$fields['_CLIENT_SECRET_TEST'] = Tools::getValue('_CLIENT_SECRET_TEST', Configuration::get(GFIX.'_CLIENT_SECRET_TEST'));
		$fields['_INLINE_MODE'] = Tools::getValue('_INLINE_MODE', Configuration::get(GFIX.'_INLINE_MODE'));
		$fields['_ORDER_MODE'] = Tools::getValue('_ORDER_MODE', Configuration::get(GFIX.'_ORDER_MODE'));
		$fields['_PREAUTHORIZED'] = Tools::getValue('_PREAUTHORIZED', Configuration::get(GFIX.'_PREAUTHORIZED'));
		$fields['_RECURRENT'] = Tools::getValue('_RECURRENT', Configuration::get(GFIX.'_RECURRENT'));
		$fields['_RECURRENCE_TYPE'] = Tools::getValue('_RECURRENCE_TYPE', Configuration::get(GFIX.'_RECURRENCE_TYPE'));
		$fields['_RECURRENCE_CYCLE'] = Tools::getValue('_RECURRENCE_CYCLE', Configuration::get(GFIX.'_RECURRENCE_CYCLE'));
		$fields['_RECURRENCE_PERIOD'] = Tools::getValue('_RECURRENCE_PERIOD', Configuration::get(GFIX.'_RECURRENCE_PERIOD'));
		$fields['_RECURRENCE_DATE_TO'] = Tools::getValue('_RECURRENCE_DATE_TO', Configuration::get(GFIX.'_RECURRENCE_DATE_TO'));
		$fields['_REFUND'] = Tools::getValue('_REFUND', Configuration::get(GFIX.'_REFUND'));
		$fields['_SKIP_STEP'] = Tools::getValue('_SKIP_STEP', Configuration::get(GFIX.'_SKIP_STEP'));
		$fields['_HOOK'] = Tools::getValue('_HOOK', Configuration::get(GFIX.'_HOOK'));
		$fields['_ORDER_REFERENCE'] = Tools::getValue('_ORDER_REFERENCE', Configuration::get(GFIX.'_ORDER_REFERENCE'));
		$fields['_ERRORS_REPORT'] = Tools::getValue('_ERRORS_REPORT', Configuration::get(GFIX.'_ERRORS_REPORT'));
		$fields['_DELETE_STATUSES[]'] = Tools::getValue('_DELETE_STATUSES');

		$languages = Language::getLanguages(false);
		foreach ($languages as $language)
		{
			$lang = $language['id_lang'];
			$fields['_ORDER_DESCRIPTION'][$lang] = Tools::getValue('_ORDER_DESCRIPTION_'.$lang, Configuration::get(GFIX.'_ORDER_DESCRIPTION_'.$lang));
		}

		foreach ($this->getStatuses() as $status)
			$fields[$status['code']] = Tools::getValue($status['code'], Configuration::get(GFIX.$status['code']));

		if (is_array($this->allowed_carriers))
		{
			foreach($this->allowed_carriers as $allowed_carrier)
				$fields['_ALLOWED_CARRIERS['.$allowed_carrier.']'] = $allowed_carrier;

		} else
			$fields['_ALLOWED_CARRIERS[]'] = '';
			

		return $fields;
	}

	private function _displayPeriodes($period_type, $period_name)
	{
		$DAYS = 31;
		$WEEKS = 53;
		$MONTHS = 12;
		$module_dir = _PS_MODULE_DIR_.$this->_M->name.'/views/templates/classes';
		$tpl_enable = Context::getContext()->smarty->createTemplate($module_dir.'/_recurrence_period.tpl');

		$tpl_enable->assign(array(
			'RECURRENCE_PERIOD'		 => Configuration::get(GFIX.'_RECURRENCE_PERIOD'),
			'recurrent_periodes'	 => ${$period_type},
			'period_name'			 => $period_name,
		));

		return $tpl_enable->fetch();
	}

	private static function getOrderStates($id_lang)
	{
		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT *
			FROM `'._DB_PREFIX_.'order_state` os
			LEFT JOIN `'._DB_PREFIX_.'order_state_lang` osl ON (os.`id_order_state` = osl.`id_order_state` AND osl.`id_lang` = '.(int)$id_lang.')
			WHERE deleted = 0
			AND osl.`name` LIKE \'Gopay%\'
			ORDER BY `name` ASC');

		return $result;
	}

	protected function _validate()
	{
		$condition = array();
		if (Tools::isSubmit('submitBasicSettings'))
		{
			Configuration::updateValue(GFIX.'_GATEWAY_MODE', Tools::getValue('_GATEWAY_MODE'));

			if (Configuration::get(GFIX.'_GATEWAY_MODE'))
			{
				if (strlen(Tools::getValue('_GO_ID')) != 10)
					$condition[] = $this->l('Target GoID must be a numeric value and string length 10 !', 'mainsetting');
	
				if (strlen(Tools::getValue('_CLIENT_ID')) != 10)
					$condition[] = $this->l('Client ID must be a numeric value and string length 10 !', 'mainsetting');
	
				if (strlen(Tools::getValue('_CLIENT_SECRET')) != 8)
					$condition[] = $this->l('Client Secred code must be a string length 8 !', 'mainsetting');
			} else
			{
				if (/*Validate::isInt(Tools::getValue('_GO_ID_TEST')) && */strlen(Tools::getValue('_GO_ID_TEST')) != 10)
					$condition[] = $this->l('Testing Target GoID must be a numeric value and string length 10 !', 'mainsetting');
	
				if (strlen(Tools::getValue('_CLIENT_ID_TEST')) != 10)
					$condition[] = $this->l('Testing Client ID must be a numeric value and string length 10 !', 'mainsetting');
	
				if (strlen(Tools::getValue('_CLIENT_SECRET_TEST')) != 8)
					$condition[] = $this->l('Testing Client Secred code must be a string length 8 !', 'mainsetting');
			}
		}

		if (count($condition) > 0)
			return implode('<br>', $condition);
	}
}
