<?php
abstract class Add_gopay_newModuleConfig
{
	const DISABLED = 0;
	const ENABLED = 1;

	private $_module;
	protected $_submit_name = 'submit';
	abstract public function init();
	abstract public function install();
	abstract public function uninstall();
	abstract public function postProces();
	abstract public function showForm();
	abstract protected function _validate();

	public function __construct(Module $module = null)
	{
		if(!is_null($module))
		{
			$this->_module = $module;
		}

		$this->init();
	}

	public function renderForms($fields_form, $fields_value)
	{
		$helper = new HelperForm();
		$helper->module = $this->_module;
		$helper->name_controller = $this->_module->name;
		$helper->token = $this->_module->token;
		$helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->_module->name;

		$lang = new Language(Configuration::get('PS_LANG_DEFAULT'));
		$helper->default_form_language = $lang->id;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;

		$helper->title = $this->_module->displayName;

		$helper->show_toolbar = false;
		$helper->toolbar_scroll = true;
		$helper->submit_action = 'submit_'.$this->_module->name;

		$context = Context::getContext();
		$helper->tpl_vars = array(
				'fields_value' => $fields_value,
				'languages' => $context->controller->getLanguages(),
				'id_language' => $context->language->id
		);
	  
		return $helper->generateForm($fields_form);
	}

	public function getTitle()
	{
		return $this->l('Configuration', 'moduleconfig');
	}

	public function submitForm()
	{
		return $this->postProces();
	}
	
	/**
	 * @return Module
	 */
	public function getModule()
	{
		return $this->_module;
	}

	protected function l($string, $source = null)
	{
		if(is_object($this->_module))
		{
			if(is_null($source))
			{
				$source = strtolower(get_class($this));
			}
				
			return $this->_module->l($string, $source);
		}

		return $string;
	}
}