<?php
include_once(dirname(__FILE__).'/moduleconfig.php');

class Add_gopay_newPaymentButtons extends Add_gopay_newModuleConfig
{
	public $_M;
	private $currency;
	private $currentUrl;

	public function init()
	{
		if (!Configuration::get(GFIX.'_GATEWAY_MODE'))
			Configuration::updateValue(GFIX.'_BUTTONS_MODE', 1);

		$this->_M = $this->getModule();
		$this->currentUrl = AdminController::$currentIndex.'&configure='.$this->_M->name.'&token='.$this->_M->token.'&idTab=paymentButtons';
		$this->currency = Tools::getValue('_CURRENCY') ? Tools::getValue('_CURRENCY') : Add_gopay_new::$gopayDefaultCurrency;
	}

	public function install()
	{
		Configuration::updateValue(GFIX.'_BUTTONS_MODE', 1);
		Configuration::updateValue(GFIX.'_DISPLAY_IMAGES', 0);
		Configuration::updateValue(GFIX.'_CUSTOM_IMAGES', 0);
		Configuration::updateValue(GFIX.'_DISPLAY_NAMES', 1);
		Configuration::updateValue(GFIX.'_CUSTOM_NAMES', 0);

		$items = array(
			'card-payment' => 'Platba platební kartou je nejpopulárnější platební metodou v prostředí internetu. Nabízíme podporu všech nejrozšířenějších karetních asociací včetně široké podpory doprovodných funkcionalit, jako jsou opakované platby či předautorizace.',
			'bank-transfer' => 'Běžný bankovní převod je stále velmi oblíbenou platební metodou. Díky vlastní GoPay bankovní síti (u vybraných velkých českých bank) vám nabízíme běžný bankovní převod s rychlým potvrzením o provedené platbě (běžně do jedné hodiny). Platbu lze zadat kdykoliv, ale zpracována je v úředních hodinách banky.',
			'wallet' => 'Elektronické peněženky jsou budoucností v placení. Nabízejí výhodnou alternativu k běžným bankovním účtům a jsou využívány zejména pro úhradu nižších a středně vysokých částek. Jedná se o progresivní platební metodu v internetovém prostředí, která umožňuje registrovaným zákazníkům provádět online platby pohodlným a bezpečným způsobem bez nutnosti poskytování osobních a finančních údajů.',
			'others' => 'Vyberte si vhodnou platební metoru z dalších nabízených plateb nabízených platební bránou GoPay'
		);

		foreach ($items as $key => $item)
		{
			Configuration::updateValue(GFIX.'_GROUP_DESC_'.$key.'_cs', $item);
		}

		return true;
	}

	public function uninstall()
	{
		if (Configuration::get(GFIX.'_FORCE_UNINSTALL'))
		{
		}

		Configuration::deleteByName(GFIX.'_BUTTONS_MODE');
		Configuration::deleteByName(GFIX.'_DISPLAY_IMAGES');
		Configuration::deleteByName(GFIX.'_CUSTOM_IMAGES');
		Configuration::deleteByName(GFIX.'_DISPLAY_NAMES');
		Configuration::deleteByName(GFIX.'_CUSTOM_NAMES');

		return true;
	}

	public function getTitle()
	{
		return $this->l('Payments button Settings', 'paymentButtons');
	}

	public function postProces()
	{
		if ($error = $this->_validate())
			return $this->_M->displayError($error);

		if (Tools::isSubmit('submitPaymentSettings'))
		{
			Configuration::updateValue(GFIX.'_BUTTONS_MODE', Tools::getValue('_BUTTONS_MODE'));
			Configuration::updateValue(GFIX.'_DISPLAY_IMAGES', Tools::getValue('_DISPLAY_IMAGES'));
			Configuration::updateValue(GFIX.'_CUSTOM_IMAGES', Tools::getValue('_CUSTOM_IMAGES'));
			Configuration::updateValue(GFIX.'_DISPLAY_NAMES', Tools::getValue('_DISPLAY_NAMES'));
			Configuration::updateValue(GFIX.'_CUSTOM_NAMES', Tools::getValue('_CUSTOM_NAMES'));

			if (Configuration::get(GFIX.'_BUTTONS_MODE') == 1 || Configuration::get(GFIX.'_BUTTONS_MODE') == 3)
			{
				$languages = Language::getLanguages(true);
				foreach (Add_gopay_new::$basePayments as $key => $group)
				{
					Configuration::updateValue(GFIX.'_HIDE_GROUP_'.$key.'_'.$this->currency, Tools::getValue('_HIDE_GROUP_'.$key) ? 0 : 1);
					Configuration::updateValue(GFIX.'_FEE_VALUE_'.$key, Tools::getValue('G_FEE_VALUE_'.$key));
					Configuration::updateValue(GFIX.'_FEE_TYPE_'.$key, Tools::getValue('G_FEE_TYPE_'.$key));
	
					foreach ($languages as $language)
					{
						$lang = $language['id_lang'];
						Configuration::updateValue(GFIX.'_GROUP_NAME_'.$key.'_'.$lang, Tools::getValue('_GROUP_NAME_'.$key.'_'.$lang));
						Configuration::updateValue(GFIX.'_GROUP_DESC_'.$key.'_'.$lang, Tools::getValue('_GROUP_DESC_'.$key.'_'.$lang), true);
					}
				}
			}

			if (Configuration::get(GFIX.'_BUTTONS_MODE') == 2 || Configuration::get(GFIX.'_BUTTONS_MODE') == 3)
			{
				$_PAYMENTS = New_Gopay_RestAPI::enabledPaymentInstruments($this->currency);
				if (isset($_PAYMENTS->enabledPaymentInstruments) && is_array($_PAYMENTS->enabledPaymentInstruments))
				{
					foreach ($_PAYMENTS->enabledPaymentInstruments as $payment)
					{
						$key = $payment->paymentInstrument;
						Configuration::updateValue(GFIX.'_HIDE_PAYMENT_'.$key.'_'.$this->currency, Tools::getValue('_HIDE_PAYMENT_'.$key) ? 0 : 1);
						Configuration::updateValue(GFIX.'_FEE_VALUE_'.$key, Tools::getValue('_FEE_VALUE_'.$key));
						Configuration::updateValue(GFIX.'_FEE_TYPE_'.$key, Tools::getValue('_FEE_TYPE_'.$key));
	
						$languages = Language::getLanguages(true);
						foreach ($languages as $language)
						{
							$lang = $language['id_lang'];
							Configuration::updateValue(GFIX.'_PAYMENT_NAME_'.$key.'_'.$lang, Tools::getValue('_PAYMENT_NAME_'.$key.'_'.$lang));
							Configuration::updateValue(GFIX.'_PAYMENT_DESC_'.$key.'_'.$lang, Tools::getValue('_PAYMENT_DESC_'.$key.'_'.$lang), true);
						}

						if (is_array($payment->enabledSwifts))
						{
							foreach ($payment->enabledSwifts as $swift)
							{
								$key1 = $swift->swift;
								Configuration::updateValue(GFIX.'_HIDE_PAYMENT_'.$key1.'_'.$this->currency, Tools::getValue('_HIDE_PAYMENT_'.$key1) ? 0 : 1);
								Configuration::updateValue(GFIX.'_FEE_VALUE_'.$key1, Tools::getValue('_FEE_VALUE_'.$key1));
								Configuration::updateValue(GFIX.'_FEE_TYPE_'.$key1, Tools::getValue('_FEE_TYPE_'.$key1));
		
								foreach ($languages as $language)
								{
									$lang = $language['id_lang'];
									Configuration::updateValue(GFIX.'_PAYMENT_NAME_'.$key1.'_'.$lang, Tools::getValue('_PAYMENT_NAME_'.$key1.'_'.$lang));
									Configuration::updateValue(GFIX.'_PAYMENT_DESC_'.$key1.'_'.$lang, Tools::getValue('_PAYMENT_DESC_'.$key1.'_'.$lang), true);
								}
							}
						}
					}
				}
			}

			return Tools::redirectAdmin($this->currentUrl.'&conf=6'.'&_CURRENCY='.$this->currency);
		}
		elseif (Tools::getValue('getPaymentsInputs'))
		{

			die(Tools::jsonEncode($this->getPaymentsInputs(Tools::getValue('paymentType'))));
		}
	}

	public function showForm()
	{
		return $this->renderForms($this->getForm(), $this->getConfig());
	}
	
	public function getForm()
	{
		foreach (Add_gopay_new::$gopayCurrencies as $currency)
		{
			$_CURRENCIES[] = array(
				"id" => $currency,
				"name" => $currency
			);
		}

		$fields_form = array(
			$this->_M->name.'-payment' => array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Setting types of payment buttons', 'paymentButtons'),
						'icon' => 'icon-cogs'
					),
					'input' => array(
						array(
							'type' => 'radio',
							'label' => $this->l('Payment buttons', 'paymentButtons'),
							'name' => '_BUTTONS_MODE',
							'desc' => $this->l('The basic version - offers a simplified choice of payment methods. Extended variant - the customer can choose himself from all authorized payment methods.', 'paymentButtons').(!Configuration::get(GFIX.'_GATEWAY_MODE') ? '<br><span style="color:red">'.$this->l('Only basic payment methods are available to test the payment gateway. After you set up your traffic data, all types of payments that you have enabled in the GoPay administration will be available.', 'paymentButtons').'</span>' : ''),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'shortened',
									'value' => 1,
									'label' => $this->l('Shortened version', 'paymentButtons').'<br><img style="margin-top: 8px;" src="../modules/'.$this->_M->name.'/views/images/Shortened.png" alt="" />'
								),
								array(
									'id' => 'extended',
									'value' => 2,
									'label' => $this->l('Extended version', 'paymentButtons').'<br><img style="margin-top: 8px;" src="../modules/'.$this->_M->name.'/views/images/Extended.gif" alt="" />',
									'disabled' => Configuration::get(GFIX.'_GATEWAY_MODE') ? false : true
								),
								array(
									'id' => 'window',
									'value' => 3,
									'label' => $this->l('Window version', 'paymentButtons').'<br><img style="margin-top: 8px;" src="../modules/'.$this->_M->name.'/views/images/Window.gif" alt="" />',
									'disabled' => Configuration::get(GFIX.'_GATEWAY_MODE') ? false : true
								)
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Display logo in payment button', 'paymentButtons'),
							'name' => '_DISPLAY_IMAGES',
							'desc' => '',
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'display_on',
									'value' => 1,
									'label' => $this->l('Yes', 'paymentButtons')
								),
								array(
									'id' => 'display_off',
									'value' => 0,
									'label' => $this->l('No', 'paymentButtons')
								)
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Custom payment button logos', 'paymentButtons'),
							'name' => '_CUSTOM_IMAGES',
							'desc' => $this->l('If enabled logos loaded on payment gateway, else displayed custom logos', 'paymentButtons'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'image_on',
									'value' => 1,
									'label' => $this->l('Yes', 'paymentButtons')
								),
								array(
									'id' => 'image_off',
									'value' => 0,
									'label' => $this->l('No', 'paymentButtons')
								)
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Display payment name in button', 'paymentButtons'),
							'name' => '_DISPLAY_NAMES',
							'desc' => '',
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'names_on',
									'value' => 1,
									'label' => $this->l('Yes', 'paymentButtons')
								),
								array(
									'id' => 'names_off',
									'value' => 0,
									'label' => $this->l('No', 'paymentButtons')
								)
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Custom payment button names', 'paymentButtons'),
							'name' => '_CUSTOM_NAMES',
							'desc' => $this->l('If enabled named loaded on payment gateway (not all languages supported), else displayed custom defined names', 'paymentButtons'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'custom_on',
									'value' => 1,
									'label' => $this->l('Yes', 'paymentButtons')
								),
								array(
									'id' => 'custom_off',
									'value' => 0,
									'label' => $this->l('No', 'paymentButtons')
								)
							)
						),
						array(
							'type' => 'hidden',
							'name' => 'idTab'
						)
					),
					// Submit Button
					'submit' => array(
									'title' => $this->l('Save', 'paymentButtons'),
									'name' => 'submitPaymentSettings',
									'icon' => 'process-icon-save'
					)
				)
			),
			$this->_M->name.'-payment1' => array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Setting payment preference', 'paymentButtons'),
						'icon' => 'icon-cogs'
					),
					'input' => array(
						array(
							'type' => 'textarea',
							'label' => ' ',
							'name' => 'hiddenTextarea',
							'title' => '',
							'form_group_class' => 'hide_mode',
							'autoload_rte' => true
						),
						array(
							'type' => 'select',
							'name' => '_CURRENCY',
							'label' => $this->l('Select currency:', 'paymentButtons'),
							'desc' => $this->l('Payments buttons displayed on this currency', 'paymentButtons'),
							'required' => false,
							'lang' => false,
							'onchange' => 'this.form.submit()',
							'options' => array(
								'query' => $_CURRENCIES,
								'id' => 'id',
								'name' => 'name'
							)
						),
						array(
							'type' => 'html',
							'name' => '',
							'label' => ' ',
							'title' => '',
							'col' => 12,
							'html_content' => '<div id="_DISPLAY_INPUTS">'.$this->getPaymentsInputs(Configuration::get(GFIX.'_BUTTONS_MODE')).'</div>'
						),
						array(
							'type' => 'hidden',
							'name' => 'idTab'
						)
					),
					// Submit Button
					'submit' => array(
									'title' => $this->l('Save', 'paymentButtons'),
									'name' => 'submitPaymentSettings',
									'icon' => 'process-icon-save'
					)
				)
			)
		);

		return $fields_form;
	}

	public function getPaymentsInputs($type)									  
	{
		$response = New_Gopay_RestAPI::enabledPaymentInstruments($this->currency);

		if ($type == 1)
			$inputs = $this->getGroupPayments();
		elseif ($type == 2)
			$inputs = $this->getPaymentInstruments($response, 'instruments');
		elseif ($type == 3)
			$inputs = $this->getPaymentInstruments($response, 'windowed');

		return $inputs;
	}

	private function getConfig()									  
	{
		$fields['idTab'] = 'paymentButtons';
		$fields['hiddenTextarea'] = '';

		$fields['_BUTTONS_MODE'] = Tools::getValue('_BUTTONS_MODE', Configuration::get(GFIX.'_BUTTONS_MODE'));
		$fields['_DISPLAY_IMAGES'] = Tools::getValue('_DISPLAY_IMAGES', Configuration::get(GFIX.'_DISPLAY_IMAGES'));
		$fields['_CUSTOM_IMAGES'] = Tools::getValue('_CUSTOM_IMAGES', Configuration::get(GFIX.'_CUSTOM_IMAGES'));
		$fields['_DISPLAY_NAMES'] = Tools::getValue('_DISPLAY_NAMES', Configuration::get(GFIX.'_DISPLAY_NAMES'));
		$fields['_CUSTOM_NAMES'] = Tools::getValue('_CUSTOM_NAMES', Configuration::get(GFIX.'_CUSTOM_NAMES'));
		$fields['_CURRENCY'] = $this->currency;

		return $fields;
	}

	private function getGroupPayments()									  
	{
		$context = Context::getContext();
		$module_dir = _PS_MODULE_DIR_.$this->_M->name.'/views/templates/classes';
		$tpl_enable = $context->smarty->createTemplate($module_dir.'/_group_payments.tpl');
		$languages = Language::getLanguages(true);
		$currency = Language::getLanguages(true);

		foreach (Add_gopay_new::$basePayments as $key => $group)
		{
			$_FEE_TYPE[$key] = Tools::getValue('G_FEE_TYPE_'.$key, Configuration::get(GFIX.'_FEE_TYPE_'.$key));
			$_FEE_VALUE[$key] = Tools::getValue('G_FEE_VALUE_'.$key, Configuration::get(GFIX.'_FEE_VALUE_'.$key));
			$_HIDE_GROUP[$key] = Tools::getValue('_HIDE_GROUP_'.$key, Configuration::get(GFIX.'_HIDE_GROUP_'.$key.'_'.$this->currency) ? 0 : 1);
			$_PAYMENT_IMAGE[$key] = self::getMediaPath(_PS_MODULE_DIR_.$this->_M->name.'/views/images/payments/'.$key.'.gif');

			foreach ($languages as $language)
			{
				$lang = $language['id_lang'];
				$name = '_GROUP_NAME_'.$key.'_'.$lang;
				$_GROUP_NAME[$key][$lang] = Tools::getValue($name, Configuration::get(GFIX.$name));
				$name = '_GROUP_DESC_'.$key.'_'.$lang;
				$_GROUP_DESC[$key][$lang] = Tools::getValue($name, Configuration::get(GFIX.$name));
			}
		}

		$tpl_enable->assign($this->_getVars());
		$tpl_enable->assign(array(
			'_PAYMENTS'			 => Add_gopay_new::$basePayments,
			'_FEE_TYPE'			 => $_FEE_TYPE,
			'_FEE_VALUE'		 => $_FEE_VALUE,
			'_GROUP_NAME'		 => $_GROUP_NAME,
			'_GROUP_DESC'		 => $_GROUP_DESC,
			'_PAYMENT_IMAGE'	 => $_PAYMENT_IMAGE,
			'_HIDE_GROUP'		 => $_HIDE_GROUP
		));

		return $tpl_enable->fetch();
	}

	private function getPaymentInstruments($_PAYMENTS, $type)									  
	{
		$context = Context::getContext();
		$module_dir = _PS_MODULE_DIR_.$this->_M->name.'/views/templates/classes';
		$tpl_enable = $context->smarty->createTemplate($module_dir.'/_payment_'.$type.'.tpl');

		if (!isset($_PAYMENTS->enabledPaymentInstruments)
			|| !is_array($_PAYMENTS->enabledPaymentInstruments)
			|| !Configuration::get(GFIX.'_GATEWAY_MODE')
		  )
			return false;

		/*echo $currency.'<pre>';
		print_r($payments);
		echo '</pre>';exit;*/
		$_PAYMENT_NAME = array();
		$_PAYMENT_DESC = array();
		$_PAYMENT_IMAGE = array();
		$_HIDE_GROUP['ACCOUNT'] = Tools::getValue('_HIDE_GROUP_ACCOUNT', Configuration::get(GFIX.'_HIDE_GROUP_ACCOUNT') ? 0 : 1);

		foreach ($_PAYMENTS->enabledPaymentInstruments as $payment)
		{
			$key = $payment->paymentInstrument;
			$_PAYMENT_IMAGE[$key] = $payment->image->normal;
			$_FEE_TYPE[$key] = Tools::getValue('_FEE_TYPE_'.$key, Configuration::get(GFIX.'_FEE_TYPE_'.$key));
			$_FEE_VALUE[$key] = Tools::getValue('_FEE_VALUE_'.$key, Configuration::get(GFIX.'_FEE_VALUE_'.$key));
			$_HIDE_PAYMENT[$key] = Tools::getValue('_HIDE_PAYMENT_'.$key, Configuration::get(GFIX.'_HIDE_PAYMENT_'.$key.'_'.$this->currency) ? 0 : 1);

			if (Configuration::get(GFIX.'_CUSTOM_IMAGES'))
				$_PAYMENT_IMAGE[$key] = self::getMediaPath(_PS_MODULE_DIR_.$this->_M->name.'/views/images/payments/'.$key.'.gif');

			$languages = Language::getLanguages(true);
			foreach ($languages as $language)
			{
				$lang = $language['id_lang'];
				$name = '_PAYMENT_NAME_'.$key.'_'.$lang;
				$_PAYMENT_NAME[$key][$lang] = Tools::getValue($name, Configuration::get(GFIX.$name));
				$name = '_PAYMENT_DESC_'.$key.'_'.$lang;
				$_PAYMENT_DESC[$key][$lang] = Tools::getValue($name, Configuration::get(GFIX.$name));
			}
	
			if (is_array($payment->enabledSwifts))
			{
				foreach ($payment->enabledSwifts as $swift)
				{
					$key1 = $swift->swift;
					$_PAYMENT_IMAGE[$key1] = $swift->image->normal;
					$_FEE_TYPE[$key1] = Tools::getValue('_FEE_TYPE_'.$key1, Configuration::get(GFIX.'_FEE_TYPE_'.$key1));
					$_FEE_VALUE[$key1] = Tools::getValue('_FEE_VALUE_'.$key1, Configuration::get(GFIX.'_FEE_VALUE_'.$key1));
					$_HIDE_PAYMENT[$key1] = Tools::getValue('_HIDE_PAYMENT_'.$key1, Configuration::get(GFIX.'_HIDE_PAYMENT_'.$key1.'_'.$this->currency) ? 0 : 1);
	
					if (Configuration::get(GFIX.'_CUSTOM_IMAGES'))
						$_PAYMENT_IMAGE[$key1] = self::getMediaPath(_PS_MODULE_DIR_.$this->_M->name.'/views/images/payments/'.$key1.'.gif');

					$languages = Language::getLanguages(true);
					foreach ($languages as $language)
					{
						$lang = $language['id_lang'];
						$name = '_PAYMENT_NAME_'.$key1.'_'.$lang;
						$_PAYMENT_NAME[$key1][$lang] = Tools::getValue($name, Configuration::get(GFIX.$name));
						$name = '_PAYMENT_DESC_'.$key1.'_'.$lang;
						$_PAYMENT_DESC[$key1][$lang] = Tools::getValue($name, Configuration::get(GFIX.$name));
					}
				}
			}
		}

		$tpl_enable->assign($this->_getVars());
		$tpl_enable->assign(array(
			'_PAYMENTS'			 => $_PAYMENTS,
			'_FEE_TYPE'			 => $_FEE_TYPE,
			'_FEE_VALUE'		 => $_FEE_VALUE,
			'_PAYMENT_NAME'		 => $_PAYMENT_NAME,
			'_PAYMENT_DESC'		 => $_PAYMENT_DESC,
			'_PAYMENT_IMAGE'	 => $_PAYMENT_IMAGE,
			'_HIDE_GROUP'		 => $_HIDE_GROUP,
			'_HIDE_PAYMENT'		 => $_HIDE_PAYMENT
		));

		return $tpl_enable->fetch();
	}

	private function _getVars()
	{
		$context = Context::getContext();

		return array(
			'_PRICE_VIEW'		 => Configuration::get(GFIX.'_PRICE_VIEW'),
			'_CUSTOM_NAMES'		 => Configuration::get(GFIX.'_CUSTOM_NAMES'),
			'_CUSTOM_IMAGES'	 => Configuration::get(GFIX.'_CUSTOM_IMAGES'),
			'_DISPLAY_IMAGES'	 => Configuration::get(GFIX.'_DISPLAY_IMAGES'),
			'_PRICE_DIFFERENT'	 => Configuration::get(GFIX.'_PRICE_DIFFERENT'),
			'default_currency'	 => new Currency(Configuration::get('PS_CURRENCY_DEFAULT')),
			'gopayDefaultLang'	 => strtolower(Add_gopay_new::$gopayDefaultLang),
			'admin_module_dir'	 => $this->currentUrl,
			'languages'			 => $context->language->getLanguages(),
			'defaultFormLanguage' => $context->language->id
		);
	}

	public static function getMediaPath($media_uri, $css_media_type = null)
	{
		if (is_array($media_uri) || $media_uri === null || empty($media_uri)) {
			return false;
		}

		$url_data = parse_url($media_uri);
		if (!is_array($url_data)) {
			return false;
		}

		if (!array_key_exists('host', $url_data)) {
			$media_uri_host_mode = '/'.ltrim(str_replace(str_replace(array('/', '\\'), DIRECTORY_SEPARATOR, _PS_CORE_DIR_), __PS_BASE_URI__, $media_uri), '/\\');
			$media_uri = '/'.ltrim(str_replace(str_replace(array('/', '\\'), DIRECTORY_SEPARATOR, _PS_ROOT_DIR_), __PS_BASE_URI__, $media_uri), '/\\');
			// remove PS_BASE_URI on _PS_ROOT_DIR_ for the following
			$file_uri = _PS_ROOT_DIR_.Tools::str_replace_once(__PS_BASE_URI__, DIRECTORY_SEPARATOR, $media_uri);
			$file_uri_host_mode = _PS_CORE_DIR_.Tools::str_replace_once(__PS_BASE_URI__, DIRECTORY_SEPARATOR, Tools::str_replace_once(_PS_CORE_DIR_, '', $media_uri));

			if (!@filemtime($file_uri) || @filesize($file_uri) === 0) {
				if (!defined('_PS_HOST_MODE_')) {
					return false;
				} elseif (!@filemtime($file_uri_host_mode) || @filesize($file_uri_host_mode) === 0) {
					return false;
				} else {
					$media_uri = $media_uri_host_mode;
				}
			}

			$media_uri = str_replace('//', '/', $media_uri);
		}

		if ($css_media_type) {
			return array($media_uri => $css_media_type);
		}

		return $media_uri;
	}

	protected function _validate()
	{
		$condition = array();
		if (Tools::isSubmit('submitPaymentSettings'))
		{
		}

		if (count($condition) > 0)
			return implode('<br>', $condition);

		return false;
	}
}
