<?php
include_once(dirname(__FILE__).'/moduleconfig.php');

class Add_gopay_newRegister extends Add_gopay_newModuleConfig
{
	private $_M;

	public function init()
	{
		$this->_M = $this->getModule();
	}

	public function getTitle()
	{
		return $this->l('License and Installation', 'register');
	}

	public function install()
	{
		return true;
	}

	public function uninstall()
	{
		return true;
	}

	public function postProces()
	{
		/*  načítá se v registrační části   */
	}

	public function showForm()
	{
		return $this->renderForms(array($this->getForm()), $this->getConfig());
	}

	private function getForm()
	{
		$fields_form = array(
				'form' => array(
 					'legend' => array(
						'title' => $this->l('Register this module', 'register'),
						'icon' => 'icon-shopping-cart'
					),
					'input' => array(
								array(
									'type' => 'hidden',
									'name' => 'idTab'
								),
								array(
									'type' => 'text',
									'label' => $this->l('License number', 'register'),
									'desc' => $this->l('Discover the latest updates and news about this module, free and easy registering from this short form.', 'register'),
									'class' => 'fixed-width-xxl',
									'name' => '_REGISTER'
								),
            		),
					'submit' => array(
									'title' => $this->l('Validate', 'register'),
									'name' => 'submitRegister',
					)
			),
		);

		return $fields_form;
	}

	private function getConfig()                                          
	{
		return array(
			'_REGISTER' => Tools::getValue('_REGISTER', Configuration::get(GFIX.'_REGISTER')),
			'idTab' => 'register'
		);
	}

	protected function _validate()
	{
	}
}
