<?php
include_once(dirname(__FILE__).'/moduleconfig.php');

class Add_gopay_newSurcharges extends Add_gopay_newModuleConfig
{
	public $_M;
	private $currentUrl;

	public function init()
	{
		$this->_M = $this->getModule();
		$this->currentUrl = AdminController::$currentIndex.'&configure='.$this->_M->name.'&token='.$this->_M->token.'&idTab=surcharges';
	}

	public function install()
	{
		Configuration::updateValue(GFIX.'_ALLOWED_MIN_PRICE', Tools::getValue('_ALLOWED_MIN_PRICE'));
		Configuration::updateValue(GFIX.'_PRICE_VIEW', Tools::getValue('_PRICE_VIEW'));
		Configuration::updateValue(GFIX.'_PRICE_DIFFERENT', Tools::getValue('_PRICE_DIFFERENT'));
		Configuration::updateValue(GFIX.'_FEE_TYPE_', Tools::getValue('_FEE_TYPE_'));
		Configuration::updateValue(GFIX.'_FEE_VALUE_', Tools::getValue('_FEE_VALUE_'));

		return true;
	}

	public function uninstall()
	{
		if (Configuration::get(GFIX.'_FORCE_UNINSTALL'))
		{
		}

		Configuration::deleteByName(GFIX.'_ALLOWED_MIN_PRICE');
		Configuration::deleteByName(GFIX.'_PRICE_VIEW');
		Configuration::deleteByName(GFIX.'_PRICE_DIFFERENT');
		Configuration::deleteByName(GFIX.'_FEE_TYPE_');
		Configuration::deleteByName(GFIX.'_FEE_VALUE_');

		return true;
	}

	public function getTitle()
	{
		return $this->l('Surcharges Settings', 'surcharges');
	}

	public function postProces()
	{
		if ($error = $this->_validate())
			return $this->_M->displayError($error);

		if (Tools::isSubmit('submitSurchargesSettings'))
		{
			Configuration::updateValue(GFIX.'_ALLOWED_MIN_PRICE', Tools::getValue('_ALLOWED_MIN_PRICE'));
			Configuration::updateValue(GFIX.'_PRICE_VIEW', Tools::getValue('_PRICE_VIEW'));
			Configuration::updateValue(GFIX.'_PRICE_DIFFERENT', Tools::getValue('_PRICE_DIFFERENT'));
			Configuration::updateValue(GFIX.'_FEE_TYPE_', Tools::getValue('_FEE_TYPE_'));
			Configuration::updateValue(GFIX.'_FEE_VALUE_', Tools::getValue('_FEE_VALUE_'));

			return Tools::redirectAdmin($this->currentUrl.'&conf=6');
		}
	}

	public function showForm()
	{
		return $this->renderForms($this->getForm(), $this->getConfig());
	}
	
	public function getForm()
	{
		$currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));

		$fields_form = array(
			$this->_M->name.'-surcharges' => array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Price rules', 'surcharges'),
						'icon' => 'icon-money'
					),
					'input' => array(
						array(
							'type' => 'text',
							'name' => '_ALLOWED_MIN_PRICE',
							'label' => $this->l('Min. price in order payment by GoPay:', 'surcharges'),
							'suffix' => $currency->sign,
							'desc' => $this->l('Minimum order amount without transport rates, since that will display the payment method GoPay(no limit with 0).', 'surcharges'),
							'class' => 'col-lg-2',
							'maxlength' => 6,
							'required' => false,
							'lang' => false,
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Enable fee', 'surcharges'),
							'name' => '_PRICE_VIEW',
							'desc' => $this->l('.', 'surcharges'),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'view_on',
									'value' => 1,
									'label' => $this->l('Yes', 'surcharges')
								),
								array(
									'id' => 'view_off',
									'value' => 0,
									'label' => $this->l('No', 'surcharges')
								)
							)
						),
						array(
							'type' => 'switch',
							'label' => $this->l('Different for each type of payment buttons', 'surcharges'),
							'name' => '_PRICE_DIFFERENT',
							'desc' => $this->l('The values ​​set in the tab Payment Methods.', 'surcharges'),
							'form_group_class' => '_PRICE_VIEW '.(!Configuration::get(GFIX.'_PRICE_VIEW') ? 'hide_mode' : ''),
							'required' => false,
							'is_bool' => true,
							'values' => array(
								array(
									'id' => 'different_on',
									'value' => 1,
									'label' => $this->l('Yes', 'surcharges')
								),
								array(
									'id' => 'different_off',
									'value' => 0,
									'label' => $this->l('No', 'surcharges')
								)
							)
						),
						array(
							'type' => 'select',
							'name' => '_FEE_TYPE_',
							'label' => $this->l('Type of fee:', 'surcharges'),
							'required' => false,
							'disabled' => Configuration::get(GFIX.'_PRICE_DIFFERENT') ? true : false,
							'form_group_class' => '_PRICE_VIEW '.(!Configuration::get(GFIX.'_PRICE_VIEW') ? 'hide_mode' : ''),
							'lang' => false,
							'options' => array(
								'query' => array(
									array(
										'id' => '1',
										'name' => $this->l('Percent', 'surcharges')
									),
									array(
										'id' => '0',
										'name' => $this->l('Amount', 'surcharges')
									)
								),
								'id' => 'id',
								'name' => 'name'
							)
						),
						array(
							'type' => 'text',
							'name' => '_FEE_VALUE_',
							'label' => $this->l('Fee value:', 'surcharges'),
							'suffix' => $currency->sign.' / %',
							'desc' => $this->l('Value or percentage amount of the premium payment method for GoPay.', 'surcharges').'<br>'.$this->l('If you choose the different values ​​of these can be set in the menu Settings payment buttons.', 'surcharges'),
							'class' => 'col-lg-2',
							'maxlength' => 6,
							'required' => false,
							'disabled' => Configuration::get(GFIX.'_PRICE_DIFFERENT') ? true : false,
							'form_group_class' => '_PRICE_VIEW '.(!Configuration::get(GFIX.'_PRICE_VIEW') ? 'hide_mode' : ''),
							'lang' => false,
						),
						array(
							'type' => 'html',
							'name' => '',
							'label' => ' ',
							'title' => '',
							'col' => 12,
							'form_group_class' => '_PRICE_VIEW '.(!Configuration::get(GFIX.'_PRICE_VIEW') ? 'hide_mode' : ''),
							'html_content' => '<div class="alert alert-onboarding">'.$this->l('The tax rate will be calculated according to the selected carrier since the surcharge added to the cost of transport.', 'surcharges').'</div>'
						),
						array(
							'type' => 'hidden',
							'name' => 'idTab'
						)
					),
					// Submit Button
					'submit' => array(
									'title' => $this->l('Save', 'surcharges'),
									'name' => 'submitSurchargesSettings',
									'icon' => 'process-icon-save'
					)
				)
			)
		);

		return $fields_form;
	}

	private function getConfig()									  
	{
		$fields['idTab'] = 'surcharges';

		$fields['_ALLOWED_MIN_PRICE'] = Tools::getValue('_ALLOWED_MIN_PRICE', Configuration::get(GFIX.'_ALLOWED_MIN_PRICE'));
		$fields['_PRICE_VIEW'] = Tools::getValue('_PRICE_VIEW', Configuration::get(GFIX.'_PRICE_VIEW'));
		$fields['_PRICE_DIFFERENT'] = Tools::getValue('_PRICE_DIFFERENT', Configuration::get(GFIX.'_PRICE_DIFFERENT'));
		$fields['_FEE_TYPE_'] = Tools::getValue('_FEE_TYPE_', Configuration::get(GFIX.'_FEE_TYPE_'));
		$fields['_FEE_VALUE_'] = Tools::getValue('_FEE_VALUE_', Configuration::get(GFIX.'_FEE_VALUE_'));

		return $fields;
	}

	protected function _validate()
	{
		$condition = array();
		if (Tools::isSubmit('submitSurchargesSettings'))
		{
		}

		if (count($condition) > 0)
			return implode('<br>', $condition);
	}
}
