<?php
class Add_Gopay_newPayInCartModuleFrontController extends ModuleFrontController
{
	public function postProcess()
	{
		$payment_status = New_Gopay_RestAPI::checkPaymentStatus((int)Tools::getValue('id'));

			if (!empty($payment_status->errors)
			|| (!empty($payment_status->state) && $payment_status->state != 'PAID')
			|| !Tools::getValue('payInCart')
		)
			Tools::redirectLink(__PS_BASE_URI__.'order.php?step=1');

		$cart = new Cart($payment_status->order_number);
		if (!Validate::isLoadedObject($cart))
			Tools::redirectLink(__PS_BASE_URI__.'order.php?step=1');

		if ($cart->OrderExists() == false)
		{
			$customer = new Customer($cart->id_customer);
			if (!Validate::isLoadedObject($customer))
				Tools::redirectLink(__PS_BASE_URI__.'order.php?step=1');

			$extra_vars = array();
			if (isset($payment_status->additional_params))
				foreach ($payment_status->additional_params as $param)
					$extra_vars = array_merge($extra_vars, array(
						$param->name => $param->value
					));

			// castka predavana validateOrder
			$total = $cart->getOrderTotal(true, Cart::BOTH);

			// vytvoreni a nacteni nove objednavky
			$this->module->validateOrder($cart->id, _PS_OS_PAYMENT_, $total, $this->module->displayName, NULL, $extra_vars, $cart->id_currency, false, $cart->secure_key, NULL);

			Tools::redirect('index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$this->module->currentOrder.'&key='.$customer->secure_key.'&id='.$payment_status->id);
		} else
		{
			if ($current_order_state->id == _PS_OS_CANCELED_
				|| $current_order_state->id == _PS_OS_PAYMENT_
				|| $current_order_state->id == _PAYMENT_CREATED_
				|| $order->hasBeenPaid()
				|| $order->hasBeenShipped()
			)
				return;
			else
			{
				$sessionState = $payment_status->state;
				$sessionSubState = isset($payment_status->sub_state) ? $payment_status->sub_state : '';

				$paymentMessage = New_GoPay_Helper::getResultMessage($sessionState, $sessionSubState);
				if(!$paymentMessage)
					return New_GoPay_Tools::getErrors('', '', $GoPay->FAILED_MESSAGE, '');

				if ($sessionState == New_GoPay_Helper::PAID)
				{
					if (isset($payment_status->recurrence))
					{
						$templateVars = array(
								'{recurrence_period}' => $GoPay->mailRepeated_1.$payment_status->recurrence->recurrence_period.' '.$payment_status->recurrence->recurrence_cycle,
								'{recurrence_date_to}' => $GoPay->mailRepeated_2.$payment_status->recurrence->recurrence_date_to
						);
					}
					/* Zaplacena */
					if ($current_order_state->id != _PS_OS_PAYMENT_)
						$this->updateStatus(_PS_OS_PAYMENT_, $order, $templateVars);

					/*$orderPayment->transaction_id = $session['id_session'];
					$orderPayment->update();*/

				}
			}
			
		}
	}
}
