<?php
/* ########################################################################### */
/*                                                                             */
/*                      Copyright 2014     Miloslav Kubín                      */
/*                        http://presta-modul.shopmk.cz                        */
/*                                                                             */
/*             Please do not change this text, remove the link,                */
/*          or remove all or any part of the creator copyright notice          */
/*                                                                             */
/*    Please also note that although you are allowed to make modifications     */
/*     for your own personal use, you may not distribute the original or       */
/*                 the modified code without permission.                       */
/*                                                                             */
/*                    SELLING AND REDISTRIBUTION IS FORBIDDEN!                 */
/*             Download is allowed only from presta-modul.shopmk.cz            */
/*                                                                             */
/*       This software is provided as is, without warranty of any kind.        */
/*           The author shall not be liable for damages of any kind.           */
/*               Use of this software indicates that you agree.                */
/*                                                                             */
/*                                    ***                                      */
/*                                                                             */
/*              Prosím, neměňte tento text, nemazejte odkazy,                  */
/*      neodstraňujte části a nebo celé oznámení těchto autorských práv        */
/*                                                                             */
/*     Prosím vezměte také na vědomí, že i když máte možnost provádět změny    */
/*        pro vlastní osobní potřebu,nesmíte distribuovat původní nebo         */
/*                        upravený kód bez povolení.                           */
/*                                                                             */
/*                   PRODEJ A DISTRIBUCE JE ZAKÁZÁNA!                          */
/*          Download je povolen pouze z presta-modul.shopmk.cz                 */
/*                                                                             */
/*   Tento software je poskytován tak, jak je, bez záruky jakéhokoli druhu.    */
/*          Autor nenese odpovědnost za škody jakéhokoliv druhu.               */
/*                  Používáním tohoto softwaru znamená,                        */
/*           že souhlasíte s výše uvedenými autorskými právy .                 */
/*                                                                             */
/* ########################################################################### */
class Add_Gopay_NewRepeatPaymentModuleFrontController extends ModuleFrontController
{
	public $ssl = true;
	public $paymentErrors = false;
	public $display_column_left = false;
	public $display_column_right = false;

	public function postProcess()
	{
		$inlineMode = !Tools::getValue('repeatInMail') && Configuration::get(GFIX.'_INLINE_MODE');

		if ($inlineMode)
			@ini_set('display_errors', 'off');

		if (!_PAYMENT_NEW_)
			die($this->module->configurationFailed);

		if (Tools::getValue('orderId') || Tools::getValue('reference'))
		{
			if ($id_order = Add_gopay_new::getOrderByReference(Tools::getValue('reference')))
				$order = new Order($id_order);
			else
				$order = new Order(Tools::getValue('orderId'));

			if (!Validate::isLoadedObject($order) || $order->current_state == _PS_OS_CANCELED_ || $order->current_state == _PS_OS_PAYMENT_)
			{
				if ($inlineMode)
					die(Tools::jsonEncode(array('errors' => $this->module->OrderPaymentClosed)));
				else
					die($this->module->OrderPaymentClosed);
			} else
			{
				$customer = new Customer($order->id_customer);
				$id = $order->id;
				$params = array(
					'key' => $customer->secure_key,
					'id_cart' => $order->id_cart,
					'id_module' => $this->module->id,
					'id_order' => $order->id
				);

				$returnuURL = $this->context->link->getPageLink('order-confirmation', true, $order->id_lang, $params);

				$create_payment = New_Gopay_RestAPI::createPayment(
											$id,
											Tools::getValue('paymentChannel'),
											Tools::getValue('paymentSwift'),
											$returnuURL,
											$order->total_paid,
											NULL,
											FALSE,
											(Tools::getValue('debug') ? TRUE : false)
				);

				if (empty($create_payment->errors))
				{

					ob_start();
					$history = new OrderHistory();
					$history->id_order = $order->id;
					if ($order->current_state != _PAYMENT_NEW_)
					{
						$history->changeIdOrderState(_PAYMENT_NEW_, $order->id);
						$history->addWithemail();
					}

					ob_clean();
					$order_payment = new New_Gopay_Order((int)$order->id);
					$order_payment->id_session = $create_payment->id;
					$order_payment->currency = $order->id_currency;
					$order_payment->total_paid = (float)$order->total_paid;
					$order_payment->update_date = pSQL(date('Y-m-d H:i:s'));
					$order_payment->payment_status = 'NEW';

					if (!$order_payment->update())
						$this->paymentErrors = array('logs' => $GoPay->errorUpdateOrder);
					else
					{
						if ($inlineMode)
							die(Tools::jsonEncode(array('url' => $create_payment->gw_url)));	
						else
							Tools::redirectLink($create_payment->gw_url);
					}
				} else
				{
					/* načíst vstupní data pro debug chyby */
					$create_payment->errors[0]->inputs = New_Gopay_RestAPI::createPayment(
											$id,
											Tools::getValue('paymentChannel'),
											Tools::getValue('paymentSwift'),
											$returnuURL,
											$order->total_paid,
											NULL,
											FALSE,
											TRUE
					);

					$paymentErrors = $this->module->getAPIErrors($this->module->l('Order: ').$order->id, $create_payment);

					if ($inlineMode)
						die(Tools::jsonEncode(array('errors' => $paymentErrors['orders'].$paymentErrors['logs'])));	
					else
						$this->paymentErrors = $paymentErrors;
				}
			}
		} else
		{
			if ($inlineMode)
				die(Tools::jsonEncode(array('errors' => $this->module->notOrderId)));	
			else
				$this->paymentErrors = array('logs' => $this->module->notOrderId);
		}
	}

	/**
	 * @see FrontController::initContent()
	 */
	public function initContent()
	{
		parent::initContent();

		if (!empty($this->paymentErrors))
		{
			$this->context->smarty->assign(array(
				'errorsAPI' => $this->paymentErrors
			));

			if (version_compare(_PS_VERSION_, '1.7', '>=') === true)
				$this->setTemplate('module:add_gopay_new/views/templates/front/errorPS7.tpl');
			else
				$this->setTemplate('error.tpl');
		}
	}
}