<?php
class Add_gopay_newValidationModuleFrontController extends ModuleFrontController
{
	public $ssl = true;
	public $paymentErrors = false;
	public $display_column_left = false;
	public $display_column_right = false;

	public function postProcess()
	{
		if (Configuration::get(GFIX.'_INLINE_MODE'))
			@ini_set('display_errors', 'off');
/*
Configuration::updateValue('GPY_NEW', 34);
Configuration::updateValue('GPY_CREATED', 35);
Configuration::updateValue('GPY_TIMEOUTED', 36);
Configuration::updateValue('GPY_PAYMENT_METHOD_CHOSEN', 37);
Configuration::updateValue('GPY_CANCELED', 38);
Configuration::updateValue('GPY_AUTHORIZED', 39);
Configuration::updateValue('GPY_REFUNDED', 40);
Configuration::updateValue('GPY_PARTIALLY_REFUNDED', 41);
echo Configuration::get('GPY_NEW');
echo Configuration::get('GPY_CREATED');
echo Configuration::get('GPY_TIMEOUTED');
echo Configuration::get('GPY_PAYMENT_METHOD_CHOSEN');
echo Configuration::get('GPY_CANCELED');
echo Configuration::get('GPY_AUTHORIZED');
echo Configuration::get('GPY_REFUNDED');
echo Configuration::get('GPY_PARTIALLY_REFUNDED');
*/

		if (!_PAYMENT_NEW_)
			die($this->module->configurationFailed);

		$cart = $this->context->cart;
		$customer = new Customer($cart->id_customer);
		$currency = new Currency($cart->id_currency);

		if ($cart->id_customer == 0
			|| $cart->id_address_delivery == 0
			|| $cart->id_address_invoice == 0
			|| !$this->module->active
			|| !$this->module->checkCurrency($cart)
			|| !Validate::isLoadedObject($customer)
		  )
			Tools::redirectLink(__PS_BASE_URI__.'order.php?step=1');

		$authorized = false;
		foreach (Module::getPaymentModules() as $module)
			if ($module['name'] == 'add_gopay_new')
			{
				$authorized = true;
				break;
			}

		if (!$authorized)
            die($this->module->l('This payment method is not available.', 'validation'));

		if (!filter_var($customer->email, FILTER_VALIDATE_EMAIL))
			die($this->module->emailIncorrect.' '.$customer->email);


		if (Tools::getValue('confirm_gopay') || Configuration::get(GFIX.'_SKIP_STEP')|| version_compare(_PS_VERSION_, '1.7', '>=') === true)
		{
			if (in_array(strtoupper($currency->iso_code), Add_gopay_new::$gopayCurrencies))
			{
				$selectedPayment = Tools::getValue('paymentChannel');
				if (Tools::getValue('paymentSwift'))
					$selectedPayment = Tools::getValue('paymentSwift');

				$total = $cart->getOrderTotal(true, Cart::BOTH);

ob_start();
				/* vytvořit nejdříve objednávku */
				if(!Configuration::get(GFIX.'_ORDER_MODE'))
				{
					$extra_vars = array(
							'selectedPayment' => $selectedPayment
					);

					// vytvoreni a nacteni nove objednavky
					$this->module->validateOrder($cart->id, _PAYMENT_NEW_, $total, $this->module->displayName, NULL, $extra_vars, $cart->id_currency, false, $cart->secure_key, NULL);

					$order = new Order((int)$this->module->currentOrder);

					$total_paid = $order->total_paid;
					$id = $order->id;
					$params = array(
						'key' => $customer->secure_key,
						'id_cart' => $cart->id,
						'id_module' => $this->module->id,
						'id_order' => $order->id
					);

					$returnuURL = $this->context->link->getPageLink('order-confirmation', true, $cart->id_lang, $params);
					$additional_params = '';
				}
				/* nejdříve provést platbu až poté vytvořit objednávku */
				else
				{
					$id = $cart->id;
					$feeWithTax = $this->module->getCost($cart, $selectedPayment, true);
					$total_paid = (float)Tools::ps_round((float)$cart->getOrderTotal(true, Cart::BOTH)+$feeWithTax, 2);
					$returnuURL = $this->context->link->getModuleLink($this->module->name, 'payInCart', array('payInCart' => 1));
					$additional_params = array(
							array('name' => 'selectedPayment', 'value' => $selectedPayment)
					);
				}
				// vytvorit platbu dle parametru
				$create_payment = New_Gopay_RestAPI::createPayment(
												$id,
												Tools::getValue('paymentChannel'),
												Tools::getValue('paymentSwift'),
												$returnuURL,
												$total_paid,
												$additional_params,
												true
				);
ob_clean();

				if (empty($create_payment->errors))
				{
					$order_payment = new New_Gopay_Order();
					$order_payment->id_order = (int)$this->module->currentOrder;
					$order_payment->id_cart = $cart->id;
					$order_payment->id_session = $create_payment->id;
					$order_payment->currency = $cart->id_currency;
					$order_payment->total_paid = (float)$total;
					$order_payment->recurrent = (int)Configuration::get(GFIX.'_RECURRENT');
					$order_payment->preauthorized = (int)Configuration::get(GFIX.'_PREAUTHORIZED');
					$order_payment->payment_date = pSQL(date('Y-m-d H:i:s'));
					$order_payment->update_date = '0000-00-00 00:00:00';
					$order_payment->payment_status = 'NEW';

					if (!$order_payment->save())
						$this->paymentErrors = array('logs' => $this->module->errorSaveOrder);
					else
					{
						if (Configuration::get(GFIX.'_INLINE_MODE'))
							die(Tools::jsonEncode(array('url' => $create_payment->gw_url)));
						else
							Tools::redirectLink($create_payment->gw_url);
					}
				} else
				{
					/* načíst vstupní data pro debug chyby */
					$create_payment->errors[0]->inputs = New_Gopay_RestAPI::createPayment(
											$id,
											Tools::getValue('paymentChannel'),
											Tools::getValue('paymentSwift'),
											$returnuURL,
											$total_paid,
											NULL,
											FALSE,
											TRUE
					);
	
					if(!Configuration::get(GFIX.'_ORDER_MODE'))
						$paymentErrors	 = $this->module->getAPIErrors($this->module->l('Order: ').$order->id, $create_payment);
					else
						$paymentErrors	 = $this->module->getAPIErrors($this->module->l('Cart: ').$cart->id, $create_payment);

					$order_payment = new New_Gopay_Order();
					$order_payment->id_order = (int)$this->module->currentOrder;
					$order_payment->id_cart = $cart->id;
					$order_payment->id_session = 'ERROR';
					$order_payment->currency = $cart->id_currency;
					$order_payment->total_paid = (float)$total;
					$order_payment->recurrent = (int)Configuration::get(GFIX.'_RECURRENT');
					$order_payment->preauthorized = (int)Configuration::get(GFIX.'_PREAUTHORIZED');
					$order_payment->payment_date = pSQL(date('Y-m-d H:i:s'));
					$order_payment->update_date = '0000-00-00 00:00:00';
					$order_payment->payment_status = 'ERROR';

					if (!$order_payment->save())
						$this->paymentErrors = array('logs' => $this->module->errorSaveOrder);

					if (Configuration::get(GFIX.'_INLINE_MODE'))
						die(Tools::jsonEncode(array('errors' => $paymentErrors['orders'].$paymentErrors['logs'])));
					else
						$this->paymentErrors = $paymentErrors;
				}
			} else
			{
				if (Configuration::get(GFIX.'_INLINE_MODE'))
					die(Tools::jsonEncode(array('errors' => $this->module->notAllowedCurrency.' '.$currency->iso_code)));
				else
					$this->paymentErrors = array('logs' => $this->module->notAllowedCurrency.' '.$currency->iso_code);
			}
		}
	}

	/**
	 * @see FrontController::initContent()
	 */
	public function initContent()
	{
		parent::initContent();
		if (!empty($this->paymentErrors))
		{
			$this->context->smarty->assign(array(
				'errorsAPI' => $this->paymentErrors
			));

			if (version_compare(_PS_VERSION_, '1.7', '>=') === true)
				$this->setTemplate('module:add_gopay_new/views/templates/front/errorPS7.tpl');
			else
				$this->setTemplate('error.tpl');
		} else
		{
			$warning = '';
			$cart = $this->context->cart;
			$currency = new Currency($cart->id_currency);

			$selectedPayment = Tools::getValue('paymentChannel');
			if (Tools::getValue('paymentSwift'))
				$selectedPayment = Tools::getValue('paymentSwift');

			if (!Configuration::get(GFIX.'_GATEWAY_MODE'))
			{
				$warning = $this->module->displayError($this->module->l('Payment gateway is running in test mode , orders will not actually been paid.'));
				foreach (Add_gopay_new::$basePayments as $key => $name)
				{
					if ($key == $selectedPayment)
						$payment_options = array(
										'code'	 => $key,
										'title'	 => $name,
										'desc'	 => $this->module->l('Test payment, money not send'),
										'price_wt' => $this->module->getCost($cart, $key),
										'price'	 => $this->module->getCost($cart, $key, false),
										'logo'	 => $this->module->getImage($key),
										'id_lang' => $cart->id_lang
						);
				}
			} else
				$payment_options = $this->module->getPaymentDetails($cart, $selectedPayment);

			$params = array(
				'paymentChannel' => Tools::getValue('paymentChannel'),
				'paymentSwift' => Tools::getValue('paymentSwift'),
				'confirm_gopay' => 1
			);

			$this->context->smarty->assign(array(
				'warning'			 => $warning,
				'payment'			 => $payment_options,
				'address_delivery'	 => new Address(intval($cart->id_address_delivery)),
				'address_invoice'	 => new Address(intval($cart->id_address_invoice)),
				'carrier'			 => new Carrier((int)$cart->id_carrier, (int)$cart->id_lang),
				'payment_url'		 => Context::getContext()->link->getModuleLink($this->module->name, 'validation', $params, true),
				'nbProducts'		 => $cart->nbProducts(),
				'products'			 => $cart->getProducts(),
				'cart_sumary'		 => $cart->getSummaryDetails(),
				'customizedDatas'	 => Product::getAllCustomizedDatas(intval($cart->id)),
				'currency'			 => $currency
			));

			$this->setTemplate('validation.tpl');
		}
	}
}