<?php
class Add_gopay_newTools {

	public static function isOldVersion() {
		$version_mask = explode('.', _PS_VERSION_, 2);
		$version_test = $version_mask[0] > 0 && $version_mask[1] < 4;

		return $version_test;
	}

	public static function executeFileQueries($sql_file, $suppress = false)
	{
		if (file_exists($sql_file))
		{
			$sql = file_get_contents($sql_file);
			$sql = str_replace('PREFIX_', _DB_PREFIX_, $sql);
			$sql = str_replace('_MYSQL_ENGINE_', _MYSQL_ENGINE_, $sql);
			$sql = preg_split("/;\s*[\r\n]+/",$sql);

			$result = true;

			foreach ($sql as $query)
			{
				if (trim($query))
				{
					try
					{
						$result &= Db::getInstance()->Execute(trim($query));
					}
					catch(Exception $e)
					{
						if(preg_match('/duplicate column/', $e->getMessage()))
						{
							$result &= true;
						}
					}
				}
			}

			return $suppress ? $suppress : $result;
		}
		
		return true;
	}

	public static function installModuleTab(Module $module, $tabClass, $tabNames, $tabParentClass, $active)
	{
		$tab = new Tab();
		$tab->class_name = $tabClass;
		$tab->module = $module->name;
		$tab->id_parent = Tab::getIdFromClassName($tabParentClass);
		$tab->active = $active;
		$languages = Language::getLanguages(false);

		if (is_array($languages))
		{
			foreach ($languages as $language)
			{
				foreach ($tabNames as $key=>$name)
				{
					$id_lang = Language::getIdByIso($key);
					if ($id_lang && $id_lang == $language['id_lang'])
						$tab->name[$language['id_lang']] = $name;
					else
						$tab->name[$language['id_lang']] = $tabNames['en'];
				}
			}
		}
			else
			{
				if (isset($tabNames[$this->context->language->iso_code]))
					$tab->name[$this->context->language->id] = $tabNames[$this->context->language->iso_code];
				else
					$tab->name[$this->context->language->id] = $tabNames['en'];
			}
		
		if(!$tab->add())
			return false;
		
		return true;
	}

	public static function uninstallModuleTab($tabClass)
	{
		$idTab = Tab::getIdFromClassName($tabClass);
	
		if($idTab != 0)
		{
			$tab = new Tab($idTab);
			if(!$tab->delete())
				return false;
		}

		return true;
	}
	
	public static function registerHooks(Module $module, array $hooks)
	{
		$result = true;
		
		foreach($hooks as $hook)
			if(!$module->isRegisteredInHook($hook))
				$result &= $module->registerHook($hook);
		
		return $result;
	}

	public static function installSettings(array $settings)
	{
		$result = true;
		
		foreach($settings as $name => $class)
			if(is_object($class))
				$result &= $class->install();
		
		return $result;
	}
	
	public static function uninstallSettings(array $settings)
	{
		$result = true;
		
		foreach($settings as $name => $class)
			if(is_object($class))
				$result &= $class->uninstall();
		
		return $result;
	}
	
	public static function setLocale($iso_lang) {
		
		$iso_lang = trim($iso_lang);
		$lower_iso_lang = strtolower($iso_lang);
		$upper_iso_lang = strtoupper($iso_lang);
		
		setlocale(LC_COLLATE, $lower_iso_lang.'_'.$upper_iso_lang.'.UTF-8');
		setlocale(LC_CTYPE, $lower_iso_lang.'_'.$upper_iso_lang.'.UTF-8');
	}

	/* ------------------------------------------------------------- */
	/*  CREATE NEW ORDER STATUSES
	/* ------------------------------------------------------------- */
	public static function createOrderStatuses(Module $module)
	{
		$statuses = array(
						array('name' => GFIX.'_NEW',
								'color' => '#029AD6',
								'mail' => 'status_new',
								'lang_cs' => 'Gopay – objednávka vytvořena',
								'lang_en' => 'GoPay - order created'
						),
						array('name' => GFIX.'_CREATED',
								'color' => '#4E3D99',
								'mail' => 'status_created',
								'lang_cs' => 'Gopay – opakovaná platba založena',
								'lang_en' => 'GoPay - recurring payment created'
						),
						array('name' => GFIX.'_TIMEOUTED',
								'color' => '#D61101',
								'mail' => 'status_timeout',
								'lang_cs' => 'Gopay – časový limit vypršel',
								'lang_en' => 'GoPay - timeout'
						),
						array('name' => GFIX.'_PAYMENT_METHOD_CHOSEN',
								'color' => '#26A942',
								'mail' => 'status_chosen',
								'lang_cs' => 'Gopay – platba byla vybrána',
								'lang_en' => 'GoPay - payment chosen'
						),
						array('name' => GFIX.'_CANCELED',
								'color' => '#C8073C',
								'mail' => 'status_canceled',
								'lang_cs' => 'Gopay – zrušeno uživatelem',
								'lang_en' => 'GoPay - canceled'
						),
						array('name' => GFIX.'_AUTHORIZED',
								'color' => '#CB6803',
								'mail' => 'status_authorized',
								'lang_cs' => 'Gopay – autorizováno',
								'lang_en' => 'GoPay - authorized'
						),
						array('name' => GFIX.'_REFUNDED',
								'color' => '#766861',
								'mail' => 'status_refunded',
								'lang_cs' => 'Gopay – vrácená platba',
								'lang_en' => 'GoPay - refunded'
						),
						array('name' => GFIX.'_PARTIALLY_REFUNDED',
								'color' => '#766861',
								'mail' => 'status_partially_refunded',
								'lang_cs' => 'Gopay – částečně vrácená platba',
								'lang_en' => 'GoPay - partially refunded'
						)
		);

		foreach ($statuses as $status)
		{
			if (!self::createStatus($module, $status))
				return false;
		}

		return true;
	}

	private static function createStatus(Module $module, $status)
	{
		if (Configuration::get($status['name']))
		{
			$order_state = new OrderState(Configuration::get($status['name']));
			if (Validate::isLoadedObject($order_state))
				return true;
			else
				return self::addStatus($module, $status);
		} else
			return self::addStatus($module, $status);
	}

	private static function addStatus(Module $module, $status)
	{
			$orderState = new OrderState();
			$orderState->name		 = array();
			$orderState->invoice	 = false;
			$orderState->send_email	 = true;
			$orderState->module_name = $module->name;
			$orderState->unremovable = true;
			$orderState->hidden		 = false;
			$orderState->logable	 = false;
			$orderState->delivery	 = false;
			$orderState->shipped	 = false;
			$orderState->paid		 = false;
			$orderState->color		 = $status['color'];
			foreach (Language::getLanguages(false) as $language)
			{
				$orderState->template[$language['id_lang']] = $status['mail'];
				if (strtolower($language['iso_code']) == 'cs')
					$orderState->name[$language['id_lang']] = $status['lang_cs'];
				else
					$orderState->name[$language['id_lang']] = $status['lang_en'];
			}

		if ($orderState->add())
			if (!self::copyIcon($orderState->id, $status['mail']))
			{
				$orderState->delete($orderState->id);
				return false;
			} else
				return Configuration::updateValue($status['name'], (int)$orderState->id, false, false, false);

		return false;
	}

	/* ------------------------------------------------------------- */
	/*  COPY MAIL FILES FOR STATUSES
	/* ------------------------------------------------------------- */
	public static function copyMails(Module $module)   
	{
		if (!is_writable(_PS_ROOT_DIR_))
	  		die("Prestashop base dir is not writable. Please set permissions using: \"sudo chmod g+rw "._PS_ROOT_DIR_." -R\", if it does not help, use: \"sudo chmod o+rw "._PS_ROOT_DIR_." -R\". You can revoke these permissions by replacig \"+\" sign with \"-\""); 

		$files = array(
					'payment',	// nahrazuje původní šablonu
					'status_new',
					'status_authorized',
					'status_canceled',
					'status_chosen',
					'status_created',
					'status_refunded',
					'status_partially_refunded',
					'status_timeout'
		);

		foreach (Language::getLanguages() as $language)
		{
			$iso			 = strtolower($language['iso_code']);
			$source			 = _PS_MODULE_DIR_.$module->name.'/install_mails/'.$iso;
			$destination	 = _PS_MAIL_DIR_.$iso;

			if(!is_dir($source))
				$source = _PS_MODULE_DIR_.$module->name.'/install_mails/en';

			if(is_dir($destination))
				foreach ($files as $file)
					if (!self::_copy_file($source, $destination, $file.'.html') || !self::_copy_file($source, $destination, $file.'.txt'))
						return false;
		}

		return true;
	}

	private static function _copy_file($source, $destination, $file)   
	{
		$destination = $destination.'/'.$file;
		$source = $source.'/'.$file;
		$dH = 0;
		$dB = 0;
		if(file_exists($destination))
            $dH = filesize($destination);

		if(file_exists($source))
            $dH = filesize($source);

		if ($dH != $dB)
		{
			if(file_exists($destination))
				if($dH > 100000)
					if(!rename($destination, $destination.".opbak"))
						return false;

			if (!copy($source, $destination))
				return false;
		}

		return true;
	}

	/* ------------------------------------------------------------- */
	/*  DELETE ORDER STATUSES
	/* ------------------------------------------------------------- */
	public static function deleteStatuses()   
	{
		$statuses = array(
					GFIX.'_NEW',
					GFIX.'_CREATED',
					GFIX.'_TIMEOUTED',
					GFIX.'_PAYMENT_METHOD_CHOSEN',
					GFIX.'_CANCELED',
					GFIX.'_AUTHORIZED',
					GFIX.'_REFUNDED',
					GFIX.'_PARTIALLY_REFUNDED'
		);

		foreach ($statuses as $status)
		{
			if (!self::deleteStatus($status))
				return false;		
		}

		return true;
	}

	private static function deleteStatus($status)
	{
		if (Configuration::get($status))
		{
			$orderState = new OrderState(Configuration::get($status));

			if ($orderState && (!$orderState->delete() || !Configuration::deleteByName($status)))
				return false;
		}

		return true;
	}

	/* ------------------------------------------------------------- */
	/*  DELETE MAIL FILES FOR STATUSES
	/* ------------------------------------------------------------- */
	public static function deleteMails()   
	{
		$files = array(
					'status_new',
					'status_authorized',
					'status_canceled',
					'status_chosen',
					'status_created',
					'status_refunded',
					'status_partially_refunded',
					'status_timeout'
		);
		foreach (Language::getLanguages() as $language)
		{
			$iso			 = strtolower($language['iso_code']);
			$destination	 = _PS_MAIL_DIR_.$iso;

			foreach ($files as $file)
				if (!self::_remove_file($destination, $file.'.html') || !self::_remove_file($destination, $file.'.txt'))
					return false;		
		}

		return true;
	}

	private static function _remove_file($destination, $file)   
	{
		$destination = $destination.'/'.$file;

		if (file_exists($destination) && !unlink($destination))
			return false;

		if (file_exists($destination.".opbak"))
			if (!rename($destination.".opbak", $destination))
				return false;

		return true;
	}

	private static function copyIcon($status, $type)
	{
		$source = dirname(__FILE__).'/views/images/'.$type.'.gif';
		$destination = dirname(__FILE__).'/../../img/os/'.$status.'.gif';
		return copy($source, $destination);
	}

	/* ------------------------------------------------------------- */
	/*  CREATE CMS
	/* ------------------------------------------------------------- */
	public static function createCMS($name)
	{
		// pridani noveho cms zaznamu - informace o GoPay
		$cms = new CMS();
		$cms->id_cms_category = 1;
		$cms->active = 1;
		$languages = Language::getLanguages(false);
		foreach ($languages AS $language)
		{
			$cms->meta_title[(int)($language['id_lang'])] = 'GoPay';
			$cms->meta_description[(int)($language['id_lang'])] = 'Platební systém GoPay';
			$cms->meta_keywords[(int)($language['id_lang'])] = 'gopay, payment, secure payment, ssl';
			$cms->link_rewrite[(int)($language['id_lang'])] = 'gopay';
			$cms->content[(int)($language['id_lang'])] = '
			<div align="right"><a href="https://www.gopay.cz" target="_blank"><img src="'.__PS_BASE_URI__.'modules/'.$name.'/views/images/logo_header.gif" alt="GoPay" style="margin-right: 20px;" /></a></div><h2>Preferujeme GoPay</h2><br />
	        <p align="justify">GoPay je český, moderní, rychlý, internetový platební systém s vysokou úrovní bezpečnosti. Nabízí platby prostřednictvím elektronické peněženky a veškerých nejpopulárnějších platebních metod na českém internetu v rámci jediného uživatelského rozhraní. GoPay je partnerem vaší platby se zárukou důvěryhodného a bezpečného platebního prostředí.</p><br />
	        <h3>S GoPay peněženkou získáte výhody</h3>
	        <p align="justify">GoPay peněženka nabízí elektronickou variantu běžné peněženky pro drobné každodenní platby. Už žádné vyplňování osobních údajů, žádné skryté poplatky, s GoPay peněženkou párkrát kliknete a můžete ihned nakupovat. Rychle. Snadno. Zdarma. Kdykoliv. Vyzkoušejte GoPay peněženku na <a href="https://www.gopay.cz" target="_blank">https://www.gopay.cz</a></p><br />
	        <h3>Hlavní výhody GoPay peněženky:</h3>
	        <ul><li>založení a užívání zdarma</li><li>registrace bez předávání citlivých údajů a čísla bankovního účtu</li><li>rychlé dobíjení a okamžité platby</li><li>platby na libovolný bankovní účet</li><li>ideální pro platby malých finančních částek</li><li>ideální jako internetová kasička pro nejmladší uživatele</li><li>splňuje všechny bezpečnostní standardy</li></ul><br />
	        <h3>Jak snadno platit s GoPay</h3>
	        <h4>1. Vyberte si zboží/službu</h4>
	        <p>Vyberte si na stránkách internetového obchodu zboží/službu, o kterou máte zájem.</p>
	        <h4>2. Potvrďte objednávku</h4>
	        <p>Na straně internetového obchodu vyplňte údaje a potvrďte objednávku vybraného zboží/služby.</p>
	        <h4>3. Volba platební metody</h4>
	        <p>Otevře se okno platební brány GoPay, kde zvolte záložku preferované platební metody.</p>
	        <h4>4. Proveďte platbu</h4>
	        <p>Na platební bráně GoPay postupujte dle instrukcí dle zvolené platební metody. Po provedení platby dojde k přesměrování zpět na stránky internetového obchodu.</p>
	        <h4>5. Vyřízení objednávky</h4>
	        <p>Platba je automaticky provedena a objednávka vybraného zboží/služby ze strany internetového obchodu ihned vyřízena.</p>
	        <a href="https://www.gopay.cz" target="_blank">https://www.gopay.cz</a>';
		}

		if ($cms->save())
		{
			Configuration::updateValue(GFIX.'_CMS', $cms->id);
			return true;
		}

		return false;
	}

	/* ------------------------------------------------------------- */
	/*  CREATE CMS
	/* ------------------------------------------------------------- */
	public static function deleteCMS()
	{
		$query = new DbQuery();
		$query->from('cms_lang');
		$query->where("`meta_title` LIKE '%GoPay%'");

		$result = DB::getInstance()->executeS($query);
		foreach ($result as $item)
		{
			$cms = new CMS($item['id_cms']);
			if (Validate::isLoadedObject($cms))
				if (!$cms->delete())
					return false;
		}

		return true;
	}
}