<?php
/* ########################################################################### */
/*                                                                             */
/*                      Copyright 2014     Miloslav Kubín                      */
/*                        http://presta-modul.shopmk.cz                        */
/*                                                                             */
/*             Please do not change this text, remove the link,                */
/*          or remove all or any part of the creator copyright notice          */
/*                                                                             */
/*    Please also note that although you are allowed to make modifications     */
/*     for your own personal use, you may not distribute the original or       */
/*                 the modified code without permission.                       */
/*                                                                             */
/*                    SELLING AND REDISTRIBUTION IS FORBIDDEN!                 */
/*             Download is allowed only from presta-modul.shopmk.cz            */
/*                                                                             */
/*       This software is provided as is, without warranty of any kind.        */
/*           The author shall not be liable for damages of any kind.           */
/*               Use of this software indicates that you agree.                */
/*                                                                             */
/*                                    ***                                      */
/*                                                                             */
/*              Prosím, neměňte tento text, nemazejte odkazy,                  */
/*      neodstraňujte části a nebo celé oznámení těchto autorských práv        */
/*                                                                             */
/*     Prosím vezměte také na vědomí, že i když máte možnost provádět změny    */
/*        pro vlastní osobní potřebu,nesmíte distribuovat původní nebo         */
/*                        upravený kód bez povolení.                           */
/*                                                                             */
/*                   PRODEJ A DISTRIBUCE JE ZAKÁZÁNA!                          */
/*          Download je povolen pouze z presta-modul.shopmk.cz                 */
/*                                                                             */
/*   Tento software je poskytován tak, jak je, bez záruky jakéhokoli druhu.    */
/*          Autor nenese odpovědnost za škody jakéhokoliv druhu.               */
/*                  Používáním tohoto softwaru znamená,                        */
/*           že souhlasíte s výše uvedenými autorskými právy .                 */
/*                                                                             */
/* ########################################################################### */

class Callback_new
{

	public function updateForCallback($id_payment, $id_order)
	{
		$GoPay = new Add_gopay_new();
		$failedPayments = array(
					New_GoPay_Helper::CREATED,
					New_GoPay_Helper::CANCELED,
					New_GoPay_Helper::TIMEOUTED,
					New_GoPay_Helper::FAILED
		);

		$templateVars = array($GoPay->extra_mail_vars);

		$payment_status = New_Gopay_RestAPI::checkPaymentStatus($id_payment);

		if (empty($payment_status))
			return New_GoPay_Tools::getErrors('', '', $GoPay->faultyPaymentIdentity, '');
		elseif (!empty($payment_status->errors))
			return $payment_status;

		$order = new Order((int)$id_order);

		if(!Validate::isLoadedObject($order))
			return New_GoPay_Tools::getErrors('', '', $GoPay->orderNotExist, '');
		else
		{
			$templateVars = array(
				'{repeat_payment_url}' => Context::getContext()->link->getModuleLink($GoPay->name, 'repeatPayment', array('paymentChannel' => 'ACCOUNT', 'orderId' => $order->id), true)
			);

			$currency = new Currency($order->id_currency);
			$current_order_state = $order->getCurrentOrderState();

			if (($current_order_state->id == _PS_OS_CANCELED_
				|| $current_order_state->id == _PS_OS_PAYMENT_
				|| $order->hasBeenPaid()
				|| $order->hasBeenShipped()
				) && $payment_status->state != New_GoPay_Helper::REFUNDED
					&& $payment_status->state != New_GoPay_Helper::PARTIALLY_REFUNDED
			)
				return $payment_status;
			else
			{
				$sessionState = $payment_status->state;
				$sessionSubState = isset($payment_status->sub_state) ? $payment_status->sub_state : '';

				$paymentMessage = New_GoPay_Helper::getResultMessage($sessionState, $sessionSubState);
				if(!$paymentMessage)
					return New_GoPay_Tools::getErrors('', '', $GoPay->FAILED_MESSAGE, '');

				if (isset($payment_status->recurrence))
				{
					$templateVars = array(
							'{recurrence_period}' => $GoPay->mailRepeated_1.$payment_status->recurrence->recurrence_period.' '.$payment_status->recurrence->recurrence_cycle,
							'{recurrence_date_to}' => $GoPay->mailRepeated_2.$payment_status->recurrence->recurrence_date_to
					);
				}

				if ($sessionState == New_GoPay_Helper::PAID)
				{
					/* Zaplacena */
					if ($current_order_state->id != _PS_OS_PAYMENT_ && !New_GoPay_Bills::getBill($order->id))
					{
						$this->updateStatus(_PS_OS_PAYMENT_, $order, $templateVars);

						$detail = New_Gopay_RestAPI::getBillDetail($id_payment);
						if (!empty($detail->errors))
							return $detail;

						if ($detail)
						{
							$date = new DateTime($detail[0]->dat_trzby);
							$new_bill = new New_GoPay_Bills();
							$new_bill->id_order = $order->id;
							$new_bill->id_session = $detail[0]->payment_id;
							$new_bill->dat_trzby = $date->format('Y-m-d H:i:s');
							$new_bill->fik = $detail[0]->fik;
							$new_bill->bkp = $detail[0]->bkp;
							$new_bill->pkp = $detail[0]->pkp;
							$new_bill->save();
						}
					}

					/*$orderPayment->transaction_id = $session['id_session'];
					$orderPayment->update();*/

				} else if ($sessionState == New_GoPay_Helper::CREATED)
				{
					/* Platba nebyla zaplacena */
					if ($current_order_state->id != Configuration::get('PS_OS_OUTOFSTOCK_UNPAID'))
						if (isset($payment_status->recurrence) && $current_order_state->id != _PAYMENT_CREATED_)
							$this->updateStatus(_PAYMENT_CREATED_, $order, $templateVars);
						else
							if ($current_order_state->id != _PAYMENT_NEW_)
								$this->updateStatus(_PAYMENT_NEW_, $order, $templateVars);

				} else if ($sessionState == New_GoPay_Helper::PAYMENT_METHOD_CHOSEN)
				{
					/* Platba ceka na zaplaceni */
					if ($current_order_state->id != _PAYMENT_CHOSEN_)
						$this->updateStatus(_PAYMENT_CHOSEN_, $order);

				} else if ($sessionState == New_GoPay_Helper::CANCELED)
				{
					/* Platba byla zrusena objednavajicim */
					if ($current_order_state->id != _PAYMENT_CANCELED_)
						$this->updateStatus(_PAYMENT_CANCELED_, $order, $templateVars);

				} else if ($sessionState == New_GoPay_Helper::TIMEOUTED)
				{
					/* Platnost platby vyprsela  */
					if ($current_order_state->id != _PAYMENT_TIMEOUT_)
						$this->updateStatus(_PAYMENT_TIMEOUT_, $order, $templateVars);

				} else if ($sessionState == New_GoPay_Helper::AUTHORIZED)
				{
					/* Platba byla autorizovana, ceka se na dokonceni  */
					if ($current_order_state->id != _PAYMENT_AUTHORIZE_)
						$this->updateStatus(_PAYMENT_AUTHORIZE_, $order);

				} else if ($sessionState == New_GoPay_Helper::REFUNDED)
				{
					/* Platba byla vracena - refundovana  */
					if ($current_order_state->id != _PAYMENT_REFUND_)
						$this->updateStatus(_PAYMENT_REFUND_, $order);

				} else if ($sessionState == New_GoPay_Helper::PARTIALLY_REFUNDED)
				{
					/* Platba byla vracena - částečně refundovana  */
					if ($current_order_state->id != _PAYMENT_PARTIALLY_REFUNDED_)
						$this->updateStatus(_PAYMENT_PARTIALLY_REFUNDED_, $order);

				} else if ($sessionState == New_GoPay_Helper::FAILED)
				{
					/* Chyba ve stavu platby */
					if ($current_order_state->id != _PS_OS_ERROR_)
						$this->updateStatus(_PS_OS_ERROR_, $order);
				}

				$order_payment = new New_Gopay_Order((int)$order->id);
				$order_payment->id_session = $payment_status->id;
				$order_payment->currency = $order->id_currency;
				$order_payment->total_paid = (float)$order->total_paid;
				$order_payment->update_date = pSQL(date('Y-m-d H:i:s'));
				$order_payment->payment_status = pSQL($sessionState);

				if ($order_payment->update())
				{
					if (Configuration::get(GFIX.'_RECURRENT') &&
						$sessionState == New_GoPay_Helper::PAID &&
						$current_order_state->id != _PS_OS_PAYMENT_)
					{
						$recurrent = new New_GoPay_Recurrent();
						$recurrent->id_order = (int)$order->id;
						$recurrent->id_session = $payment_status->id;
						$recurrent->id_parent_session = $payment_status->parent_id ? $payment_status->parent_id : 0;
						$recurrent->recurrence_cycle = $payment_status->recurrence->recurrence_cycle;
						$recurrent->recurrence_period = $payment_status->recurrence->recurrence_period;
						$recurrent->recurrence_date_to = $payment_status->recurrence->recurrence_date_to;
						$recurrent->recurrence_state = $payment_status->recurrence->recurrence_state;
						$recurrent->add();
					}
				}

				$repeatPayment = false;
				if (in_array($sessionState, $failedPayments))
					$repeatPayment = true;

				return New_GoPay_Tools::getConfirmations($paymentMessage, $repeatPayment);
			}
		}
	}
	
	private function updateStatus($new_status, $order, $templateVars = false)
	{
		// Create new OrderHistory
		$history = new OrderHistory();
		$history->id_order = $order->id;
		$history->changeIdOrderState($new_status, $order, !$order->hasInvoice());
		$history->addWithemail();
	}
}