<?php

define('_PAYMENT_NEW_', Configuration::get(GFIX.'_NEW'));
define('_PAYMENT_CREATED_', Configuration::get(GFIX.'_CREATED'));
define('_PAYMENT_TIMEOUT_', Configuration::get(GFIX.'_TIMEOUTED'));
define('_PAYMENT_CHOSEN_', Configuration::get(GFIX.'_PAYMENT_METHOD_CHOSEN'));
define('_PAYMENT_CANCELED_', Configuration::get(GFIX.'_CANCELED'));
define('_PAYMENT_AUTHORIZE_', Configuration::get(GFIX.'_AUTHORIZED'));
define('_PAYMENT_REFUND_', Configuration::get(GFIX.'_REFUNDED'));
define('_PAYMENT_PARTIALLY_REFUNDED_', Configuration::get(GFIX.'_PARTIALLY_REFUNDED'));

class New_GoPay_Config
{
	const TEST = "TEST";
	const PROD = "PROD";

	/**
	 * Parametr specifikujici, pracuje-li se na testovacim ci provoznim prostredi
	 */
	static $version = self::TEST;
	
	/**
	 * Nastaveni testovaciho ci provozniho prostredi prostrednictvim parametru
	 * 
	 * @param $new_version
	 * TEST - Testovaci prostredi
	 * PROD - Provozni prostredi
	 *
	 */
	public static function init()
	{
		if(Configuration::get(GFIX.'_GATEWAY_MODE') == 1)
			self::$version = self::PROD;
	}
	
	/**
	 * URL platebni brany pro uplnou integraci
	 *
	 * @return URL
	 */
	public static function getURL()
	{
		if (self::$version == self::PROD)
			return "https://gate.gopay.cz/api/";
		 else
			return "https://gw.sandbox.gopay.com/api/";
	}

	/**
	 * GO_ID
	 *
	 * @return GO_ID
	 */
	public static function GO_ID()
	{
		if (self::$version == self::PROD)
			return Configuration::get(GFIX.'_GO_ID');
		 else
			return Configuration::get(GFIX.'_GO_ID_TEST');
	}

	/**
	 * CLIENT_ID
	 *
	 * @return CLIENT_ID
	 */
	public static function CLIENT_ID()
	{
		if (self::$version == self::PROD)
			return Configuration::get(GFIX.'_CLIENT_ID');
		 else
			return Configuration::get(GFIX.'_CLIENT_ID_TEST');
	}

	/**
	 * CLIENT_SECRET
	 *
	 * @return CLIENT_SECRET
	 */
	public static function CLIENT_SECRET()
	{
		if (self::$version == self::PROD)
			return Configuration::get(GFIX.'_CLIENT_SECRET');
		 else
			return Configuration::get(GFIX.'_CLIENT_SECRET_TEST');
	}

	/**
	 * URL webove sluzby GoPay
	 *
	 * @return URL - wsdl
	 */
	public static function ws() {
		
		if (self::$version == self::PROD) {
			return "https://gate.gopay.cz/axis/EPaymentServiceV2?wsdl";		
			
		} else {
			return "https://testgw.gopay.cz/axis/EPaymentServiceV2?wsdl";	
			
		}
	}
}