<?php
class New_GoPay_Helper {
	/**
	 * Kody stavu platby 
	 */
	const CREATED = "CREATED";
	const PAYMENT_METHOD_CHOSEN = "PAYMENT_METHOD_CHOSEN";
	const PAID = "PAID";
	const AUTHORIZED = "AUTHORIZED";
	const CANCELED = "CANCELED";
	const TIMEOUTED = "TIMEOUTED";
	const REFUNDED = "REFUNDED";
	const PARTIALLY_REFUNDED = "PARTIALLY_REFUNDED";
	const FAILED = "FAILED";
	
	const CALL_COMPLETED = "CALL_COMPLETED";
	const CALL_FAILED = "CALL_FAILED";
	
	
	/**
	 * Konstanty pro opakovanou platbu
	 */
	const RECURRENCE_CYCLE_MONTH = "MONTH";
	const RECURRENCE_CYCLE_WEEK = "WEEK";
	const RECURRENCE_CYCLE_DAY = "DAY";
	const RECURRENCE_CYCLE_ON_DEMAND = "ON_DEMAND";
	
	/**
	 * Konstanty pro zruseni opakovani platby
	 */
	const CALL_RESULT_ACCEPTED = "ACCEPTED";
	const CALL_RESULT_FINISHED = "FINISHED";
	const CALL_RESULT_FAILED = "FAILED";

	/**
	 * URL obrazku tlacitek pro platebni formulare a odkazy 
	 */
	const iconRychloplatba = "https://www.gopay.cz/download/PT_rychloplatba.png";		
	const iconDaruj = "https://www.gopay.cz/download/PT_daruj.png";		
	const iconBuynow = "https://www.gopay.cz/download/PT_buynow.png";		
	const iconDonate = "https://www.gopay.cz/download/PT_donate.png";		
	

	/**
	 * Ziskani korektniho hlaseni o stavu platby - po volani (GopaySoap::isPaymentDone)
	 *
	 * @param String $sessionState - stav platby. Hodnoty viz konstanty New_GoPay_Helper
	 * @param String $sessionSubState - detailnejsi popis stavu platby
	 * 
	 * @return String retezec popisujici stav platby
	 */
	public static function getResultMessage($sessionState, $sessionSubState) {

		$result = "";
		$add_gopay = new Add_gopay_new();

		if ($sessionState == New_GoPay_Helper::PAID) {
			$result = $add_gopay->PAID_MESSAGE;

		} else if ($sessionState == New_GoPay_Helper::CANCELED) {
			$result = $add_gopay->CANCELED_MESSAGE;

		} else if ($sessionState == New_GoPay_Helper::TIMEOUTED) {
			$result = $add_gopay->TIMEOUTED_MESSAGE;

		} else if ($sessionState == New_GoPay_Helper::CREATED) {
			$result = $add_gopay->CREATED_MESSAGE;

		} else if ($sessionState == New_GoPay_Helper::AUTHORIZED) {
			$result = $add_gopay->AUTHORIZED_MESSAGE;

		} else if ($sessionState == New_GoPay_Helper::REFUNDED) {
			$result = $add_gopay->REFUNDED_MESSAGE;

		} else if ($sessionState == New_GoPay_Helper::PAYMENT_METHOD_CHOSEN) {
			if (! empty($sessionSubState) && $sessionSubState == 101) {
				$result = $add_gopay->PAYMENT_METHOD_CHOSEN_ONLINE_MESSAGE;

			} else if (! empty($sessionSubState) && $sessionSubState == 102) {
				$result = $add_gopay->PAYMENT_METHOD_CHOSEN_OFFLINE_MESSAGE;

			} else {
				$result = $add_gopay->PAYMENT_METHOD_CHOSEN_MESSAGE;
				
			}
			
		} else {
			$result = false;
		}
		
		return $result;
	}

	public static function getVatRates()
	{
		return array(
			0 => 0,
			10 => 3,
			15 => 2,
			21 => 1
		);
	}
}