
function inlineFunction(url, form, event) {
	$("button.payment-overlay").attr('disabled', true);
	
		//console.log(url);
		//console.log(datas);
	$.ajax({
		url: url,
		type: 'POST',
		dataType: 'json',
		data: form,
		success: function(data){
			if(!data.errors)
			{
				_gopay.checkout({
					gatewayUrl: data.url,
					inline: true
				});

				$('#gopay-payment-iframe').on('load', function(){
					$('#loadGoPay').hide();
				});
			} else {
			if (!!$.prototype.fancybox)
				$.fancybox.open([
					{
						type: 'inline',
						autoScale: true,
						minHeight: 30,
						content: '<div class="error alert alert-danger"><p class="fancybox-error">' + data.errors + '</p></div>'
					}
				], {
					padding: 0
				});
			else
 				alert('Chyba: ' + data.errors);
			}
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
			if (!!$.prototype.fancybox)
				$.fancybox.open([
					{
						type: 'inline',
						autoScale: true,
						minHeight: 30,
						content: '<p class="fancybox-error">' + textStatus + " / " + XMLHttpRequest.responseText + " / " + errorThrown + '</p>'
					}
				], {
					padding: 0
				});
			else
 				alert('Chyba: ' + textStatus + " / " + XMLHttpRequest.responseText + " / " + errorThrown);
		}
	});
}

function display_payment_desc()
{
	$('._payment_desc').each( function(index, elem) {
		//console.log(this);
		var ID = $(this).data('id');
		var value = $(this).data('value');

		value = value.replace(/</g, "<").replace(/>/g, ">").replace(/"/g, "\"").replace("\/", "/");
		$('#' + ID).html(value);
	});
}


function cancelRecurrent(id_order, id_session)
{
	$.ajax({
		url: "../modules/" + add_gopay_new + "/ajax.php",
		type:"POST",
		dataType: "json",
		data : {
				submit_cancel_recurrent	: 1,
				id_order				: id_order,
				id_session				: id_session
		},
		success: function(data){
			if(data.errors == 1)
			{
				$("#error_" + id_order).html(data.message);
				$("#error_" + id_order).fadeIn(200).show();
					$("#error_" + id_order).delay(3000).slideUp();
			} else
			{
				$("#cancel_recurr_" + id_order).hide();
				$("#conf_" + id_order).fadeIn(200).show();
					$("#conf_" + id_order).delay(9000).slideUp();
			}
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
 			alert('Chyba: ' + textStatus + " / " + XMLHttpRequest.responseText + " / " + errorThrown);
		}
	});
}

$(document).ready(function ()
{
	/* zobrazit popis platební metody v HTML */
	display_payment_desc();

	$('.payment-overlay').click(function (e)
	{
		if (typeof INLINE_MODE !== 'undefined' && INLINE_MODE == 1)
		{
			e.preventDefault();
		}

		$('body').append('<div id="loadGoPay" class="fancybox-overlay fancybox-overlay-fixed" style="overflow: auto; overflow-y: scroll; display:block;"><div id="loader"></div></div>');
		return true;
	});

	$('#gopay-payment-iframe').on('load', function(){
		$('#loadGoPay').hide();
	});

	/* 1.7 */
	/* inline platební brána */
	if (typeof INLINE_MODE !== 'undefined' && INLINE_MODE == 1)
	{
		var id_button = $('button .btn-primary');
		var id_checkbox = $('#conditions-to-approve input[type="checkbox"]');

		$('input[name="payment-option"]').each(function(e)
		{
			if ($(this) .is(":checked"))
			{
				if (this.getAttribute('data-module-name') == pms_gopay_extra)
				{
					var h1 = document.getElementById("payment-confirmation");
					if (typeof h1 !== 'undefined' && h1)
						h1.setAttribute('id', 'submit_payment');
				} else
				{
					var h1 = document.getElementById("submit_payment");
					if (typeof h1 !== 'undefined' && h1)
						h1.setAttribute('id', 'payment-confirmation');
				}
			}
		});

		id_checkbox.click(function (checkbox)
		{
			$("#submit_payment button").attr('disabled', true);
			if (id_checkbox.is(":checked"))
				$("#submit_payment button").attr('disabled', false);
		});


		$('input[name="payment-option"]').click(function (e)
		{ 
			var button_EU = $("#pay-with-" + this.getAttribute('id') + "-form input[name=\"module_name_EU\"]").val();
			if (this.getAttribute('data-module-name') == add_gopay_new
			   || button_EU == add_gopay_new
			)
			{
				var h1 = document.getElementById("payment-confirmation");
				if (typeof h1 !== 'undefined' && h1)
					h1.setAttribute('id', 'submit_payment');
			} else
			{
				var h1 = document.getElementById("submit_payment");
				if (typeof h1 !== 'undefined' && h1)
					h1.setAttribute('id', 'payment-confirmation');
			}

			$("#submit_payment button").attr('disabled', true);
			if (id_checkbox.is(":checked"))
				$("#submit_payment button").attr('disabled', false);
		});

		$("#payment-confirmation").click(function (e)
		{
			e.preventDefault();
			this.disabled = true;
			$('body').append('<div id="loadGoPay" class="fancybox-overlay fancybox-overlay-fixed" style="overflow: auto; overflow-y: scroll; display:block;"><div id="loader"></div></div>');

			var input = $('input[name="payment-option"]:checked');
			var module_name_EU = $("#pay-with-" + input.attr('id') + "-form input[name=\"module_name_EU\"]").val();

			if (input.attr('data-module-name') == add_gopay_new
			   || module_name_EU == add_gopay_new)
			{
				var form = $("#pay-with-" + input.attr('id') + "-form form");

				inlineFunction(form.attr("action"), form.serialize());
			}
		});
	}
});