
function toggle_settings_loadLogo(settingsGroup) {
    if ($(settingsGroup+':visible').length > 0) {
        $(settingsGroup).slideToggle('slow');
    } else {
        $(settingsGroup).slideToggle('slow');
    }
}

function selected_cycles() {
	var _RECURRENCE_CYCLE = $('#_RECURRENCE_CYCLE');

	if(_RECURRENCE_CYCLE.val() == 'DAY')
	{
		_RECURRENCE_CYCLE.after(period_days);
	}
	else if(_RECURRENCE_CYCLE.val() == 'WEEK')
	{
		_RECURRENCE_CYCLE.after(period_weeks);
	}
	else if(_RECURRENCE_CYCLE.val() == 'MONTH')
	{
		_RECURRENCE_CYCLE.after(period_months);
	}
}

/*
*
* Upload loga
*
*/
function handleFiles(files , ID) {
	//console.log(files);

    var file_data = $('#_IMAGE_FILE_' + ID).prop('files')[0]; 
	var formData = new FormData();
	formData.append('submit_upload_logo', 1);
	formData.append('ID', ID);
	formData.append('file', file_data);

	$.ajax({
		url: '../modules/add_gopay_new/ajax.php',
		type:"POST",
		dataType: 'json', 
		cache: false,
		processData: false,
		contentType: false,
		data: formData,
		success: function(data) {
			if(data.errors == 1)
			{
				var list = $("#errors_ajax");
				list.html('<div class="module_error alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>' + data.message + '</div>');
			} else
			{
				var list = $("#_IMAGE_" + ID);
				var img = document.createElement("img");
				img.src = data.url;
				img.height = 60;
				list.html(img);
		
                window.URL = window.URL || window.webkitURL;

				var fileList = document.getElementById("_IMAGE_" + ID);		
				
				fileList.innerHTML = "";

				for (var i = 0; i < files.length; i++) {
					var img = document.createElement("img");
					img.src = window.URL. createObjectURL (files[i]);
					img.onload = function() {
						window.URL. revokeObjectURL (this.src);
					}

					fileList.appendChild(img);
				}
			}
		},
		error: function(XMLHttpRequest, textStatus, errorThrown) {
			alert("TECHNICAL ERROR: \n\nDetails:\nError thrown: " + JSON.stringify(XMLHttpRequest) + "\n" + 'Text status: ' + textStatus + "\n" + 'Text status: ' + errorThrown);
		}
	});
}

/*
*
* načtení platebních inputů
*
*/
function paymentsInputs(paymentType, displaySelect) {
	//console.log(files);

	if (displaySelect) {
		$('._DISPLAYSELECT').show();
	} else {
		$('._DISPLAYSELECT').hide();
	}

	$.ajax({
		url: 'index.php?controller=AdminModules&configure=add_gopay_new&token='+token,
		type:"POST",
		dataType: 'json', 
		cache: false,
		data: {
				getPaymentsInputs	: 1,
				paymentType			: paymentType,
		},
		success: function(data) {
			$("#_DISPLAY_INPUTS").html(data);
		},
		error: function(XMLHttpRequest, textStatus, errorThrown) {
			alert("TECHNICAL ERROR: \n\nDetails:\nError thrown: " + JSON.stringify(XMLHttpRequest) + "\n" + 'Text status: ' + textStatus + "\n" + 'Text status: ' + errorThrown);
		}
	});
}

/*
*
* Skrytí a deaktivace platebnich metod
*
*/
function setPayments(paymentType, $displaySelect) {
	var payments = ["_SHORTENED_MODE", "_EXTENDED_MODE", "_WINDOW_MODE"];

	for (var i = 0; i < payments.length; i++) {
		if (payments[i] == paymentType) {
			$('.' + payments[i]).show();
			$('.' + payments[i] + ' :input[type="checkbox"]').removeAttr('disabled');
		} else {
			$('.' + payments[i]).hide();
			$('.' + payments[i] + ' :input[type="checkbox"]').attr('disabled', true);
		}
	}

	if ($displaySelect) {
		$('._DISPLAYSELECT').show();
	} else {
		$('._DISPLAYSELECT').hide();
	}
}

/*
*
* Skrytí a deaktivace platebnich metod
*
*/
function displayTypeRefund(type) {
	if (type == 2) {
		$('#_PARTIALY').show();
		$('._refund :input[type="checkbox"]').removeAttr('disabled');
	} else {
		$('#_PARTIALY').hide();
		$('._refund :input[type="checkbox"]').attr('disabled', true);
	}
}


$(document).ready(function () {

	$('#content').addClass('bootstrap');

	$('.PRICE-type-VALUES').each( function(index, elem) {
    	$(this).on('click','li a', function(e){
			e.preventDefault();
			//console.log(this);
			var parentDIV = $(this).parent().parent().parent().parent();

			parentDIV.find('.PRICE-option').removeClass('active');
			$(this).closest('li').addClass('active');
			parentDIV.find('._FEE_TYPE').val($(this).data('value'));
			parentDIV.find('._PRICE_ICON').html($(this).data('icon'));
		});
	});

/*
			$('.' + payments[i] + ' :input').attr('disabled', true);
*
* Typ platebních údajů zákazníka testovaí nebo provozní
*
*/
	$('#mode_on').on('click', function () {
		$('#fieldset_add_gopay_new-general .test_mode').hide();
		$('#fieldset_add_gopay_new-general .full_mode').show();
	});

	$('#mode_off').on('click', function () {
		$('#fieldset_add_gopay_new-general .test_mode').show();
		$('#fieldset_add_gopay_new-general .full_mode').hide();
	});

/*
*
* Typ zobrazení platebních tlačítek
*
*/
	$("input[name='_BUTTONS_MODE']").on('click', function () {
		paymentsInputs(this.value, false);
	});

/*
*
* Typ příplatku platebních metod
*
*/

	$('#_PRICE_DIFFERENT_on').on('click', function () {
		$('#_FEE_TYPE_').each(function() {this.disabled = 'disabled';});
		$('#_FEE_VALUE_').each(function() {this.disabled = 'disabled';});
	});

	$('#_PRICE_DIFFERENT_off').on('click', function () {
		$('#_FEE_TYPE_').removeAttr('disabled');
		$('#_FEE_VALUE_').removeAttr('disabled');
	});

/*
*
* Povolit zobrazení příplatků
*
*/
	$('#_PRICE_VIEW_on').on('click', function () {
		$('._PRICE_VIEW').show(500);
	});

	$('#_PRICE_VIEW_off').on('click', function () {
		$('._PRICE_VIEW').hide(500);
	});

/*
*
* Typ příplatku platebních metod - pouze jeden typ pro zjednodušené platby
*
*/
	if(typeof PAYMENT_MODE !== 'undefined' && PAYMENT_MODE == 1)
	{
		$('#price_different_off').each(function() {this.checked = 'checked';});
		$('#price_different_on').each(function() {this.disabled = 'disabled';});
		$('#price_different_off').each(function() {this.disabled = 'disabled';});
	} else
	{
		$('#price_different_on').removeAttr('disabled');
		$('#price_different_off').removeAttr('disabled');
	}

	$('#shortened').on('click', function () {
		$('#price_different_on').removeAttr('checked');
		$('#price_different_off').each(function() {this.checked = 'checked';});
		$('#price_different_on').each(function() {this.disabled = 'disabled';});
		$('#price_different_off').each(function() {this.disabled = 'disabled';});
		$('#_FEE_TYPE').removeAttr('disabled');
		$('#_FEE_VALUE').removeAttr('disabled');
	});

	$('#extended').on('click', function () {
		$('#price_different_on').removeAttr('disabled');
		$('#price_different_off').removeAttr('disabled');
		if(typeof PRICE_DIFFERENT !== 'undefined' && PRICE_DIFFERENT == 1)
			$('#price_different_on').each(function() {this.checked = 'checked';});
		else
			$('#price_different_off').each(function() {this.checked = 'checked';});
		$('#_FEE_TYPE').each(function() {this.disabled = 'disabled';});
		$('#_FEE_VALUE').each(function() {this.disabled = 'disabled';});
	});

/*
*
* Opakované platby
*
*/
	var _RECURRENCE_TYPE = $('#_RECURRENCE_TYPE');

	var _RECURRENCE_CYCLE = $('#_RECURRENCE_CYCLE');
	var _RECURRENCE_DATE_TO = $('#_RECURRENCE_DATE_TO');

	var _RECURRENCE_TYPE_FORM = _RECURRENCE_TYPE.closest('.form-group');
	var _RECURRENCE_CYCLE_FORM = _RECURRENCE_CYCLE.closest('.form-group');
	var _RECURRENCE_DATE_TO_FORM = _RECURRENCE_DATE_TO.closest('.form-group');


	if($('#_RECURRENT_on').is(":checked"))
	{
		_RECURRENCE_TYPE_FORM.show();

		if(_RECURRENCE_TYPE.val() == 'periodic')
		{
			_RECURRENCE_CYCLE_FORM.show();
			_RECURRENCE_DATE_TO_FORM.show();
			selected_cycles();
		} else
		{
			_RECURRENCE_CYCLE_FORM.hide();
			_RECURRENCE_DATE_TO_FORM.hide();
		}
	} else
	{
		_RECURRENCE_TYPE_FORM.hide();
		_RECURRENCE_CYCLE_FORM.hide();
		_RECURRENCE_DATE_TO_FORM.hide();
	}

	$('#_RECURRENT_on').on('click', function () {
		if(_RECURRENCE_TYPE_FORM.is(":visible"))
			return;

		_RECURRENCE_TYPE_FORM.show(500);
		if(_RECURRENCE_TYPE.val() == 'periodic')
		{
			_RECURRENCE_CYCLE_FORM.show(500);
			_RECURRENCE_DATE_TO_FORM.show(500);
			selected_cycles();
		} else
		{
			_RECURRENCE_CYCLE_FORM.hide(500);
			_RECURRENCE_DATE_TO_FORM.hide(500);
		}
	});

	$('#_RECURRENT_off').on('click', function () {
		_RECURRENCE_TYPE_FORM.hide(500);
		_RECURRENCE_CYCLE_FORM.hide(500);
		_RECURRENCE_DATE_TO_FORM.hide(500);
		$('#recurrence_period').remove();
		$('#span_period').remove();
		$('#span_ewery').remove();
	});

	_RECURRENCE_TYPE.on('change', function () {
		if($(this).val() == 'periodic')
		{
			_RECURRENCE_CYCLE_FORM.show(500);
			_RECURRENCE_DATE_TO_FORM.show(500);
		} else
		{
			_RECURRENCE_CYCLE_FORM.hide(500);
			_RECURRENCE_DATE_TO_FORM.hide(500);
		}
	});

	$('#_RECURRENCE_CYCLE').on('change', function () {
		$('#recurrence_period').remove();
		$('#span_period').remove();
		$('#span_ewery').remove();
		selected_cycles();
	});

/*
*
* Test konfigurace
*
*/
	$("#test_config").on("click", function (e) {
		$( ".progressIcon" ).show();
		$.ajax({
			type: "POST",
			cache: false,
			url: currentIndex + "&token=" + token + "&configure=add_gopay_new",
			data: {
				test_configuration : 1
			},
			success: function (data) {
				e.preventDefault();
				$( ".progressIcon" ).hide();
				$.fancybox(data, {
						width: 950,
						height: 805,
						autoSize: false,
						closeClick: false,
						openEffect: "none",
						closeEffect: "none"
				});
			}
		});
	});

/*
*
* Delete logo
*
*/
var deleteLinks = document.querySelectorAll('.delete');

for (var i = 0; i < deleteLinks.length; i++)
{
	deleteLinks[i].addEventListener('click', function(event)
	{
		event.preventDefault();

		var choice = confirm(this.getAttribute('data-confirm'));
		var ID = this.getAttribute('data-id');

		if (choice)
		{
			$.ajax({
				url: '../modules/add_gopay_new/ajax.php',
				type:"POST",
				dataType: 'json',
				cache: false,
				data: {
					delete_logo	 : 1,
					ID			 : ID
				},
				success: function(data) {
					if(data.errors == 1)
					{
						var list = $("#errors_ajax");
						list.html('<div class="module_error alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>' + data.message + '</div>');
					} else
					{
						var fileList = document.getElementById("_IMAGE_" + ID);		
						
						fileList.innerHTML = "";
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown){
					alert('Chyba: ' + textStatus + " / " + XMLHttpRequest.responseText + " / " + errorThrown);
				}
			});
		}
	});
}
});