<?php

require_once('../../config/config.inc.php');
require_once('../../init.php');

require_once dirname(__FILE__) . '/config.php';
require_once _MONSTER_BALIKOBOT_CLASSES_DIR_ . 'API.php';
require_once _MONSTER_BALIKOBOT_CLASSES_DIR_ . 'Carrier.php';
require_once _MONSTER_BALIKOBOT_CLASSES_DIR_ . 'Package.php';

function printLabels($orderIds)
{
    $orderIds = array_filter(explode(',', $orderIds));
    try {
        $result = BalikobotPackage::getLabelsUrl($orderIds);
    }
    catch (BalikobotAPIException $e) {
        $result = [ 'errors' => $e->getMessageList() ];
    }
    die(
        json_encode($result)
    );
}

function getPackageData($orderId)
{
    $result = [
        'weight' => BalikobotPackage::getWeight($orderId),
        'price' => BalikobotPackage::getPrice($orderId),
    ];
    die(
        json_encode($result)
    );
}

function trackPackage($orderId)
{
    $package = new BalikobotPackage($orderId);
    $result = $package->trackPackage();
    die(
        json_encode($result)
    );
}



if ($_POST['action'] == 'trackPackage')
{
    trackPackage($_POST['id_order']);
}
else if ($_POST['action'] == 'printLabels')
{
    printLabels($_POST['orderIds']);
}
else if ($_POST['action'] == 'getPackageData')
{
    getPackageData($_POST['id_order']);
}