$('document').ready(function() {
    $('button[name=submitPrintLabel]').click(function(){
        $('#print-label').modal('hide');
    });

    $('a[href^="#balikobot-printLabel-position-"]').click(function(){
        var position = $(this).attr('href').split('-')[3];
        $('#print-label input[name=position]').val(position);
        $('button[name=submitPrintLabel]').click();
    });

    $('#print-labels').on('hidden.bs.modal', function() {
        location.reload();
    });

    $('#print-label').on('hidden.bs.modal', function() {
        location.reload();
    });
});

function packagesOrder() {
    $('#packages-order').modal('show');
}

function choosePackage(orderId, piecesCount, positionCount) {
    $('#choose-package input[name=orderId]').val(orderId);
    $('#choose-package input[name=positionCount]').val(positionCount);
    $('#choose-package button:not(.btn-primary)').remove();
    for (var i = 1; i <= piecesCount; i++) {
        $('#choose-package form').append(
            '<div><button type="submit" class="btn btn-default" name="buttonPrintPackage-' + i + '">' +
                '<i class="icon-print"></i>' +
                'Vytisknout štítek k balíku č. ' + i +
            '</button></div>'
        );
    }
    $('#choose-package').modal('show');
}

function printLabel(orderId, positionCount) {
    $('#print-label input[name=orderId]').val(orderId);
    $('#print-label input[name=position]').val('');

    if (positionCount == 8) {
        $('.balikobot-printLabel-4').hide();
        $('.balikobot-printLabel-8').show();
    }
    else {
        $('.balikobot-printLabel-4').show();
        $('.balikobot-printLabel-8').hide();
    }

    $('#print-label').modal('show');
}

function printLabels(orderIds) {
    $('#labels-to-print tbody').html('');
    $('#print-labels-loading').show();
    $('#print-labels-none').hide();
    $('#print-labels-error').hide();
    $('#print-labels-success').hide();
    $('#print-labels').modal('show');

    var query = 'ajax=1&action=printLabels&orderIds=' + orderIds.toString();
    $.ajax({
        type: 'POST',
        url: balikobot_ajax_url,
        cache: false,
        dataType: 'json',
        data: query,
        success : function(data)
        {
            if (data.errors)
            {
                var errors = '';
                $.each(data.errors, function (key, value) {
                    errors += value + '<br />';
                });
                $('#print-labels-error').html(errors);
                $('#print-labels-error').show();
            }
            else {
                var anyOrders = false;
                var odd = true;
                $.each(data, function (supplier, list) {
                    $.each(list, function (key, value) {
                        var classStr = '';
                        if (odd) {
                            classStr = 'class="odd"';
                        }
                        odd = !odd;
                        $('#labels-to-print tbody').append(
                            '<tr ' + classStr + '>' +
                            '<td>' + value.supplier + '</td>' +
                            '<td>' + value.name + '</td>' +
                            '<td class="text-center">' + value.count + '</td>' +
                            '<td><a href="' + value.labelsUrl + '" target="_blank"><i class="process-icon-save"></i></a></td>' +
                            '</tr>'
                        );
                        anyOrders = true;
                    });
                });
                if (anyOrders) {
                    $('#print-labels-success').show();
                }
                else {
                    $('#print-labels-none').show();
                }
            }
            $('#print-labels-loading').hide();
        }
    });
}

function modifyPackage(orderId) {
    var query = 'ajax=1&action=getPackageData&id_order=' + orderId;

    $.ajax({
        type: 'POST',
        url: balikobot_ajax_url,
        cache: false,
        dataType: 'json',
        data : query,
        success : function(data)
        {
            $('#modify-package-weight').val(data.weight);
            $('#modify-package-pieces').val('1');
            $('#modify-package-price').val(data.price);
            $('#modify-package').modal('show');
        }
    });
}

function trackPackage(orderId) {
    var query = 'ajax=1&action=trackPackage&id_order=' + orderId;

    $('#track-package').modal('show');
    $('#track-package-number').html('');
    $('#track-package-current-status').html('Načítání...');
    $('#track-package-events').html('');

    $.ajax({
        type: 'POST',
        url: balikobot_ajax_url,
        cache: false,
        dataType: 'json',
        data : query,
        success : function(data)
        {
            $('#track-package-number').html(data.number);
            $('#track-package-current-status').html(data.status);
            $.each(data.events, function(key, value){
                $('#track-package-events').append('<li>' + value + '</li>');
            });
        }
    });
}