<?php

require_once _PS_MODULE_DIR_ . 'monster_balikobot/config.php';
require_once _PS_MODULE_DIR_ . 'monster_balikobot/classes/API.php';
require_once _PS_MODULE_DIR_ . 'monster_balikobot/classes/Carrier.php';
require_once _PS_MODULE_DIR_ . 'monster_balikobot/classes/Order.php';
require_once _PS_MODULE_DIR_ . 'monster_balikobot/classes/Package.php';

class AdminOrdersController extends AdminOrdersControllerCore
{
    // add two buttons to the toolbar on orders list page
    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display) || $this->display == 'list') {
            $this->page_header_toolbar_btn['print_labels'] = array(
                'href' => '#print-labels',
                'desc' => $this->l('Tisk štítků', null, null, false),
                'icon' => 'process-icon-print icon-print'
            );

            $this->page_header_toolbar_btn['packages_order'] = array(
                'href' => '#packages-order',
                'desc' => $this->l('Odeslat data', null, null, false),
                'icon' => 'process-icon-ship icon-AdminParentShipping'
            );
        }
    }

    // add action buttons to each orders list row + pass numbers of packages to order into template
    public function renderList()
    {
        $this->addRowAction('printLabel');
        $this->addRowAction('printLabelModify');
        $this->addRowAction('dropPackage');
        $this->addRowAction('trackPackage');

        return parent::renderList();
    }

    // reactions to button clicks
    public function postProcess()
    {
        try {
            // order for all carriers
            if (Tools::isSubmit('submitObjednatSvoz')) {
                $result = BalikobotPackage::orderPackagesForAll();
                $this->context->smarty->assign([ 'balikobot_last_order' => $result ]);
            }

            // order for one carrier
            $submitOrderInfo = $this->getSubmitOrderInfo();
            if ($submitOrderInfo !== false) {
                $result = BalikobotPackage::orderPackagesForCarrier($submitOrderInfo['supplierId'], $submitOrderInfo['carrierCode']);
                $carrierName = BalikobotCarrier::getCarrierNameFromCode($submitOrderInfo['carrierCode']);
                $supplierName = Supplier::getNameById($submitOrderInfo['supplierId']);
                $this->context->smarty->assign([ 'balikobot_last_order' => [ $supplierName => [$carrierName => $result ]]]);
            }

            // print labels for selected orders
            if (Tools::isSubmit('submitPrintLabel'))
            {
                $orderId = Tools::getValue('orderId');
                $position = Tools::getValue('position');

                // set new package weight, if provided
                $weight = Tools::getValue('weight');
                if ($weight != '') {
                    BalikobotPackage::setWeight($orderId, $weight);
                }

                // set new package vat, if provided
                $vat = Tools::getValue('vat');
                if ($vat != '') {
                    BalikobotPackage::setVat($orderId, $vat);
                }

                // set new package price, if provided
                $price = Tools::getValue('price');
                if ($price != '') {
                    BalikobotPackage::setPrice($orderId, $price);
                }

                $package = new BalikobotPackage($orderId);

                // set new custom label text, if provided
                $labelText = Tools::getValue('label_text');
                if ($labelText != '') {
                    $package->label_text = $labelText;
                }

                // set new carrier package type, if provided
                $carrierPackageType = Tools::getValue('carrier_package_type');
                if ($carrierPackageType != '') {
                    $package->carrier_package_type = $carrierPackageType;
                }

                // set new packages number, if provided
                $pieces = Tools::getValue('pieces');
                if ($pieces != '') {
                    $package_pieces = $pieces;
                }
                else {
                    $package_pieces = 1;
                }

                // which label to print
                $piece = Tools::getValue('piece');
                if ($piece != '') {
                    $package_piece = $piece;
                }
                else {
                    $package_piece = 'all';
                }

                $labelUrl = $package->getLabelUrl($position, $package_pieces, $package_piece);
                Tools::redirect($labelUrl);
            }

            // drop package from Balikobot API
            if (Tools::getValue('action') == 'dropPackage') {
                BalikobotPackage::delete(Tools::getValue('id_order'));
                $this->context->cookie->bb_flash_message = 'Balík byl úspěšně odebrán z API Balíkobotu.';
                Tools::redirectAdmin('?controller=AdminOrders&token='.$this->token.'');
            }
        }
        catch(BalikobotAPIException $e)
        {
            foreach ($e->getMessageList() as $message)
            {
                $this->errors[] = Tools::displayError($message);
            }
        }

        if (isset($this->context->cookie->bb_flash_message)) {
            $this->confirmations[] = $this->context->cookie->bb_flash_message;
            unset($this->context->cookie->bb_flash_message);
        }

        parent::postProcess();
    }

    protected function getSubmitOrderInfo()
    {
        $carrierCodes = array_keys(BalikobotCarrier::$bb_carriers_list);
        $supplierIds = DB::getInstance()->executeS('SELECT DISTINCT supplier FROM '._DB_PREFIX_.'monster_balikobot_packages WHERE sent = 0');

        foreach($supplierIds as $supplierId){
            foreach ($carrierCodes as $carrierCode)
            {
                if (Tools::isSubmit('submitObjednatSvoz_'.$supplierId['supplier'] .'_'. $carrierCode))
                {
                    return ['supplierId' => $supplierId['supplier'], 'carrierCode' => $carrierCode];
                }
            }
        }

        return false;
    }

    public function displayPrintLabelModifyLink($token = null, $id, $name = null)
    {
        // show this button only if package is not in BB API
        $package = new BalikobotPackage($id);
        if (!empty($package->package_id))
        {
            return '';
        }

        $tpl = $this->context->smarty->createTemplate(
            _MONSTER_BALIKOBOT_VIEWS_DIR_ . 'templates/list/list_action_printlabel.tpl',
            $this->context->smarty
        );

        $package = new BalikobotPackage($id);
        $positionCount = $package->getLabelPositionCount();

        $tpl->assign(array(
            'href' => '#print-labelmodify-' . $id . '-' . $positionCount,
            'action' => 'Přidat balík s upřesněním',
            'id' => $id
        ));

        return $tpl->fetch();
    }

    public function displayPrintLabelLink($token = null, $id, $name = null)
    {
        $package = new BalikobotPackage($id);
        $title = 'Tisk štítku';
        if (empty($package->package_id))
        {
            $title = 'Přidat balík';
        }

        $tpl = $this->context->smarty->createTemplate(
            _MONSTER_BALIKOBOT_VIEWS_DIR_ . 'templates/list/list_action_printlabel.tpl',
            $this->context->smarty
        );

        $package = new BalikobotPackage($id);
        $positionCount = $package->getLabelPositionCount();
        $orderCount = $package->order_count;

        $tpl->assign(array(
            'href' => '#print-label-' . $id . '-' . $positionCount . '-' . $orderCount,
            'action' => $title,
            'id' => $id
        ));

        return $tpl->fetch();
    }

    public function displayDropPackageLink($token = null, $id, $name = null)
    {
        // show this button only if package is in BB API and was not ordered/sent yet
        $package = new BalikobotPackage($id);
        if (empty($package->package_id) || $package->sent)
        {
            return '';
        }

        $tpl = $this->context->smarty->createTemplate(
            _MONSTER_BALIKOBOT_VIEWS_DIR_ . 'templates/list/list_action_droppackage.tpl',
            $this->context->smarty
        );

        $tpl->assign(array(
            'href' => self::$currentIndex.'&action=dropPackage&id_order=' . (int)$id . '&token='.Tools::getAdminTokenLite('AdminOrders'),
            'action' => 'Smazání štítku',
            'id' => $id
        ));

        return $tpl->fetch();
    }

    public function displayTrackPackageLink($token = null, $id, $name = null)
    {
        // show this button only if package is in BB API and was already ordered/sent
        $package = new BalikobotPackage($id);
        if (empty($package->package_id) || !$package->sent)
        {
            return '';
        }

        $tpl = $this->context->smarty->createTemplate(
            _MONSTER_BALIKOBOT_VIEWS_DIR_ . 'templates/list/list_action_trackpackage.tpl',
            $this->context->smarty
        );

        $tpl->assign(array(
            'href' => '#track-package-' . $id,
            'action' => 'Sledovat balík',
            'id' => $id
        ));

        return $tpl->fetch();
    }
}