<!-- Block Balikobot -->
<script type="text/javascript" src="../modules/monster_balikobot/js/balikobot.js"></script>

<script type="text/javascript">
    $('document').ready(function(){
        function choosePackageClick(e) {
            e.preventDefault();
            var orderId = $('#choose-package input[name=orderId]').val();
            var positionCount = $('#choose-package input[name=positionCount]').val();
            var piece = $(this).attr('name').split('-')[1];
            $('#print-label input[name=piece]').val(piece);
            $('#choose-package').modal('hide');
            if (piece == 'all') {
                $('#print-label input[name=orderId]').val(orderId);
                $('button[name=submitPrintLabel]').click();
            }
            else {
                printLabel(orderId, positionCount);
            }
        }

        $('a[href="#packages-order"]').click(function(){
            packagesOrder();
        });

        $('#choose-package form').on('click', 'div button', choosePackageClick);

        $('a[href^="#print-label-"]').click(function(){
            var orderId = $(this).attr('href').split('-')[2];
            var positionCount = $(this).attr('href').split('-')[3];
            var orderCount = $(this).attr('href').split('-')[4];

            if (orderCount == 1) {
                $('#print-label input[name=weight]').val('');
                $('#print-label input[name=pieces]').val('');
                printLabel(orderId, positionCount);
            }
            else {
                choosePackage(orderId, orderCount, positionCount);
            }
        });

        $('a[href^="#print-labelmodify-"]').click(function(e){
            e.preventDefault();
            var orderId = $(this).attr('href').split('-')[2];
            var positionCount = $(this).attr('href').split('-')[3];
            $('#modify-package input[name=orderId]').val(orderId);
            $('#modify-package input[name=positions]').val(positionCount);
            modifyPackage(orderId);
        });

        $('button[name=submitModifyPackage]').click(function(e){
            e.preventDefault();
            $('#modify-package').modal('hide');

            // set changed package weight
            var weight = parseFloat($('#modify-package-weight').val());
            $('#print-label input[name=weight]').val(weight);

            // set changed packages count
            var pieces = parseInt($('#modify-package-pieces').val());
            $('#print-label input[name=pieces]').val(pieces);

            // monster edit - set vat status
            var vat = parseInt($('#modify-package-vat').val());
            $('#print-label input[name=vat]').val(vat);

			// monster edit - set vat status
			var price = parseFloat($('#modify-package-price').val());
			$('#print-label input[name=price]').val(price);

            var orderId = $('#modify-package input[name=orderId]').val();
            var positions = $('#modify-package input[name=positions]').val();

            if (pieces == 1) {
                // print label as if clicked on Print label button
                printLabel(orderId, positions);
            }
            else {
                choosePackage(orderId, pieces, positions);
            }
        });

        $('a[href="#print-labels"]').click(function(){
            var orders = new Array();
            $('input[name^=orderBox]').each(function(key, order){
                if (order.checked)
                {
                    orders.push($(order).val());
                }
            });
            printLabels(orders)
        });

        $('a[href^="#track-package-"]').click(function(){
            var orderId = $(this).attr('href').split('-')[2];
            trackPackage(orderId);
        });
    });
</script>

<div id="packages-order" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">Odeslat data</h3>
            </div>
            <div class="modal-body" style="text-align: center">
                <form method="post">
                    <div>
                        {if $balikobot_order['total'] > 0}
                            <h4>Celkem objednávek ve stavu <strong>Ke svozu: {$balikobot_order['total']}</strong></h4>
                            <button type="submit" class="btn btn-default" name="submitObjednatSvoz">
                                <i class="icon-truck"></i>
                                {l s='Odeslat data u všech dopravců'}
                            </button>
                        {else}
                            <h4>V systému nejsou žádné objednávky ke svozu.</h4>
                        {/if}
                    </div>
                    <div>
                        <p style="margin-top: 20px;">V případě, že chcete vybrat pouze konkrétního přepravce, klikněte
                            na jeden z níže uvedených odkazů.</p>
                        <table class="table balikobot" id="order-counts">
                            <thead>
                            <tr>
                                <th class="text-center">Sklad</th>
                                <th class="text-center">Přepravce</th>
                                <th class="text-center">Počet obj.</th>
                                <th class="text-center">Odeslat data</th>
                            </tr>
                            </thead>
                            <tbody>

                            {foreach $balikobot_order['expeditions'] as $supplier_code => $suppliers}
                                {foreach $suppliers as $carrier_code => $expedition name=orderCounts}

                                    <tr {if $smarty.foreach.orderCounts.iteration % 2 == 1}class="odd"{/if}>
                                        <td>{$expedition['supplier_name']}</td>
                                        <td>{$expedition['carrier_name']}</td>
                                        <td>{$expedition['count']}</td>
                                        <td>
                                            <button type="submit" class="btn btn-default" name="submitObjednatSvoz_{$supplier_code}_{$carrier_code}">
                                                <i class="icon-truck"></i>
                                                {l s='Odeslat data'}
                                            </button>
                                        </td>
                                    </tr>
                                {/foreach}
                            {/foreach}
                            </tbody>
                        </table>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

{if isset($balikobot_last_order)}
<script type="text/javascript">
    $('document').ready(function() {
        $('#packages-last-order').modal('show');
    });
</script>
<div id="packages-last-order" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">Data odeslána</h3>
            </div>
            <div class="modal-body" style="text-align: center">
                <div>
                    <p>
                        Byla odeslána data do systému přepravní služby.<br />
                        Níže naleznete odkazy pro jednotlivé soubory související se svozem.
                    </p>
                </div>
                <table class="table balikobot">
                    <thead>
                    <tr>
                        <th class="text-center">Sklad</th>
                        <th class="text-center">Přepravní společnost</th>
                        <th class="text-center">Předávací arch</th>
                        <th class="text-center">Štítky</th>
                    </tr>
                    </thead>
                    <tbody>

                    {foreach $balikobot_last_order as $supplier_name => $carriers name=lastOrder}
                        {foreach $carriers as $carrier_name => $order_carrier name=lastOrder}
                            {if !isset($order_carrier['error'])}
                            <tr>
                                <td>{$supplier_name}</td>
                                <td>{$carrier_name}</td>
                                <td class="text-center">
                                    {if isset($order_carrier['file_url'])}
                                        <a href="{$order_carrier['file_url']}" target="_blank"><strong>Datový soubor</strong></a><br />
                                    {/if}
                                    <a href="{$order_carrier['handover_url']}" target="_blank"><i class="process-icon-save"></i></a>
                                </td>
                                <td class="text-center"><a href="{$order_carrier['labels_url']}" target="_blank"><i class="process-icon-save"></i></a></td>
                            </tr>
                            {else}
                                <p style="color: red;">
                                    <strong>Chyba při odesílání dat do systému přepravní služby {$name}:</strong>
                                    <br />{$order_carrier['error']}
                                </p>
                            {/if}
                        {/foreach}
                    {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
{/if}

<div id="choose-package" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">Sdružená zásilka - výběr balíku</h3>
            </div>
            <div class="modal-body" style="text-align: center">
                <form method="post" target="_blank">
                    <div>
                        <button type="submit" class="btn btn-default btn-primary" name="buttonPrintPackage-all">
                            <i class="icon-print"></i>
                            {l s='Vytisknout štítky ke všem balíkům'}
                        </button>
                    </div>
                    <input type="hidden" name="orderId" value="" />
                    <input type="hidden" name="positionCount" value="" />
                </form>
            </div>
        </div>
    </div>
</div>

<div id="print-label" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">Tisk štítku</h3>
            </div>
            <div class="modal-body" style="text-align: center">
                <form method="post" target="_blank">
                    <button type="submit" class="btn btn-default" name="submitPrintLabel">
                        <i class="icon-print"></i>
                        {l s='Tisk štítku na celou stránku'}
                    </button>
                    <h4>Tisk štítku na pozici:</h4>
                    <div>
                        <div class="balikobot-printLabel-4">
                            <a href="#balikobot-printLabel-position-1">
                                <div class="balikobot-printLabel-position">
                                    1
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-2">
                                <div class="balikobot-printLabel-position">
                                    2
                                </div>
                            </a>
                            <div style="clear: both"></div>
                            <a href="#balikobot-printLabel-position-3">
                                <div class="balikobot-printLabel-position">
                                    3
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-4">
                                <div class="balikobot-printLabel-position">
                                    4
                                </div>
                            </a>
                            <div style="clear: both"></div>
                        </div>
                        <div class="balikobot-printLabel-8">
                            <a href="#balikobot-printLabel-position-1">
                                <div class="balikobot-printLabel-position">
                                    1
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-2">
                                <div class="balikobot-printLabel-position">
                                    2
                                </div>
                            </a>
                            <div style="clear: both"></div>
                            <a href="#balikobot-printLabel-position-3">
                                <div class="balikobot-printLabel-position">
                                    3
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-4">
                                <div class="balikobot-printLabel-position">
                                    4
                                </div>
                            </a>
                            <div style="clear: both"></div>
                            <a href="#balikobot-printLabel-position-5">
                                <div class="balikobot-printLabel-position">
                                    5
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-6">
                                <div class="balikobot-printLabel-position">
                                    6
                                </div>
                            </a>
                            <div style="clear: both"></div>
                            <a href="#balikobot-printLabel-position-7">
                                <div class="balikobot-printLabel-position">
                                    7
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-8">
                                <div class="balikobot-printLabel-position">
                                    8
                                </div>
                            </a>
                            <div style="clear: both"></div>
                        </div>
                    </div>
                    <input type="hidden" name="weight" value="" />
                    <input type="hidden" name="pieces" value="" />
                    <input type="hidden" name="piece" value="" />
                    <input type="hidden" name="position" value="" />
                    <input type="hidden" name="orderId" value="" />
					<!--monster edit-->
					<input type="hidden" name="vat" value="" />
					<input type="hidden" name="price" value="" />
                </form>
            </div>
        </div>
    </div>
</div>

<div id="modify-package" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">Upřesnění parametrů balíku</h3>
            </div>
            <div class="modal-body">
                <form method="post" target="_blank">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <label class="control-label col-lg-3">Váha balíku (kg):</label>
                            <div class="col-lg-3">
                                <input id="modify-package-weight" name="weight" type="text" />
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-lg-3">Počet kusů sdružené zásilky:</label>
                            <div class="col-lg-3">
                                <input id="modify-package-pieces" name="pieces" type="text" />
                            </div>
                        </div>

						<!--monster edit -->
						<div class="form-group">
						  <label class="control-label col-lg-3">Cena objednávky:</label>
							<div class="col-lg-3">
							  <select id="modify-package-vat" name="vat">
								<option value="1">s DPH</option>
								<option value="0">bez DPH</option>
							  </select>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3">Nebo vlastní cena:</label>
							<div class="col-lg-3">
								<input id="modify-package-price" name="price" type="text" />
							</div>
						</div>
						<!--monster edit -->


                        <button type="submit" class="btn btn-primary" name="submitModifyPackage">
                            Přidat balík
                        </button>
                        <input type="hidden" name="positions" value="" />
                        <input type="hidden" name="orderId" value="" />
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="print-labels" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">Hromadný tisk štítků</h3>
            </div>
            <div class="modal-body" style="text-align: center">
                <form method="post">
                    <div>
                        <p id="print-labels-success">
                            Byly úspěšně vygenerovány štítky pro vybrané objednávky.<br />
                            PDF soubory se štítky pro jednotlivé dopravce jsou dostupné
                            přes odkazy v následující tabulce:
                        </p>
                        <p id="print-labels-loading">
                            <strong>Načítání...</strong>
                        </p>
                        <p id="print-labels-none" style="color: red">
                            Nebyly vybrány žádné objednávky.<br />
                            Zaškrtněte, prosím, objednávky, ke kterým chcete vytisknout štítek
                            a klikněte znovu na tlačítko &quot;Tisk štítků&quot;.
                        </p>
                        <p id="print-labels-error" style="color: red">

                        </p>
                    </div>
                    <div>
                        <table class="table balikobot" id="labels-to-print">
                            <thead>
                                <tr>
                                    <th class="text-center">Sklad</th>
                                    <th class="text-center">Přepravce</th>
                                    <th class="text-center">Počet obj.</th>
                                    <th class="text-center">PDF se štítky</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="track-package" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">Detailní informace k zásilce č. <span id="track-package-number"></span></h3>
            </div>
            <div class="modal-body">
                <h4>Aktuální stav zásilky: <strong><span id="track-package-current-status"></span></strong></h4>
                <ul id="track-package-events">
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- /Block Balikobot -->
