<!-- Block Balikobot -->
<script type="text/javascript" src="../modules/monster_balikobot/js/balikobot.js"></script>

<script type="text/javascript">
    function choosePackageClick(e) {
        e.preventDefault();
        var piece = $(this).attr('name').split('-')[1];
        $('#print-label input[name=piece]').val(piece);
        $('#choose-package').modal('hide');
        if (piece == 'all') {
            $('#print-label input[name=orderId]').val({$balikobot_id_order});
            $('button[name=submitPrintLabel]').click();
        }
        else {
            printLabel({$balikobot_id_order}, {$balikobot_position_count});
        }
    }

    $('document').ready(function(){
        $('#choose-package form').on('click', 'div button', choosePackageClick);

        $('button[name="buttonPrintLabel"]').click(function(e){
            e.preventDefault();
            if ({$balikobot_pieces_count} == 1) {
                $('#print-label input[name=weight]').val('');
                $('#print-label input[name=pieces]').val('');

                // set custom label text
                var label_text = $('#monsterBalikobotCustomLabelText').val();
                $('#print-label input[name=label_text]').val(label_text);

                // set custom package type
                var carrier_package_type = $('#monsterBalikobotCarrierPackageType').val();
                $('#print-label input[name=carrier_package_type]').val(carrier_package_type);

                printLabel({$balikobot_id_order}, {$balikobot_position_count});
            }
            else {
                choosePackage({$balikobot_id_order}, {$balikobot_pieces_count});
            }
        });

        $('button[name="buttonPrintLabelModify"]').click(function(e){
            e.preventDefault();
            modifyPackage({$balikobot_id_order});
        });

        $('button[name=submitModifyPackage]').click(function(e){
            e.preventDefault();
            $('#modify-package').modal('hide');

            // set changed package weight
            var weight = parseFloat($('#modify-package-weight').val());
            $('#print-label input[name=weight]').val(weight);

            // set changed packages count
            var pieces = parseInt($('#modify-package-pieces').val());
            $('#print-label input[name=pieces]').val(pieces);

            // set custom label text
            var label_text = $('#monsterBalikobotCustomLabelText').val();
            $('#print-label input[name=label_text]').val(label_text);

            // set custom package type
            var carrier_package_type = $('#monsterBalikobotCarrierPackageType').val();
            $('#print-label input[name=carrier_custom_type]').val(carrier_package_type);

            if (pieces == 1) {
                // print label as if clicked on Print label button
                printLabel({$balikobot_id_order}, {$balikobot_position_count});
            }
            else {
                choosePackage({$balikobot_id_order}, pieces);
            }
        });

        $('button[name=submitSledovatBalik]').click(function(e){
            e.preventDefault();
            trackPackage({$balikobot_id_order});
        });
    });
</script>

<div id="mymodule_block_ship" class="block">
    <h4>Balíkobot</h4>
    <form method="post">
        {if $balikobot_in_api}
            <input type="text" value="{$balikobot_label_text}" disabled />
            <br/>
            {if $balikobot_carrier_code == 'toptrans'}
                {l s='Zvolený typ zásilky pro balík TopTrans:'} {$balikobot_carrier_package_type}
                <br/>
            {/if}
        {else}
            <input type="text" id="monsterBalikobotCustomLabelText" value="{$balikobot_label_text}" placeholder="{l s='Poznámka přepravci. Bude zkrácena podle možností přepravce.'}" />
            <br/>
            {if $balikobot_carrier_code == 'toptrans'}
                <select id="monsterBalikobotCarrierPackageType">
                    {foreach $balikobot_toptrans_types as $type}
                        <option value="{$type['name']}" {if $balikobot_carrier_package_type == $type['name']}selected{/if}>{$type['name']}</option>
                    {/foreach}
                </select>
            {/if}
        {/if}
        <br/>
        {if $balikobot_in_api}
            <button class="btn btn-default" name="buttonPrintLabel">
                <i class="icon-print"></i>
                {l s='Tisk štítku'}
            </button>
        {else}
            <button class="btn btn-default" name="buttonPrintLabel">
                <i class="icon-print"></i>
                {l s='Přidání balíku'}
            </button>
            <button class="btn btn-default" name="buttonPrintLabelModify">
                <i class="icon-print"></i>
                {l s='Přidání balíku s upřesněním'}
            </button>
        {/if}
        {if $balikobot_in_api && !$balikobot_is_sent}
            <button type="submit" class="btn btn-default" name="submitSmazaniStitku">
                <i class="icon-trash"></i>
                {l s='Smazání štítku'}
            </button>
        {/if}
        {if $balikobot_in_api && $balikobot_is_sent}
            <button class="btn btn-default" name="submitSledovatBalik">
                <i class="icon-truck"></i>
                {l s='Sledovat balík'}
            </button>
        {/if}
        <br/><br/>

    </form>
</div>

<div id="choose-package" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">{l s='Sdružená zásilka - výběr balíku'}</h3>
            </div>
            <div class="modal-body" style="text-align: center">
                <form method="post" target="_blank">
                    <div>
                    <button type="submit" class="btn btn-default btn-primary" name="buttonPrintPackage-all">
                        <i class="icon-print"></i>
                        {l s='Vytisknout štítky ke všem balíkům'}
                    </button>
                    </div>
                    <input type="hidden" name="orderId" value="" />
                </form>
            </div>
        </div>
    </div>
</div>

<div id="print-label" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">{l s='Tisk štítku'}</h3>
            </div>
            <div class="modal-body" style="text-align: center">
                <form method="post" target="_blank">
                    <button type="submit" class="btn btn-default" name="submitPrintLabel">
                        <i class="icon-print"></i>
                        {l s='Tisk štítku na celou stránku'}
                    </button>
                    <h4>{l s='Tisk štítku na pozici:'}</h4>
                    <div>
                        <div class="balikobot-printLabel-4">
                            <a href="#balikobot-printLabel-position-1">
                                <div class="balikobot-printLabel-position">
                                    1
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-2">
                                <div class="balikobot-printLabel-position">
                                    2
                                </div>
                            </a>
                            <div style="clear: both"></div>
                            <a href="#balikobot-printLabel-position-3">
                                <div class="balikobot-printLabel-position">
                                    3
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-4">
                                <div class="balikobot-printLabel-position">
                                    4
                                </div>
                            </a>
                            <div style="clear: both"></div>
                        </div>
                        <div class="balikobot-printLabel-8">
                            <a href="#balikobot-printLabel-position-1">
                                <div class="balikobot-printLabel-position">
                                    1
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-2">
                                <div class="balikobot-printLabel-position">
                                    2
                                </div>
                            </a>
                            <div style="clear: both"></div>
                            <a href="#balikobot-printLabel-position-3">
                                <div class="balikobot-printLabel-position">
                                    3
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-4">
                                <div class="balikobot-printLabel-position">
                                    4
                                </div>
                            </a>
                            <div style="clear: both"></div>
                            <a href="#balikobot-printLabel-position-5">
                                <div class="balikobot-printLabel-position">
                                    5
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-6">
                                <div class="balikobot-printLabel-position">
                                    6
                                </div>
                            </a>
                            <div style="clear: both"></div>
                            <a href="#balikobot-printLabel-position-7">
                                <div class="balikobot-printLabel-position">
                                    7
                                </div>
                            </a>
                            <a href="#balikobot-printLabel-position-8">
                                <div class="balikobot-printLabel-position">
                                    8
                                </div>
                            </a>
                            <div style="clear: both"></div>
                        </div>
                    </div>
                    <input type="hidden" name="weight" value="" />
                    <input type="hidden" name="pieces" value="" />
                    <input type="hidden" name="piece" value="" />
                    <input type="hidden" name="label_text" value="" />
                    <input type="hidden" name="carrier_package_type" value="" />
                    <input type="hidden" name="position" value="" />
                    <input type="hidden" name="orderId" value="" />
                </form>
            </div>
        </div>
    </div>
</div>

<div id="modify-package" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">{l s='Upřesnění parametrů balíku'}</h3>
            </div>
            <div class="modal-body">
                <form method="post" target="_blank">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <label class="control-label col-lg-3">{l s='Váha balíku (kg):'}</label>
                            <div class="col-lg-2">
                                <input id="modify-package-weight" name="weight" type="text" />
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-lg-3">{l s='Počet kusů sdružené zásilky:'}</label>
                            <div class="col-lg-2">
                                <input id="modify-package-pieces" name="pieces" type="text" />
                            </div>
                        </div>
						<!--monster edit -->
						<div class="form-group">
							<label class="control-label col-lg-3">{l s='Cena objednávky:'}</label>
							<div class="col-lg-3">
								<select id="modify-package-vat" name="vat">
									<option value="1">{l s='s DPH'}</option>
									<option value="0">{l s='bez DPH'}</option>
								</select>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3">{l s='Nebo vlastní cena:'}</label>
							<div class="col-lg-3">
								<input id="modify-package-price" name="price" type="text" />
							</div>
						</div>
						<!--monster edit -->
                        <button type="submit" class="btn btn-primary" name="submitModifyPackage">
                            {l s='Přidat balík'}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="track-package" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h3 class="modal-title">{l s='Detailní informace k zásilce č.'} <span id="track-package-number"></span></h3>
            </div>
            <div class="modal-body">
                <h4>{l s='Aktuální stav zásilky:'} <strong><span id="track-package-current-status"></span></strong></h4>
                <ul id="track-package-events">
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- /Block Balikobot -->