/*
 ********************* ADC (page 413) ********************
 * ADC->DBxRH / ADC_DRH: 9:2 data bits in left-aligned or 9:8 bits in right-aligned mode
 * ADC->DBxRL / ADC_DRL: 1:0 data bits in left-aligned or 7:0 bits in right-aligned mode
 * ADC->CSR: | EOC | AWD | EOCIE | AWDIE | CH[3:0] |
 * 		EOC: End of conversion
 * 		AWD: Analog Watchdog flag
 * 		EOCIE: Interrupt enable for EOC
 * 		AWDIE: Analog watchdog interrupt enable
 * 		CH[3:0]: Channel selection bits (0..15)
 * ADC->CR1: | - | SPSEL[2:0] | - | - | CONT | ADON |
 * 		SPSEL[2:0]: Prescaler selection
 * 		CONT: Continuous conversion (0 for single)
 * 		ADON: A/D Converter on/off   <----------------------------------------
 * ADC->CR2: | - | EXTTRIG | EXTSEL[1:0] | ALIGN | - | SCAN | - |
 * 		EXTTRIG: External trigger enable
 * 		EXTSEL[1:0]: External event selection
 * 		ALIGN: Data alignment (1 - right alignment, first read ADC->DRL)
 * 		SCAN: Scan mode enable
 * ADC->CR3: | DBUF | OVR | reserved[5:0] |
 * 		DBUF: Data buffer enable (on buffered mode data stored not in ADC->DBhl but in ADC->DBxRhl)
 * 		OVR: Overrun flag
 * ADC->TDRH/L - trigger shmidt disable (1 - disable)
 */

#include "adc.h"
//-----------------------------------------------------------------------------------
uint8_t flgADCend;

uint8_t  state_Tk;
uint16_t state_Pk;
uint16_t state_Pkm1;
uint16_t state_Uk;
uint16_t state_Ukm1;
uint16_t state_Ik;
uint16_t state_Ikm1;
uint32_t state_Wus = 0;
uint16_t state_Ws = 0;
uint16_t state_Wh = 0;

uint16_t state_adcTk;
uint16_t state_rawTk;
uint16_t state_adcUk;
uint16_t state_rawUk;
uint16_t state_rawUkm1;
uint16_t state_adcIk;
uint16_t state_rawIk;
uint16_t state_rawIkm1;
//-----------------------------------------------------------------------------------
void ADCstart(void)
{
    ADC1->CR1 = 0x01;	// f/2  & non-continuous & non-buffered conversion & wake it up & turn on ADC (second write operation for start conversion)
//  ADC1->CR1 = 0x71;	// f/18 & non-continuous & non-buffered conversion & wake it up & turn on ADC (second write operation for start conversion)
}
//-----------------------------------------------------------------------------------
void ADCstop(void)
{
	ADC1->TDRL = 0b10000111;    // disable Schmitt triger for lowers the power consumption
	ADC1->CSR  = 0x00;	// desable interrupt
	ADC1->CR1  = 0x00;	// turn off ADC
//	ADC1->CR2  = 0x08;	// ALIGN 1
}
//-----------------------------------------------------------------------------------
void ADCconfig(void)
{
	ADCstop();
}
//-----------------------------------------------------------------------------------
/*void ADCchannel(uint8_t channel)
{
//	ADC1->CSR  &= (0x20 + channel);	// enabled interrupt for EOC and select AIN input
	ADC1->CSR   = channel;	// select AIN input
}*/
//-----------------------------------------------------------------------------------
/*
void ADCtriger(uint8_t channel)
{
	ADC1->TDRL &= ~channel;	// enable Schmitt triger for channel
}
*/
//-----------------------------------------------------------------------------------
uint16_t ADCread(uint8_t channel)
{
	uint16_t ADCvalue = 0;

//	ADCchannel(channel);
	ADC1->CSR   = channel;	// select AIN input
//	ADCtriger(0);
	ADCstart();
	while(!(ADC1->CSR & ADC1_CSR_EOC));
	// ALIGN 1
//	ADCvalue  = ADC1->DRL; // in right-alignment mode we should first read LSB
//	ADCvalue |= ADC1->DRH << 8;
	// ALIGN 0
	ADCvalue  = ADC1->DRL; // in left-alignment mode we should first read LSB
	ADCvalue += ADC1->DRH << 2;
	ADC1->CSR &= 0x3f; // clear EOC & AWD flags
	return(ADCvalue);
}
//-----------------------------------------------------------------------------------
void ADCinterupt(void)
{
	state_adcIk = ADCread(4);
	state_adcUk = ADCread(3);
	state_adcTk = ADCread(6) / 10;
	if(state_adcIk <= system8.ADCzeroI) state_adcIk = 0;
	else state_adcIk -= system8.ADCzeroI;
}
//-----------------------------------------------------------------------------------
void ADCfirst(void)
{
    delay(100);
    state_rawIk = state_adcIk;
    state_rawUk = state_adcUk;
    state_rawTk = state_adcTk;
}
//-----------------------------------------------------------------------------------
void ADCvalue(void)
{
	uint8_t l;

//  Klouzavý průměr
//  y[0] = (x[0] + y[-1]) / 2;
//  y[0] = (x[0] + y[-1] * (a-1) ) / a
//  y[0] = (x[0] + ((y[-1] << a) - y[-1])) >> a

    state_rawIk = (state_adcIk + (state_rawIk << system8.ADCdivI) - state_rawIk) >> system8.ADCdivI;
    state_rawUk = (state_adcUk + (state_rawUk << system8.ADCdivU) - state_rawUk) >> system8.ADCdivU;
    if(delayADC == 0) {
       #ifdef PCB9
        if(state_PWM < 20 || state_PWM > 40) state_rawTk = (state_adcTk + state_rawTk) / 2;
       #else
        state_rawTk = (state_adcTk + state_rawTk) / 2;
       #endif
        delayADC = 1000 >> 1;
    }

    l = (uint8_t)state_rawTk;
//  if(l < 5)   state_Tk = 118;           else      // > 118
//  if(l < 10)  state_Tk = 132 - (l * 5); else      // 107 až 87
    if(l < 14)  state_Tk = 114 - (l * 3); else      //  84 až 75
    if(l < 26)  state_Tk = 100 - (l * 2); else      //  72 až 50
    if(l < 75)  state_Tk =  75 - l;       else      //  49 až  1
    state_Tk = 0;                                   // < 0
/*
    if(l < 80)  state_Tk =   0;           else      //   0
    if(l < 88)  state_Tk =  79 - l;       else      //  -1 až -8
    if(l < 96)  state_Tk = 166 - (l * 2); else      // -10 až -24
    if(l < 100) state_Tk = 261 - (l * 3); else      // -27 až -36
    state_Tk = -43;                                 // < -43
*/
   #ifdef PCB9
    if(rezim >= 2 && state_PWM < 50 && state_rawIk < 50) state_Ik = 0; else
   #endif
    state_Ik = (uint16_t)(((uint32_t)state_rawIk * (uint32_t)IcalCON)  / (uint32_t)conIcal);
    state_Uk = (uint16_t)(((uint32_t)state_rawUk * (uint32_t)UcalCON)  / (uint32_t)conUcal);
	state_Pk = (uint16_t)(((uint32_t)state_Ik    * (uint32_t)state_Uk) / (uint32_t)1000);
	
    if(state_PWM == 0) return;
    state_Wus += (uint32_t)state_Pk * (uint32_t)state_PWM;
    state_Ws  += (uint16_t)(state_Wus / 1000000);
    state_Wus  = (uint32_t)(state_Wus % 1000000);
    state_Wh  += state_Ws / 3600;
    state_Ws   = state_Ws % 3600;
}
//-----------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------
// This function returns the Arduino's own Vcc - this is necessary for accurately reading voltages 
// Taken from https://code.google.com/p/tinkerit/wiki/SecretVoltmeter
//------------------------------------------------------------------------------------------------------
/*
uint16_t readVcc(uint8_t channel) {
  long result;
  result = ADCread(channel);
  result = 503630L / result; // Back-calculate AVcc in mV
//  result = 17902500L / result; // Back-calculate AVcc in mA
  return (uint16_t)result;
}
*/
//------------------------------------------------------------------------------------------------------
// This routine reads and averages the analog inputs for this system, solar volts, solar amps and 
// battery volts. It is called with the adc channel number (pin number) and returns the average adc 
// value as an integer. 
//------------------------------------------------------------------------------------------------------
/*
uint16_t read_adc(uint16_t channel){

  uint32_t sum = 0;
  uint16_t temp;
  uint16_t i;
  uint8_t AVG_NUM = 100;

  for (i=0; i<AVG_NUM; i++) {            // loop through reading raw adc values AVG_NUM number of times  
    temp = ADCread(channel);          // read the input pin  
    sum += temp;                        // store sum for averaging
    delay(1);              // pauses for 50 microseconds  
  }
  return(sum / AVG_NUM);                // divide sum by AVG_NUM to get average and return it
}
*/
