#include "eeprom.h"
#include <string.h>
#include <stdio.h>
//-----------------------------------------------------------------------------------
uint16_t state_Whkm1 = 0;
//-----------------------------------------------------------------------------------
inline void EEPROMunlock(void)
{
	// Enable the flash data writing
	FLASH->DUKR = 0xAE;
	FLASH->DUKR = 0x56;
	while (!(FLASH->IAPSR & FLASH_IAPSR_DUL));
//	while ((FLASH->IAPSR & FLASH_IAPSR_EOP) == 0);
}
//-----------------------------------------------------------------------------------
inline void EEPROMlock(void)
{
	while (!(FLASH->IAPSR & FLASH_IAPSR_EOP));
	FLASH->IAPSR &= ~FLASH_IAPSR_DUL;
}
//-----------------------------------------------------------------------------------
/*
void EEPROMdata(uint16_t *address, uint8_t data8, uint16_t data16)
{
	disableInterrupts();
	EEPROMunlock();
	*address = '\0';
	if(data8)  *(( uint8_t*)(uint16_t)address) = *(( uint8_t*)(&( uint8_t)data8));
	if(data16) *((uint16_t*)(uint16_t)address) = *((uint16_t*)(&(uint16_t)data16));
	EEPROMlock();
	enableInterrupts();
}
*/
//-----------------------------------------------------------------------------------
void EEPROMdata16(uint16_t *address, uint16_t data)
{
	disableInterrupts();
	EEPROMunlock();
//	*address = '\0';
	*((uint16_t*)(uint16_t)address) = *((uint16_t*)(&(uint16_t)data));
	EEPROMlock();
	enableInterrupts();
}
//-----------------------------------------------------------------------------------
void EEPROMdata8(uint8_t *address, uint8_t data)
{
	disableInterrupts();
	EEPROMunlock();
//	*address = '\0';
	*((uint8_t*)(uint16_t)address) = *((uint8_t*)(&(uint8_t)data));
	EEPROMlock();
	enableInterrupts();
}
//--------------------------------------------------------------------------------
//
//  Verify that the data in the EEPROM is the same as the data we
//  wrote originally.
//
//uint8_t readEEPROMdata(uint16_t address)
//{
//	char *adr = (char *) address;
//    return(*adr);
//}
//--------------------------------------------------------------------------------
void EEPROMsave(void)
{
    uint8_t flgSAVE = 0;

    if(system8.mode <= 1) return;
    if(state_Wh > state_Whkm1) {
        energieWh += (uint32_t)(state_Wh - state_Whkm1);
        EEPROMdata16((uint16_t *)(EEP_Emsb),(uint16_t)(energieWh >> 16));
        EEPROMdata16((uint16_t *)(EEP_Elsb),(uint16_t)(energieWh));
        state_Whkm1 = state_Wh;
        flgSAVE = 1;
    }
    if(state_Unap > system16.Unap)
    {
        EEPROMdata16((uint16_t *)(EEP_Unap),state_Unap);
        UARTprintF((uint16_t *)textUn);
        flgSAVE = 1;
        if(system8.mode >= 4) {
            eprom_Ureg = state_Unap * system16.Uodh / 100;
            if(eprom_Ureg < system16.Uzap) eprom_Ureg = system16.Uzap * 100 / system16.Uodh;
        }
    }
    if(system8.mode == 3) eprom_Ureg = state_Ureg;
    if(eprom_Ureg != system16.Ureg) {
        EEPROMdata16((uint16_t *)(EEP_Ureg),eprom_Ureg);
        UARTprintF((uint16_t *)textUr);
        flgSAVE = 1;
    }
    if(state_Pmax > system16.Pmax) {EEPROMdata16((uint16_t *)(EEP_Pmax),state_Pmax); flgSAVE = 1;}
    if(state_Imax > system16.Imax) {EEPROMdata16((uint16_t *)(EEP_Imax),state_Imax); flgSAVE = 1;}
    if(state_Tmax > system16.Tmax) {EEPROMdata16((uint16_t *)(EEP_Tmax),state_Tmax); flgSAVE = 1;}
    if(flgSAVE == 1) {
        UARTprintF((uint16_t *)textSave);
        CONFread();
        CONFprint();
    }
}
//--------------------------------------------------------------------------------
/*
void testEEPROMafr(void)
{
	uint8_t OPTcon;
#ifndef SG3525
	OPTcon = 0x91; // ARF7 ARF4 ARF0
#endif
#ifdef SG3525
	OPTcon = 0x00;
#endif

	if (OPT->OPT2 != OPTcon) {
		if (setEEPROMafr(OPTcon)) {
			UARTprintF("AFR set\n");
			IWDGinit(0x00); // Time out 16 ms
			while (1); // Force a reset in a few msec
		}
		else {
			UARTprintF("AFR failed\n");
		}
	}
}
//--------------------------------------------------------------------------------
uint8_t setEEPROMafr(uint8_t opt)
{
	uint8_t sr;
	uint16_t timeout;

	EEPROMunlock();

	FLASH->CR2  =  FLASH_CR2_OPT;   // Set the OPT bit
	FLASH->NCR2 = ~FLASH_NCR2_NOPT; // Remove the NOPT bit

	OPT->OPT2  =  opt;
	OPT->NOPT2 = ~opt;
	for (timeout = 0xFFFF; timeout > 0; timeout--) 
	{
		sr = FLASH->IAPSR;
		if (sr & FLASH_IAPSR_EOP) break;
	}

	if (sr & FLASH_IAPSR_WR_PG_DIS) timeout = 0; // This will report failure

	FLASH->CR2  &= FLASH_CR2_OPT;
	FLASH->NCR2 |= FLASH_NCR2_NOPT;
	EEPROMlock();
	return (timeout > 0) && (OPT->OPT2 == opt);
}
*/
//-----------------------------------------------------------------------------------

