/*
 ********************* External interrupts (page 69) ********************
 * EXTI_CR1: | PDIS[1:0] | PCIS[1:0] | PBIS[1:0] | PAIS[1:0] |
 * 		per-port sensivity bits:
 * 			00: Falling edge and low level
 * 			01: Rising edge only
 * 			10: Falling edge only
 * 			11: Rising and falling edge
 * EXTI_CR2: | -reserved[7:3]- | TLIS | PEIS[1:0] |
 * 		TLIS: Top level interrupt sensitivity (0: Falling edge, 1 - Rising)
 * 		PEIS[1:0]: Port E external interrupt sensitivity bits
 * after config run enableInterrupts()
 * ports:
 * 		5 lines on Port A: PA[6:2]
 * 		8 lines on Port B: PB[7:0]
 * 		8 lines on Port C: PC[7:0]
 * 		7 lines on Port D: PD[6:0]
 * 		8 lines on Port E: PE[7:0]
 * 	PD7 is the Top Level Interrupt source (TLI), except for 20-pin packages
 * 		on which the Top Level Interrupt source (TLI) can be available on the
 * 		PC3 pin using an alternate function remapping option bit
 ********************* GPIO (page 111) ********************
 * Px_ODR - Output data register bits
 * Px_IDR - Pin input values
 * Px_DDR - Data direction bits (1 - output)
 * Px_CR1 - DDR=0: 0 - floating, 1 - pull-up input; DDR=1: 0 - pseudo-open-drain, 1 - push-pull output [not for "T"]
 * Px_CR2 - DDR=0: 0/1 - EXTI disabled/enabled; DDR=1: 0/1 - 2/10MHz
 *
 */
// ---------------------------------------------
// vyuziti vstupu/vystupu
// ---------------------------------------------
// PD4 - BRK led             PD3 - IFB
// PD5 - TX                  PD2 - VFB
// PD6 - RX/NTC              PD1 - WAR led
// RST - RST                 PC7 - H2
// PA1 - tl +                PC6 - H1
// PA2 - tl -                PC5 - PWM led
// GND                       PC4 - L2
// 5V                        PC3 - L1
// 3V3                       PB4 - RELE out
// PA3 - FAN out             PB5 - BFB in
//-----------------------------------------------------------------------------------
#include "gpio.h"
#ifdef uartNTC
#include <math.h>
#endif
//-----------------------------------------------------------------------------------
//#define uartNTC	1
//#define offBRKwatchdog			 		//vypíná watchdog v break 
//-----------------------------------------------------------------------------------
uint8_t ledWARcnt = 0;
uint8_t ledWARflag = 0;
uint8_t ledWARtick = 0;
uint8_t ledBRKcnt = 0;
uint8_t ledBRKflag = 0;
uint8_t ledBRKlast = 0;
uint8_t ledBRKtick = 0;
uint8_t ledPWMcnt = 0;
uint8_t ledPWMflag = ledPWMconOFF;
uint8_t ledPWMtick = 0;
uint8_t outRELE = 0;
//-----------------------------------------------------------------------------------
/*
void LSIconfig(void)
{
    CLK->ICKR = 0b00001000;                        //  Enable the LSI.
    while ((CLK->ICKR & CLK_ICKR_LSIRDY) == 0);    //  Wait for the LSI to be ready for use.
    CLK->CKDIVR = 0b00011111;                      //  Ensure the clocks are running at full speed.
    CLK->SWR = 0xd2;                              //  Use LSI as the clock source.
    CLK->SWCR = 0b00000010;                       //  Enable switching.
    while ((CLK->SWCR & CLK_SWCR_SWBSY) != 0);    //  Pause while the clock switch is busy.
}
*/
//-----------------------------------------------------------------------------------
void HSIconfig(void)
{
//    CLK->ICKR = 0b00000001;                        //  Enable the HSI.
//    while ((CLK->ICKR & CLK_ICKR_HSIRDY) == 0);    //  Wait for the HSI to be ready for use.
      CLK->CKDIVR = 0x00;                            //  Set the frequency to 16 MHz
//    CLK->SWR = 0xe1;                               //  Use HSI as the clock source.
//    CLK->SWCR = 0b00000010;                        //  Enable switching.
//    while ((CLK->SWCR & CLK_SWCR_SWBSY) != 0);     //  Pause while the clock switch is busy.
}
//-----------------------------------------------------------------------------------
void AWUconfig(void)
{
  /* Enable the AWU peripheral */
  AWU->CSR |= AWU_CSR_AWUEN;
  
  /* Set the TimeBase */
  AWU->TBR = AWU_TBR_AWUTB;
//  AWU->TBR &= (uint8_t)(~AWU_TBR_AWUTB);
//  AWU->TBR |= TBR_Array[(uint8_t)AWU_TimeBase];
  
  /* Set the APR divider */
  AWU->APR = 0x15;// 0x0f~6s 0x40~30s
//  AWU->APR &= (uint8_t)(~AWU_APR_APR);
//  AWU->APR |= APR_Array[(uint8_t)AWU_TimeBase];
}
//-----------------------------------------------------------------------------------
void GPIOconfig(void)
{
//	CLK->CKDIVR = 0x00; // Set the frequency to 16 MHz
//	CLK->PCKENR1 = 0xFF; // Enable peripherals

//  PIN input
//	PA->ODR = 0;
//	PA->DDR = 0;
//	PA->CR1 |= GPIO1;	// tlacitko +  - nastaví na vstupu pull-up
//	PA->CR1 |= GPIO2;	// tlacitko -  - nastaví na vstupu pull-up
//	PA->CR1 = 0b00000110; // TL-, TL+ - nastaví na vstupu pull-up
//	PA->CR2 = 0;

	// PD  0 NTC/RX TX BRK 0 0 WAR 0
    PD->ODR = 0b00010010; // nastaví hodnotu výstupu
    PD->CR1 = 0b00010010; // 1 - pull-up/push-pull
    PD->DDR = 0b00010010; // 0 - vstup / 1 - výstup

	// PC  H2 H1 PWM L2 L1 0 0 0
   #ifdef HHO     // pouze L1 s IR2101
    PC->ODR = 0b00100000; // nastaví hodnotu výstupu
    PC->CR1 = 0b00110000; // 1 - pull-up/push-pull
    PC->DDR = 0b00110000; // 0 - vstup / 1 - výstup
   #else          // H1L1 a H2L2 pro IR2101
    PC->ODR = 0b00100000; // nastaví hodnotu výstupu
    PC->CR1 = 0b11111000; // 1 - pull-up/push-pull
    PC->DDR = 0b11111000; // 0 - vstup / 1 - výstup
   #endif

	// PB  0 0 BFB RELE 0 0 0 0
    PB->ODR = 0b00010000; // 0 - výstup low; 1 - výstup high
    PB->DDR = 0b00010000; // 0 - vstup; 1 - výstup
//  PB->CR1 = 0b00010000; // 1 - pull-up/push-pull; 0 - open drain

	// PA  0 0 0 0 FAN TL- TL+ 0
//	PA->ODR = 0b00000000; // nastaví hodnotu výstupu
    PA->DDR = 0b00001000; // 0 - vstup / 1 - výstup
    PA->CR1 = 0b00001110; // 1 - pull-up/push-pull
/*
	// LED BRK output
	ledBRKoff;
	ledBRKpool;
	ledBRKinit;

	// LED pwm output
	ledPWMoff;
	ledPWMpool;
	ledPWMinit;

	// LED WAR output
	ledWARoff;
	ledWARpool;
	ledWARinit;

	// FAN output
	outFANoff;
	outFANinit;
//	outFANpool;
*/
}
//-----------------------------------------------------------------------------------
void ledWARinterrupt(void)
{
    // ovladani led warning
    if(ledWARflag > ledWARconMAX) ledWARon;
    else if(ledWARflag)
    {
        if(ledWARtick == 0)
        {
            ledWARinverse;
            ledWARtick = ledWARconTICK;
        }
        else ledWARtick--;
    }
    else ledWARoff;
}
//-----------------------------------------------------------------------------------
void ledBRKinterrupt(void)
{
    uint8_t ledBRKtemp;
    
    if(ledBRKflag  == ledBRKconOFF) {ledBRKoff; ledBRKcnt = ledBRKconMAX; return;}
    if(ledBRKflag  == ledBRKconON)  {ledBRKon;  ledBRKcnt = ledBRKconMAX; return;}
    if(ledBRKtick-- != 0) return;
    ledBRKtick = ledBRKconTICK;
    if(ledBRKcnt   >= ledBRKconMAX) {ledBRKcnt = 0; ledBRKlast = ledBRKflag;}
    ledBRKtemp = ledBRKlast & 0x0f;
    if(ledBRKtemp  >  ledBRKcnt)    {
        ledBRKport->ODR = (ledBRKport->ODR & (~(1 << ledBRKpin))) | ((ledBRKcnt & 1) << ledBRKpin);
        if((ledBRKlast & GPIO7) != 0) ledBRKinverse;
    }
    ledBRKcnt++;
}
//-----------------------------------------------------------------------------------
void ledPWMinterrupt(void)
{
    if(ledPWMtick-- != 0) return;
    ledPWMtick = ledPWMconTICK;
    if(ledPWMflag == ledPWMconOFF) {ledPWMoff; return;}
    if(ledPWMflag == ledPWMconON)  {ledPWMon;  return;}
    if(ledPWMcnt != 0)             {ledPWMcnt--; return;}
    if(rezim == 9 || inPWMled == 0) ledPWMcnt = ledPWMflag;
    ledPWMinverse;
}
//-----------------------------------------------------------------------------------
void ledPWMset(void)
{
    uint16_t a, b, c;
    if(system8.ledP == 0) return;
    a = 1; b = state_PWMtop; c = state_PWM;
    if(system8.ledP == 2) {a = 10; b = conPmax; c = state_Pk;}
    if(system8.ledP == 3) {a = 50; b = conImax; c = state_Ik;}
    ledPWMflag = prepocet(a, ledPWMconOFF, b, ledPWMconON, c);
}
//-----------------------------------------------------------------------------------
void ledBRKset(void)
{
    // blikání led v test módu pro vyhodnocení Izero
    if(rezim == 0 && state_PWM == 0) {
        ledBRKflag = (((uint8_t)(state_rawIk >> 2) + 1) << 1);
        return;
    }
    // nastavení ledBRK podle omezování PWM
    if(state_PWMmax == state_PWMtop) ledBRKflag = ledBRKconOFF;
    else ledBRKflag = prepocet(0, ledBRKconMAX, state_PWMtop, 1, state_PWMmax) & (uint8_t)(~1);
}
//-----------------------------------------------------------------------------------
void releSET(void)
{
    // ovládání relé podle výkonu
    if(delayRELE != 0) return;
    if(inRELE != outRELE) outRELEinverse;
    if(state_Pk > system16.releH) outRELE = 1;
    if(state_Pk < system16.releL) outRELE = 0;
    if(inRELE != outRELE) delayRELE = 120000 >> 1;
}
//-----------------------------------------------------------------------------------
void fanSET(void)
{
    if(system8.mode == 0) {
        if(delayRELE != 0) return;
        TIM2->CCER2 ^= 0b00000011;	//	x		x		x		x		x		x		CC3P	CC3E
        outRELEinverse;
        delayRELE = 1000 >> 1;
    } else
    if(state_Tk > system16.Tzap) {
//        TIM2->CCR3L = (uint8_t)state_Tk;
        TIM2->CCER2 = 0b00000001;	//	x		x		x		x		x		x		CC3P	CC3E
    }
    else TIM2->CCER2 = 0b00000000;	//	x		x		x		x		x		x		CC3P	CC3E

}
//-----------------------------------------------------------------------------------
void brk(uint8_t type)
{
    disableInterrupts();                // smaže vektory přerušení
	TIM1->BKR   = 0b10000100;           //	MOE		AOE		BKP		BKE		OSSR	OSSI	LOCK	LOCK
	ledBRKflag  = ledBRKconON;          // rozsvítí led BRK
    enableInterrupts();                 // obnoví přerušení na blikání ledBRK
    UARTnewline();
    UARTprintF((uint16_t *)textBreak);
    UARTnumber(type);
    UARTnewline();
    rezim = 10;
    PWMstop();
    outRELEoff;                         // vypne RELE
    ledPWMflag = ledPWMconOFF;          // vypne LED PWM
    ledWARflag = ledWARconOFF;          // vypne LED WAR
    ledBRKflag = (type << 1) | GPIO7;   // zapne LED BRK
    state_Imax = 0;
    state_Unap = 0;
    EEPROMsave();
    delayUART = 0;
    delayPause = 15000 >> 1;
    while(1) {
        if(delayPause == 0              // čeká pevnou dobu
        && PB->IDR & GPIO5              // čeká pokud je trvale break
        && state_Ik < 90                // čeká pokud je trvale proud
        && state_Tk < 50) break;        // čeká pokud je přehřátý
        fanSET();
		if(delayUART == 0) UARTregul();
    }
    IWDGrestart();
}
//-----------------------------------------------------------------------------------
#ifdef uartNTC
float Thermister(int rawADC) 
{
	float Temp;
#ifdef NTCprevod
	ADCpulse();
#endif
#ifndef NTCpullup
//	[Ground] ---- [10k-Resistor] -------|ANI|------- [10k-Thermistor] ---- [+Vcc]
	Temp = logf(10000.0*((1024.0/rawADC-1))); 
#endif
#ifdef NTCpullup
//	for pull-up configuration
//	[Ground] ---- [10k-Thermistor] -------|ANI|------- [10k-Resistor] ---- [+Vcc]
	Temp = logf(10000.0/(1024.0/rawADC-1));
#endif
	Temp = 1 / (0.001129148 + (0.000234125 + (0.0000000876741 * Temp * Temp ))* Temp );
	Temp = Temp - 273.15;            // Convert Kelvin to Celcius
//	Temp = (Temp * 9.0)/ 5.0 + 32.0; // Convert Celcius to Fahrenheit
#ifdef NTCprevod
	ADCpulse();
#endif
	return Temp;
}
#endif
//-----------------------------------------------------------------------------------

