#include "iwdg.h"
//-----------------------------------------------------------------------------------
void IWDGinit(uint8_t numPR)
{
	// The default values give us about 16msec between pings
	IWDG->KR = 0xcc; // Enable IWDG

	// PR 0x00 + RLR 0xff => Time out 16ms
	// PR 0x06 + RLR 0xff => Time out 1,02s
	IWDG->KR = 0x55; // Allow the IWDG registers to be programmed.
	IWDG->PR = numPR; // Prescaler
	IWDG->RLR = 0xff; // PR 0x06 + RLR 0xff => Time out 1,02s
	IWDG->KR = 0xaa; // refresh IWDG
}
//-----------------------------------------------------------------------------------
void IWDGtick(void)
{
     IWDG->KR = 0xaa; // Reset the counter
}
//-----------------------------------------------------------------------------------
void IWDGrestart(void)
{
    UARTprintF((uint16_t *)textReset);
    IWDGinit(0x06); // Time out 1,02s
    while(1);
}
//-----------------------------------------------------------------------------------

