#include "pwm.h"
#include <string.h>

#define PWMslave 7000
#define confmin  5      // minimální frekvence pro Fout = 0
#define confmax  50     // maximální frekvence pro Fout = 0

int16_t  state_PWM;
uint16_t state_PWMkm1;
uint16_t state_PWMmin;
uint16_t state_PWMmax;
uint16_t state_PWMtop;
uint16_t state_Fk;
uint16_t state_Fkm1;
uint8_t  flgPWMset = 0;
//-----------------------------------------------------------------------------------
void PWMstart(void)
{
	if(!state_PWMkm1) UARTprintF((uint16_t *)textStart);
	UARTregul();
	ledWARflag = ledWARconON;
	PWMset();
}
//-----------------------------------------------------------------------------------
void PWMstop(void)
{
	if(state_PWMkm1) UARTprintF((uint16_t *)textStop); 
	UARTregul();
    pid[0].shiftP = eprom_shiftP;
    state_shiftP  = eprom_shiftP;
    ledWARflag = ledWARconMAX;
    flgSHIFTfirst = 0;
	state_PWM = 0;
	PWMset();
}
//-----------------------------------------------------------------------------------
void PWMmeze(void)
{
  	if(state_PWM < (int16_t)1)            state_PWM = (int16_t)0; else
    if(state_PWM < (int16_t)state_PWMmin) state_PWM = (int16_t)state_PWMmin;
    if(state_PWM > (int16_t)state_PWMmax) state_PWM = (int16_t)state_PWMmax;
}
//-----------------------------------------------------------------------------------
void PWMset(void)
{
	tim1CCR1 = prepocet(0, 0, PWMcon, tim1CCR, (uint16_t)state_PWM);
	tim1CCR2 = tim1ARR - tim1CCR1;

    if(rezim <= 1) ledWARflag = ledWARconMAX;

    flgPWMset = 1;
    while(flgPWMset != 0) IWDGtick();
}
//-----------------------------------------------------------------------------------
void PWMfout(void)
{
    # define Ikm2min 50
    // Fout = 0 > změna frekvence [Hz] od confmin do confmax podle Ik
    if(system16.Fout != 0) return;
    state_Fk = prepocet(Ikm2min, confmin, system16.Ifmax, confmax, state_Ik);
}
//-----------------------------------------------------------------------------------
void PWMlimit(void)
{
	uint32_t temp;
    // omezování PWM podle frekvence (DT)
    if(state_Fk != state_Fkm1)
    {
        // nové nastavení TIM1
        for(tim1PSCR = 0; tim1PSCR < 0xff; tim1PSCR++)
        {
            temp = fclk/((uint32_t)(tim1PSCR+1)*state_Fk*2);
            if(temp < 0xffff && (temp & 1) == 0) break;
        }
        tim1ARR = (uint16_t)temp;
        tim1CCR = tim1ARR >> 1;
        // nové limity PWM
        state_PWMmin = (50000/state_Fk)+1;
        state_PWMmin = ((2*system16.DT)+PWMpulz)/state_PWMmin;
        state_PWMtop = (PWMcon - PWMdead) - state_PWMmin;
        if(state_PWMtop > system16.PWMmax) state_PWMtop = system16.PWMmax;
    }
    // omezování PWM podle teploty
    state_PWMmax = prepocet(system16.Tzap + 5, state_PWMtop, system16.Tvyp, 0, state_Tk);
}
//-----------------------------------------------------------------------------------
void PWMplus(void)
{
	IWDGtick();
	flgTLopen = 1;
//	if(state_PWM == state_PWMmax) return; // pro uint16_t
	flgTLsmer++;
	if(flgTLsmer < 0) flgTLsmer = 0;
	state_PWM += PWMstep();
//	flgTLplus = 0;
}
//-----------------------------------------------------------------------------------
void PWMminus(void)
{
	IWDGtick();
	flgTLopen = 2;
//	if(state_PWM == 0) return; // pro uint16_t
	flgTLsmer--;
	if(flgTLsmer > 0) flgTLsmer = 0;
	state_PWM -= PWMstep();
//	flgTLminus = 0;
}
//-----------------------------------------------------------------------------------
uint16_t PWMstep(void)
{
	uint8_t i = 0;
	uint8_t step = 0;

	if(delayRucne == 0 || flgTLsmer == 0)
	{
		i = (state_PWM % 10);
		if(flgTLplus) step = (10 - i);
		else if(i) step = i;
			 else  step = 10;
	}
	else
	{
		i = (state_PWM % 100);
		if(i) step = 10;
		else  step = 100;
	}
	return (step);
}
//-----------------------------------------------------------------------------------
/*
void PWMparse(void)
{
	if(state_PWMofset < 10)   state_PWMofset = state_PWMofset % 10;
	if(state_PWMofset < 100)  state_PWMofset = state_PWMofset % 100;
	if(state_PWMofset < 1000) state_PWMofset = state_PWMofset % 1000;
	if(state_PWMofset < 10000) state_PWMofset = state_PWMofset % 10000;
	if(state_PWMofset / 1000 >= 1)     step = 1000;
	else if(state_PWMofset / 100 >= 1) step = 100;
//	else if(state_PWMofset / 10 >= 1)  step = 10;
	else                                 step = 10;
}
*/
//-----------------------------------------------------------------------------------
#ifdef flgPWMtest
void PWMtest(void)
{
    // endless loop
    for(;;)
	{
		state_PWM = 1;
		PWMset();
		delay(100);
		state_PWM = 10;
		PWMset();
		delay(100);
		state_PWM = 100;
		PWMset();
		delay(200);
		state_PWM = 0;
		PWMset();
		delay(100);
		state_PWM = 100;
		PWMset();
		delay(100);
		TIM1->SR1 |= TIM1_SR1_BIF;
	}
//	return;
}
#endif
//-----------------------------------------------------------------------------------
void delay(uint16_t delay)
{
     // tick 2 ms, delay 1 ms
     delayPause = delay >> 1;
     while(delayPause) IWDGtick();
}
//-----------------------------------------------------------------------------------
/*
uint16_t time(uint16_t delay)
{
     // tick 2 ms, delay 1 ms
     return (delay >> 1);
}
//-----------------------------------------------------------------------------------
uint32_t millis(void)
{
	return(milliscnt);
}
*/
//-----------------------------------------------------------------------------------

