/*
 ********************* Timer1 ********************
 * prescaler: TIM1_PSCRH/L, f = f_{in}/(TIM1_PSCR + 1)
 * other registers:
 * TIM1_CR1 (page 185): | ARPE | CMS[1:0] | DIR | OPM | URS | UDIS | CEN |
 * 		ARPE - Auto-reload preload enable (for TIM1_ARR)
 * 		CMS[1:0]: Center-aligned mode selection (0 - simple counter up/down)
 * 		DIR: Direction (0 - up, 1 - down)
 * 		OPM: One-pulse mode (1 - opm enabled)
 * 		URS: Update request source (When enabled by the UDIS bit, 1 - interrupt only on counter overflow/underflow)
 * 		UDIS: Update disable (1 - disable update int)
 * 		CEN: Counter enable (1 - enable)
 * TIM1_CR2 (page 187): | - | MMS [2:0] | - | COMS | - | CCPS |
 * 		MMS[2:0]: Master mode selection (for ADC or other timers)
 * 		COMS: Capture/compare control update selection
 * 		CCPC: Capture/compare preloaded control
 * TIM1_IER (page 191): | BIE | TIE | COMIE | CC4IE | CC3IE | CC2IE | CC1IE | UIE |
 * 		B - break; T - trigger; COM - commutation; CC - comp/capt; U - update <--
 * TIM1_SR1 (page 192): similar (but instead of IE -> IF)
 * 		interrupt flags
 * TIM1_CNTRH, TIM1_CNTRL - counter value (automatical)
 * TIM1_PSCRH, TIM1_PSCRL - prescaler value
 * TIM1_ARRH, TIM1_ARRL   - auto-reload value (while zero, timer is stopped) (page 206)
 */
//--------------------------------------------------------------------------------
#include "timer1.h"

uint16_t tim1PSCR;
uint16_t tim1ARR;
uint16_t tim1CCR;
uint16_t tim1CCR1;
uint16_t tim1CCR2;
//
//  Set up Timer 1, channel 1 and 2 to compare output.
//
void TIMER1config(void)
{
//  Setup Timer 1 for PWM signal.
//  fout*ARR=fclk/(PSCR+1) PSCR=(fclk/(fout*ARR))-1=(16MHz/(50Hz*40000))-1=7
//  zvolím ARR 40000 =^= 0x9c40 (celé číslo <= 0xffff)
//  100 % Power =^= 50 % dutty = ARR/2 = 40000/2 =^= 0x4e20
//	tim1PSCR = (((uint32_t)(fclk/1000)/(uint32_t)((2*regul.Fout*tim1ARR)/1000))-(uint32_t)1);

    /* Set the Prescaler value */
  	TIM1->PSCRH = 0x00;
    TIM1->PSCRL = 0x03;
    /* Set the Autoreload value */
	TIM1->ARRH  = 0x9c;
	TIM1->ARRL  = 0x40;
    //
    //  Now configure Timer 1, channel 1.
//	TIM1->CCR1H = 0x00;
//	TIM1->CCR1L = 0x00;
    //
    //  Now configure Timer 1, channel 2.
	TIM1->CCR2H = 0xff;
	TIM1->CCR2L = 0xff;
    //
    //  Now configure Timer 1, channel 3.
//  TIM1->CCR3H = 0x00;
//  TIM1->CCR3L = 0x00;
    //
    //  Now configure Timer 1, channel 4.
//  TIM1->CCR4H = 0x00;
//  TIM1->CCR4L = 0x00;

//	Start TIM1
//  TIM1->RCR   = 0x0a;
   #ifdef DC      // L1L2 s IR2101, T2T4, out propojka, zátež na T3
	TIM1->DTR  	= 0;            //  8us je 0x7f pro 16MHz
	TIM1->OISR  = 0b00000000;	//	X		OIS4	OIS3N	OIS3	OIS2N	OIS2	OIS1N	OIS1
	TIM1->CCER1 = 0b01000100;	//	CC2NP	CC2NE	CC2P	CC2E	CC1NP	CC1NE	CC1P	CC1E
	TIM1->CCMR1 = 0b01101100;	//	OC1CE	OC1M	OC1M	OC1M	OC1PE	OC1FE	CC1S	CC1S
	TIM1->CCMR2 = 0b01111100;	//	OC2CE	OC2M	OC2M	OC2M	OC2PE	OC2FE	CC2S	CC2S
   #elif HHO      // pouze L1 s IR2101
	TIM1->DTR  	= 0;            //  8us je 0x7f pro 16MHz
	TIM1->OISR  = 0b00000000;	//	X		OIS4	OIS3N	OIS3	OIS2N	OIS2	OIS1N	OIS1
	TIM1->CCER1 = 0b01000000;	//	CC2NP	CC2NE	CC2P	CC2E	CC1NP	CC1NE	CC1P	CC1E
	TIM1->CCMR1 = 0b01101100;	//	OC1CE	OC1M	OC1M	OC1M	OC1PE	OC1FE	CC1S	CC1S
   #elif H1H2     // H1H2 bez L1 a L2 a bez DT pro IR2109/2104
	TIM1->DTR  	= 0;            //  8us je 0x7f pro 16MHz
	TIM1->OISR  = 0b00000000;	//	X		OIS4	OIS3N	OIS3	OIS2N	OIS2	OIS1N	OIS1
	TIM1->CCER1 = 0b10011001;	//	CC2NP	CC2NE	CC2P	CC2E	CC1NP	CC1NE	CC1P	CC1E
	TIM1->CCMR1 = 0b01101100;	//	OC1CE	OC1M	OC1M	OC1M	OC1PE	OC1FE	CC1S	CC1S
	TIM1->CCMR2 = 0b01111100;	//	OC2CE	OC2M	OC2M	OC2M	OC2PE	OC2FE	CC2S	CC2S
   #elif H1L2X    // H1L2 a H2L1 s překříženými R27 a R29 pro IR2101
	TIM1->DTR  	= (uint8_t)(((uint32_t)system16.DT*(uint32_t)10)/(uint32_t)DTstep);   //  8us je 0x7f pro 16MHz
	TIM1->OISR  = 0b00001010;	//	X		OIS4	OIS3N	OIS3	OIS2N	OIS2	OIS1N	OIS1
	TIM1->CCER1 = 0b11011101;	//	CC2NP	CC2NE	CC2P	CC2E	CC1NP	CC1NE	CC1P	CC1E
	TIM1->CCMR1 = 0b01101100;	//	OC1CE	OC1M	OC1M	OC1M	OC1PE	OC1FE	CC1S	CC1S
	TIM1->CCMR2 = 0b01111100;	//	OC2CE	OC2M	OC2M	OC2M	OC2PE	OC2FE	CC2S	CC2S
   #elif L2H1X    // L2H1 a L1H2 s překříženými R27 a R29 pro IR2101
	TIM1->DTR  	= (uint8_t)(((uint32_t)system16.DT*(uint32_t)10)/(uint32_t)DTstep);   //  8us je 0x7f pro 16MHz
	TIM1->OISR  = 0b00000000;	//	X		OIS4	OIS3N	OIS3	OIS2N	OIS2	OIS1N	OIS1
	TIM1->CCER1 = 0b01110111;	//	CC2NP	CC2NE	CC2P	CC2E	CC1NP	CC1NE	CC1P	CC1E
	TIM1->CCMR1 = 0b01111100;	//	OC1CE	OC1M	OC1M	OC1M	OC1PE	OC1FE	CC1S	CC1S
	TIM1->CCMR2 = 0b01101100;	//	OC2CE	OC2M	OC2M	OC2M	OC2PE	OC2FE	CC2S	CC2S
   #else          // H1L1 a H2L2 pro IR2101
	TIM1->DTR  	= (uint8_t)(((uint32_t)system16.DT*(uint32_t)10)/(uint32_t)DTstep);   //  8us je 0x7f pro 16MHz
	TIM1->OISR  = 0b00000000;	//	X		OIS4	OIS3N	OIS3	OIS2N	OIS2	OIS1N	OIS1
	TIM1->CCER1 = 0b01010101;	//	CC2NP	CC2NE	CC2P	CC2E	CC1NP	CC1NE	CC1P	CC1E
	TIM1->CCMR1 = 0b01101100;	//	OC1CE	OC1M	OC1M	OC1M	OC1PE	OC1FE	CC1S	CC1S
	TIM1->CCMR2 = 0b01111100;	//	OC2CE	OC2M	OC2M	OC2M	OC2PE	OC2FE	CC2S	CC2S
   #endif
	TIM1->BKR   = 0b11011100;   //	MOE		AOE		BKP		BKE		OSSR	OSSI	LOCK	LOCK
	TIM1->IER   = 0b10000001;   //	BIE		TIE		COMIE	CC4IE	CC3IE	CC2IE	CC1IE	UIE
//	TIM1->CR2   = 0b00000000;	//	x		MMS		MMS		MMS		x		COMS	x		CCPC
//  TIM1->CCER2 = 0b00000000;	//	x		x		CC4P	CC4E	CC3NP	CC3NE	CC3P	CC3E
//	TIM1->CCMR3 = 0b01101000;	//	OC3CE	OC3M	OC3M	OC3M	OC3PE	OC3FE	CC3S	CC3S
//	TIM1->CCMR4 = 0b01101000;	//	OC4CE	OC4M	OC4M	OC4M	OC4PE	OC4FE	CC4S	CC4S
	TIM1->CR1   = 0b11100001;	//	ARPE	CMS		CMS		DIR		OPM		URS		UDIS	CEN
}

