#include "config.h"
#include <string.h>
//-----------------------------------------------------------------------------------
// Režimy
// 0 - test
// 1 - ruční
// 2 - fake sinus Uk > 200V - čerpadno
// 3 - fix Ureg
// 4 - fake mppt
// 5 - real mppt
// 6 - Imax
// 7 - Pmax
// 8 - PWMoff
// 9 - Unap
//-----------------------------------------------------------------------------------
pid_t		pid[PIDarry];
//pid_t		pid;
system8_t   system8;
system16_t  system16;
//-----------------------------------------------------------------------------------
uint32_t IcalCON;
uint32_t UcalCON;
uint32_t energieWh;
//-----------------------------------------------------------------------------------
#ifndef PROGEEPROM
void CONFmode(void)
{
    uint8_t flgMODE = 0;

	ledBRKflag = ledBRKconON;
	delayTLopen(2);
	ledBRKflag = ledBRKconMAX;
  	state_print = 1;
	while(1)
	{
        if(flgTLminus)
        {
            flgMODE++;
            if(flgMODE > 4) flgMODE = 1;
            ledBRKflag = flgMODE << 1;
            UARTnumber(flgMODE);
            UARTprintF((uint16_t *)(textTEST + (flgMODE * 8)));
            delayTLopen(2);
        }
        if(flgTLplus) break;
	}
    ledBRKflag = ledBRKconON;
	delayTLopen(1);
  #ifndef TEST
	if((PD->IDR & GPIO5) != 0 && flgMODE == 0) flgMODE = CONFerase();
	while((PD->IDR & GPIO5) == 0);
  #endif
    EEPROMdata8((uint8_t *)EEP_mode,flgMODE);
    IWDGrestart();
//	WWDG->CR = 0xff; // reset
}
//--------------------------------------------------------------------------------
uint8_t CONFerase(void)
{
    uint8_t id = 5;
	uint16_t *adrEEP16	= (uint16_t *)EEP_Tmax;

    EEPROMdata8((uint8_t *)(EEP_Izero),0);
    while(id != 0)
    {
        id--;
        EEPROMdata16((uint16_t *)adrEEP16--,(uint16_t)0);
    }
    id = 4;
    UARTprintF((uint16_t *)textERASE);
    return(id);
}
//-----------------------------------------------------------------------------------
void CONFregul(void)
{
   #ifdef LIGHT
    state_print = 0;
   #endif
    rezim = system8.mode;
    if(rezim <= 1) {
        system8.uartADC = 1;
	    system16.Uvyp = 0;
    }
	if(rezim == 0)
	{
	    state_print = 1;
	    system16.Fout = 50;
	    system16.Ureg = 250;
	    system16.Unap = 500;
	    system16.OFFpwm = 0;
	}
	if(rezim == 2) {
	    system8.ledP = 1;
	    system16.Fout = 48;
	    system16.Ureg = 230;
	    system16.Uzap = 180;
	    system16.OFFpwm = 0;
	}
	state_Fk = system16.Fout;
    state_mppUP   = system16.mppUP1;
    state_mppDOWN = system16.mppDOWN1;
	eprom_Ureg = system16.Ureg;
    state_Ureg = system16.Ureg; // pro fix Ureg
	state_Unap = system16.Unap;
	state_Pmax = system16.Pmax;
	state_Imax = system16.Imax;
	state_Tmax = system16.Tmax;
	eprom_shiftP = pid[0].shiftP;
	energieWh  = (uint32_t)system16.Emsb << 16;
	energieWh += (uint32_t)system16.Elsb;
	diffUreg = (state_Unap - eprom_Ureg) / 2;
	if(diffUreg > 15) diffUreg = 15;
   #ifdef RELE
	system16.OFFpwm = 0;
   #endif
}
#endif /* PROGEEPROM */
//-----------------------------------------------------------------------------------
void CONFread(void)
{
    memcpy(&pid,		BASEpid,		sizeof(pid));
    memcpy(&system8,	BASEsystem8,	sizeof(system8));
    memcpy(&system16,	BASEsystem16,	sizeof(system16));
#ifndef PROGEEPROM
    UcalCON = ((uint32_t)system16.UcalV  * conUcal) / (uint32_t)system16.UcalADC;
    IcalCON = ((uint32_t)system16.IcalmA * conIcal) / (uint32_t)system16.IcalADC;
#endif /* PROGEEPROM */
}
//-----------------------------------------------------------------------------------
void CONFload(void)
{
    disableInterrupts();                // smaže vektory přerušení
    enableInterrupts();                 // obnoví přerušení
    PWMstop();
    EEPROMsave();
    UARTnewline();
	if(state_print == 0) state_print = 3;
	ledBRKflag = ledBRKconMAX;
	ledWARflag = ledWARconMAX;
	ledPWMflag = ledPWMconOFF;
	while(1)
	{
		CONFread();
		CONFprint();
		UARTprintF((uint16_t *)textLoad);
		UARTdataRX();
		UARTprintF(strbuf);
		UARTnewline();
		CONFsave(strbuf);
	}
}
//-----------------------------------------------------------------------------------
void CONFprint(void)
{
    uint8_t i=0;
    uint8_t j=0;
    uint8_t k=0;
	uint16_t val=0;
	uint8_t  *Ptext       = (uint16_t *)EEPtext;
	uint8_t  *ADRsystem8  = ( uint8_t *)system8;
	uint16_t *ADRsystem16 = (uint16_t *)system16;
	uint16_t *ADRpid      = (uint16_t *)pid;

	// tisk hodnot
	for(i=0;i<EEPstruct;i++)
	{
		UARTnumber(i+1);
		j = STRUCTsize[i];
		do
		{
			j--;
			//Čtení popisů dat z eeprom
            #ifdef TEST
	    	UARTprintF((uint8_t *)Ptext);
			for(k=0;*Ptext++;k++);
            #endif

			//Čtení dat z eeprom podle typu struktury
			k = EEPstruct - PIDarry - 1;
			if(i >  k) val = *ADRpid++; else
			if(i >  0) val = *ADRsystem16++;
			else       val = *ADRsystem8++;
	    	UARTprintF(" ");
			UARTnumber(val);
		}while(j);
		UARTnewline();
	}
}
//-----------------------------------------------------------------------------------
//void CONFmemcpy(void)
//{
//	memcpy(&pid,		BASEpid,		sizeof(pid));
//	memcpy(&system8,	BASEsystem8,	sizeof(system8));
//	memcpy(&system16,	BASEsystem16,	sizeof(system16));
//}
//-----------------------------------------------------------------------------------
uint16_t PARSEstring(uint8_t *s)
{
	uint8_t *ch = s;
	uint8_t flgMinus = 0;
	uint16_t value = 0;
	for (; *ch; ch++)
	{
		if (*ch >= '0' && *ch <= '9') value = value * 10 + (*ch - '0');
		else if(*ch == '-') flgMinus = 1;
	}
	if(flgMinus) value *= -1;
	return value;
}
//-----------------------------------------------------------------------------------
//  Zápis dat do struktur v EEPROM
void CONFsave(uint8_t *s)
{
	uint8_t *ch = s;
	uint8_t i = 0;
	uint8_t j = 0;
	uint8_t k = 0;
	uint8_t val0 = 0;
	uint8_t diff = 0;
	uint8_t  *adrEEP8 	= ( uint8_t *)EEPsystem8;
	uint16_t *adrEEP16	= (uint16_t *)EEPsystem16;
	uint16_t val = 0;

	system8.mode = 1;
	for (; *ch; *ch++,i++)
	{
		j=0;
    	while (1)
	    {
            if(*ch < '0' || *ch > '9') break;
    	    strbuf[j] = *ch;
    	    ch++;                                //  Grab the next character.
			j++;
    	}
		strbuf[j] = '\0';
		val = PARSEstring(strbuf);
		if(i == 0)
		{
			val0 = (uint8_t)val;
			if(val0 == 99) IWDGrestart();   // restartuje regulátor
            if(val0 == 90) CONFerase();     // vymaže zapsané hodnoty
			for (k=2; k<val0; k++) diff += STRUCTsize[k-1];
			adrEEP16 = (uint16_t *)EEPsystem16 + diff;
			continue;
		}
        if(i > STRUCTsize[val0-1])          return; // nezapíše více hodnot než je v řádku
		if(val0 == 0 || val0 > EEPstruct)   return; // ukončí zápis
        if(val0 > 1) EEPROMdata16((uint16_t *)adrEEP16++,(uint16_t)val);
        else         EEPROMdata8 (( uint8_t *)adrEEP8++, ( uint8_t)val);
	}
}
//-----------------------------------------------------------------------------------

