#include "pireg.h"

uint8_t  diffUreg;
uint8_t  flgUset = 0;
uint8_t  flgSHIFTfirst = 0;
uint16_t state_KP;
uint16_t state_shiftP;
uint16_t eprom_shiftP;
//int32_t Ierr;
//-----------------------------------------------------------------------------------
void runPIreg(void)
{
    int16_t Pterm = 0;
    int16_t Aterm = 0;
    int16_t Uerror = 0;
    uint16_t state_KPm1;
    uint16_t state_shiftPm1;

    if(system16.Unap == 0) flgUset = 2; else                        // Nastavení Izero při Unap = 0
    if(rezim >= 6) {                                                // Pmax, Imax
        state_KP      = pid[0].I;
        state_shiftP  = pid[1].I;
        flgSHIFTfirst = 0;
        if(rezim == 7) Uerror = (int16_t)(conPmax*4) - (int16_t)(state_Pk*4);
        else           Uerror = (int16_t)(conImax)   - (int16_t)(state_Ik);
    }
    else {
        if(rezim == 2) {                                            // čerpadlo
            if(state_Uk > state_Ureg) state_PWM = prepocet(210, 7000, 250, 8500, state_Uk);
            delayPause = 3000 >> 1;
            return;
        }
        if(rezim == 4) {                                            // fake mppt
            if(system16.Imax < 500) system16.Imax = 0;              // pro Imax < 500 nastavení Unap a Ureg při 500mA
            if(state_Ik > (500 + (2 * system16.Imax))) flgUset = 1; // pro Imax > 500 nastavení Unap a Ureg při 500mA + 2*Imax
            #define UregI1   200                                    // proud v mA pro začátek 1. pásma
            #define UregI2   600                                    // proud v mA pro konce 1. pásma
            #define UregI3  8000                                    // proud v mA pro konec 2. pásma
            state_Udif = (eprom_Ureg * system16.Umpr / 100);
            if(state_Ik < 500) state_Udif *= 2;
            state_Ulow = eprom_Ureg - state_Udif;
            if(state_Ik < 500) state_Ureg = prepocet(        UregI1, state_Ulow, UregI2, eprom_Ureg, state_Ik);
            else               state_Ureg = prepocet(system16.Ifmax, eprom_Ureg, UregI3, state_Ulow, state_Ik);
        }
        if(state_Ureg == 0) return;

        if(state_Uk > (state_Ureg + diffUreg) && state_Ik < pid[1].shiftPmA) {
            if(delaySHIFT == 0 && pid[0].shiftP > 3) {
                if(flgSHIFTfirst != 0) {
                    delayUART = 0;
                    delayPIDshift = 0;
                    pid[0].shiftP--;
                    UARTprintF((uint16_t *)textPSdec);
                }
                flgSHIFTfirst = 1;
                delaySHIFT = system16.Tshift >> 1;
            }
        }
        else flgSHIFTfirst = 0;

        state_KPm1 = state_KP;
        state_shiftPm1 = state_shiftP;
        if(delayPIDshift == 0) {
            state_KP     = prepocet(pid[1].shiftPmA, pid[0].KP, conImax, pid[1].KP, state_Ik);
            state_shiftP = prepocet(pid[0].shiftPmA, pid[0].shiftP, pid[1].shiftPmA, pid[1].shiftP, state_Ik);
            if(state_KP != state_KPm1 || state_shiftP != state_shiftPm1) delayPIDshift = 5000 >> 1;
        }

        Uerror = (int16_t)state_Uk - (int16_t)state_Ureg;
    }

    Pterm = Uerror * (int16_t)state_KP;
    Aterm = Pterm  / (int16_t)(1 << state_shiftP);

    state_PWM += Aterm;
}
//-----------------------------------------------------------------------------------
uint16_t prepocet(uint16_t ax, uint16_t ay, uint16_t bx, uint16_t by, uint16_t x)
{
//  prepocet(100,20,8000,10,state_Ik) =^= pro proud od 100 mA do 8000 mA vrací hodnotu od 20 do 10
//  Ik <  100 mA =^= 20
//  Ik > 8000 mA =^= 10

/*
    int16_t a, b;
    int32_t c, y;

    if(ay == by) return ay;
    if(x < ax) x = ax;
    if(x > bx) x = bx;

    a = by - ay;
    a *= -1;
    b = bx - ax;
    c = a*(int32_t)ax + b*(int32_t)ay;
    c *= -1;
    y = (c+(int32_t)a*(int32_t)x)/(int32_t)b;
    y *= -1;

    return (uint16_t)y;
*/
/*
    uint8_t flgREVERSE = 0;
    uint16_t temp;
    int32_t a, b, c, y;

    if(by <  ay) { temp = ay; ay = by; by = temp; flgREVERSE = 1; }
    if(x  <= ax) return ay;
    if(x  >= bx) return by;
    if(by == ay) return ay;

    a = by - ay;
    b = bx - ax;
    c = (b * ay) - (a * ax);
    y = ((a * x) - c) / b;
    
    if(y < ay) y = ay;
    if(y > by) y = by;
    if(flgREVERSE) return (uint16_t)(by + ay - y);
    else           return (uint16_t)y;
*/
//    uint8_t flgREVERSE = 0;
//    uint16_t temp;
//    int32_t a, b, c;
    uint16_t y;

//    if(by <  ay) { temp = ay; ay = by; by = temp; flgREVERSE = 1; }
    if(x  <= ax) return ay;
    if(x  >= bx) return by;
//    if(by == ay) return ay;
//  pro uint32_t nepočítá správně záporný kvadrant (20->0)
//  y = (uint16_t)(((((uint32_t)by-(uint32_t)ay)*(( 1000*((uint32_t)x-(uint32_t)ax))/((uint32_t)bx-(uint32_t)ax)))/ 1000)+(uint32_t)ay);
    y = (uint16_t)((((( int32_t)by-( int32_t)ay)*((10000*(( int32_t)x-( int32_t)ax))/(( int32_t)bx-( int32_t)ax)))/10000)+( int32_t)ay);
//    a = by - ay;
//    b = bx - ax;
//    c = (1000*(x-ax))/b;
//    y = a*c/1000 + ay;
//    if(y < ay) y = ay;
//    if(y > by) y = by;

    return y;
}

