#include "regul.h"

#define uart        // zobrazení paramtrů
#define conUnap 10  // počet opakování pro shodu napětí
//#define uartINCCOND

uint8_t cntUnap = 0;
uint8_t flgMPPTstred;
uint8_t flgMPPTsmer;
uint8_t flgNEWmpp;
uint8_t flgNEWpower;
uint8_t flgNEWtime;
uint32_t flgMPPTtime;
uint16_t state_mppDOWN;	  // snižování kroku MPPT [V]
uint16_t state_mppUP;     // zvyšování kroku MPPT [V]
uint16_t state_Tmax;
uint16_t state_Pmax;
uint16_t state_Imax;
uint16_t eprom_Ureg;
uint16_t state_Ureg;
uint16_t state_Unap;
uint16_t state_Una1 = 0;
uint16_t state_Una2 = 0;
uint16_t state_Udif;
uint16_t state_Ulow;
//-----------------------------------------------------------------------------------
void setUnap(void)
{
    #ifdef TEST
    state_Ureg = state_Una1;            // zobrazení ustálené Uk
    state_Ulow = cntUnap;               // zobrazení počet ustálení
    state_Fk   = (uint16_t)(milliscnt / (uint32_t)1000);
    #endif
    rezim = 9;
    system8.uartADC = 1;
    ledPWMflag = 25;
    ledWARflag = ledWARconMAX;
    if(state_PWM != 0 || state_Uk < system16.Uzap) {
        milliscnt = 0;                  // nulování globálního času na omezení doby detekce
        state_PWM = 0;                  // vypnutí výstupu
        cntUnap = 0;                    // nulování čítače ustálení
        return;
    }
    if(milliscnt > 900000) {            // omezení detekce na 900 s - 15 min.
        cntUnap = conUnap;
        state_Unap = state_Uk;
    }
    if(cntUnap == conUnap) {            // při ustálení zapsat
       	state_print = 1;
  	    if(system16.Unap == 0) {        // Nastavení Izero
            state_rawIk++;
            EEPROMdata8((uint8_t *)(EEP_Izero),(uint8_t)state_rawIk);
            UARTprintF((uint16_t *)textIz);
            state_Ureg = state_Unap;
        }
        EEPROMsave();
        IWDGrestart();
    }
}
//-----------------------------------------------------------------------------------
void setMAX(void)
{
    if(state_Imax < state_Ik) state_Imax = state_Ik;
    if(state_Tmax < state_Tk) state_Tmax = state_Tk;
	if(state_Pmax < state_Pk) state_Pmax = state_Pk;
    if(state_Unap < state_Uk || flgUset != 0) {
    	if(delayUnap == 0 && cntUnap < conUnap) {
            state_Una2 = state_Una1;
            state_Una1 = (state_Uk + state_Una1) / 2;
            if(state_Una1 == state_Una2) cntUnap++;
            else cntUnap = 0;
            if(cntUnap == conUnap) state_Unap = state_Una1 + 1;
            delayUnap = 1000 >> 1;
        }
    }
    else cntUnap = 0;
}
//-----------------------------------------------------------------------------------
void setLASTvalue(void)
{
	state_Pkm1 = state_Pk;
	state_Ikm1 = state_Ik;
	state_Ukm1 = state_Uk;
}
//-----------------------------------------------------------------------------------
void mpptINCCOND(void)
{
	int16_t dI;
	int16_t dU;
	int16_t dP;
	int16_t dPdU = 0;

//	power = (long) f_iin * f_vin;
	dP = (state_Pk - state_Pkm1)*10;
	dI = (state_Ik/10) - (state_Ikm1/10);
	dU = (state_Uk - state_Ukm1);
    if(dU > 0) dPdU = dP / dU;
    else dPdU = 0;

/*
		UARTprintF("mppt ");
#ifndef LIGHT
		UARTprintF("P:");
		UARTnumber(state_Pk,0);
		UARTprintF("-");
		UARTnumber(state_Pkm1,0);
		UARTprintF(" U:");
		UARTnumber(state_Uk,0);
		UARTprintF("-");
		UARTnumber(state_Ukm1,0);
		UARTprintF(" I:");
		UARTnumber(state_Ik,0);
		UARTprintF("-");
		UARTnumber(state_Ikm1,0);
#endif
		UARTprintF("  dP");
		UARTnumber((int32_t)dP,16);
		UARTprintF("  dU");
		UARTnumber((int32_t)dU,16);
		UARTprintF("  dI");
		UARTnumber((int32_t)dI,16);
		UARTprintF("  dP/dU");
		UARTnumber((int32_t)dPdU,16);
*/

	if(dU > 0)
	{
		if(dPdU > 0) state_Ureg += state_mppUP; else
		if(dPdU < 0) state_Ureg -= state_mppDOWN;
	} 
	else
	{
		if(dI > 0) state_Ureg += state_mppUP; else
		if(dI < 0) state_Ureg -= state_mppDOWN;
	}

	if(state_Ureg < (eprom_Ureg + state_Udif))
	{
	    flgMPPTsmer = 1;
		flgMPPTstred = 0;
	    state_mppUP   = system16.mppUP2;
	    state_mppDOWN = system16.mppDOWN2;
		state_Ureg = eprom_Ureg;
//		UARTprintF("  MEZ>Ur0");
	}
	if((state_Ureg > system16.Ureg && flgMPPTsmer == 1) || (state_Ureg < system16.Ureg && flgMPPTsmer == 0))
	{
	    if(flgMPPTstred == 0)
	    {
    	    state_mppUP   = system16.mppUP1;
            state_mppDOWN = system16.mppDOWN1;
//            UARTprintF("  MEZ>Ur");
            flgMPPTstred = 1;
        }
	}
	if(state_Ureg > state_Ulow)
	{
	    flgMPPTsmer = 0;
		flgMPPTstred = 0;
	    state_mppUP   = system16.mppUP3;
	    state_mppDOWN = system16.mppDOWN3;
		state_Ureg = eprom_Ureg;
//		UARTprintF("  MEZ>Ur1");
	}
//		UARTnewline();

//	state_Pkm1 = state_Pk;
//	state_Ikm1 = state_Ik;
//	state_Ukm1 = state_Uk;
}
//-----------------------------------------------------------------------------------

