/*
 ********************* UART ********************
 * baud rate: regs UART_BRR1/2  !!!VERY STUPID!!!
 * f_{UART} = f_{master} / UART_DIV
 * if UART_DIV = 0xABCD then
 * 		UART_BRR1 = UART_DIV[11:4] = 0xBC;
 * 		UART_BRR2 = UART_DIV[15:12|3:0] = 0xAD
 *           registers
 * UART_SR:  | TXE | TC | RXNE | IDLE | OR/LHE | NF | FE | PE |
 * 		TXE: Transmit data register empty
 * 		TC: Transmission complete
 * 		RXNE: Read data register not empty
 * 		IDLE: IDLE line detected
 * 		OR: Overrun error / LHE: LIN Header Error (LIN slave mode)
 * 		NF: Noise flag
 * 		FE: Framing error
 * 		PE: Parity error
 * UART_DR: data register (when readed returns coming byte, when writed fills output shift register)
 * UART_BRR1 / UART_BRR2 - see upper
 * UART_CR1: | R8 | T8 | UARTD | M | WAKE | PCEN | PS | PIEN |
 * 		R8, T8 - ninth bit (in 9-bit mode)
 * 		UARTD: UART Disable (for low power consumption)
 * 		M: word length (0 - 8bits, 1 - 9bits)
 * 		WAKE: Wakeup method
 * 		PCEN: Parity control enable
 * 		PS: Parity selection (0 - even)
 * 		PIEN: Parity interrupt enable
 * UART_CR2: | TIEN | TCEN | RIEN | ILIEN | TEN | REN | RWU | SBK |
 * 		TIEN: Transmitter interrupt enable
 * 		TCIEN: Transmission complete interrupt enable
 * 		RIEN: Receiver interrupt enable
 * 		ILIEN: IDLE Line interrupt enable
 * 		TEN: Transmitter enable   <----------------------------------------
 * 		REN: Receiver enable      <----------------------------------------
 * 		RWU: Receiver wakeup
 * 		SBK: Send break
 * UART_CR3: | - | LINEN | STOP[1:0] | CLCEN | CPOL | CPHA | LBCL |
 *		LINEN: LIN mode enable
 * 		STOP: STOP bits
 * 		CLKEN: Clock enable (CLC pin)
 * 		CPOL: Clock polarity
 * 		CPHA: Clock phase
 * 		LBCL: Last bit clock pulse
 */
//-----------------------------------------------------------------------------------
#include "uart.h"

#define uartNTC            // zobrazení teploty ve ADC

#define conUART     (1000 >> 1) // zpoždění tisku na uart ms
//-----------------------------------------------------------------------------------
uint8_t flgTXsend = 0;
uint8_t flgUARTwait;
uint8_t strbuf[strbufsize];
//-----------------------------------------------------------------------------------
void UARTconfig(void)
{
	UART1->BRR2 = 0x0b; UART1->BRR1 = 0x08; // 115.2 kbs on 16MHz
	UART1->CR2  = 0b00101100;               // | TIEN | TCEN | RIEN | ILIEN | TEN | REN | RWU | SBK |
    UART1->CR5  = UART1_CR5_HDSEL;          // half duplex (Rx/Tx - PD5)
}
//-----------------------------------------------------------------------------------
void UARTnewline(void)
{
    if(UART1->DR != '\n') UARTprintF("\n");
}
//-----------------------------------------------------------------------------------
// Odeslat bajt
//void UARTbyteTX(uint8_t data)
//{
//    UART1->DR = data;
//    while(!(UART1->SR & UART1_SR_TXE));
//}
//-----------------------------------------------------------------------------------
//  Send the message in the string to UART1.
void UARTprintF(uint8_t *message)
{
    #ifdef LIGHT
	if(state_print == 0) return;
    #endif
    flgTXsend = 2;
    do {
        UART1->DR = *message++;
        while(!(UART1->SR & UART1_SR_TXE));
    } while(*message);
//  do {
//      UARTbyteTX(*message++);
//  } while(*message);
}
//-----------------------------------------------------------------------------------
//  Send the number with unsigned size 16 to UART1.
void UARTnumber(uint16_t number)
{
	uint8_t i = strbufsize;

    strbuf[--i] = '\0';
	do {
		strbuf[--i] = (uint8_t)((number % 10) + 0x30);
        number /= 10;
	} while(number);
	UARTprintF(&strbuf[i]);
}
//-----------------------------------------------------------------------------------
//unsigned char UARTrxData()
void UARTdataRX(void)
{
	uint8_t ind = 0;
    delay(10);
    UART1->CR2  = 0b00000100;           // | TIEN | TCEN | RIEN | ILIEN | TEN | REN | RWU | SBK |
	while(1)
	{
        strbuf[ind] = '\0';
        while(1) {
            if(UART1->SR & UART1_SR_RXNE) {
        		strbuf[ind] = UART1->DR;
                if(ind < strbufsize) ind++;
                flgTXsend = 50 >> 1;
                break;
            }
            if(flgTXsend == 0 && ind != 0) break;
        }
        if(flgTXsend == 0) break;
	}
    if(ind == strbufsize) strbuf[0] = '\0';
    UART1->CR2  = 0b00001000;           // | TIEN | TCEN | RIEN | ILIEN | TEN | REN | RWU | SBK |
}
//-----------------------------------------------------------------------------------
void UARTregul(void)
{
	flgUARTwait = 1;
	while(flgUARTwait) IWDGtick();

	UARTprintF("M:");
	UARTnumber(rezim);

	UARTprintF(" P:");
	UARTnumber(state_KP);
	UARTprintF(":");
	UARTnumber(state_shiftP);
   #ifdef TEST
	UARTprintF(":");
	UARTnumber(pid[0].shiftP);
   #endif

	UARTprintF(" R:");
	UARTnumber(inRELE);

	UARTprintF(" F:");
    UARTnumber((TIM2->CCER2 & 1) + ((state_PWMtop - state_PWMmax) / 100));

   #ifdef UNAP
	UARTprintF(" Un:");
	UARTnumber(system16.Unap);
	UARTprintF(":");
	UARTnumber(cntUnap);
	UARTprintF(":");
	UARTnumber(state_Unap);
   #endif

   #ifdef TEST
	UARTprintF(" U:");
	UARTnumber(eprom_Ureg);
	UARTprintF(":");
	UARTnumber(state_Ureg);
	UARTprintF(":");
	UARTnumber(state_Ulow);
   #endif
	UARTprintF(" ");

    UARTnumber(state_Fk);
	UARTprintF("Hz ");

        UARTadc(state_rawTk);
		UARTnumber(state_Tk);
		UARTprintF("C ");

        UARTadc(state_rawUk);
		UARTnumber(state_Uk);
		UARTprintF("V ");

		UARTadc(state_rawIk);
		UARTnumber(state_Ik);
		UARTprintF("mA ");

		UARTnumber(state_Pk);
		UARTprintF("W ");

		UARTnumber(state_PWM);
		UARTprintF("us ");

        UARTnumber(state_Wh);
        UARTprintF("Wh\n");

    delayUART = conUART;
}
//-----------------------------------------------------------------------------------
void UARTadc(uint16_t number)
{
    if(system8.uartADC == 0) return;
    UARTnumber(number);
    UARTprintF("|");
}
//-----------------------------------------------------------------------------------
/*
void UARTnapeti(void)
{
	UARTprintF("Unap:");
	UARTnumber(state_Unap,0);
	UARTprintF("V Ur0:");
	UARTnumber(state_Unizsi,0);
	UARTprintF("V Ur:");
	UARTnumber(state_Ureg,0);
	UARTprintF("V Ur1:");
	UARTnumber(state_Uvyssi,0);
	UARTprintF("V\n");
}
*/
//-----------------------------------------------------------------------------------
/*
void UARTmpp(void)
{
	UARTprintF("  MPP:");
	UARTnumber(state_Umax,0);
	UARTprintF("V");
	UARTnumber(state_Pmax,32);
	UARTprintF("W");
}
*/
//-----------------------------------------------------------------------------------
/*
void UARTregul0(uint16_t time)
{
	state_Uk = 0;
	state_Ik = 0;
	state_Pk = 0;
	delayPause = time >> 1;
	while(delayPause > 0)
	{
		if(delayUART == 0) UARTregul();
	}
}
*/
//------------------------------------------------------------------------------------------------------
// This function returns a string representtion of a number scaled by 1000 with 3 decimal places
//------------------------------------------------------------------------------------------------------
/*
uint8_t int1000_to_string(int inputInt, uint8_t decimal) {

  String outputStr = "";

  int highInt = int(inputInt/1000)*1;
  int lowInt = int(inputInt%1000)*1;

  if (inputInt < 0) {
    outputStr = "-";
  }

  outputStr += highInt;
  outputStr += ".";
  outputStr += lowInt;

  return outputStr;
}
*/
/*
U8 U8toHEX(U8 val){
	val &= 0x0f;
	if(val < 10) val += '0';
	else val += 'a' - 10;
	return val;
}

void printUHEX(U8 val){
	uart_write("0x");
	UART_send_byte(U8toHEX(val>>4)); // MSB
	UART_send_byte(U8toHEX(val));    // LSB
}
*/
#ifdef PROGEEPROM
//-----------------------------------------------------------------------------------
uint8_t U4toHEX(uint8_t val)
{
	val &= 0x0f;
	if(val < 10) val += '0';
	else val += 'a' - 10;
	UART1->DR = val;
	while(!(UART1->SR & UART1_SR_TXE));

	return val;
}
//-----------------------------------------------------------------------------------
void UARTprintHEX(uint16_t val)
{
	UARTprintF("0x");
	UARTprintF((uint8_t*)U4toHEX(val>>12));
	UARTprintF((uint8_t*)U4toHEX(val>>8));
	UARTprintF((uint8_t*)U4toHEX(val>>4));
	UARTprintF((uint8_t*)U4toHEX((uint8_t)val));
}
#endif /* PROGEEPROM */

