/*
 ********************* UART ********************
 * baud rate: regs UART_BRR1/2  !!!VERY STUPID!!!
 * f_{UART} = f_{master} / UART_DIV
 * if UART_DIV = 0xABCD then
 * 		UART_BRR1 = UART_DIV[11:4] = 0xBC;
 * 		UART_BRR2 = UART_DIV[15:12|3:0] = 0xAD
 *           registers
 * UART_SR:  | TXE | TC | RXNE | IDLE | OR/LHE | NF | FE | PE |
 * 		TXE: Transmit data register empty
 * 		TC: Transmission complete
 * 		RXNE: Read data register not empty
 * 		IDLE: IDLE line detected
 * 		OR: Overrun error / LHE: LIN Header Error (LIN slave mode)
 * 		NF: Noise flag
 * 		FE: Framing error
 * 		PE: Parity error
 * UART_DR: data register (when readed returns coming byte, when writed fills output shift register)
 * UART_BRR1 / UART_BRR2 - see upper
 * UART_CR1: | R8 | T8 | UARTD | M | WAKE | PCEN | PS | PIEN |
 * 		R8, T8 - ninth bit (in 9-bit mode)
 * 		UARTD: UART Disable (for low power consumption)
 * 		M: word length (0 - 8bits, 1 - 9bits)
 * 		WAKE: Wakeup method
 * 		PCEN: Parity control enable
 * 		PS: Parity selection (0 - even)
 * 		PIEN: Parity interrupt enable
 * UART_CR2: | TIEN | TCEN | RIEN | ILIEN | TEN | REN | RWU | SBK |
 * 		TIEN: Transmitter interrupt enable
 * 		TCIEN: Transmission complete interrupt enable
 * 		RIEN: Receiver interrupt enable
 * 		ILIEN: IDLE Line interrupt enable
 * 		TEN: Transmitter enable   <----------------------------------------
 * 		REN: Receiver enable      <----------------------------------------
 * 		RWU: Receiver wakeup
 * 		SBK: Send break
 * UART_CR3: | - | LINEN | STOP[1:0] | CLCEN | CPOL | CPHA | LBCL |
 *		LINEN: LIN mode enable
 * 		STOP: STOP bits
 * 		CLKEN: Clock enable (CLC pin)
 * 		CPOL: Clock polarity
 * 		CPHA: Clock phase
 * 		LBCL: Last bit clock pulse
 */
#include "stm8s.h"
#include "uart.h"
#include "iwdg.h"
#include <string.h>
#include "extern.h"

//#define uartNTC            // zobrazení teploty ce °C

//uint8_t txbuf[50];
//uint8_t rxbuf[50];
uint8_t flgUARTwait;
//-----------------------------------------------------------------------------------
void UARTconfig(void)
//void UARTconfig(uint32_t BaudRate, uint32_t fMaster)
{
	unsigned long brr;

	brr = fMaster/BaudRate;
	UART2->BRR2  =  brr &  0x000F;
	UART2->BRR2 |=  brr >> 12;
	UART2->BRR1  = (brr >> 4) & 0x00FF;
	UART2->CR1  = 0;
	UART2->CR2  = 0;
	UART2->CR3  = 0;
	UART2->CR2  =  UART2_CR2_TEN | UART2_CR2_REN;// | UART2_CR2_RIEN; // Allow TX and RX
	UART2->CR3 &= ~(UART2_CR3_STOP); // 1 stop bit
}
//-----------------------------------------------------------------------------------
#ifndef PROGEEPROM
void UARTwait(void)
{
	flgUARTwait = 1;
	while(flgUARTwait) IWDGtick();
}
#endif /* PROGEEPROM */
//-----------------------------------------------------------------------------------
void UARTnewline(void)
{
	UARTprintF("\n");
}
//-----------------------------------------------------------------------------------
//
//  Send the message in the string to UART2.
void UARTprintF(char *message)
{
    char *ch = message;
#ifdef LIGHT
	if(state.print == 0) return;
#endif
    UARTwait();
/*
	while(*ch){
		while(!(UART2->SR & UART2_SR_TXE));
		UART2->CR2 |= UART2_CR2_TEN;
		UART2->DR = *ch++;
	}
*/

    while (*ch)
    {
        UART2->DR = (unsigned char) *ch++;     //  Put the next character into the data transmission register.
        while (!(UART2->SR & UART2_SR_TXE)); //  Wait for transmission to complete.
//        ch++;                                //  Grab the next character.
    }

}
//-----------------------------------------------------------------------------------
//
//  Send the number with signed size 8, 16, 32 or unsigned 0 to UART2.
void UARTnumber(int32_t number, unsigned char sizesigned)
{
	int i = 0;
	char flaMinus = 0;
//    char ascii[11]={0};
#ifdef LIGHT
	if(state.print == 0) return;
#endif
    UARTwait();
	if(sizesigned)
	{
//		if((number >> (sizesigned - 1)) > 0)
		if(number < 0)
		{
//			number = (~number) + 1;
			number *= -1;
			flaMinus = 1;
		}
	}
//	if(flaMinus) number = ~number + 1;
	do {
		strbuf[i] = (unsigned char)((number % 10) + 0x30);
        number /= 10;
		i++;
	}while(number);
//	while(!(UART2->SR & UART2_SR_TXE));
	if(sizesigned)
	{
		strbuf[i] = 0x20;
		if(flaMinus) strbuf[i] = 0x2D;
		i++;
	}
	do {
		i--;
		UART2->DR = strbuf[i];
		while(!(UART2->SR & UART2_SR_TXE));
	}while(i);
}
//-----------------------------------------------------------------------------------
unsigned char UARTbyteRX()
{
    unsigned char data;
       
    while(!(UART2->SR & UART2_SR_RXNE));
    data = UART2->DR;
    return data;
}
//-----------------------------------------------------------------------------------
//unsigned char UARTrxData()
void UARTdataRX()
{
	uint8_t ind=0;
//	memset(strbuf, 0, sizeof(*strbuf));
	while(1)
	{
		strbuf[ind] = UARTbyteRX();
		if(strbuf[ind] == 0x3B) break;
		ind++;
	}
	ind++;
	strbuf[ind] = '\0';
	ind++;
	strbuf[ind] = '\0';
}
//-----------------------------------------------------------------------------------
void UARTregul(void)
{
		UARTrezim();

	UARTprintF("  KP:");
	UARTnumber(pid[2].KP,0);
	UARTprintF(" Ps:");
	UARTnumber(pid[2].shiftP,0);

#ifndef LIGHT
//	     if(state.Ureg == state.Umax)   UARTprintF("  Um:");
//	else if(state.Ureg == state.Unizsi) UARTprintF("  Un:");
//	else if(state.Ureg == state.Uvyssi) UARTprintF("  Uv:");
//	else                                
	UARTprintF("  Ur:");
	UARTnumber(state.Ureg,0);
	UARTprintF("V  R:");
#endif

		#ifdef  uartNTC
			UARTnumber(Thermister(state.Tk),16);
			UARTprintF("C");
		#endif

//		UARTnumber(state.rawTk,0);
//		UARTprintF("C ");
		
		if(system8.uartADC)
		{
			UARTnumber(state.rawUk,0);
			UARTprintF("|");
		}
		UARTnumber(state.Uk,0);
		UARTprintF("V ");

		if(system8.uartADC)
		{
			UARTnumber(state.rawIk,0);
			UARTprintF("|");
		}
		UARTnumber(state.Ik,0);
		UARTprintF("mA");

		UARTnumber(state.Pk,16);
		UARTprintF("W");

		UARTnumber(state.PWMkm1,16);
		UARTprintF(">");
		UARTnumber(state.PWM,0);
		UARTprintF("us");
//		IWDGtick();

		UARTnewline();
}
//-----------------------------------------------------------------------------------
void UARTnapeti(void)
{
	UARTprintF("Unap:");
	UARTnumber(state.Unap,0);
	UARTprintF("V Ur0:");
	UARTnumber(state.Unizsi,0);
	UARTprintF("V Ur:");
	UARTnumber(state.Ureg,0);
	UARTprintF("V Ur1:");
	UARTnumber(state.Uvyssi,0);
	UARTprintF("V\n");
}
//-----------------------------------------------------------------------------------
/*
void UARTmpp(void)
{
	UARTprintF("  MPP:");
	UARTnumber(state.Umax,0);
	UARTprintF("V");
	UARTnumber(state.Pmax,32);
	UARTprintF("W");
}
*/
//-----------------------------------------------------------------------------------
void UARTrezim(void)
{
	UARTprintF("M:");
	UARTnumber(rezim,0);
}
//------------------------------------------------------------------------------------------------------
// This function returns a string representtion of a number scaled by 1000 with 3 decimal places
//------------------------------------------------------------------------------------------------------
/*
uint8_t int1000_to_string(int inputInt, uint8_t decimal) {

  String outputStr = "";

  int highInt = int(inputInt/1000)*1;
  int lowInt = int(inputInt%1000)*1;

  if (inputInt < 0) {
    outputStr = "-";
  }

  outputStr += highInt;
  outputStr += ".";
  outputStr += lowInt;

  return outputStr;
}
*/
/*
U8 U8toHEX(U8 val){
	val &= 0x0f;
	if(val < 10) val += '0';
	else val += 'a' - 10;
	return val;
}

void printUHEX(U8 val){
	uart_write("0x");
	UART_send_byte(U8toHEX(val>>4)); // MSB
	UART_send_byte(U8toHEX(val));    // LSB
}
*/
#ifdef PROGEEPROM
//-----------------------------------------------------------------------------------
uint8_t U4toHEX(uint8_t val)
{
	val &= 0x0f;
	if(val < 10) val += '0';
	else val += 'a' - 10;
	UART2->DR = val;
	while(!(UART2->SR & UART2_SR_TXE));

	return val;
}
//-----------------------------------------------------------------------------------
void UARTprintHEX(uint16_t val)
{
	UARTprintF("0x");
	UARTprintF((uint8_t*)U4toHEX(val>>12));
	UARTprintF((uint8_t*)U4toHEX(val>>8));
	UARTprintF((uint8_t*)U4toHEX(val>>4));
	UARTprintF((uint8_t*)U4toHEX((uint8_t)val));
}
#endif /* PROGEEPROM */

