#pragma once
#ifndef __STRUCT_H__
#define __STRUCT_H__

//-----------------------------------------------------------------------------------
// eeprom sruktury
typedef struct {
	uint8_t mode;       /*!< Režim regulátoru 1 - ruční, 2 - napětí, 3 - mppt */
	uint8_t jet;        /*!< 1 - každou změnu na uart, 0 - výspis podle časového internvalu*/
	uint8_t uartADC;    /*!< povolí ADC výstup na uart */
	uint8_t ADCzeroI;   /*!< velikost ofsetu nuly pro proudový bočník */
	uint8_t ADCdivI;    /*!< dělitel RAW ADC hodnot pro průměrování proudu */
	uint8_t ADCdivU;    /*!< delitel RAW ADC hodnot pro průměrování napětí */
	uint8_t ledP;       /*!< přepínač pro funkci výkonové ledky */
} system8_t;

typedef struct {
	uint16_t Uodh;       // odhad žádané hodnoty při nenaučených hodnotách [%]
    uint16_t Umpr;       // mez pro Ureg [%]
	uint16_t Uzap;       // napeti pro zapnuti regulace [V]
	uint16_t Uvyp;       // napeti pro vypnuti regulace [V]
	uint16_t Fout;       // výstupní frekvence PWM [Hz]
	uint16_t Emsb;       // vyrobená energie MSB [Wh]
	uint16_t Elsb;       // vyrobená energie LSB [Wh]

	uint16_t Ureg;       // žádaná hodnota pro napěťovou regulaci [V]
	uint16_t Unap;       // napětí naprázdno [V]
	uint16_t Pmax;       // maximální výkon [W]
	uint16_t Imax;       // maximální proud [mA]
	uint16_t Tmax;       // maximální teplota [°C]

	uint16_t Tshift;     // čas pro hledání optimálního Pshift [ms]
	uint16_t Ifmax;      // proud pro dosažení Fmax [mA]
	uint16_t DT;         // deadtime [62.5ns]
	uint16_t releH;      // horní hranice pro sepnutí rele [W/PWM]
	uint16_t releL;      // dolní hranice pro rozepnutí rele [W/PWM]

	uint16_t PWMmax;
	uint16_t OFFpwm;      // maximální pwm pro test rozpojené zátěže
	uint16_t OFFms;       // čas do testování připojené zátěže [ms]
	uint16_t Tzap;        // teplota pro omezování PWM [ADC]
	uint16_t Tvyp;        // teplota pro vypnutí PWM [ADC]

	uint16_t mppTIME;     // čas pro přepočítání MPP [ms]
    uint16_t mppDOWN1;	  // snižování kroku MPPT [V]
    uint16_t mppUP1;      // zvyšování kroku MPPT [V]
    uint16_t mppDOWN2;	  // snižování kroku MPPT [V]
    uint16_t mppUP2;	  // zvyšování kroku MPPT [V]
    uint16_t mppDOWN3;	  // snižování kroku MPPT [V]
    uint16_t mppUP3;	  // zvyšování kroku MPPT [V]
	uint16_t mppIzap;     // proud pro zapnutí MPPT [mA]
	uint16_t mppIvyp;     // proud pro vypnutí MPPT [mA]

	uint16_t IcalADC;	  // ADC hodnota měřeného proudu
	uint16_t IcalmA;	  // měřený proud výstupu
	uint16_t UcalADC;	  // ADC hodnota měřeného napětí
	uint16_t UcalV;		  // měřené napětí na výstupu
} system16_t;

typedef struct {
    uint16_t KP;//, KI, KD;
    uint16_t shiftP;//, shiftI;	//dělitel
    uint16_t shiftPmA;//, shiftI;	//proud pro uplatnění dělitele
    uint16_t I;           //[0] P pro I [1], Divade pro I
    //uint16_t errImax, errDmax;	//integratir limits
//    int16_t dstate;	    //last position input
//    int16_t istate;	    //integrator state
} pid_t;
//-----------------------------------------------------------------------------------
#define BASEpid         ((uint16_t *)EEPpid)
#define BASEsystem8     (( uint8_t *)EEPsystem8)
#define BASEsystem16    ((uint16_t *)EEPsystem16)
#define BASEtext        (( uint8_t *)EEPtext)
//-----------------------------------------------------------------------------------
#define PIDarry         2
//-----------------------------------------------------------------------------------

#endif // __STRUCT_H__

