//#include "interupt.h"
//#include "stm8s.h"

uint16_t delayADC = 0;
uint16_t delayRucne = 0;
uint16_t delayPause = 0;
uint16_t delayUnap  = 0;
uint16_t delayMPPT  = 0;
uint16_t delayUART  = 0;
uint16_t delayRELE  = 0;
uint16_t delaySHIFT = 0;
uint16_t delayOFFpwm = 0;
uint16_t delayPIDshift = 0;
uint32_t milliscnt = 0;

INTERRUPT_HANDLER(TIM4_UPD_OVF_IRQHandler, 23)
{
	milliscnt += 2;
//- - - - - - - - - - - - - - - - - - - - - - -
    if (delayADC)   --delayADC;
    if (flgTXsend)  --flgTXsend;
    if (delayPause) --delayPause;
    if (delayRucne) --delayRucne;
    if (delayUnap)  --delayUnap;
    if (delayMPPT)  --delayMPPT;
    if (delayRELE)  --delayRELE;
    if (delayUART)  --delayUART;
    if (delaySHIFT) --delaySHIFT;
    if (delayOFFpwm)    --delayOFFpwm;
    if (delayPIDshift)  --delayPIDshift;
//- - - - - - - - - - - - - - - - - - - - - - -
	ledBRKinterrupt();
	ledWARinterrupt();
	ledPWMinterrupt();
//- - - - - - - - - - - - - - - - - - - - - - -
    if (buttonSTART) {
        interuptTlplus();
        interuptTlminus();
    }
//- - - - - - - - - - - - - - - - - - - - - - -
    TIM4->SR1 = 0;		    // clear interrupt flag
}
//-----------------------------------------------------------------------------------
INTERRUPT_HANDLER(TIM1_UPD_OVF_TRG_BRK_IRQHandler, 11)
{
	if	(TIM1->SR1 &= TIM1_SR1_UIF)
	{
        if(flgPWMset != 0)
        {
            TIM1->PSCRH = BYTE1(tim1PSCR);
            TIM1->PSCRL = BYTE0(tim1PSCR);
            TIM1->ARRH  = BYTE1(tim1ARR);
            TIM1->ARRL  = BYTE0(tim1ARR);
            TIM1->CCR1H = BYTE1(tim1CCR1);
            TIM1->CCR1L = BYTE0(tim1CCR1);
            TIM1->CCR2H = BYTE1(tim1CCR2);
            TIM1->CCR2L = BYTE0(tim1CCR2);
            flgPWMset = 0;
        }
		ADCinterupt();
		ADCvalue();
		flgADCend = 0;
		flgUARTwait = 0;
    }
//- - - - - - - - - - - - - - - - - - - - - - -
	if	(TIM1->SR1 &= TIM1_SR1_BIF)	brk(1);
    TIM1->SR1 = 0;		    // clear interrupt flag
}
//-----------------------------------------------------------------------------------
INTERRUPT_HANDLER(AWU_IRQHandler, 1)
{
	volatile unsigned char reg;
	reg = AWU->CSR;
}
//-----------------------------------------------------------------------------------
INTERRUPT_HANDLER(UART1_RX_IRQHandler, 18)
{
    volatile uint8_t reg;
    reg = UART1->SR;                                // při chybě přenosu restart uart
    reg = UART1->DR;                                // přijatý bajt
    if(flgTXsend) flgTXsend = 2; else
    if(reg == '^') CONFload();
}
//-----------------------------------------------------------------------------------

